/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.formatter;

import java.io.Writer;
import java.util.Dictionary;
import org.apache.cocoon.formatter.AbstractFormatter;
import org.apache.cocoon.framework.Status;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.Document;

public class TextFormatter
extends AbstractFormatter
implements Status {
    private SerializerFactory factory = SerializerFactory.getSerializerFactory((String)"text");

    public void format(Document document, Writer writer, Dictionary dictionary) throws Exception {
        OutputFormat outputFormat = super.getFormat(dictionary);
        outputFormat.setMethod("text");
        outputFormat.setOmitXMLDeclaration(true);
        outputFormat.setPreserveSpace(true);
        Serializer serializer = this.factory.makeSerializer(writer, outputFormat);
        serializer.asDOMSerializer().serialize(document);
    }

    public String getMIMEType() {
        return "text/plain";
    }

    public String getStatus() {
        return "Text Formatter";
    }
}

