/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class URLHandlerFactory
implements URLStreamHandlerFactory {
    private String home;

    public URLHandlerFactory(String string) {
        this.home = string == null ? System.getProperty("user.dir").replace('\\', '/') : string;
    }

    public URLStreamHandler createURLStreamHandler(String string) {
        try {
            if (string.equalsIgnoreCase("cocoon")) {
                return new CocoonStreamHandler();
            }
            if (string.equalsIgnoreCase("resource")) {
                return new ResourceStreamHandler();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class CocoonStreamHandler
    extends URLStreamHandler {
        CocoonStreamHandler() {
        }

        public URLConnection openConnection(URL uRL) throws IOException {
            if (uRL == null) {
                return null;
            }
            String string = uRL.getFile();
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) != '/') {
                    string = string.substring(n);
                    break;
                }
                ++n;
            }
            return new URL("file:///" + URLHandlerFactory.this.home + string).openConnection();
        }
    }

    private class ResourceStreamHandler
    extends URLStreamHandler {
        ResourceStreamHandler() {
        }

        public URLConnection openConnection(URL uRL) throws IOException {
            String string = String.valueOf(uRL.getHost()) + uRL.getFile();
            URL uRL2 = ClassLoader.getSystemResource(string);
            if (uRL2 == null) {
                throw new IOException("Resource not found: " + string);
            }
            return uRL2.openConnection();
        }
    }
}

