/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.Browsers;
import org.apache.cocoon.Cocoon;
import org.apache.cocoon.Defaults;
import org.apache.cocoon.Frontend;
import org.apache.cocoon.URLHandlerFactory;
import org.apache.cocoon.cache.Cache;
import org.apache.cocoon.formatter.FormatterFactory;
import org.apache.cocoon.framework.Changeable;
import org.apache.cocoon.framework.Configurations;
import org.apache.cocoon.framework.Manager;
import org.apache.cocoon.framework.Page;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.interpreter.InterpreterFactory;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.ProcessorFactory;
import org.apache.cocoon.producer.ProducerFactory;
import org.apache.cocoon.store.Store;
import org.apache.cocoon.transformer.Transformer;
import org.w3c.dom.Document;

public class Engine
implements Defaults {
    private static Engine instance = null;
    Configurations configurations;
    boolean showStatus;
    ProducerFactory producers;
    ProcessorFactory processors;
    FormatterFactory formatters;
    InterpreterFactory interpreters;
    Manager manager = new Manager();
    Browsers browsers;
    Parser parser;
    Transformer transformer;
    Cache cache;
    Store store;
    ServletContext servletContext;
    static /* synthetic */ Class class$org$apache$cocoon$Engine;

    private Engine(Configurations configurations, Object object) throws Exception {
        this.manager.setRole("factory", this.manager);
        this.configurations = configurations;
        if (object != null && object instanceof ServletContext) {
            this.servletContext = (ServletContext)object;
            this.manager.setRole("context", object);
        }
        URL.setURLStreamHandlerFactory(new URLHandlerFactory((String)configurations.get("document.root")));
        this.parser = (Parser)this.manager.create((String)configurations.get("parser", "org.apache.cocoon.parser.XercesParser"), configurations.getConfigurations("parser"));
        this.manager.setRole("parser", this.parser);
        this.transformer = (Transformer)this.manager.create((String)configurations.get("transformer", "org.apache.cocoon.transformer.XalanTransformer"), configurations.getConfigurations("transformer"));
        this.manager.setRole("transformer", this.transformer);
        this.store = (Store)this.manager.create((String)configurations.get("store", "org.apache.cocoon.store.CocoonStore"), configurations.getConfigurations("store"));
        this.manager.setRole("store", this.store);
        this.cache = (Cache)this.manager.create((String)configurations.get("cache", "org.apache.cocoon.cache.CocoonCache"), configurations.getConfigurations("cache"));
        this.manager.setRole("cache", this.cache);
        this.interpreters = (InterpreterFactory)this.manager.create("org.apache.cocoon.interpreter.InterpreterFactory", configurations.getConfigurations("interpreter"));
        this.manager.setRole("interpreters", this.interpreters);
        this.producers = (ProducerFactory)this.manager.create("org.apache.cocoon.producer.ProducerFactory", configurations.getConfigurations("producer"));
        this.manager.setRole("producers", this.producers);
        this.processors = (ProcessorFactory)this.manager.create("org.apache.cocoon.processor.ProcessorFactory", configurations.getConfigurations("processor"));
        this.manager.setRole("processors", this.processors);
        this.formatters = (FormatterFactory)this.manager.create("org.apache.cocoon.formatter.FormatterFactory", configurations.getConfigurations("formatter"));
        this.manager.setRole("formatters", this.formatters);
        this.browsers = (Browsers)this.manager.create("org.apache.cocoon.Browsers", configurations.getConfigurations("browser"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private boolean getFlag(HttpServletRequest httpServletRequest, String string, boolean bl) {
        String string2 = httpServletRequest.getParameter(string);
        return string2 != null ? string2.toLowerCase().equals("true") : bl;
    }

    public static Engine getInstance() throws Exception {
        if (instance != null) {
            return instance;
        }
        throw new Exception("The Cocoon engine has not been initialized!");
    }

    public static Engine getInstance(Configurations configurations, Object object) throws Exception {
        if (instance == null) {
            Class clazz = class$org$apache$cocoon$Engine != null ? class$org$apache$cocoon$Engine : (class$org$apache$cocoon$Engine = Engine.class$("org.apache.cocoon.Engine"));
            synchronized (clazz) {
                if (instance == null) {
                    instance = new Engine(configurations, object);
                }
            }
        }
        return instance;
    }

    public Hashtable getStatus() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Browsers", this.browsers.getStatus());
        Enumeration enumeration = this.manager.getRoles();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.manager.getActor(string);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (stringBuffer.length() > 0) {
                stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
            }
            String string2 = stringBuffer.toString();
            if (object instanceof Status) {
                hashtable.put(string2, ((Status)object).getStatus());
                continue;
            }
            hashtable.put(string2, object.getClass().getName());
        }
        return hashtable;
    }

    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Object object2;
        long l = 0L;
        l = System.currentTimeMillis();
        ByteArrayOutputStream byteArrayOutputStream = null;
        boolean bl = this.getFlag(httpServletRequest, "cache", true);
        boolean bl2 = this.getFlag(httpServletRequest, "debug", false);
        String string = httpServletRequest.getParameter("user-Agent");
        if (string == null) {
            string = httpServletRequest.getHeader("user-Agent");
        }
        if (bl2) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            object2 = new PrintStream(new BufferedOutputStream(byteArrayOutputStream), true);
            System.setOut((PrintStream)object2);
            System.setErr((PrintStream)object2);
        }
        object2 = null;
        if (bl) {
            object2 = this.cache.getPage(httpServletRequest);
        }
        if (object2 == null) {
            Object object3;
            object2 = new Page();
            object = this.producers.getProducer(httpServletRequest);
            ((Page)object2).setChangeable((Changeable)object);
            Document document = object.getDocument(httpServletRequest);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("path", object.getPath(httpServletRequest));
            hashtable.put("browser", this.browsers.map(string));
            hashtable.put("request", (String)httpServletRequest);
            hashtable.put("response", (String)httpServletResponse);
            while ((object3 = this.processors.getProcessor(document)) != null) {
                document = object3.process(document, hashtable);
                ((Page)object2).setChangeable((Changeable)object3);
            }
            object3 = this.formatters.getFormatter(document);
            StringWriter stringWriter = new StringWriter();
            object3.format(document, stringWriter, hashtable);
            ((Page)object2).setContent(stringWriter.toString());
            ((Page)object2).setContentType(object3.getMIMEType());
        }
        if (bl2) {
            Frontend.print((ServletResponse)httpServletResponse, "Debugging " + httpServletRequest.getRequestURI(), byteArrayOutputStream.toString());
            System.setOut(System.out);
            System.setErr(System.err);
        } else {
            httpServletResponse.setContentType(((Page)object2).getContentType());
            object = httpServletResponse.getWriter();
            ((PrintWriter)object).println(((Page)object2).getContent());
            if (((Page)object2).isText()) {
                l = System.currentTimeMillis() - l;
                ((PrintWriter)object).println("<!-- This page was served " + (((Page)object2).isCached() ? "from cache " : "") + "in " + l + " milliseconds by " + Cocoon.version() + " -->");
            }
            ((PrintWriter)object).flush();
        }
        this.cache.setPage((Page)object2, httpServletRequest);
    }
}

