/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.Defaults;
import org.apache.cocoon.Engine;
import org.apache.cocoon.EngineWrapper;
import org.apache.cocoon.Frontend;
import org.apache.cocoon.Utils;
import org.apache.cocoon.framework.Configurations;

public class Cocoon
extends HttpServlet
implements Defaults {
    Engine engine = null;
    String message = null;
    Exception exception = null;
    Configurations confs = null;
    String confsName = null;
    String server = null;
    String statusURL = null;
    boolean errorsInternally = false;
    boolean showStatus = false;

    private static String getProperties(String string) throws Exception {
        File file;
        if (string != null && (file = new File(string)).canRead()) {
            return file.toString();
        }
        file = new File("cocoon.properties");
        if (file.canRead()) {
            return file.toString();
        }
        file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "cocoon.properties");
        if (file.canRead()) {
            return file.toString();
        }
        file = new File("/usr/local/etc/cocoon.properties");
        if (file.canRead()) {
            return file.toString();
        }
        throw new Exception("The property file could not be found.");
    }

    public String getServletInfo() {
        return Cocoon.version();
    }

    private Hashtable getStatus() {
        Runtime runtime = Runtime.getRuntime();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("Servlet Engine", this.server);
        hashtable.put("Configurations", this.confsName);
        hashtable.put("Free Memory", new Long(runtime.freeMemory()));
        hashtable.put("Total Memory", new Long(runtime.totalMemory()));
        return hashtable;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.server = servletConfig.getServletContext().getServerInfo();
        this.confsName = servletConfig.getInitParameter("properties");
        if (this.confsName == null) {
            this.exception = null;
            this.message = "<p>The servlet initialization argument <i>\"properties\"</i> was not found. Please, make sure Cocoon is able to find its configurations or it won't be able to execute correctly.</p><p>A template for such configurations may be found in the file \"/bin/cocoon.properties\" in the distribution.</p>";
            return;
        }
        try {
            this.confs = new Configurations(this.confsName);
            this.showStatus = ((String)this.confs.get("selfservlet.enabled", "false")).toLowerCase().equals("true");
            this.statusURL = (String)this.confs.get("selfservlet.uri", "/Cocoon.xml");
            this.errorsInternally = ((String)this.confs.get("handle.errors.internally", "false")).toLowerCase().equals("true");
            this.engine = Engine.getInstance(this.confs, this.getServletConfig().getServletContext());
        }
        catch (Exception exception) {
            this.exception = exception;
            this.message = "Publishing Engine could not be initialized.";
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = null;
        String string2 = null;
        Object var3_3 = null;
        String string3 = null;
        int n = 0;
        if (stringArray.length < 2 || stringArray.length > 4) {
            Cocoon.usage();
        }
        if (stringArray[n].charAt(0) == '-') {
            string = Cocoon.getProperties(stringArray[++n]);
        }
        int n2 = ++n;
        string2 = stringArray[n2];
        string3 = stringArray[++n];
        EngineWrapper engineWrapper = new EngineWrapper(new Configurations(string));
        engineWrapper.handle(new PrintWriter((Writer)new FileWriter(string3), true), new File(string2));
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block9: {
            if (this.engine == null) {
                Frontend.error((ServletResponse)httpServletResponse, this.message, this.exception);
            } else if (this.showStatus && httpServletRequest.getRequestURI().endsWith(this.statusURL)) {
                Frontend.status((ServletResponse)httpServletResponse, this.getStatus(), this.engine.getStatus());
            } else {
                try {
                    this.engine.handle(httpServletRequest, httpServletResponse);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (this.errorsInternally) {
                        Frontend.error((ServletResponse)httpServletResponse, "File not found.", fileNotFoundException);
                        break block9;
                    }
                    httpServletResponse.sendError(404, Utils.getStackTraceAsString(fileNotFoundException));
                }
                catch (Throwable throwable) {
                    if (this.errorsInternally) {
                        Frontend.error((ServletResponse)httpServletResponse, "Error found handling the request.", throwable);
                        break block9;
                    }
                    httpServletResponse.sendError(500, Utils.getStackTraceAsString(throwable));
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.cocoon.Cocoon [-p properties] Input Output");
        System.err.println("\nOptions:");
        System.err.println("  -p : indicates the property file");
        System.err.println("\nNote: if the property file is not specified, Cocoon looks for a file named");
        System.err.println("\"cocoon.properties\" in the current working directory, in the user directory");
        System.err.println("and in the \"/usr/local/etc/\" directory before giving up.");
        System.exit(1);
    }

    public static String version() {
        return "Cocoon 1.6.1";
    }
}

