/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.util.EmptyStackException;

public class BoolStack {
    private int m_blocksize;
    private boolean[] m_map;
    private int m_firstFree = 0;
    private int m_mapSize;

    public BoolStack() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new boolean[this.m_blocksize];
    }

    public BoolStack(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = blocksize;
        this.m_map = new boolean[blocksize];
    }

    public final void addElement(boolean value) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            boolean[] newMap = new boolean[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public final boolean elementAt(int i) {
        return this.m_map[i];
    }

    public final void insertElementAt(boolean value, int at) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            boolean[] newMap = new boolean[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        if (at <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, at, this.m_map, at + 1, this.m_firstFree - at);
        }
        this.m_map[at] = value;
        ++this.m_firstFree;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final int lastIndexOf(boolean elem) {
        int i = this.m_firstFree - 1;
        while (i >= 0) {
            if (this.m_map[i] == elem) {
                return i;
            }
            --i;
        }
        return Integer.MIN_VALUE;
    }

    public boolean peek() {
        int len = this.size();
        if (len == 0) {
            return false;
        }
        return this.elementAt(len - 1);
    }

    public boolean pop() {
        int len = this.size();
        boolean i = this.peek();
        this.removeElementAt(len - 1);
        return i;
    }

    public boolean push(boolean i) {
        this.addElement(i);
        return i;
    }

    public final void removeAllElements() {
        int i = 0;
        while (i < this.m_firstFree) {
            this.m_map[i] = false;
            ++i;
        }
        this.m_firstFree = 0;
    }

    public final void removeElementAt(int i) {
        if (i > this.m_firstFree) {
            System.arraycopy(this.m_map, i + 1, this.m_map, i, this.m_firstFree);
        } else {
            this.m_map[i] = false;
        }
        --this.m_firstFree;
    }

    public final void setElementAt(boolean value, int index) {
        this.m_map[index] = value;
    }

    public void setTop(boolean val) {
        int len = this.size();
        if (len == 0) {
            throw new EmptyStackException();
        }
        this.setElementAt(val, len - 1);
    }

    public final int size() {
        return this.m_firstFree;
    }
}

