/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xdom;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import org.apache.xalan.xpath.XPathEnvSupport;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.xml.DefaultErrorHandler;
import org.apache.xalan.xpath.xml.XMLParserLiaisonDefault;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.framework.XMLParser;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.XSchemaValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XercesLiaison
extends XMLParserLiaisonDefault
implements XPathSupport {
    public static final String XML4J_VERSION = "XML4J 2.0.15";
    private transient boolean m_didVersionCheck = false;
    private static final int MAJOR = 1;
    private static final int MINOR = 2;
    private static final int SUBMINOR = 3;
    static /* synthetic */ Class class$org$apache$xerces$framework$Version;

    public XercesLiaison() {
    }

    public XercesLiaison(XPathEnvSupport envSupport) {
        this.m_envSupport = envSupport;
    }

    public XercesLiaison(ErrorHandler errorHandler) {
        this.m_errorHandler = errorHandler;
    }

    public void checkNode(Node node) throws SAXException {
        if (!(node instanceof NodeImpl)) {
            throw new SAXException("XercesLiaison can not handle nodes of type" + node.getClass());
        }
    }

    public void checkXML4JVersion() {
        if (!this.m_didVersionCheck) {
            if (!this.getXML4JVersionString().equals(XML4J_VERSION)) {
                if (this.getXML4JVersionNum(1) == 2 && this.getXML4JVersionNum(2) == 0 && this.getXML4JVersionNum(3) >= 14 || this.getXML4JVersionNum(1) == 2 && this.getXML4JVersionNum(2) > 0 || this.getXML4JVersionNum(1) > 2) {
                    System.out.println("Found version " + this.getXML4JVersionString() + " of XML4J. \n" + "This version of XSLT4J is only tested with version " + XML4J_VERSION + " of XML4J! \n");
                } else {
                    System.out.println("Found version " + this.getXML4JVersionString() + " of XML4J. \n" + "This version of XSLT4J doesn't work with versions less than " + XML4J_VERSION + " of XML4J! \n");
                }
            }
            this.m_didVersionCheck = true;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Document createDocument() {
        DocumentImpl doc = new DocumentImpl();
        return doc;
    }

    public Element getElementByID(String id, Document doc) {
        return ((DocumentImpl)doc).getIdentifier(id);
    }

    public Node getParentOfNode(Node node) throws RuntimeException {
        return node.getNodeType() == 2 ? ((AttrImpl)node).getElement() : node.getParentNode();
    }

    public String getParserDescription() {
        return "XML4J Version " + this.getXML4JVersionString();
    }

    private int getXML4JVersionNum(int field) {
        int versionNum = 0;
        String ver = this.getXML4JVersionString();
        StringTokenizer tokenizer = new StringTokenizer(ver, " .");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (field == i) {
                versionNum = Integer.parseInt(tok);
            }
            ++i;
        }
        return versionNum;
    }

    private String getXML4JVersionString() {
        String version = "";
        try {
            Field versionField = (class$org$apache$xerces$framework$Version != null ? class$org$apache$xerces$framework$Version : (class$org$apache$xerces$framework$Version = XercesLiaison.class$("org.apache.xerces.framework.Version"))).getField("fVersion");
            version = (String)versionField.get(null);
        }
        catch (Exception exception) {}
        return version;
    }

    public boolean isIgnorableWhitespace(Text node) {
        boolean isIgnorable = node instanceof TextImpl ? ((TextImpl)node).isIgnorableWhitespace() : false;
        return isIgnorable;
    }

    public void parse(InputSource source) throws SAXException, IOException {
        boolean isDomParser;
        MyParser parser = null;
        if (this.m_docHandler == null) {
            isDomParser = true;
            MyParser domParser = new MyParser();
            domParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            parser = domParser;
        } else {
            isDomParser = false;
            SAXParser saxparser = new SAXParser();
            saxparser.setDocumentHandler(this.m_docHandler);
            this.m_docHandler = null;
            parser = saxparser;
            if (this.m_DTDHandler != null) {
                saxparser.setDTDHandler(this.m_DTDHandler);
            }
        }
        try {
            if (this.m_errorHandler != null) {
                parser.setErrorHandler(this.m_errorHandler);
            } else {
                String ident = source.getSystemId() == null ? "Input XSL" : source.getSystemId();
                parser.setErrorHandler(new DefaultErrorHandler(ident));
            }
            if (this.m_entityResolver != null) {
                parser.setEntityResolver(this.m_entityResolver);
            }
            if (this.m_locale != null) {
                parser.setLocale(this.m_locale);
            }
            parser.parse(source);
            if (isDomParser) {
                this.m_document = ((DOMParser)parser).getDocument();
                if (source.getSystemId() != null) {
                    this.getSourceDocsTable().put(source.getSystemId(), this.m_document);
                }
            }
        }
        catch (SAXException e) {
            if (parser != null) {
                throw new SAXException("XercesLiaison.parse error: SystemID - " + parser.getSystemId() + " line - " + parser.getLineNumber(), e);
            }
            throw new SAXException("XercesLiaison.parse error", e);
        }
    }

    public boolean supportsSAX() {
        return true;
    }

    class NullSchemaValidator
    extends XSchemaValidator {
        public NullSchemaValidator(StringPool stringPool, XMLErrorReporter errorReporter, XMLEntityHandler entityHandler) {
            super(stringPool, errorReporter, entityHandler);
        }

        public final void loadSchema(String uri) {
        }
    }

    class MyParser
    extends DOMParser {
        MyParser() {
        }

        protected XSchemaValidator getSchemaValidator() {
            if (((XMLParser)this).fSchemaValidator == null) {
                ((XMLParser)this).fSchemaValidator = new NullSchemaValidator(((XMLParser)this).fStringPool, ((XMLParser)this).fErrorReporter, ((XMLParser)this).fEntityHandler);
            }
            return ((XMLParser)this).fSchemaValidator;
        }
    }
}

