/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.dtm;

import org.apache.xalan.xpath.dtm.DTM;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DTMtest {
    static final boolean RAW = false;

    public static void main(String[] args) {
        DTM parser;
        DTM model = parser = new DTM();
        String uri = args[0];
        InputSource in = new InputSource(uri);
        try {
            parser.parse(in);
        }
        catch (Exception e) {
            System.out.println("Java Exception: " + e);
            e.printStackTrace();
            return;
        }
        DTMtest.treedump(model.getNode(0));
    }

    static void treedump(Node n) {
        if (n == null) {
            return;
        }
        switch (n.getNodeType()) {
            case 3: 
            case 4: {
                System.out.print(n.getNodeValue());
                break;
            }
            case 1: {
                Node at;
                System.out.print("<" + n.getNodeName());
                NamedNodeMap attrs = n.getAttributes();
                int i = 0;
                while ((at = attrs.item(i++)) != null) {
                    System.out.print(" " + at.getNodeName() + "=\"" + at.getFirstChild().getNodeValue() + "\"");
                }
                System.out.print(">");
                break;
            }
            case 2: {
                System.out.print(" " + n.getNodeName() + "=\"" + n.getNodeValue() + "\"");
                break;
            }
            case 7: {
                System.out.println("\n<?" + n.getNodeName() + " " + n.getNodeValue() + " ?>");
                break;
            }
            case 8: {
                System.out.println("\n<!-- " + n.getNodeValue() + " -->");
                break;
            }
            case 9: {
                System.out.println("<!-- Document -->");
                break;
            }
            default: {
                System.out.println("<!-- Not expected: " + n.getNodeName() + " -->");
            }
        }
        DTMtest.treedump(n.getFirstChild());
        if (n.getNodeType() == 1) {
            System.out.print("</" + n.getNodeName() + ">");
        }
        DTMtest.treedump(n.getNextSibling());
    }
}

