/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathSupport;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XString
extends XObject {
    public XString(String val) {
        super(val);
    }

    public boolean bool() {
        return this.str().length() > 0;
    }

    public boolean equals(XObject obj2) throws SAXException {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        return this.str().equals(obj2.str());
    }

    public int getType() {
        return 3;
    }

    private String getTypeString() {
        return "#STRING";
    }

    public double num() {
        double result;
        NumberFormat m_formatter = NumberFormat.getNumberInstance();
        String s = (String)this.m_obj;
        if (s != null) {
            try {
                Number n = m_formatter.parse(s.trim());
                result = n.doubleValue();
            }
            catch (ParseException parseException) {
                result = Double.NaN;
            }
        } else {
            result = Double.NaN;
        }
        return result;
    }

    public DocumentFragment rtree(XPathSupport support) {
        DocumentFragment df = support.getDOMFactory().createDocumentFragment();
        Text textNode = support.getDOMFactory().createTextNode(this.str());
        df.appendChild(textNode);
        return df;
    }

    public String str() {
        return this.m_obj != null ? (String)this.m_obj : "";
    }
}

