/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import org.apache.xalan.xpath.FoundIndex;
import org.apache.xalan.xpath.FuncLoader;
import org.apache.xalan.xpath.Function;
import org.apache.xalan.xpath.MutableNodeList;
import org.apache.xalan.xpath.SimpleNodeLocator;
import org.apache.xalan.xpath.XBoolean;
import org.apache.xalan.xpath.XBooleanStatic;
import org.apache.xalan.xpath.XLocator;
import org.apache.xalan.xpath.XNodeSet;
import org.apache.xalan.xpath.XNull;
import org.apache.xalan.xpath.XNumber;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathException;
import org.apache.xalan.xpath.XPathProcessorImpl;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XRTreeFrag;
import org.apache.xalan.xpath.XString;
import org.apache.xalan.xpath.dtm.DTM;
import org.apache.xalan.xpath.dtm.DTMNodeLocator;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.ProblemListener;
import org.apache.xalan.xpath.xml.ProblemListenerDefault;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XPath
implements Serializable {
    public static XBoolean m_true = new XBooleanStatic(true);
    public static XBoolean m_false = new XBooleanStatic(false);
    public String m_currentPattern;
    public static final int MAXTOKENQUEUESIZE = 500;
    public Object[] m_tokenQueue = new Object[500];
    public int m_tokenQueueSize = 0;
    public int[] m_opMap = new int[1500];
    public static final int MAPINDEX_LENGTH = 1;
    public static final boolean m_debug = false;
    private ProblemListener m_problemListener = null;
    public static final boolean m_trace = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;
    public static final int ENDOP = -1;
    public static final int EMPTY = -2;
    public static final int ELEMWILDCARD = -3;
    public static final int OP_XPATH = 1;
    public static final int OP_OR = 2;
    public static final int OP_AND = 3;
    public static final int OP_NOTEQUALS = 4;
    public static final int OP_EQUALS = 5;
    public static final int OP_LTE = 6;
    public static final int OP_LT = 7;
    public static final int OP_GTE = 8;
    public static final int OP_GT = 9;
    public static final int OP_PLUS = 10;
    public static final int OP_MINUS = 11;
    public static final int OP_MULT = 12;
    public static final int OP_DIV = 13;
    public static final int OP_MOD = 14;
    public static final int OP_QUO = 15;
    public static final int OP_NEG = 16;
    public static final int OP_STRING = 17;
    public static final int OP_BOOL = 18;
    public static final int OP_NUMBER = 19;
    public static final int OP_UNION = 20;
    public static final int OP_LITERAL = 21;
    public static final int OP_VARIABLE = 22;
    public static final int OP_GROUP = 23;
    public static final int OP_NUMBERLIT = 24;
    public static final int OP_ARGUMENT = 25;
    public static final int OP_LOCATIONPATH = 28;
    public static final int OP_PREDICATE = 29;
    public static final int NODETYPE_COMMENT = 1030;
    public static final int NODETYPE_TEXT = 1031;
    public static final int NODETYPE_PI = 1032;
    public static final int NODETYPE_NODE = 1033;
    public static final int NODENAME = 34;
    public static final int NODETYPE_ROOT = 35;
    public static final int NODETYPE_ANYELEMENT = 36;
    public static final int FROM_ANCESTORS = 37;
    public static final int FROM_ANCESTORS_OR_SELF = 38;
    public static final int FROM_ATTRIBUTES = 39;
    public static final int FROM_CHILDREN = 40;
    public static final int FROM_DESCENDANTS = 41;
    public static final int FROM_DESCENDANTS_OR_SELF = 42;
    public static final int FROM_FOLLOWING = 43;
    public static final int FROM_FOLLOWING_SIBLINGS = 44;
    public static final int FROM_PARENT = 45;
    public static final int FROM_PRECEDING = 46;
    public static final int FROM_PRECEDING_SIBLINGS = 47;
    public static final int FROM_SELF = 48;
    public static final int FROM_NAMESPACE = 49;
    public static final int FROM_ROOT = 55;
    public static final int FUNC_CURRENT = 0;
    public static final int FUNC_LAST = 1;
    public static final int FUNC_POSITION = 2;
    public static final int FUNC_COUNT = 3;
    public static final int FUNC_ID = 4;
    public static final int FUNC_KEY = 5;
    public static final int FUNC_LOCAL_PART = 7;
    public static final int FUNC_NAMESPACE = 8;
    public static final int FUNC_QNAME = 9;
    public static final int FUNC_GENERATE_ID = 10;
    public static final int FUNC_NOT = 11;
    public static final int FUNC_TRUE = 12;
    public static final int FUNC_FALSE = 13;
    public static final int FUNC_BOOLEAN = 14;
    public static final int FUNC_NUMBER = 15;
    public static final int FUNC_FLOOR = 16;
    public static final int FUNC_CEILING = 17;
    public static final int FUNC_ROUND = 18;
    public static final int FUNC_SUM = 19;
    public static final int FUNC_STRING = 20;
    public static final int FUNC_STARTS_WITH = 21;
    public static final int FUNC_CONTAINS = 22;
    public static final int FUNC_SUBSTRING_BEFORE = 23;
    public static final int FUNC_SUBSTRING_AFTER = 24;
    public static final int FUNC_NORMALIZE_SPACE = 25;
    public static final int FUNC_TRANSLATE = 26;
    public static final int FUNC_CONCAT = 27;
    public static final int FUNC_SUBSTRING = 29;
    public static final int FUNC_STRING_LENGTH = 30;
    public static final int FUNC_SYSTEM_PROPERTY = 31;
    public static final int FUNC_LANG = 32;
    public static final int FUNC_EXT_FUNCTION_AVAILABLE = 33;
    public static final int FUNC_EXT_ELEM_AVAILABLE = 34;
    public static final int FUNC_DOCLOCATION = 35;
    public static final int FUNC_UNPARSED_ENTITY_URI = 36;
    private static final int NUM_BUILT_IN_FUNCS = 37;
    private static final int NUM_ALLOWABLE_ADDINS = 30;
    private static Function[] m_functions;
    private static int m_funcNextFreeIndex;
    public static final int OP_EXTFUNCTION = 26;
    public static final int OP_FUNCTION = 27;
    public static final int OP_MATCHPATTERN = 92;
    public static final int OP_LOCATIONPATHPATTERN = 93;
    public static final int MATCH_ATTRIBUTE = 94;
    public static final int MATCH_ANY_ANCESTOR = 95;
    public static final int MATCH_IMMEDIATE_ANCESTOR = 96;
    public static final String PSEUDONAME_ANY = "*";
    public static final String PSEUDONAME_ROOT = "/";
    public static final String PSEUDONAME_TEXT = "#text";
    public static final String PSEUDONAME_COMMENT = "#comment";
    public static final String PSEUDONAME_PI = "#pi";
    public static final String PSEUDONAME_OTHER = "*";
    public static final int NEXT_FREE_ID = 99;
    public int[] m_patternMap = new int[100];
    public int m_patternMapSize;

    static {
        m_funcNextFreeIndex = 37;
        m_functions = new Function[67];
        XPath.m_functions[0] = new FuncLoader("FuncCurrent", 0);
        XPath.m_functions[1] = new FuncLoader("FuncLast", 1);
        XPath.m_functions[2] = new FuncLoader("FuncPosition", 2);
        XPath.m_functions[3] = new FuncLoader("FuncCount", 3);
        XPath.m_functions[4] = new FuncLoader("FuncId", 4);
        XPath.m_functions[5] = new FuncLoader("FuncKey", 5);
        XPath.m_functions[7] = new FuncLoader("FuncLocalPart", 7);
        XPath.m_functions[8] = new FuncLoader("FuncNamespace", 8);
        XPath.m_functions[9] = new FuncLoader("FuncQname", 9);
        XPath.m_functions[10] = new FuncLoader("FuncGenerateId", 10);
        XPath.m_functions[11] = new FuncLoader("FuncNot", 11);
        XPath.m_functions[12] = new FuncLoader("FuncTrue", 12);
        XPath.m_functions[13] = new FuncLoader("FuncFalse", 13);
        XPath.m_functions[14] = new FuncLoader("FuncBoolean", 14);
        XPath.m_functions[32] = new FuncLoader("FuncLang", 32);
        XPath.m_functions[15] = new FuncLoader("FuncNumber", 15);
        XPath.m_functions[16] = new FuncLoader("FuncFloor", 16);
        XPath.m_functions[17] = new FuncLoader("FuncCeiling", 17);
        XPath.m_functions[18] = new FuncLoader("FuncRound", 18);
        XPath.m_functions[19] = new FuncLoader("FuncSum", 19);
        XPath.m_functions[20] = new FuncLoader("FuncString", 20);
        XPath.m_functions[21] = new FuncLoader("FuncStartsWith", 21);
        XPath.m_functions[22] = new FuncLoader("FuncContains", 22);
        XPath.m_functions[23] = new FuncLoader("FuncSubstringBefore", 23);
        XPath.m_functions[24] = new FuncLoader("FuncSubstringAfter", 24);
        XPath.m_functions[25] = new FuncLoader("FuncNormalizeSpace", 25);
        XPath.m_functions[26] = new FuncLoader("FuncTranslate", 26);
        XPath.m_functions[27] = new FuncLoader("FuncConcat", 27);
        XPath.m_functions[31] = new FuncLoader("FuncSystemProperty", 31);
        XPath.m_functions[33] = new FuncLoader("FuncExtFunctionAvailable", 33);
        XPath.m_functions[34] = new FuncLoader("FuncExtElementAvailable", 34);
        XPath.m_functions[29] = new FuncLoader("FuncSubstring", 29);
        XPath.m_functions[30] = new FuncLoader("FuncStringLength", 30);
        XPath.m_functions[35] = new FuncLoader("FuncDoclocation", 35);
        XPath.m_functions[36] = new FuncLoader("FuncUnparsedEntityURI", 36);
    }

    public XPath() {
        this.m_problemListener = new ProblemListenerDefault();
    }

    public XPath(XPathSupport callbacks, ProblemListener problemListener) {
        this.m_problemListener = problemListener;
    }

    public XPath(ProblemListener problemListener) {
        this.m_problemListener = problemListener;
    }

    private void ____API____() {
    }

    private void ____CONSTANTS____() {
    }

    private void ____DIAGNOSTICS_AND_ERRORS____() {
    }

    private void ____EVALUATION____() {
    }

    private void ____IGNORE____() {
    }

    private void ____OPCODE_POSITION_HELPER_FUNCTIONS____() {
    }

    protected XBoolean and(XPathSupport execContext, Node context, int opPos) throws SAXException {
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        if (expr1.bool()) {
            XObject expr2 = this.execute(execContext, context, expr2Pos);
            return expr2.bool() ? m_true : m_false;
        }
        return m_false;
    }

    protected XObject arg(XPathSupport execContext, Node context, int opPos) throws SAXException {
        return this.execute(execContext, context, opPos + 2);
    }

    private void assert(boolean b, String msg) throws SAXException {
        if (!b) {
            this.error(null, 30, new Object[]{msg});
        }
    }

    protected XBoolean bool(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr1 = this.execute(execContext, context, opPos + 2);
        return expr1.bool() ? m_true : m_false;
    }

    public XLocator createXLocatorHandler(XPath xpath) {
        return new SimpleNodeLocator();
    }

    public XLocator createXLocatorHandler(XPathSupport callbacks) {
        return callbacks.createXLocatorHandler();
    }

    protected XNumber div(XPathSupport execContext, Node context, int opPos) throws SAXException {
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        XObject expr2 = this.execute(execContext, context, expr2Pos);
        return new XNumber(expr1.num() / expr2.num());
    }

    protected XBoolean equals(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr2;
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        return expr1.equals(expr2 = this.execute(execContext, context, expr2Pos)) ? m_true : m_false;
    }

    public void error(int msg) throws SAXException {
        this.error(null, msg, null);
    }

    public void error(int msg, Object[] args) throws SAXException {
        this.error(null, msg, args);
    }

    public void error(Node sourceNode, int msg) throws SAXException {
        this.error(sourceNode, msg, null);
    }

    public void error(Node sourceNode, int msg, Object[] args) throws SAXException {
        String fMsg = XSLMessages.createXPATHMessage(msg, args);
        String emsg = String.valueOf(this.m_currentPattern != null ? "pattern = '" + this.m_currentPattern + "'\n" : "") + fMsg;
        boolean shouldThrow = this.m_problemListener.problem((short)4, (short)2, null, sourceNode, emsg, null, 0, 0);
        if (shouldThrow) {
            throw new XPathException(emsg);
        }
    }

    public XObject execute(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject result = null;
        switch (this.m_opMap[opPos]) {
            case 1: {
                result = this.execute(execContext, context, opPos + 2);
                break;
            }
            case 92: {
                result = this.matchPattern(execContext, context, opPos + 2);
                break;
            }
            case -2: {
                ++opPos;
                break;
            }
            case 2: {
                result = this.or(execContext, context, opPos);
                break;
            }
            case 3: {
                result = this.and(execContext, context, opPos);
                break;
            }
            case 4: {
                result = this.notequals(execContext, context, opPos);
                break;
            }
            case 5: {
                result = this.equals(execContext, context, opPos);
                break;
            }
            case 6: {
                result = this.lte(execContext, context, opPos);
                break;
            }
            case 7: {
                result = this.lt(execContext, context, opPos);
                break;
            }
            case 8: {
                result = this.gte(execContext, context, opPos);
                break;
            }
            case 9: {
                result = this.gt(execContext, context, opPos);
                break;
            }
            case 10: {
                result = this.plus(execContext, context, opPos);
                break;
            }
            case 11: {
                result = this.minus(execContext, context, opPos);
                break;
            }
            case 12: {
                result = this.mult(execContext, context, opPos);
                break;
            }
            case 13: {
                result = this.div(execContext, context, opPos);
                break;
            }
            case 14: {
                result = this.mod(execContext, context, opPos);
                break;
            }
            case 15: {
                result = this.quo(execContext, context, opPos);
                break;
            }
            case 16: {
                result = this.neg(execContext, context, opPos);
                break;
            }
            case 17: {
                result = this.string(execContext, context, opPos);
                break;
            }
            case 18: {
                result = this.bool(execContext, context, opPos);
                break;
            }
            case 19: {
                result = this.number(execContext, context, opPos);
                break;
            }
            case 20: {
                result = this.union(execContext, context, opPos);
                break;
            }
            case 21: {
                result = this.literal(execContext, context, opPos);
                break;
            }
            case 22: {
                result = this.variable(execContext, context, opPos);
                break;
            }
            case 23: {
                result = this.group(execContext, context, opPos);
                break;
            }
            case 24: {
                result = this.numberlit(execContext, context, opPos);
                break;
            }
            case 25: {
                result = this.arg(execContext, context, opPos);
                break;
            }
            case 26: {
                int endExtFunc = opPos + this.m_opMap[opPos + 1] - 1;
                opPos = XPath.getFirstChildPos(opPos);
                String ns = (String)this.m_tokenQueue[this.m_opMap[opPos]];
                String funcName = (String)this.m_tokenQueue[this.m_opMap[++opPos]];
                ++opPos;
                Vector<XObject> args = new Vector<XObject>();
                while (opPos < endExtFunc) {
                    int nextOpPos = this.getNextOpPos(opPos);
                    args.addElement(this.execute(execContext, context, opPos));
                    opPos = nextOpPos;
                }
                result = this.extfunction(execContext, context, opPos, ns, funcName, args);
                break;
            }
            case 27: {
                int endFunc = opPos + this.m_opMap[opPos + 1] - 1;
                opPos = XPath.getFirstChildPos(opPos);
                int funcID = this.m_opMap[opPos];
                ++opPos;
                Vector<XObject> args = new Vector<XObject>();
                while (opPos < endFunc) {
                    int nextOpPos = this.getNextOpPos(opPos);
                    args.addElement(this.execute(execContext, context, opPos));
                    opPos = nextOpPos;
                }
                if (funcID != -1) {
                    result = this.function(execContext, context, opPos, funcID, args);
                    break;
                }
                this.warn(8);
                break;
            }
            case 28: {
                result = this.locationPath(execContext, context, opPos);
                break;
            }
            case 93: {
                result = this.locationPathPattern(execContext, context, opPos);
                break;
            }
            default: {
                this.error(context, 24, new Object[]{Integer.toString(this.m_opMap[opPos])});
            }
        }
        return result;
    }

    public XObject execute(XPathSupport execContext, Node contextNode, PrefixResolver namespaceContext) throws SAXException {
        PrefixResolver savedPrefixResolver = execContext.getNamespaceContext();
        execContext.setNamespaceContext(namespaceContext);
        execContext.setCurrentNode(contextNode);
        XObject xobj = null;
        try {
            xobj = this.execute(execContext, contextNode, 0);
        }
        finally {
            Object var7_6 = null;
            execContext.setNamespaceContext(savedPrefixResolver);
            execContext.setCurrentNode(null);
        }
        return xobj;
    }

    protected XObject extfunction(XPathSupport execContext, Node context, int opPos, String namespace, String extensionName, Vector argVec) throws SAXException {
        XObject result;
        Object val = execContext.extFunction(namespace, extensionName, argVec);
        if (val != null) {
            if (val instanceof XLocator) {
                XLocator locator = (XLocator)val;
                opPos = this.getNextOpPos(opPos + 1);
                result = locator.connectToNodes(this, execContext, context, opPos, argVec);
            } else if (val instanceof XObject) {
                result = (XObject)val;
            } else if (val instanceof String) {
                result = new XString((String)val);
            } else if (val instanceof Boolean) {
                result = (Boolean)val != false ? m_true : m_false;
            } else if (val instanceof Double) {
                result = new XNumber((Double)val);
            } else if (val instanceof DocumentFragment) {
                result = new XRTreeFrag((DocumentFragment)val);
            } else if (val instanceof Node) {
                opPos = this.getNextOpPos(opPos);
                XNodeSet mnl = null;
                if (opPos < this.m_opMap[1] && this.m_opMap[opPos] == 28) {
                    mnl = this.locationPath(execContext, (Node)val, opPos);
                }
                result = mnl == null ? new XNodeSet((Node)val) : mnl;
            } else if (val instanceof NodeList) {
                opPos = this.getNextOpPos(opPos);
                XNodeSet mnl = null;
                if (opPos < this.m_opMap[1] && this.m_opMap[opPos] == 28) {
                    NodeList nl = (NodeList)val;
                    int nNodes = nl.getLength();
                    int i = 0;
                    while (i < nNodes) {
                        XNodeSet xnl = this.locationPath(execContext, nl.item(i), opPos);
                        if (xnl == null) {
                            mnl = xnl;
                        } else {
                            mnl.mutableNodeset().addNodes(xnl.nodeset());
                        }
                        ++i;
                    }
                }
                result = mnl == null ? new XNodeSet((NodeList)val) : mnl;
            } else {
                result = new XObject(val);
            }
        } else {
            result = new XNull();
        }
        return result;
    }

    protected XObject function(XPathSupport execContext, Node context, int opPos, int funcID, Vector args) throws SAXException {
        return m_functions[funcID].execute(this, execContext, context, opPos, args);
    }

    public int getArgLengthOfStep(int opPos) {
        return this.m_opMap[opPos + 1 + 1] - 3;
    }

    int getCountOfContextNodeList(XPathSupport execContext) {
        if (execContext.getThrowFoundIndex()) {
            throw new FoundIndex();
        }
        return execContext.getContextNodeList().getLength();
    }

    public static int getFirstChildPos(int opPos) {
        return opPos + 2;
    }

    public static int getFirstChildPosOfStep(int opPos) {
        return opPos + 3;
    }

    public double getMatchScore(XPathSupport execContext, DTM dtm, int context) throws SAXException {
        double score = Double.NEGATIVE_INFINITY;
        int opPos = 0;
        if (this.m_opMap[opPos] == 92) {
            opPos = XPath.getFirstChildPos(opPos);
            XLocator locator = execContext.getXLocatorFromNode(dtm.getDocument());
            if (locator == null) {
                locator = execContext.createXLocatorHandler();
            }
            DTMNodeLocator dtmLocator = (DTMNodeLocator)locator;
            while (this.m_opMap[opPos] == 93) {
                int nextOpPos = this.getNextOpPos(opPos);
                score = dtmLocator.locationPathPattern(this, execContext, dtm, context, opPos);
                if (score == Double.NEGATIVE_INFINITY) {
                    opPos = nextOpPos;
                    continue;
                }
                break;
            }
        } else {
            this.error(dtm.getNode(context), 22);
        }
        return score;
    }

    public double getMatchScore(XPathSupport execContext, Node context) throws SAXException {
        double score = Double.NEGATIVE_INFINITY;
        int opPos = 0;
        if (this.m_opMap[opPos] == 92) {
            opPos = XPath.getFirstChildPos(opPos);
            XLocator locator = execContext.getXLocatorFromNode(context);
            if (locator == null) {
                locator = execContext.createXLocatorHandler();
            }
            while (this.m_opMap[opPos] == 93) {
                int nextOpPos = this.getNextOpPos(opPos);
                score = locator.locationPathPattern(this, execContext, context, opPos);
                if (score == Double.NEGATIVE_INFINITY) {
                    opPos = nextOpPos;
                    continue;
                }
                break;
            }
        } else {
            this.error(context, 22);
        }
        return score;
    }

    public int getNextOpPos(int opPos) {
        return opPos + this.m_opMap[opPos + 1];
    }

    public static int getNextOpPos(int[] opMap, int opPos) {
        return opPos + opMap[opPos + 1];
    }

    public int getOp(int opPos) {
        return this.m_opMap[opPos];
    }

    int getPositionInContextNodeList(Node context, XPathSupport execContext) {
        if (execContext.getThrowFoundIndex()) {
            throw new FoundIndex();
        }
        int pos = -1;
        if (execContext.getContextNodeList() != null) {
            int nNodes = execContext.getContextNodeList().getLength();
            int i = 0;
            while (i < nNodes) {
                Node item = execContext.getContextNodeList().item(i);
                if (item != null && item.equals(context)) {
                    pos = i + 1;
                    break;
                }
                ++i;
            }
        }
        return pos;
    }

    public ProblemListener getProblemListener() {
        return this.m_problemListener;
    }

    public Node getRoot(XPathSupport execContext, Node node) {
        Node root = null;
        while (node != null) {
            root = node;
            node = execContext.getParentOfNode(node);
        }
        return root;
    }

    public Vector getTargetElementStrings() {
        Vector<String> targetStrings = new Vector<String>();
        int opPos = 2;
        while (this.m_opMap[opPos] == 93) {
            int nextOpPos = this.getNextOpPos(opPos);
            opPos = XPath.getFirstChildPos(opPos);
            while (this.m_opMap[opPos] != -1) {
                int nextStepPos = this.getNextOpPos(opPos);
                int nextOp = this.m_opMap[nextStepPos];
                if (nextOp == 29 || nextOp == -1) {
                    int stepType = this.m_opMap[opPos];
                    opPos += 3;
                    block0 : switch (stepType) {
                        case 27: {
                            targetStrings.addElement("*");
                            break;
                        }
                        case 55: {
                            targetStrings.addElement(PSEUDONAME_ROOT);
                            break;
                        }
                        case 94: 
                        case 95: 
                        case 96: {
                            int tok = this.m_opMap[opPos];
                            ++opPos;
                            switch (tok) {
                                case 1030: {
                                    targetStrings.addElement(PSEUDONAME_COMMENT);
                                    break block0;
                                }
                                case 1031: {
                                    targetStrings.addElement(PSEUDONAME_TEXT);
                                    break block0;
                                }
                                case 1033: {
                                    targetStrings.addElement("*");
                                    break block0;
                                }
                                case 35: {
                                    targetStrings.addElement(PSEUDONAME_ROOT);
                                    break block0;
                                }
                                case 36: {
                                    targetStrings.addElement("*");
                                    break block0;
                                }
                                case 1032: {
                                    targetStrings.addElement("*");
                                    break block0;
                                }
                                case 34: {
                                    int tokenIndex = this.m_opMap[opPos + 1];
                                    if (tokenIndex >= 0) {
                                        String targetName = (String)this.m_tokenQueue[tokenIndex];
                                        if (targetName.equals("*")) {
                                            targetStrings.addElement("*");
                                            break block0;
                                        }
                                        targetStrings.addElement(targetName);
                                        break block0;
                                    }
                                    targetStrings.addElement("*");
                                    break block0;
                                }
                            }
                            targetStrings.addElement("*");
                            break;
                        }
                    }
                }
                opPos = nextStepPos;
            }
            opPos = nextOpPos;
        }
        return targetStrings;
    }

    protected XObject group(XPathSupport execContext, Node context, int opPos) throws SAXException {
        return this.execute(execContext, context, opPos + 2);
    }

    protected XBoolean gt(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr2;
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        return expr1.greaterThan(expr2 = this.execute(execContext, context, expr2Pos)) ? m_true : m_false;
    }

    protected XBoolean gte(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr2;
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        return expr1.greaterThanOrEqual(expr2 = this.execute(execContext, context, expr2Pos)) ? m_true : m_false;
    }

    public void installFunction(String name, int funcIndex, Function func) {
        XPath.m_functions[funcIndex] = func;
    }

    public static int installFunction(String name, Function func) {
        int funcIndex;
        Object funcIndexObj = XPathProcessorImpl.m_functions.get(name);
        if (funcIndexObj != null) {
            funcIndex = (Integer)funcIndexObj;
        } else {
            funcIndex = m_funcNextFreeIndex++;
            XPathProcessorImpl.m_functions.put(name, new Integer(funcIndex));
        }
        XPath.m_functions[funcIndex] = func;
        return funcIndex;
    }

    protected XString literal(XPathSupport execContext, Node context, int opPos) {
        opPos = XPath.getFirstChildPos(opPos);
        return (XString)this.m_tokenQueue[this.m_opMap[opPos]];
    }

    public XNodeSet locationPath(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XLocator xlocator = execContext.getXLocatorFromNode(context);
        if (xlocator == null) {
            xlocator = execContext.createXLocatorHandler();
        }
        XNodeSet results = xlocator.locationPath(this, execContext, context, opPos);
        return results;
    }

    protected XNumber locationPathPattern(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XLocator locator = execContext.getXLocatorFromNode(context);
        if (locator == null) {
            locator = execContext.createXLocatorHandler();
        }
        double results = locator.locationPathPattern(this, execContext, context, opPos);
        return new XNumber(results);
    }

    protected XBoolean lt(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr2;
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        return expr1.lessThan(expr2 = this.execute(execContext, context, expr2Pos)) ? m_true : m_false;
    }

    protected XBoolean lte(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr2;
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        return expr1.lessThanOrEqual(expr2 = this.execute(execContext, context, expr2Pos)) ? m_true : m_false;
    }

    protected XObject matchPattern(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject score = null;
        while (this.m_opMap[opPos] == 93) {
            int nextOpPos = this.getNextOpPos(opPos);
            score = this.execute(execContext, context, opPos);
            if (score.num() != Double.NEGATIVE_INFINITY) break;
            opPos = nextOpPos;
        }
        if (score == null) {
            score = new XNumber(Double.NEGATIVE_INFINITY);
        }
        return score;
    }

    protected XNumber minus(XPathSupport execContext, Node context, int opPos) throws SAXException {
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        XObject expr2 = this.execute(execContext, context, expr2Pos);
        return new XNumber(expr1.num() - expr2.num());
    }

    protected XNumber mod(XPathSupport execContext, Node context, int opPos) throws SAXException {
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        XObject expr2 = this.execute(execContext, context, expr2Pos);
        return new XNumber(expr1.num() % expr2.num());
    }

    protected XNumber mult(XPathSupport execContext, Node context, int opPos) throws SAXException {
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        XObject expr2 = this.execute(execContext, context, expr2Pos);
        return new XNumber(expr1.num() * expr2.num());
    }

    protected XNumber neg(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr1 = this.execute(execContext, context, opPos + 2);
        return new XNumber(-expr1.num());
    }

    public double nodeTest(XPathSupport execContext, Node context, int opPos, int argLen, int stepType) throws SAXException {
        this.warn(context, 7);
        return Double.NEGATIVE_INFINITY;
    }

    protected XBoolean notequals(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr2;
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        return !expr1.equals(expr2 = this.execute(execContext, context, expr2Pos)) ? m_true : m_false;
    }

    protected XNumber number(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr1 = this.execute(execContext, context, opPos + 2);
        return new XNumber(expr1.num());
    }

    protected XNumber numberlit(XPathSupport execContext, Node context, int opPos) {
        opPos = XPath.getFirstChildPos(opPos);
        return (XNumber)this.m_tokenQueue[this.m_opMap[opPos]];
    }

    protected XBoolean or(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr2;
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        XBoolean result = !expr1.bool() ? (!(expr2 = this.execute(execContext, context, expr2Pos)).bool() ? new XBoolean(false) : new XBoolean(true)) : new XBoolean(true);
        return result;
    }

    protected XNumber plus(XPathSupport execContext, Node context, int opPos) throws SAXException {
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        XObject expr2 = this.execute(execContext, context, expr2Pos);
        return new XNumber(expr1.num() + expr2.num());
    }

    public XObject predicate(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr1 = this.execute(execContext, context, opPos + 2);
        int objType = expr1.getType();
        if (objType != 2 && objType != 1) {
            expr1 = expr1.bool() ? m_true : m_false;
        }
        return expr1;
    }

    protected XNumber quo(XPathSupport execContext, Node context, int opPos) throws SAXException {
        this.warn(5);
        opPos = XPath.getFirstChildPos(opPos);
        int expr2Pos = this.getNextOpPos(opPos);
        XObject expr1 = this.execute(execContext, context, opPos);
        XObject expr2 = this.execute(execContext, context, expr2Pos);
        return new XNumber((int)(expr1.num() / expr2.num()));
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            stream.defaultReadObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("In XPath.readObject: " + cnfe.getMessage());
        }
    }

    public void setProblemListener(ProblemListener l) {
        this.m_problemListener = l;
    }

    public void shrink() {
        int[] map = this.m_opMap;
        int n = this.m_opMap[1];
        this.m_opMap = new int[n + 4];
        int i = 0;
        while (i < n) {
            this.m_opMap[i] = map[i];
            ++i;
        }
        this.m_opMap[i] = 0;
        this.m_opMap[i + 1] = 0;
        this.m_opMap[i + 2] = 0;
        map = this.m_patternMap;
        n = this.m_patternMapSize;
        this.m_patternMap = new int[n + 4];
        i = 0;
        while (i < n) {
            this.m_patternMap[i] = map[i];
            ++i;
        }
        this.m_patternMap[i] = 0;
        this.m_patternMap[i + 1] = 0;
        this.m_patternMap[i + 2] = 0;
        Object[] tokens = this.m_tokenQueue;
        n = this.m_tokenQueueSize;
        this.m_tokenQueue = new Object[n + 4];
        i = 0;
        while (i < n) {
            this.m_tokenQueue[i] = tokens[i];
            ++i;
        }
        this.m_tokenQueue[i] = null;
        this.m_tokenQueue[i + 1] = null;
        this.m_tokenQueue[i + 2] = null;
    }

    protected MutableNodeList step(XPathSupport execContext, Node context, int opPos) throws SAXException {
        this.warn(context, 7);
        return null;
    }

    protected XString string(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject expr1 = this.execute(execContext, context, opPos + 2);
        return new XString(expr1.str());
    }

    private final void trace(String s) {
        System.out.println(s);
    }

    protected XNodeSet union(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XLocator xlocator = execContext.getXLocatorFromNode(context);
        if (xlocator == null) {
            xlocator = execContext.createXLocatorHandler();
        }
        XNodeSet results = xlocator.union(this, execContext, context, opPos);
        return results;
    }

    protected XObject variable(XPathSupport execContext, Node context, int opPos) throws SAXException {
        XObject result;
        opPos = XPath.getFirstChildPos(opPos);
        String varName = (String)this.m_tokenQueue[this.m_opMap[opPos]];
        QName qname = new QName(varName, execContext.getNamespaceContext());
        try {
            result = execContext.getVariable(qname);
        }
        catch (Exception exception) {
            this.error(23, new Object[]{varName});
            result = null;
        }
        if (result == null) {
            this.warn(context, 6, new Object[]{varName});
        }
        return result;
    }

    public void warn(int msg) throws SAXException {
        this.warn(null, msg, null);
    }

    public void warn(int msg, Object[] args) throws SAXException {
        this.warn(null, msg, args);
    }

    public void warn(Node sourceNode, int msg) throws SAXException {
        this.warn(sourceNode, msg, null);
    }

    public void warn(Node sourceNode, int msg, Object[] args) throws SAXException {
        String fmsg = XSLMessages.createXPATHWarning(msg, args);
        boolean shouldThrow = this.m_problemListener.problem((short)4, (short)1, null, sourceNode, fmsg, null, 0, 0);
        if (shouldThrow) {
            throw new XPathException(fmsg);
        }
    }

    protected XObject xpath(XPathSupport execContext, Node context, int opPos) throws SAXException {
        return this.execute(execContext, context, opPos + 2);
    }
}

