/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import org.apache.xalan.xpath.FoundIndex;
import org.apache.xalan.xpath.MutableNodeList;
import org.apache.xalan.xpath.MutableNodeListImpl;
import org.apache.xalan.xpath.NodeCallback;
import org.apache.xalan.xpath.SimpleNodeLocatorFactory;
import org.apache.xalan.xpath.UnionContext;
import org.apache.xalan.xpath.XLocator;
import org.apache.xalan.xpath.XNodeSet;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathFactory;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XString;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class SimpleNodeLocator
implements XLocator,
Serializable {
    private static SimpleNodeLocator m_locater = null;

    public static XLocator connect(String path, String fileSpec) {
        m_locater = m_locater == null ? new SimpleNodeLocator() : m_locater;
        return m_locater;
    }

    public XNodeSet connectToNodes(XPath xpath, XPathSupport execContext, Node context, int opPos, Vector connectArgs) throws SAXException {
        String fileSpec = ((XObject)connectArgs.elementAt(0)).str();
        FileFilter filter = null;
        String filterSpec = null;
        if (connectArgs.size() > 1) {
            filterSpec = ((XObject)connectArgs.elementAt(1)).str();
            filter = new FileFilter(filterSpec);
        }
        File dir = new File(fileSpec);
        XNodeSet results = new XNodeSet();
        MutableNodeList mnl = results.mutableNodeset();
        if (dir != null) {
            String[] filenames;
            String[] stringArray = filenames = filter != null ? dir.list(filter) : dir.list();
            if (filenames != null) {
                int nFiles = filenames.length;
                int i = 0;
                while (i < nFiles) {
                    try {
                        String urlString = "file:" + dir.getAbsolutePath() + File.separatorChar + filenames[i];
                        URL url = new URL(urlString);
                        Document doc = execContext.parseXML(url, null, null);
                        if (doc != null) {
                            if (xpath.m_opMap[opPos] == 28) {
                                XNodeSet xnl = xpath.locationPath(execContext, doc, opPos);
                                if (xnl != null) {
                                    mnl.addNodes(xnl.nodeset());
                                    execContext.associateXLocatorToNode(doc, this);
                                }
                            } else {
                                mnl.addNode(doc);
                                execContext.associateXLocatorToNode(doc, this);
                            }
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Couldn't parse file: " + e.getMessage());
                    }
                    ++i;
                }
            } else {
                System.out.println("Couldn't get a file list from filespec");
            }
        } else {
            System.out.println("Filespec was bad in connect");
        }
        return results;
    }

    protected MutableNodeList depthStep(XPath xpath, XPathSupport execContext, Node context, UnionContext unionContext, int indexPos) throws SAXException {
        MutableNodeListImpl queryResults = new MutableNodeListImpl();
        Node top = context;
        NodeCallback callback = execContext.getCallback();
        Object callbackInfo = execContext.getCallbackInfo();
        execContext.setCallback(null, null);
        boolean isSelf = true;
        int nLP = unionContext.getLocationPathCount();
        boolean[] walkInstructions = new boolean[2];
        while (context != null) {
            Node nextNode;
            boolean hasChildNodes = context.getNodeType() != 2 ? context.hasChildNodes() : false;
            boolean shouldProcess = this.evalSteps(xpath, execContext, context, unionContext, nLP, hasChildNodes, isSelf, walkInstructions);
            boolean shouldWalkSubtree = walkInstructions[0];
            boolean shouldWalkAttributes = walkInstructions[1];
            if (shouldProcess) {
                if (callback != null) {
                    callback.processLocatedNode(execContext, context, callbackInfo);
                } else {
                    queryResults.addNode(context);
                }
            }
            if (shouldWalkAttributes) {
                if (!hasChildNodes) {
                    int x = 0;
                    while (x < nLP) {
                        int nextOpPos = unionContext.peek(x);
                        if (nextOpPos != -10000 && xpath.m_opMap[nextOpPos = xpath.getNextOpPos(nextOpPos)] != 39) {
                            nextOpPos = -10000;
                        }
                        unionContext.push(x, nextOpPos, 1);
                        ++x;
                    }
                }
                NamedNodeMap attrs = context.getAttributes();
                int n = attrs.getLength();
                int k = 0;
                while (k < n) {
                    shouldProcess = this.evalSteps(xpath, execContext, attrs.item(k), unionContext, nLP, false, isSelf, null);
                    if (shouldProcess) {
                        if (callback != null) {
                            callback.processLocatedNode(execContext, attrs.item(k), callbackInfo);
                        } else {
                            queryResults.addNode(context);
                        }
                    }
                    ++k;
                }
                if (!hasChildNodes) {
                    unionContext.pop();
                }
            }
            if (isSelf) {
                isSelf = false;
            }
            if (shouldWalkSubtree && hasChildNodes) {
                nextNode = context.getFirstChild();
            } else {
                nextNode = null;
                if (hasChildNodes) {
                    unionContext.pop();
                }
            }
            while (nextNode == null) {
                if (top.equals(context)) break;
                nextNode = context.getNextSibling();
                if (nextNode != null) continue;
                unionContext.pop();
                context = context.getParentNode();
                if (context != null && !top.equals(context)) continue;
                nextNode = null;
                break;
            }
            context = nextNode;
        }
        return queryResults;
    }

    boolean evalSteps(XPath xpath, XPathSupport execContext, Node context, UnionContext unionContext, int nLP, boolean hasChildNodes, boolean isSelf, boolean[] walkInstructions) throws SAXException {
        boolean shouldProcessNode = false;
        boolean shouldWalkSubtree = false;
        boolean shouldWalkAttributes = false;
        int i = 0;
        while (i < nLP) {
            int stepType;
            int opPos = unionContext.peek(i);
            int argLen = 0;
            if (opPos == -10000) {
                stepType = -10000;
                argLen = 0;
            } else {
                stepType = xpath.m_opMap[opPos];
                int posOfNext = xpath.getNextOpPos(opPos);
                int nextStepType = xpath.m_opMap[posOfNext];
                if (!isSelf || stepType == 42 || stepType == 48) {
                    int posOfNextIfSuccess;
                    int childPosOfStep = XPath.getFirstChildPosOfStep(opPos);
                    argLen = xpath.getArgLengthOfStep(opPos);
                    int origStepType = stepType;
                    if (stepType == 41 || stepType == 42) {
                        childPosOfStep = XPath.getFirstChildPosOfStep(posOfNext);
                        argLen = xpath.getArgLengthOfStep(posOfNext);
                        posOfNextIfSuccess = xpath.getNextOpPos(posOfNext);
                        stepType = nextStepType;
                    } else {
                        posOfNextIfSuccess = posOfNext;
                    }
                    if (this.nodeTest(xpath, execContext, context, childPosOfStep, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                        boolean doNotFilter = this.testPredicates(xpath, execContext, context, unionContext, opPos, i);
                        opPos = doNotFilter ? posOfNext : -10000;
                        argLen = 0;
                        if (opPos != -10000) {
                            if (nextStepType == -1) {
                                if (origStepType != 41 && origStepType != 42) {
                                    stepType = -10000;
                                }
                                shouldProcessNode = true;
                            } else {
                                shouldWalkSubtree = true;
                                if (!shouldWalkAttributes && nextStepType == 39) {
                                    shouldWalkAttributes = true;
                                }
                            }
                            unionContext.incrementNodePosition(i);
                        }
                    }
                    if (hasChildNodes) {
                        argLen = 0;
                        if (origStepType != 41 && origStepType != 42) {
                            opPos = -10000;
                        }
                    }
                } else {
                    shouldWalkSubtree = true;
                }
            }
            if (hasChildNodes) {
                opPos += argLen;
                unionContext.push(i, opPos, 1);
            }
            ++i;
        }
        if (walkInstructions != null) {
            walkInstructions[0] = shouldWalkSubtree;
            walkInstructions[1] = shouldWalkAttributes;
        }
        return shouldProcessNode;
    }

    public static XPathFactory factory() {
        return new SimpleNodeLocatorFactory();
    }

    protected int findAncestors(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        context = execContext.getParentOfNode(context);
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        while (context != null) {
            if (this.nodeTest(xpath, execContext, context, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                subQueryResults.addNode(context);
            }
            context = execContext.getParentOfNode(context);
        }
        return argLen + 3;
    }

    protected int findAncestorsOrSelf(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        while (context != null) {
            if (this.nodeTest(xpath, execContext, context, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                subQueryResults.addNode(context);
            }
            context = execContext.getParentOfNode(context);
        }
        return argLen + 3;
    }

    protected int findAttributes(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        NamedNodeMap attributeList;
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        if (context != null && context.getNodeType() == 1 && (attributeList = context.getAttributes()) != null) {
            int nAttrs = attributeList.getLength();
            int j = 0;
            while (j < nAttrs) {
                Attr attr = (Attr)attributeList.item(j);
                if (this.nodeTest(xpath, execContext, attr, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                    subQueryResults.addNode(attr);
                }
                ++j;
            }
        }
        return argLen + 3;
    }

    protected int findChildren(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        if (context.getNodeType() != 11) {
            Node c = context.getFirstChild();
            while (c != null) {
                if (this.nodeTest(xpath, execContext, c, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                    subQueryResults.addNode(c);
                }
                c = c.getNextSibling();
            }
        } else {
            NodeList children = context.getChildNodes();
            int n = children.getLength();
            int i = 0;
            while (i < n) {
                Node c = children.item(i);
                if (this.nodeTest(xpath, execContext, c, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                    subQueryResults.addNode(c);
                }
                c = c.getNextSibling();
                ++i;
            }
        }
        return argLen + 3;
    }

    protected int findDescendants(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        Node pos = context;
        if (context.getNodeType() != 11) {
            while (pos != null) {
                if ((stepType == 42 || context != pos) && this.nodeTest(xpath, execContext, pos, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                    subQueryResults.addNode(pos);
                }
                Node nextNode = pos.getFirstChild();
                while (nextNode == null) {
                    if (context == pos) break;
                    nextNode = pos.getNextSibling();
                    if (nextNode != null || context != (pos = pos.getParentNode()) && pos != null) continue;
                    nextNode = null;
                    break;
                }
                pos = nextNode;
            }
        } else {
            NodeList children = context.getChildNodes();
            int n = children.getLength();
            int i = 0;
            while (i < n) {
                context = pos = children.item(i);
                while (pos != null) {
                    if ((stepType == 42 || context != pos) && this.nodeTest(xpath, execContext, pos, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                        subQueryResults.addNode(pos);
                    }
                    Node nextNode = pos.getFirstChild();
                    while (nextNode == null) {
                        if (context == pos) break;
                        nextNode = pos.getNextSibling();
                        if (nextNode != null || context != (pos = pos.getParentNode()) && pos != null) continue;
                        nextNode = null;
                        break;
                    }
                    pos = nextNode;
                }
                ++i;
            }
        }
        return argLen + 3;
    }

    protected int findFollowing(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        Document doc = context.getOwnerDocument();
        Node pos = context;
        while (pos != null) {
            Node nextNode;
            if (pos != context) {
                if (this.nodeTest(xpath, execContext, pos, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                    subQueryResults.addNodeInDocOrder(pos, execContext);
                }
                nextNode = pos.getFirstChild();
            } else {
                nextNode = null;
            }
            while (nextNode == null) {
                nextNode = pos.getNextSibling();
                if (nextNode != null || doc != (pos = pos.getParentNode()) && pos != null) continue;
                nextNode = null;
                break;
            }
            pos = nextNode;
        }
        return argLen + 3;
    }

    protected int findFollowingSiblings(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        Node pos = context.getNextSibling();
        while (pos != null) {
            if (this.nodeTest(xpath, execContext, pos, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                subQueryResults.addNode(pos);
            }
            pos = pos.getNextSibling();
        }
        return argLen + 3;
    }

    protected int findNamespace(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        xpath.error(context, 14);
        return argLen + 3;
    }

    protected int findNodeSet(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        XObject obj = xpath.execute(execContext, context, opPos);
        NodeList nl = obj.nodeset();
        subQueryResults.addNodes(nl);
        return xpath.m_opMap[opPos + 1];
    }

    protected int findNodesOnUnknownAxis(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        xpath.error(context, 15, new Object[]{Integer.toString(stepType)});
        return argLen + 3;
    }

    protected int findParent(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        context = execContext.getParentOfNode(context);
        int argLen = xpath.getArgLengthOfStep(opPos);
        if (context != null) {
            opPos = XPath.getFirstChildPosOfStep(opPos);
            if (argLen > 0) {
                if (this.nodeTest(xpath, execContext, context, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                    subQueryResults.addNode(context);
                }
            } else {
                subQueryResults.addNode(context);
            }
        }
        return argLen + 3;
    }

    protected int findPreceding(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        Document doc = context.getOwnerDocument();
        Node pos = doc;
        while (pos != null) {
            if (context == pos) break;
            if (this.nodeTest(xpath, execContext, pos, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                boolean isParent = false;
                Node parent = execContext.getParentOfNode(context);
                while (parent != null) {
                    if (parent == pos) {
                        isParent = true;
                        break;
                    }
                    parent = execContext.getParentOfNode(parent);
                }
                if (!isParent) {
                    subQueryResults.insertNode(pos, 0);
                }
            }
            Node nextNode = pos.getFirstChild();
            while (nextNode == null) {
                nextNode = pos.getNextSibling();
                if (nextNode != null || doc != (pos = pos.getParentNode()) && pos != null) continue;
                nextNode = null;
                break;
            }
            pos = nextNode;
        }
        return argLen + 3;
    }

    protected int findPrecedingSiblings(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        Node pos = context.getPreviousSibling();
        while (pos != null) {
            if (this.nodeTest(xpath, execContext, pos, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                subQueryResults.addNode(pos);
            }
            pos = pos.getPreviousSibling();
        }
        return argLen + 3;
    }

    protected int findRoot(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        Document docContext = context.getNodeType() == 9 ? (Document)context : context.getOwnerDocument();
        subQueryResults.addNode(docContext);
        return argLen + 3;
    }

    protected int findSelf(XPath xpath, XPathSupport execContext, Node context, int opPos, int stepType, MutableNodeList subQueryResults) throws SAXException {
        int argLen = xpath.getArgLengthOfStep(opPos);
        opPos = XPath.getFirstChildPosOfStep(opPos);
        if (argLen > 0) {
            if (this.nodeTest(xpath, execContext, context, opPos, argLen, stepType) != Double.NEGATIVE_INFINITY) {
                subQueryResults.addNode(context);
            }
        } else {
            subQueryResults.addNode(context);
        }
        return argLen + 3;
    }

    public static XLocator getDefaultLocator() {
        m_locater = m_locater == null ? new SimpleNodeLocator() : m_locater;
        return m_locater;
    }

    public XNodeSet locationPath(XPath xpath, XPathSupport execContext, Node context, int opPos) throws SAXException {
        MutableNodeList mnl = this.step(xpath, execContext, context, opPos = XPath.getFirstChildPos(opPos));
        XNodeSet results = mnl != null ? new XNodeSet(mnl) : new XNodeSet(new MutableNodeListImpl());
        return results;
    }

    public double locationPathPattern(XPath xpath, XPathSupport execContext, Node context, int opPos) throws SAXException {
        opPos = XPath.getFirstChildPos(opPos);
        double[] scoreHolder = new double[]{Double.NEGATIVE_INFINITY};
        this.stepPattern(xpath, execContext, context, opPos, scoreHolder);
        return scoreHolder[0];
    }

    public double nodeTest(XPath xpath, XPathSupport execContext, Node context, int opPos, int argLen, int stepType) throws SAXException {
        double score;
        int testType = xpath.m_opMap[opPos];
        short nodeType = context.getNodeType();
        ++opPos;
        block0 : switch (testType) {
            case 1030: {
                score = nodeType == 8 ? -0.5 : Double.NEGATIVE_INFINITY;
                break;
            }
            case 1031: {
                score = (nodeType == 4 || nodeType == 3) && !execContext.shouldStripSourceNode(context) ? -0.5 : Double.NEGATIVE_INFINITY;
                break;
            }
            case 1032: {
                if (nodeType == 7) {
                    if (argLen == 2) {
                        XString name = (XString)xpath.m_tokenQueue[xpath.m_opMap[opPos]];
                        score = ((ProcessingInstruction)context).getNodeName().equals(name.str()) ? 0.0 : Double.NEGATIVE_INFINITY;
                        break;
                    }
                    if (argLen == 1) {
                        score = -0.5;
                        break;
                    }
                    score = Double.NEGATIVE_INFINITY;
                    xpath.error(17);
                    break;
                }
                score = Double.NEGATIVE_INFINITY;
                break;
            }
            case 1033: {
                if (nodeType == 4 || nodeType == 3) {
                    score = !execContext.shouldStripSourceNode(context) ? -0.5 : Double.NEGATIVE_INFINITY;
                    break;
                }
                score = -0.5;
                break;
            }
            case 35: {
                score = nodeType == 11 || nodeType == 9 ? 0.5 : Double.NEGATIVE_INFINITY;
                break;
            }
            case 34: {
                String targetLocalName;
                boolean test;
                int queueIndex = xpath.m_opMap[opPos];
                String targetNS = queueIndex >= 0 ? (String)xpath.m_tokenQueue[xpath.m_opMap[opPos]] : null;
                boolean isTotallyWild = targetNS == null && xpath.m_opMap[++opPos] == -3;
                boolean processNamespaces = execContext.getProcessNamespaces();
                boolean didMatchNS = false;
                if (!isTotallyWild && processNamespaces) {
                    String contextNS = execContext.getNamespaceOfNode(context);
                    if (targetNS != null && contextNS != null) {
                        test = contextNS.equals(targetNS);
                        didMatchNS = true;
                    } else {
                        test = queueIndex == -3 || (contextNS == null || contextNS.length() == 0) && (targetNS == null || targetNS.length() == 0);
                    }
                } else {
                    test = true;
                }
                queueIndex = xpath.m_opMap[opPos];
                String string = targetLocalName = queueIndex >= 0 ? (String)xpath.m_tokenQueue[xpath.m_opMap[opPos]] : null;
                if (!test) {
                    score = Double.NEGATIVE_INFINITY;
                    break;
                }
                switch (nodeType) {
                    case 2: {
                        if (stepType == 39) {
                            if (queueIndex == -3) {
                                String attrName = ((Attr)context).getNodeName();
                                if (processNamespaces) {
                                    score = !attrName.startsWith("xmlns:") && !attrName.equals("xmlns") ? -0.5 : Double.NEGATIVE_INFINITY;
                                    break block0;
                                }
                                score = -0.5;
                                break block0;
                            }
                            String localAttrName = execContext.getLocalNameOfNode(context);
                            score = localAttrName.equals(targetLocalName) ? 0.0 : Double.NEGATIVE_INFINITY;
                            break block0;
                        }
                        score = Double.NEGATIVE_INFINITY;
                        break block0;
                    }
                    case 1: {
                        if (stepType != 39) {
                            if (queueIndex == -3) {
                                score = didMatchNS ? -0.25 : -0.5;
                                break block0;
                            }
                            score = execContext.getLocalNameOfNode(context).equals(targetLocalName) ? 0.0 : Double.NEGATIVE_INFINITY;
                            break block0;
                        }
                        score = Double.NEGATIVE_INFINITY;
                        break block0;
                    }
                }
                score = Double.NEGATIVE_INFINITY;
                break;
            }
            default: {
                score = Double.NEGATIVE_INFINITY;
            }
        }
        return score;
    }

    protected MutableNodeList predicates(XPath xpath, XPathSupport execContext, Node context, int opPos, MutableNodeList subQueryResults, int[] endPredicatesPos) throws SAXException {
        boolean hasNulls = false;
        int nextStepType = xpath.m_opMap[opPos];
        while (nextStepType == 29) {
            int nContexts = subQueryResults.getLength();
            int i = 0;
            while (i < nContexts) {
                XObject pred = xpath.predicate(execContext, subQueryResults.item(i), opPos);
                if (pred.getType() == 2) {
                    if (i + 1 != (int)pred.num()) {
                        hasNulls = true;
                        subQueryResults.setItemNull(i);
                    }
                } else if (!pred.bool()) {
                    hasNulls = true;
                    subQueryResults.setItemNull(i);
                }
                ++i;
            }
            nextStepType = xpath.m_opMap[opPos = xpath.getNextOpPos(opPos)];
            if (nextStepType != 29) continue;
            subQueryResults = new MutableNodeListImpl(subQueryResults);
            execContext.setContextNodeList(subQueryResults);
        }
        endPredicatesPos[0] = opPos;
        if (hasNulls) {
            subQueryResults = new MutableNodeListImpl(subQueryResults);
        }
        return subQueryResults;
    }

    public static XLocator query(String path, String fileSpec) {
        m_locater = m_locater == null ? new SimpleNodeLocator() : m_locater;
        return m_locater;
    }

    protected MutableNodeList step(XPath xpath, XPathSupport execContext, Node context, int opPos) throws SAXException {
        int argLen;
        int stepType = xpath.m_opMap[opPos];
        MutableNodeList subQueryResults = new MutableNodeListImpl();
        MutableNodeList queryResults = null;
        boolean shouldReorder = false;
        boolean continueStepRecursion = true;
        boolean mightHaveToChangeLocators = false;
        switch (stepType) {
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                argLen = this.findNodeSet(xpath, execContext, context, opPos, stepType, subQueryResults);
                mightHaveToChangeLocators = true;
                break;
            }
            case 55: {
                argLen = this.findRoot(xpath, execContext, context, opPos, stepType, subQueryResults);
                break;
            }
            case 45: {
                argLen = this.findParent(xpath, execContext, context, opPos, stepType, subQueryResults);
                break;
            }
            case 48: {
                argLen = this.findSelf(xpath, execContext, context, opPos, stepType, subQueryResults);
                break;
            }
            case 37: {
                argLen = this.findAncestors(xpath, execContext, context, opPos, stepType, subQueryResults);
                shouldReorder = true;
                break;
            }
            case 38: {
                argLen = this.findAncestorsOrSelf(xpath, execContext, context, opPos, stepType, subQueryResults);
                shouldReorder = true;
                break;
            }
            case 94: {
                continueStepRecursion = false;
            }
            case 39: {
                argLen = this.findAttributes(xpath, execContext, context, opPos, stepType, subQueryResults);
                break;
            }
            case 95: 
            case 96: {
                continueStepRecursion = false;
            }
            case 40: {
                argLen = this.findChildren(xpath, execContext, context, opPos, stepType, subQueryResults);
                break;
            }
            case 41: 
            case 42: {
                argLen = this.findDescendants(xpath, execContext, context, opPos, stepType, subQueryResults);
                break;
            }
            case 43: {
                argLen = this.findFollowing(xpath, execContext, context, opPos, stepType, subQueryResults);
                break;
            }
            case 44: {
                argLen = this.findFollowingSiblings(xpath, execContext, context, opPos, stepType, subQueryResults);
                break;
            }
            case 46: {
                argLen = this.findPreceding(xpath, execContext, context, opPos, stepType, subQueryResults);
                shouldReorder = true;
                break;
            }
            case 47: {
                argLen = this.findPrecedingSiblings(xpath, execContext, context, opPos, stepType, subQueryResults);
                shouldReorder = true;
                break;
            }
            case 49: {
                argLen = this.findNamespace(xpath, execContext, context, opPos, stepType, subQueryResults);
                break;
            }
            default: {
                argLen = this.findNodesOnUnknownAxis(xpath, execContext, context, opPos, stepType, subQueryResults);
            }
        }
        int nextStepType = xpath.m_opMap[opPos += argLen];
        NodeList savedContextNodeList = execContext.getContextNodeList();
        execContext.setContextNodeList(subQueryResults);
        if (nextStepType == 29) {
            int[] endPredicatesPos = new int[]{-42};
            subQueryResults = this.predicates(xpath, execContext, context, opPos, subQueryResults, endPredicatesPos);
            opPos = endPredicatesPos[0];
            nextStepType = xpath.m_opMap[opPos];
        }
        XLocator xlocator = this;
        if (nextStepType != -1 && continueStepRecursion) {
            int nContexts = subQueryResults.getLength();
            int i = 0;
            while (i < nContexts) {
                Node node = subQueryResults.item(i);
                if (node != null) {
                    if (mightHaveToChangeLocators) {
                        xlocator = execContext.getXLocatorFromNode(node);
                    }
                    MutableNodeList mnl = this.step(xpath, execContext, node, opPos);
                    if (queryResults == null) {
                        queryResults = mnl;
                    } else {
                        queryResults.addNodesInDocOrder(mnl, execContext);
                    }
                }
                ++i;
            }
            if (queryResults == null) {
                queryResults = new MutableNodeListImpl();
            }
        } else if (shouldReorder) {
            queryResults = new MutableNodeListImpl();
            queryResults.addNodesInDocOrder(subQueryResults, execContext);
        } else {
            queryResults = subQueryResults;
        }
        execContext.setContextNodeList(savedContextNodeList);
        return queryResults;
    }

    /*
     * Unable to fully structure code
     */
    protected Node stepPattern(XPath xpath, XPathSupport execContext, Node context, int opPos, double[] scoreHolder) throws SAXException {
        block25: {
            startOpPos = opPos;
            stepType = xpath.m_opMap[opPos];
            endStep = xpath.getNextOpPos(opPos);
            nextStepType = xpath.m_opMap[endStep];
            if (nextStepType != -1) {
                if ((context = this.stepPattern(xpath, execContext, context, endStep, scoreHolder)) == null) {
                    scoreHolder[0] = -Infinity;
                }
                if (scoreHolder[0] == -Infinity) {
                    return null;
                }
                scoreHolder[0] = 0.5;
                if ((context = execContext.getParentOfNode(context)) == null) {
                    return null;
                }
            }
            block1 : switch (stepType) {
                case 27: {
                    argLen = xpath.m_opMap[opPos + 1];
                    obj = xpath.execute(execContext, context, opPos);
                    nl = obj.nodeset();
                    len = nl.getLength();
                    score = -Infinity;
                    i = 0;
                    while (i < len) {
                        n = nl.item(i);
                        v0 = score = n.equals(context) != false ? 0.5 : -Infinity;
                        if (score == 0.5) {
                            context = n;
                            break block1;
                        }
                        ++i;
                    }
                    break;
                }
                case 55: {
                    argLen = xpath.getArgLengthOfStep(opPos);
                    opPos = XPath.getFirstChildPosOfStep(opPos);
                    docContext = context.getNodeType() == 9 ? (Document)context : context.getOwnerDocument();
                    v1 = score = docContext == context ? 0.5 : -Infinity;
                    if (score != 0.5) break;
                    context = docContext;
                    break;
                }
                case 94: {
                    argLen = xpath.getArgLengthOfStep(opPos);
                    opPos = XPath.getFirstChildPosOfStep(opPos);
                    score = this.nodeTest(xpath, execContext, context, opPos, argLen, 39);
                    break;
                }
                case 95: {
                    argLen = xpath.getArgLengthOfStep(opPos);
                    if (context.getNodeType() != 2) {
                        opPos = XPath.getFirstChildPosOfStep(opPos);
                        score = -Infinity;
                        while (context != null) {
                            score = this.nodeTest(xpath, execContext, context, opPos, argLen, stepType);
                            if (score != -Infinity) break block1;
                            context = context.getParentNode();
                        }
                        break;
                    }
                    score = -Infinity;
                    break;
                }
                case 96: {
                    argLen = xpath.getArgLengthOfStep(opPos);
                    if (context.getNodeType() != 2) {
                        opPos = XPath.getFirstChildPosOfStep(opPos);
                        score = this.nodeTest(xpath, execContext, context, opPos, argLen, stepType);
                        break;
                    }
                    score = -Infinity;
                    break;
                }
                default: {
                    argLen = xpath.getArgLengthOfStep(opPos);
                    opPos = XPath.getFirstChildPosOfStep(opPos);
                    score = -Infinity;
                    xpath.error(context, 16);
                }
            }
            nextStepType = xpath.m_opMap[opPos += argLen];
            if (score != -Infinity && nextStepType == 29) {
                score = 0.5;
                try {
                    execContext.setThrowFoundIndex(true);
                    opPos = startPredicates = opPos;
                    nextStepType = xpath.m_opMap[opPos];
                    while (nextStepType == 29) {
                        pred = xpath.predicate(execContext, context, opPos);
                        if (pred.getType() == 2) {
                            throw new FoundIndex();
                        }
                        if (!pred.bool()) {
                            score = -Infinity;
                            break;
                        }
                        opPos = xpath.getNextOpPos(opPos);
                        nextStepType = xpath.m_opMap[opPos];
                    }
                    execContext.setThrowFoundIndex(false);
                    break block25;
                }
                catch (FoundIndex v2) {
                    execContext.setThrowFoundIndex(false);
                    parentContext = execContext.getParentOfNode(context);
                    mnl = this.step(xpath, execContext, parentContext, startOpPos);
                    nNodes = mnl.getLength();
                    score = -Infinity;
                    i = 0;
                    ** while (i < nNodes)
                }
lbl-1000:
                // 1 sources

                {
                    child = mnl.item(i);
                    if (child != null && child.equals(context)) {
                        score = 0.5;
                        break;
                    }
                    ++i;
                    continue;
                }
            }
        }
        if (scoreHolder[0] == -Infinity || score == -Infinity) {
            scoreHolder[0] = score;
        }
        return score == -Infinity ? null : context;
    }

    protected boolean testPredicates(XPath xpath, XPathSupport execContext, Node context, UnionContext unionContext, int opPos, int whichLocationPath) throws SAXException {
        boolean doNotFilter = true;
        int childPosOfStep = XPath.getFirstChildPosOfStep(opPos);
        int argLen = xpath.getArgLengthOfStep(opPos);
        int nextStepType = xpath.m_opMap[childPosOfStep += argLen];
        while (nextStepType == 29) {
            XObject pred = xpath.predicate(execContext, context, childPosOfStep);
            if (pred.getType() == 2) {
                if (unionContext.getNodePosition(whichLocationPath) != (int)pred.num()) {
                    doNotFilter = false;
                }
            } else if (!pred.bool()) {
                doNotFilter = false;
            }
            childPosOfStep = xpath.getNextOpPos(childPosOfStep);
            nextStepType = xpath.m_opMap[childPosOfStep];
        }
        return doNotFilter;
    }

    public XNodeSet union(XPath xpath, XPathSupport execContext, Node context, int opPos) throws SAXException {
        XNodeSet resultNodeSet = null;
        opPos = XPath.getFirstChildPos(opPos);
        while (xpath.m_opMap[opPos] == 28) {
            int nextOpPos = xpath.getNextOpPos(opPos);
            XNodeSet expr = (XNodeSet)xpath.execute(execContext, context, opPos);
            if (resultNodeSet == null) {
                resultNodeSet = expr;
            } else {
                MutableNodeList nl = resultNodeSet.mutableNodeset();
                nl.addNodesInDocOrder(expr.nodeset(), execContext);
            }
            opPos = nextOpPos;
        }
        return resultNodeSet;
    }

    class FileFilter
    implements FilenameFilter {
        private String m_filterSpec;

        public FileFilter(String filter) {
            this.m_filterSpec = filter;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.m_filterSpec);
        }
    }
}

