/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.lang.reflect.Constructor;
import java.net.URL;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPath;
import org.apache.xalan.xpath.XPathProcessorImpl;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.res.XPATHErrorResources;
import org.apache.xalan.xpath.xml.ProblemListenerDefault;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Process {
    public static void main(String[] argv) throws SAXException {
        XPATHErrorResources resbundle = (XPATHErrorResources)XSLMessages.loadResourceBundle("org.apache.xalan.xpath.res.XPATHErrorResources");
        if (argv.length > 1) {
            Document doc;
            XPathSupport callbacks = null;
            String parserLiaisonClassName = "org.apache.xalan.xpath.xdom.XercesLiaison";
            try {
                Class<?> parserLiaisonClass = Class.forName(parserLiaisonClassName);
                Constructor<?> parserLiaisonCtor = parserLiaisonClass.getConstructor(null);
                callbacks = (XPathSupport)parserLiaisonCtor.newInstance(null);
            }
            catch (Exception exception) {
                System.err.println(XSLMessages.createXPATHMessage(39, new Object[]{parserLiaisonClassName}));
                return;
            }
            XPathProcessorImpl processor = new XPathProcessorImpl(callbacks);
            XPath xpath = new XPath(callbacks, new ProblemListenerDefault());
            String inputURI = null;
            String path = null;
            String match = null;
            int i = 0;
            while (i < argv.length) {
                if ("-in".equalsIgnoreCase(argv[i])) {
                    inputURI = argv[++i];
                } else if ("-select".equalsIgnoreCase(argv[i])) {
                    path = argv[++i];
                } else if ("-match".equalsIgnoreCase(argv[i])) {
                    match = argv[++i];
                }
                ++i;
            }
            if (path == null) {
                System.out.println(XSLMessages.createXPATHMessage(40, null));
                return;
            }
            if (inputURI != null) {
                System.out.println("Parsing XML...");
                processor.pushTime(inputURI);
                URL url = callbacks.getURLFromString(inputURI, null);
                doc = callbacks.parseXML(url, null, null);
                processor.displayDuration("Parse ", inputURI);
            } else {
                doc = callbacks.getDOMFactory();
            }
            processor.pushTime(xpath);
            processor.initXPath(xpath, path, null);
            processor.displayDuration("Initialization of xpath ", xpath);
            XPath matchPat = null;
            if (match != null) {
                matchPat = new XPath(callbacks, new ProblemListenerDefault());
                processor.initMatchPattern(matchPat, match, null);
            }
            processor.pushTime(doc);
            XObject result = xpath.execute(callbacks, (Node)doc, null);
            processor.displayDuration("Execution of xpath ", doc);
            if (result.getType() == 4) {
                System.out.println("<results>");
                NodeList nl = result.nodeset();
                int nNodes = nl.getLength();
                int i2 = 0;
                while (i2 < nNodes) {
                    Node n = nl.item(i2);
                    System.out.print("  <node name='" + n.getNodeName() + "'");
                    if (matchPat != null) {
                        System.out.print(" match-value='" + matchPat.getMatchScore(callbacks, n) + "'");
                    }
                    if (n.getNodeType() != 2) {
                        Document owner = n.getNodeType() == 9 ? (Document)n : n.getOwnerDocument();
                        String docURI = callbacks.findURIFromDoc(owner);
                        System.out.print(" doc-ref='" + docURI + "'");
                    }
                    System.out.println("/>");
                    ++i2;
                }
                System.out.println("</results>");
            } else {
                System.out.println("XPath Result: \n" + result.str());
            }
        } else if (argv.length == 1) {
            XPathProcessorImpl.diagnoseXPathString(argv[0]);
        } else {
            Process.printArgOptions(resbundle);
        }
    }

    protected static void printArgOptions(XPATHErrorResources resbundle) {
        System.out.println(resbundle.getString("xpath_option"));
        System.out.println(resbundle.getString("optionIN"));
        System.out.println(resbundle.getString("optionSelect"));
        System.out.println(resbundle.getString("optionMatch"));
        System.out.println(resbundle.getString("optionAnyExpr"));
    }
}

