/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.InlineArea;
import org.apache.fop.layout.InlineSpace;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.RuleArea;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.LineGraphic;
import org.apache.fop.svg.RectGraphic;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.TextGraphic;

public class PDFRenderer
implements Renderer {
    protected PDFDocument pdfDoc = new PDFDocument();
    protected PDFResources pdfResources;
    PDFStream currentStream;
    protected String currentFontName;
    protected int currentFontSize;
    protected float currentRed = 0.0f;
    protected float currentGreen = 0.0f;
    protected float currentBlue = 0.0f;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    private int currentAreaContainerXPosition = 0;

    public void setProducer(String string) {
        this.pdfDoc.setProducer(string);
    }

    public void render(AreaTree areaTree, PrintWriter printWriter) throws IOException {
        System.err.println("rendering areas to PDF");
        this.pdfResources = this.pdfDoc.getResources();
        Enumeration enumeration = areaTree.getPages().elements();
        while (enumeration.hasMoreElements()) {
            this.renderPage((Page)enumeration.nextElement());
        }
        System.err.println("writing out PDF");
        this.pdfDoc.output(printWriter);
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, float f, float f2, float f3) {
        this.currentStream.add(f + " " + f2 + " " + f3 + " RG\n" + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " m " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " l " + (float)n5 / 1000.0f + " w S\n" + "0 0 0 RG\n");
    }

    protected void addRect(int n, int n2, int n3, int n4, float f, float f2, float f3) {
        this.currentStream.add(f + " " + f2 + " " + f3 + " RG\n" + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re S\n" + "0 0 0 RG\n");
    }

    protected void addRect(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, float f5, float f6) {
        this.currentStream.add(f4 + " " + f5 + " " + f6 + " rg\n" + f + " " + f2 + " " + f3 + " RG\n" + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re S\n" + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re f\n" + "0 0 0 RG 0 0 0 rg\n");
    }

    public void renderAreaContainer(AreaContainer areaContainer) {
        this.currentStream.add("1 0 0 1 " + (float)areaContainer.getXPosition() / 1000.0f + " " + (float)areaContainer.getYPosition() / 1000.0f + " Tm\n");
        this.currentYPosition = areaContainer.getYPosition();
        this.currentAreaContainerXPosition = areaContainer.getXPosition();
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderBlockArea(BlockArea blockArea) {
        int n = this.currentAreaContainerXPosition + blockArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = blockArea.getContentWidth();
        int n4 = blockArea.getHeight();
        ColorType colorType = blockArea.getBackgroundColor();
        if (colorType != null && colorType.alpha() == 0.0f) {
            this.addRect(n, n2, n3, -n4, colorType.red(), colorType.green(), colorType.blue(), colorType.red(), colorType.green(), colorType.blue());
        }
        Enumeration enumeration = blockArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentAreaContainerXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4 * 1000;
        FopImage fopImage = imageArea.getImage();
        int n5 = this.pdfDoc.addImage(fopImage);
        this.currentStream.add("ET\nq\n" + (float)fopImage.getWidth() / 1000.0f + " 0 0 " + (float)fopImage.getHeight() / 1000.0f + " " + (float)(n + fopImage.getX()) / 1000.0f + " " + (float)(n2 - n4 - fopImage.getY()) / 1000.0f + " cm\n" + "/Im" + n5 + " Do\nQ\nBT\n");
    }

    public void renderSVGArea(SVGArea sVGArea) {
        int n = this.currentAreaContainerXPosition;
        int n2 = this.currentYPosition;
        int n3 = sVGArea.getContentWidth();
        int n4 = sVGArea.getHeight();
        this.currentYPosition -= n4;
        Enumeration enumeration = sVGArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            int n5;
            int n6;
            int n7;
            Object e = enumeration.nextElement();
            if (e instanceof RectGraphic) {
                n7 = ((RectGraphic)e).x;
                n6 = ((RectGraphic)e).y;
                int n8 = ((RectGraphic)e).width;
                n5 = ((RectGraphic)e).height;
                this.addRect(n + n7, n2 - n6, n8, -n5, 0.0f, 0.0f, 0.0f);
                continue;
            }
            if (e instanceof LineGraphic) {
                n7 = ((LineGraphic)e).x1;
                n6 = ((LineGraphic)e).y1;
                int n9 = ((LineGraphic)e).x2;
                n5 = ((LineGraphic)e).y2;
                this.addLine(n + n7, n2 - n6, n + n9, n2 - n5, 0, 0.0f, 0.0f, 0.0f);
                continue;
            }
            if (!(e instanceof TextGraphic)) continue;
            n7 = ((TextGraphic)e).x;
            n6 = ((TextGraphic)e).y;
            String string = ((TextGraphic)e).s;
            this.currentStream.add("1 0 0 1 " + (float)(n + n7) / 1000.0f + " " + (float)(n2 - n6) / 1000.0f + " Tm " + "(" + string + ") Tj\n");
        }
    }

    public void renderInlineArea(InlineArea inlineArea) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = inlineArea.getFontState().getFontName();
        int n = inlineArea.getFontState().getFontSize();
        float f = inlineArea.getRed();
        float f2 = inlineArea.getGreen();
        float f3 = inlineArea.getBlue();
        if (!string.equals(this.currentFontName) || n != this.currentFontSize) {
            this.currentFontName = string;
            this.currentFontSize = n;
            stringBuffer = stringBuffer.append("/" + string + " " + n / 1000 + " Tf\n");
        }
        if (f != this.currentRed || f2 != this.currentGreen || f3 != this.currentBlue) {
            this.currentRed = f;
            this.currentGreen = f2;
            this.currentBlue = f3;
            stringBuffer = stringBuffer.append(f + " " + f2 + " " + f3 + " rg\n");
        }
        int n2 = this.currentXPosition;
        int n3 = this.currentYPosition;
        stringBuffer = stringBuffer.append("1 0 0 1 " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " Tm (");
        String string2 = inlineArea.getText();
        int n4 = string2.length();
        int n5 = 0;
        while (n5 < n4) {
            char c = string2.charAt(n5);
            if (c > '\u007f') {
                stringBuffer = stringBuffer.append("\\");
                stringBuffer = stringBuffer.append(Integer.toOctalString(c));
            } else {
                switch (c) {
                    case '(': {
                        stringBuffer = stringBuffer.append("\\(");
                        break;
                    }
                    case ')': {
                        stringBuffer = stringBuffer.append("\\)");
                        break;
                    }
                    case '\\': {
                        stringBuffer = stringBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        stringBuffer = stringBuffer.append(c);
                    }
                }
            }
            ++n5;
        }
        stringBuffer = stringBuffer.append(") Tj\n");
        this.currentStream.add(stringBuffer.toString());
        this.currentXPosition += inlineArea.getContentWidth();
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderLineArea(LineArea lineArea) {
        int n = this.currentAreaContainerXPosition + lineArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = lineArea.getContentWidth();
        int n4 = lineArea.getHeight();
        this.currentYPosition -= lineArea.getPlacementOffset();
        this.currentXPosition = n;
        int n5 = this.currentYPosition;
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.currentYPosition = n2 - n4;
    }

    public void renderPage(Page page) {
        this.currentStream = this.pdfDoc.makeStream();
        AreaContainer areaContainer = page.getBody();
        AreaContainer areaContainer2 = page.getBefore();
        AreaContainer areaContainer3 = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.currentStream.add("BT\n");
        this.renderAreaContainer(areaContainer);
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        if (areaContainer3 != null) {
            this.renderAreaContainer(areaContainer3);
        }
        this.currentStream.add("ET\n");
        this.pdfDoc.makePage(this.pdfResources, this.currentStream, page.getWidth() / 1000, page.getHeight() / 1000);
    }

    public void renderRuleArea(RuleArea ruleArea) {
        int n = this.currentAreaContainerXPosition + ruleArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = ruleArea.getContentWidth();
        int n4 = ruleArea.getHeight();
        int n5 = ruleArea.getRuleThickness();
        float f = ruleArea.getRed();
        float f2 = ruleArea.getGreen();
        float f3 = ruleArea.getBlue();
        this.addLine(n, n2, n + n3, n2, n5, f, f2, f3);
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo);
        FontSetup.addToResources(this.pdfDoc, fontInfo);
    }
}

