/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class Table
extends FObj {
    FontState fs;
    int breakBefore;
    int breakAfter;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    Vector columns = new Vector();
    int currentColumnNumber = 0;
    BlockArea blockArea;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public Table(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            object = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, (String)object, n);
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.isInListBody) {
                this.startIndent += this.bodyIndent + this.distanceBetweenStarts;
            }
            this.marker = 0;
            if (this.breakBefore == 3) {
                return new Status(4);
            }
            if (this.breakBefore == 5) {
                return new Status(6);
            }
            if (this.breakBefore == 4) {
                return new Status(5);
            }
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        this.blockArea = new BlockArea(this.fs, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, 0, 0, 0, 0);
        this.blockArea.setPage(area.getPage());
        this.blockArea.setBackgroundColor(this.backgroundColor);
        this.blockArea.start();
        this.currentColumnNumber = 0;
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            object = (FONode)this.children.elementAt(n2);
            if (object instanceof TableColumn) {
                TableColumn tableColumn = (TableColumn)object;
                int n3 = tableColumn.getColumnNumber();
                if (n3 == 0) {
                    n3 = this.currentColumnNumber + 1;
                }
                this.currentColumnNumber = n3;
                if (n3 > this.columns.size()) {
                    this.columns.setSize(n3);
                }
                this.columns.setElementAt(tableColumn, n3 - 1);
            } else if (object instanceof TableBody) {
                if (this.columns.size() == 0) {
                    System.err.println("WARNING: current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                ((TableBody)object).setColumns(this.columns);
                Status status = ((FONode)object).layout(this.blockArea);
                if (status.isIncomplete()) {
                    this.marker = n2;
                    if (n2 != 0 && status.getCode() == 2) {
                        status = new Status(3);
                    }
                    area.addChild(this.blockArea);
                    area.increaseHeight(this.blockArea.getHeight());
                    return status;
                }
            }
            ++n2;
        }
        this.blockArea.end();
        area.addChild(this.blockArea);
        area.increaseHeight(this.blockArea.getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        if (this.breakAfter == 3) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 5) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 4) {
            this.marker = -1001;
            return new Status(5);
        }
        return new Status(1);
    }

    public int getAreaHeight() {
        return this.blockArea.getHeight();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Table(fObj, propertyList);
        }
    }
}

