/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class PageNumber
extends FObj {
    FontState fs;
    float red;
    float green;
    float blue;
    int wrapOption;
    int whiteSpaceTreatment;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public PageNumber(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:page-number";
    }

    public Status layout(Area area) throws FOPException {
        String string;
        if (!(area instanceof BlockArea)) {
            System.err.println("WARNING: page-number outside block area");
            return new Status(1);
        }
        if (this.marker == -1000) {
            string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            String string3 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, string3, n);
            ColorType colorType = this.properties.get("color").getColorType();
            this.red = colorType.red();
            this.green = colorType.green();
            this.blue = colorType.blue();
            this.wrapOption = this.properties.get("wrap-option").getEnum();
            this.whiteSpaceTreatment = this.properties.get("white-space-treatment").getEnum();
            this.marker = 0;
        }
        string = Integer.toString(area.getPage().getNumber());
        this.marker = ((BlockArea)area).addText(this.fs, this.red, this.green, this.blue, this.wrapOption, this.whiteSpaceTreatment, string.toCharArray(), 0, string.length());
        return new Status(1);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new PageNumber(fObj, propertyList);
        }
    }
}

