/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class Block
extends FObjMixed {
    FontState fs;
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    int textIndent;
    int keepWithNext;
    ColorType backgroundColor;
    BlockArea blockArea;
    boolean anythingLaidOut = false;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public Block(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:block";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            object = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, (String)object, n);
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.textIndent = this.properties.get("text-indent").getLength().mvalue();
            this.keepWithNext = this.properties.get("keep-with-next").getEnum();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.isInLabel) {
                this.startIndent += this.bodyIndent;
                this.endIndent += area.getAllocationWidth() - this.distanceBetweenStarts - this.startIndent + this.labelSeparation;
            }
            if (this.isInListBody) {
                this.startIndent += this.bodyIndent + this.distanceBetweenStarts;
            }
            if (this.isInTableCell) {
                this.startIndent += this.forcedStartOffset;
                this.endIndent = area.getAllocationWidth() - this.forcedWidth - this.forcedStartOffset;
            }
            this.marker = 0;
            if (this.breakBefore == 3) {
                return new Status(4);
            }
            if (this.breakBefore == 5) {
                return new Status(6);
            }
            if (this.breakBefore == 4) {
                return new Status(5);
            }
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.anythingLaidOut) {
            this.textIndent = 0;
        }
        this.blockArea = new BlockArea(this.fs, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, this.textIndent, this.align, this.alignLast, this.lineHeight);
        this.blockArea.setPage(area.getPage());
        this.blockArea.setBackgroundColor(this.backgroundColor);
        this.blockArea.start();
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            Status status;
            object = (FONode)this.children.elementAt(n2);
            if (this.isInListBody) {
                ((FONode)object).setIsInListBody();
                ((FONode)object).setDistanceBetweenStarts(this.distanceBetweenStarts);
                ((FONode)object).setBodyIndent(this.bodyIndent);
            }
            if ((status = ((FONode)object).layout(this.blockArea)).isIncomplete()) {
                this.marker = n2;
                if (n2 != 0 && status.getCode() == 2) {
                    status = new Status(3);
                }
                area.addChild(this.blockArea);
                area.increaseHeight(this.blockArea.getHeight());
                this.anythingLaidOut = true;
                return status;
            }
            this.anythingLaidOut = true;
            ++n2;
        }
        this.blockArea.end();
        area.addChild(this.blockArea);
        area.increaseHeight(this.blockArea.getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        if (this.breakAfter == 3) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 5) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 4) {
            this.marker = -1001;
            return new Status(5);
        }
        if (this.keepWithNext == 1) {
            return new Status(7);
        }
        return new Status(1);
    }

    public int getAreaHeight() {
        return this.blockArea.getHeight();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Block(fObj, propertyList);
        }
    }
}

