/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.Hashtable;
import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyListBuilder;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.layout.AreaTree;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public class FOTreeBuilder
extends HandlerBase {
    protected Hashtable fobjTable = new Hashtable();
    protected PropertyListBuilder propertyListBuilder = new PropertyListBuilder();
    protected FObj currentFObj = null;
    protected FObj rootFObj = null;
    protected Hashtable unknownFOs = new Hashtable();
    protected int level = 0;
    protected Stack namespaceStack = new Stack();

    public FOTreeBuilder() {
        this.namespaceStack.push(new NSMap("xml", "http://www.w3.org/XML/1998/namespace", -1));
        this.namespaceStack.push(new NSMap("", "", -1));
    }

    protected String findURI(String string) {
        int n = this.namespaceStack.size() - 1;
        while (n >= 0) {
            NSMap nSMap = (NSMap)this.namespaceStack.elementAt(n);
            if (string.equals(nSMap.prefix)) {
                return nSMap.uri;
            }
            --n;
        }
        return null;
    }

    protected String mapName(String string) throws SAXException {
        String string2;
        int n = string.indexOf(58);
        String string3 = "";
        String string4 = string;
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        if ((string2 = this.findURI(string3)) == null) {
            if (string3.equals("")) {
                return string;
            }
            throw new SAXException(new FOPException("Unknown namespace prefix " + string3));
        }
        return string2 + "^" + string4;
    }

    public void addMapping(String string, String string2, FObj.Maker maker) {
        this.fobjTable.put(string + "^" + string2, maker);
    }

    public void characters(char[] cArray, int n, int n2) {
        this.currentFObj.addCharacters(cArray, n, n + n2);
    }

    public void endElement(String string) {
        this.currentFObj.end();
        this.currentFObj = this.currentFObj.getParent();
        --this.level;
        while (((NSMap)this.namespaceStack.peek()).level > this.level) {
            this.namespaceStack.pop();
        }
    }

    public void startDocument() {
        System.err.println("building formatting object tree");
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        FObj fObj;
        String string2;
        ++this.level;
        int n = attributeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            string2 = attributeList.getName(n2);
            if (string2.equals("xmlns")) {
                this.namespaceStack.push(new NSMap("", attributeList.getValue(n2), this.level));
            } else if (string2.startsWith("xmlns:")) {
                String string3 = attributeList.getValue(n2);
                this.namespaceStack.push(new NSMap(string2.substring(6), string3, this.level));
            }
            ++n2;
        }
        string2 = this.mapName(string);
        FObj.Maker maker = (FObj.Maker)this.fobjTable.get(string2);
        if (maker == null) {
            if (!this.unknownFOs.containsKey(string2)) {
                this.unknownFOs.put(string2, "");
                System.err.println("WARNING: Unknown formatting object " + string2);
            }
            maker = new FObjMixed.Maker();
        }
        try {
            fObj = maker.make(this.currentFObj, this.propertyListBuilder.makeList(attributeList, this.currentFObj == null ? null : this.currentFObj.properties));
        }
        catch (FOPException fOPException) {
            throw new SAXException(fOPException);
        }
        if (this.rootFObj == null) {
            this.rootFObj = fObj;
            if (!fObj.getName().equals("fo:root")) {
                throw new SAXException(new FOPException("Root element must be root, not " + fObj.getName()));
            }
        } else {
            this.currentFObj.addChild(fObj);
        }
        this.currentFObj = fObj;
    }

    public void format(AreaTree areaTree) throws FOPException {
        System.err.println("formatting FOs into areas");
        ((Root)this.rootFObj).format(areaTree);
    }

    protected static class NSMap {
        String prefix;
        String uri;
        int level;

        NSMap(String string, String string2, int n) {
            this.prefix = string;
            this.uri = string2;
            this.level = n;
        }
    }
}

