/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;

public class CommandLine {
    static Parser createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "com.jclark.xml.sax.Driver";
        }
        System.err.println("using SAX parser " + string);
        try {
            return (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            System.err.println(string + " is not a SAX driver");
        }
        return null;
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = '/' + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public static void main(String[] stringArray) {
        Parser parser;
        String string = Version.getVersion();
        System.err.println(string);
        if (stringArray.length != 2) {
            System.err.println("usage: java org.apache.fop.apps.CommandLine formatting-object-file pdf-file");
            System.exit(1);
        }
        if ((parser = CommandLine.createParser()) == null) {
            System.err.println("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            Driver driver = new Driver();
            driver.setRenderer("org.apache.fop.render.pdf.PDFRenderer", string);
            driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
            driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            driver.setWriter(new PrintWriter(new FileWriter(stringArray[1])));
            driver.buildFOTree(parser, CommandLine.fileInputSource(stringArray[0]));
            driver.format();
            driver.render();
        }
        catch (Exception exception) {
            System.err.println("FATAL ERROR: " + exception.getMessage());
            System.exit(1);
        }
    }
}

