/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Version;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.PreviewDialog;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;

public class AWTCommandLine {
    public AWTCommandLine(AWTRenderer aWTRenderer) {
        PreviewDialog previewDialog = new PreviewDialog(aWTRenderer);
        previewDialog.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = previewDialog.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        ((Component)previewDialog).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        ((Component)previewDialog).setVisible(true);
    }

    static Parser createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "com.jclark.xml.sax.Driver";
        }
        System.err.println("using SAX parser " + string);
        try {
            return (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            System.err.println(string + " is not a SAX driver");
        }
        return null;
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = '/' + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = null;
        System.err.println(Version.getVersion());
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            System.err.println("usage: java AWTCommandLine formatting-object-file");
            System.exit(1);
        }
        AWTRenderer aWTRenderer = new AWTRenderer();
        new AWTCommandLine(aWTRenderer);
        Parser parser = AWTCommandLine.createParser();
        if (parser == null) {
            System.err.println("ERROR: Unable to create SAX parser");
            System.exit(1);
        }
        try {
            Driver driver = new Driver();
            driver.setRenderer(aWTRenderer);
            driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
            driver.addElementMapping("org.apache.fop.svg.SVGElementMapping");
            driver.buildFOTree(parser, AWTCommandLine.fileInputSource(string));
            driver.format();
            driver.render();
        }
        catch (Exception exception) {
            System.err.println("FATAL ERROR: " + exception.getMessage());
            System.exit(1);
        }
    }
}

