/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jserv;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.apache.jserv.JServ;
import org.apache.jserv.JServLogChannels;
import org.apache.jserv.JServServletManager;

public class JServSession
implements HttpSession,
JServLogChannels,
Serializable {
    protected String id;
    protected long creationTime;
    protected long lastAccessTime;
    private Hashtable sessionData;
    private JServServletManager context;
    private boolean valid = true;
    private boolean isNew;

    public JServSession(String string, JServServletManager jServServletManager) {
        this.id = string;
        this.context = jServServletManager;
        this.sessionData = new Hashtable();
        this.lastAccessTime = this.creationTime = System.currentTimeMillis();
        this.isNew = true;
    }

    public synchronized String getId() {
        this.checkState();
        return this.id;
    }

    public synchronized HttpSessionContext getSessionContext() {
        this.checkState();
        return this.context;
    }

    synchronized void setSessionContext(JServServletManager jServServletManager) {
        this.context = jServServletManager;
    }

    public synchronized long getCreationTime() {
        this.checkState();
        return this.creationTime;
    }

    public synchronized long getLastAccessedTime() {
        this.checkState();
        return this.lastAccessTime;
    }

    public synchronized void invalidate() {
        this.checkState();
        Enumeration enumeration = this.sessionData.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.sessionData.get(k);
            if (!(v instanceof HttpSessionBindingListener)) continue;
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)v;
            try {
                httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, (String)k));
            }
            catch (Throwable throwable) {
                this.log("debug", "JServSession.invalidate", throwable);
            }
        }
        this.valid = false;
        this.context.removeSession(this);
    }

    public synchronized void putValue(String string, Object object) {
        this.checkState();
        this.removeValue(string);
        this.sessionData.put(string, object);
        if (object instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)object;
            try {
                httpSessionBindingListener.valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
                return;
            }
            catch (Throwable throwable) {
                this.log("debug", "JServSession.putValue", throwable);
                return;
            }
        }
    }

    public synchronized Object getValue(String string) {
        this.checkState();
        return this.sessionData.get(string);
    }

    public synchronized void removeValue(String string) {
        this.checkState();
        Object var2_2 = null;
        try {
            var2_2 = this.sessionData.get(string);
            if (var2_2 instanceof HttpSessionBindingListener) {
                HttpSessionBindingListener httpSessionBindingListener = var2_2;
                try {
                    httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
                }
                catch (Throwable throwable) {
                    this.log("debug", "JServSession.removeValue", throwable);
                }
            }
            Object var4_5 = null;
            this.sessionData.remove(string);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.sessionData.remove(string);
            throw throwable;
        }
    }

    public synchronized String[] getValueNames() {
        this.checkState();
        Vector vector = new Vector();
        Enumeration enumeration = this.sessionData.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized boolean isNew() {
        this.checkState();
        return this.isNew;
    }

    public boolean isValid() {
        return this.valid;
    }

    public synchronized void access() {
        this.lastAccessTime = System.currentTimeMillis();
        this.isNew = false;
    }

    private void checkState() {
        if (!this.valid) {
            throw new IllegalStateException("Session " + this.id + " has been invalidated.");
        }
    }

    private void log(String string, String string2, Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.println(string2);
        throwable.printStackTrace(printWriter);
        JServ.log.log(string, charArrayWriter.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.id = (String)objectInputStream.readObject();
        this.creationTime = ((Date)objectInputStream.readObject()).getTime();
        this.lastAccessTime = ((Date)objectInputStream.readObject()).getTime();
        this.valid = (Boolean)objectInputStream.readObject();
        this.isNew = (Boolean)objectInputStream.readObject();
        this.sessionData = (Hashtable)objectInputStream.readObject();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.id);
        objectOutputStream.writeObject(new Date(this.creationTime));
        objectOutputStream.writeObject(new Date(this.lastAccessTime));
        objectOutputStream.writeObject(new Boolean(this.valid));
        objectOutputStream.writeObject(new Boolean(this.isNew));
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(this.sessionData.size());
        String string = null;
        Object v = null;
        Enumeration enumeration = this.sessionData.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            v = this.sessionData.get(string);
            if (v instanceof Serializable) {
                hashtable.put(string, v);
                continue;
            }
            if (!(v instanceof HttpSessionBindingListener)) continue;
            try {
                HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)this.sessionData.get(string);
                httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
            }
            catch (Exception exception) {}
        }
        objectOutputStream.writeObject(hashtable);
    }
}

