/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import org.apache.java.util.ConfigurationsRepository;

public class Configurations {
    private Configurations defaults;
    private ConfigurationsRepository repository;

    public Configurations() {
        this(null, null);
    }

    public Configurations(ConfigurationsRepository configurationsRepository) {
        this(configurationsRepository, null);
    }

    public Configurations(Configurations configurations) {
        this(null, configurations);
    }

    public Configurations(ConfigurationsRepository configurationsRepository, Configurations configurations) {
        this.repository = configurationsRepository;
        this.defaults = configurations;
    }

    public Hashtable getRepository() {
        return this.repository;
    }

    public Enumeration getKeys() {
        return this.repository.keys();
    }

    public Enumeration getKeys(String string) {
        Enumeration enumeration = this.repository.keys();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String) || !((String)k).startsWith(string)) continue;
            vector.addElement(k);
        }
        return vector.elements();
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        Object v = this.repository.get(string);
        if (v instanceof String) {
            return (String)v;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getString(string, string2);
            }
            return string2;
        }
        throw new ClassCastException(String.valueOf(string) + " doesn't map to a String object");
    }

    public Properties getProperties(String string) {
        return this.getProperties(string, new Properties());
    }

    public Properties getProperties(String string, Properties properties) {
        String[] stringArray = this.getStringArray(string);
        Properties properties2 = new Properties(properties);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            int n2 = string2.indexOf(61);
            if (n2 <= 0) {
                throw new IllegalArgumentException("'" + string2 + "' does not contain an equals sign");
            }
            String string3 = string2.substring(0, n2).trim();
            String string4 = string2.substring(n2 + 1).trim();
            ((Hashtable)properties2).put(string3, string4);
            ++n;
        }
        return properties2;
    }

    public String[] getStringArray(String string) {
        Vector vector;
        Object v = this.repository.get(string);
        if (v instanceof String) {
            vector = new Vector(1);
            vector.addElement(v);
        } else if (v instanceof Vector) {
            vector = (Vector)v;
        } else {
            if (v == null) {
                if (this.defaults != null) {
                    return this.defaults.getStringArray(string);
                }
                return new String[0];
            }
            throw new ClassCastException(String.valueOf(string) + " doesn't map to a String/Vector object");
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public Enumeration getList(String string) {
        return this.getVector(string, null).elements();
    }

    public Vector getVector(String string) {
        return this.getVector(string, null);
    }

    public Vector getVector(String string, Vector vector) {
        Object v = this.repository.get(string);
        if (v instanceof Vector) {
            return (Vector)v;
        }
        if (v instanceof String) {
            Vector<String> vector2 = new Vector<String>(1);
            vector2.addElement((String)v);
            this.repository.put(string, vector2);
            return vector2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getVector(string, vector);
            }
            if (vector == null) {
                return new Vector();
            }
            return vector;
        }
        throw new ClassCastException(String.valueOf(string) + " doesn't map to a Vector object");
    }

    public boolean getBoolean(String string) {
        Boolean bl = this.getBoolean(string, null);
        if (bl != null) {
            return bl;
        }
        throw new NoSuchElementException(String.valueOf(string) + " doesn't map to an existing object");
    }

    public boolean getBoolean(String string, boolean bl) {
        return this.getBoolean(string, new Boolean(bl));
    }

    public Boolean getBoolean(String string, Boolean bl) {
        Object v = this.repository.get(string);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            Boolean bl2 = new Boolean((String)v);
            this.repository.put(string, bl2);
            return bl2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(string, bl);
            }
            return bl;
        }
        throw new ClassCastException(String.valueOf(string) + " doesn't map to a Boolean object");
    }

    public byte getByte(String string) {
        Byte by = this.getByte(string, null);
        if (by != null) {
            return by;
        }
        throw new NoSuchElementException(String.valueOf(string) + " doesn't map to an existing object");
    }

    public byte getByte(String string, byte by) {
        return this.getByte(string, new Byte(by));
    }

    public Byte getByte(String string, Byte by) {
        Object v = this.repository.get(string);
        if (v instanceof Byte) {
            return (Byte)v;
        }
        if (v instanceof String) {
            Byte by2 = new Byte((String)v);
            this.repository.put(string, by2);
            return by2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getByte(string, by);
            }
            return by;
        }
        throw new ClassCastException(String.valueOf(string) + " doesn't map to a Byte object");
    }

    public short getShort(String string) {
        Short s = this.getShort(string, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException(String.valueOf(string) + " doesn't map to an existing object");
    }

    public short getShort(String string, short s) {
        return this.getShort(string, new Short(s));
    }

    public Short getShort(String string, Short s) {
        Object v = this.repository.get(string);
        if (v instanceof Short) {
            return (Short)v;
        }
        if (v instanceof String) {
            Short s2 = new Short((String)v);
            this.repository.put(string, s2);
            return s2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getShort(string, s);
            }
            return s;
        }
        throw new ClassCastException(String.valueOf(string) + " doesn't map to a Short object");
    }

    public int getInteger(String string) {
        Integer n = this.getInteger(string, null);
        if (n != null) {
            return n;
        }
        throw new NoSuchElementException(String.valueOf(string) + " doesn't map to an existing object");
    }

    public int getInteger(String string, int n) {
        return this.getInteger(string, new Integer(n));
    }

    public Integer getInteger(String string, Integer n) {
        Object v = this.repository.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            Integer n2 = new Integer((String)v);
            this.repository.put(string, n2);
            return n2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(string, n);
            }
            return n;
        }
        throw new ClassCastException(String.valueOf(string) + " doesn't map to a Integer object");
    }

    public long getLong(String string) {
        Long l = this.getLong(string, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException(String.valueOf(string) + " doesn't map to an existing object");
    }

    public long getLong(String string, long l) {
        return this.getLong(string, new Long(l));
    }

    public Long getLong(String string, Long l) {
        Object v = this.repository.get(string);
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof String) {
            Long l2 = new Long((String)v);
            this.repository.put(string, l2);
            return l2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getLong(string, l);
            }
            return l;
        }
        throw new ClassCastException(String.valueOf(string) + " doesn't map to a Long object");
    }

    public float getFloat(String string) {
        Float f = this.getFloat(string, null);
        if (f != null) {
            return f.floatValue();
        }
        throw new NoSuchElementException(String.valueOf(string) + " doesn't map to an existing object");
    }

    public float getFloat(String string, float f) {
        return this.getFloat(string, new Float(f)).floatValue();
    }

    public Float getFloat(String string, Float f) {
        Object v = this.repository.get(string);
        if (v instanceof Float) {
            return (Float)v;
        }
        if (v instanceof String) {
            Float f2 = new Float((String)v);
            this.repository.put(string, f2);
            return f2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(string, f);
            }
            return f;
        }
        throw new ClassCastException(String.valueOf(string) + " doesn't map to a Float object");
    }

    public double getDouble(String string) {
        Double d = this.getDouble(string, null);
        if (d != null) {
            return d;
        }
        throw new NoSuchElementException(String.valueOf(string) + " doesn't map to an existing object");
    }

    public double getDouble(String string, double d) {
        return this.getDouble(string, new Double(d));
    }

    public Double getDouble(String string, Double d) {
        Object v = this.repository.get(string);
        if (v instanceof Double) {
            return (Double)v;
        }
        if (v instanceof String) {
            Double d2 = new Double((String)v);
            this.repository.put(string, d2);
            return d2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getDouble(string, d);
            }
            return d;
        }
        throw new ClassCastException(String.valueOf(string) + " doesn't map to a Double object");
    }
}

