/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript;

import com.netscape.javascript.Context;
import com.netscape.javascript.Function;
import com.netscape.javascript.JavaScriptException;
import com.netscape.javascript.NativeFunction;
import com.netscape.javascript.NativeJavaObject;
import com.netscape.javascript.ScriptRuntime;
import com.netscape.javascript.Scriptable;
import com.netscape.javascript.Undefined;
import com.netscape.javascript.Wrapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class NativeJavaMethod
extends NativeFunction
implements Function {
    private static final boolean debug = false;
    Method[] methods;

    static String signature(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < classArray.length) {
            if (n != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(NativeJavaMethod.signature(classArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    static String signature(Member member) {
        Class[] classArray = member instanceof Method ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
        return member.getName() + "(" + NativeJavaMethod.signature(classArray) + ")";
    }

    public Object getDefaultValue(Class clazz) {
        return this;
    }

    public NativeJavaMethod() {
        this.names = new String[1];
    }

    public NativeJavaMethod(Method[] methodArray) {
        this.methods = methodArray;
        this.names = new String[1];
        this.names[0] = methodArray[0].getName();
    }

    public void add(Method method) {
        if (this.names[0] == null) {
            this.names[0] = method.getName();
        } else if (!this.names[0].equals(method.getName())) {
            throw new RuntimeException("internal method name mismatch");
        }
        int n = this.methods == null ? 0 : this.methods.length;
        Method[] methodArray = new Method[n + 1];
        int n2 = 0;
        while (n2 < n) {
            methodArray[n2] = this.methods[n2];
            ++n2;
        }
        methodArray[n] = method;
        this.methods = methodArray;
    }

    Method[] getMethods() {
        return this.methods;
    }

    private static void printDebug(String string, Member member, Object[] objectArray) {
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object object;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Wrapper) {
                objectArray[n] = ((Wrapper)objectArray[n]).unwrap();
            }
            ++n;
        }
        Method method = (Method)NativeJavaMethod.findFunction(this.methods, objectArray);
        if (method == null) {
            Class<?> clazz = this.methods[0].getDeclaringClass();
            String string = clazz.getName() + "." + this.names[0] + "(" + NativeJavaMethod.signature(objectArray) + ")";
            Object[] objectArray2 = new Object[]{string};
            throw Context.reportRuntimeError(Context.getMessage("msg.java.no_such_method", objectArray2));
        }
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = 0;
        while (n2 < objectArray.length) {
            objectArray[n2] = NativeJavaObject.coerceType(classArray[n2], objectArray[n2]);
            ++n2;
        }
        try {
            object = ((NativeJavaObject)scriptable2).unwrap();
        }
        catch (ClassCastException classCastException) {
            if (Modifier.isStatic(method.getModifiers())) {
                object = null;
            }
            Object[] objectArray3 = new Object[]{this.names[0]};
            throw Context.reportRuntimeError(Context.getMessage("msg.nonjava.method", objectArray3));
        }
        try {
            Object object2 = method.invoke(object, objectArray);
            Class<?> clazz = method.getReturnType();
            Object object3 = NativeJavaObject.wrap(scriptable, object2, clazz);
            if (object3 == Undefined.instance) {
                return object3;
            }
            if (object3 == null && clazz == Void.TYPE) {
                return Undefined.instance;
            }
            if (object2 != object3 && object3 instanceof Scriptable) {
                Scriptable scriptable3 = (Scriptable)object3;
                if (scriptable3.getPrototype() == null) {
                    scriptable3.setPrototype(this.parent.getPrototype());
                }
                if (scriptable3.getParentScope() == null) {
                    scriptable3.setParentScope(this.parent.getParentScope());
                }
            }
            return object3;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Context.reportRuntimeError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JavaScriptException.wrapException(scriptable, invocationTargetException);
        }
    }

    static Member findFunction(Member[] memberArray, Object[] objectArray) {
        if (memberArray.length == 0) {
            return null;
        }
        boolean bl = memberArray[0] instanceof Method;
        int n = 0;
        while (n < memberArray.length) {
            block5: {
                Class<?>[] classArray;
                Member member = memberArray[n];
                Class<?>[] classArray2 = classArray = bl ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
                if (classArray.length == objectArray.length) {
                    int n2 = 0;
                    while (n2 < classArray.length) {
                        if (NativeJavaObject.canConvert(objectArray[n2], classArray[n2])) {
                            ++n2;
                            continue;
                        }
                        break block5;
                    }
                    return member;
                }
            }
            ++n;
        }
        return null;
    }

    static String signature(Class clazz) {
        if (clazz == null) {
            return "null";
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return "boolean";
        }
        if (clazz == ScriptRuntime.ByteClass) {
            return "byte";
        }
        if (clazz == ScriptRuntime.ShortClass) {
            return "short";
        }
        if (clazz == ScriptRuntime.IntegerClass) {
            return "int";
        }
        if (clazz == ScriptRuntime.LongClass) {
            return "long";
        }
        if (clazz == ScriptRuntime.FloatClass) {
            return "float";
        }
        if (clazz == ScriptRuntime.DoubleClass) {
            return "double";
        }
        if (clazz == ScriptRuntime.StringClass) {
            return "string";
        }
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
            if (ScriptRuntime.FunctionClass.isAssignableFrom(clazz)) {
                return "function";
            }
            if (clazz == ScriptRuntime.UndefinedClass) {
                return "undefined";
            }
            return "object";
        }
        return clazz.getName();
    }

    static String signature(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            if (n != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(objectArray[n] == null ? "null" : NativeJavaMethod.signature(objectArray[n].getClass()));
            ++n;
        }
        return stringBuffer.toString();
    }
}

