/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.javascript;

import com.netscape.javascript.ClassNameHelper;
import com.netscape.javascript.Context;
import com.netscape.javascript.FunctionNode;
import com.netscape.javascript.IRFactory;
import com.netscape.javascript.InterpretedFunction;
import com.netscape.javascript.InterpretedScript;
import com.netscape.javascript.InterpreterData;
import com.netscape.javascript.JavaScriptException;
import com.netscape.javascript.LabelTable;
import com.netscape.javascript.NativeClosure;
import com.netscape.javascript.NativeRegExp;
import com.netscape.javascript.Node;
import com.netscape.javascript.NodeTransformer;
import com.netscape.javascript.ScriptRuntime;
import com.netscape.javascript.Scriptable;
import com.netscape.javascript.ScriptableObject;
import com.netscape.javascript.SecuritySupport;
import com.netscape.javascript.TokenStream;
import com.netscape.javascript.Undefined;
import com.netscape.javascript.VariableTable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Interpreter
extends LabelTable {
    public static final boolean printICode = false;
    boolean itsInFunctionFlag;
    Vector itsFunctionList;
    InterpreterData itsData;
    int itsTryDepth = 0;
    int itsStackDepth = 0;
    int itsEpilogLabel = -1;
    String itsSourceFile;
    int itsLineNumber = 0;
    InterpretedFunction[] itsNestedFunctions = null;
    static PrintWriter out;
    private static final Double zero;
    private static final Double one;
    private int version;

    private static Number getNumber(Number[] numberArray, byte[] byArray, int n) {
        int n2 = (byArray[n] << 8) + (byArray[n + 1] & 0xFF);
        return numberArray[n2];
    }

    private void generateNestedFunctions(Scriptable scriptable, Context context, Object object) {
        this.itsNestedFunctions = new InterpretedFunction[this.itsFunctionList.size()];
        short s = 0;
        while (s < this.itsFunctionList.size()) {
            FunctionNode functionNode = (FunctionNode)this.itsFunctionList.elementAt(s);
            Interpreter interpreter = new Interpreter();
            interpreter.itsData = new InterpreterData(0, 0, 0, object);
            interpreter.itsInFunctionFlag = true;
            this.itsNestedFunctions[s] = interpreter.generateFunctionICode(context, scriptable, functionNode, object);
            functionNode.putProp(5, new Short(s));
            s = (short)(s + 1);
        }
    }

    private final int addByte(byte by, int n) {
        if (this.itsData.itsICode.length == n) {
            byte[] byArray = new byte[n * 2];
            System.arraycopy(this.itsData.itsICode, 0, byArray, 0, n);
            this.itsData.itsICode = byArray;
        }
        this.itsData.itsICode[n++] = by;
        return n;
    }

    private static int getTarget(byte[] byArray, int n) {
        int n2 = (byArray[n] << 8) + (byArray[n + 1] & 0xFF);
        return n - 1 + n2;
    }

    private int addLocalRef(Node node, int n) {
        int n2;
        Integer n3 = (Integer)node.getProp(7);
        if (n3 == null) {
            n2 = this.itsData.itsMaxLocals++;
            node.putProp(7, new Integer(n2));
        } else {
            n2 = n3;
        }
        n = this.addByte((byte)n2, n);
        if (n2 >= this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = n2 + 1;
        }
        return n;
    }

    private void generateICodeFromTree(Node node, VariableTable variableTable, boolean bl, Object object) {
        int n = 0;
        this.itsData.itsVariableTable = variableTable;
        this.itsData.itsNeedsActivation = bl;
        this.itsData.itsICodeTop = n = this.generateICode(node, n);
        if (this.itsEpilogLabel != -1) {
            this.markLabel(this.itsEpilogLabel, n);
        }
        int n2 = 0;
        while (n2 < this.itsLabelTableTop) {
            this.itsLabelTable[n2].fixGotos(this.itsData.itsICode);
            ++n2;
        }
    }

    private InterpretedScript generateScriptICode(Context context, Scriptable scriptable, Node node, Object object) {
        this.itsSourceFile = (String)node.getProp(16);
        this.itsFunctionList = (Vector)node.getProp(5);
        if (this.itsFunctionList != null) {
            this.generateNestedFunctions(scriptable, context, object);
        }
        NativeRegExp[] nativeRegExpArray = null;
        Vector vector = (Vector)node.getProp(12);
        if (vector != null) {
            nativeRegExpArray = this.generateRegExpLiterals(vector, scriptable);
        }
        VariableTable variableTable = (VariableTable)node.getProp(10);
        this.generateICodeFromTree(node, variableTable, false, object);
        this.itsData.itsNestedFunctions = this.itsNestedFunctions;
        this.itsData.itsRegExpLiterals = nativeRegExpArray;
        return new InterpretedScript(this.itsData, context);
    }

    private InterpretedFunction generateFunctionICode(Context context, Scriptable scriptable, FunctionNode functionNode, Object object) {
        this.itsFunctionList = (Vector)functionNode.getProp(5);
        if (this.itsFunctionList != null) {
            this.generateNestedFunctions(scriptable, context, object);
        }
        NativeRegExp[] nativeRegExpArray = null;
        Vector vector = (Vector)functionNode.getProp(12);
        if (vector != null) {
            nativeRegExpArray = this.generateRegExpLiterals(vector, scriptable);
        }
        VariableTable variableTable = functionNode.getVariableTable();
        this.generateICodeFromTree(functionNode.getLastChild(), variableTable, functionNode.requiresActivation(), object);
        this.itsData.itsName = functionNode.getFunctionName();
        this.itsData.itsSource = (String)functionNode.getProp(17);
        this.itsData.itsNestedFunctions = this.itsNestedFunctions;
        this.itsData.itsRegExpLiterals = nativeRegExpArray;
        return new InterpretedFunction(this.itsData, context);
    }

    private void badTree(Node node) {
        try {
            out = new PrintWriter(new FileOutputStream("icode.txt", true));
            out.println("Un-handled node : " + node.toString());
            out.close();
        }
        catch (IOException iOException) {}
        throw new RuntimeException("Un-handled node : " + node.toString());
    }

    private static String getString(String[] stringArray, byte[] byArray, int n) {
        int n2 = (byArray[n] << 8) + (byArray[n + 1] & 0xFF);
        return stringArray[n2];
    }

    private static void dumpICode(InterpreterData interpreterData) {
    }

    public Object compile(Context context, Scriptable scriptable, Node node, Object object, SecuritySupport securitySupport, ClassNameHelper classNameHelper) throws IOException {
        this.version = context.getLanguageVersion();
        this.itsData = new InterpreterData(0, 0, 0, object);
        if (node instanceof FunctionNode) {
            FunctionNode functionNode = (FunctionNode)node;
            InterpretedFunction interpretedFunction = this.generateFunctionICode(context, scriptable, functionNode, object);
            Interpreter.createFunctionObject(interpretedFunction, scriptable);
            return interpretedFunction;
        }
        return this.generateScriptICode(context, scriptable, node, object);
    }

    public static Object interpret(InterpreterData interpreterData) throws JavaScriptException {
        Object[] objectArray = new Object[interpreterData.itsMaxStack];
        int n = -1;
        byte[] byArray = interpreterData.itsICode;
        int n2 = 0;
        int n3 = interpreterData.itsICodeTop;
        Object[] objectArray2 = null;
        if (interpreterData.itsMaxLocals > 0) {
            objectArray2 = new Object[interpreterData.itsMaxLocals];
        }
        Object[] objectArray3 = null;
        int n4 = interpreterData.itsVariableTable.size();
        if (n4 > 0) {
            objectArray3 = new Object[n4];
            n4 = 0;
            while (n4 < interpreterData.itsVariableTable.getParameterCount()) {
                objectArray3[n4] = n4 >= interpreterData.itsInArgs.length ? Undefined.instance : interpreterData.itsInArgs[n4];
                ++n4;
            }
            while (n4 < objectArray3.length) {
                objectArray3[n4] = Undefined.instance;
                ++n4;
            }
        }
        Context context = interpreterData.itsCX;
        Scriptable scriptable = interpreterData.itsScope;
        if (interpreterData.itsNestedFunctions != null) {
            n4 = 0;
            while (n4 < interpreterData.itsNestedFunctions.length) {
                Interpreter.createFunctionObject(interpreterData.itsNestedFunctions[n4], scriptable);
                ++n4;
            }
        }
        int[] nArray = null;
        int[] nArray2 = null;
        Scriptable[] scriptableArray = null;
        int n5 = 0;
        if (interpreterData.itsMaxTryDepth > 0) {
            nArray = new int[interpreterData.itsMaxTryDepth];
            nArray2 = new int[interpreterData.itsMaxTryDepth];
            scriptableArray = new Scriptable[interpreterData.itsMaxTryDepth];
        }
        context.interpreterSecurityDomain = interpreterData.securityDomain;
        Object object = Undefined.instance;
        block94: while (n2 < n3) {
            try {
                switch (byArray[n2]) {
                    case 76: {
                        --n5;
                        break;
                    }
                    case 75: {
                        n4 = Interpreter.getTarget(byArray, n2 + 1);
                        if (n4 == n2) {
                            n4 = 0;
                        }
                        nArray[n5] = n4;
                        n4 = Interpreter.getTarget(byArray, n2 + 3);
                        if (n4 == n2 + 2) {
                            n4 = 0;
                        }
                        nArray2[n5] = n4;
                        scriptableArray[n5++] = scriptable;
                        n2 += 4;
                        break;
                    }
                    case 19: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.cmp_LEB(object2, object3);
                        break;
                    }
                    case 17: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.cmp_LEB(object3, object2);
                        break;
                    }
                    case 18: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.cmp_LTB(object2, object3);
                        break;
                    }
                    case 16: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.cmp_LTB(object3, object2);
                        break;
                    }
                    case 63: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = new Boolean(ScriptRuntime.in(object3, object2));
                        break;
                    }
                    case 64: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = new Boolean(ScriptRuntime.instanceOf(object3, object2));
                        break;
                    }
                    case 14: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.eqB(object2, object3);
                        break;
                    }
                    case 15: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.neB(object3, object2);
                        break;
                    }
                    case 53: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.seqB(object3, object2);
                        break;
                    }
                    case 54: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.sneB(object3, object2);
                        break;
                    }
                    case 8: {
                        if (!ScriptRuntime.toBoolean(objectArray[n--])) {
                            n2 = Interpreter.getTarget(byArray, n2 + 1);
                            continue block94;
                        }
                        n2 += 2;
                        break;
                    }
                    case 7: {
                        if (ScriptRuntime.toBoolean(objectArray[n--])) {
                            n2 = Interpreter.getTarget(byArray, n2 + 1);
                            continue block94;
                        }
                        n2 += 2;
                        break;
                    }
                    case 6: {
                        n2 = Interpreter.getTarget(byArray, n2 + 1);
                        continue block94;
                    }
                    case 65: {
                        objectArray[++n] = new Integer(n2 + 3);
                        n2 = Interpreter.getTarget(byArray, n2 + 1);
                        continue block94;
                    }
                    case 66: {
                        int n6 = byArray[++n2] & 0xFF;
                        n2 = (Integer)objectArray2[n6];
                        continue block94;
                    }
                    case 57: {
                        --n;
                        break;
                    }
                    case 9: {
                        objectArray[n + 1] = objectArray[n];
                        ++n;
                        break;
                    }
                    case 2: {
                        object = objectArray[n--];
                        break;
                    }
                    case 5: {
                        object = objectArray[n--];
                        n2 = Interpreter.getTarget(byArray, n2 + 1);
                        break;
                    }
                    case 28: {
                        int n7 = ScriptRuntime.toInt32(objectArray[n]);
                        objectArray[n] = new Double(~n7);
                        break;
                    }
                    case 13: {
                        int n7 = ScriptRuntime.toInt32(objectArray[n--]);
                        int n8 = ScriptRuntime.toInt32(objectArray[n]);
                        objectArray[n] = new Double(n8 & n7);
                        break;
                    }
                    case 11: {
                        int n7 = ScriptRuntime.toInt32(objectArray[n--]);
                        int n8 = ScriptRuntime.toInt32(objectArray[n]);
                        objectArray[n] = new Double(n8 | n7);
                        break;
                    }
                    case 12: {
                        int n7 = ScriptRuntime.toInt32(objectArray[n--]);
                        int n8 = ScriptRuntime.toInt32(objectArray[n]);
                        objectArray[n] = new Double(n8 ^ n7);
                        break;
                    }
                    case 20: {
                        int n7 = ScriptRuntime.toInt32(objectArray[n--]);
                        int n8 = ScriptRuntime.toInt32(objectArray[n]);
                        objectArray[n] = new Double(n8 << n7);
                        break;
                    }
                    case 21: {
                        int n7 = ScriptRuntime.toInt32(objectArray[n--]);
                        int n8 = ScriptRuntime.toInt32(objectArray[n]);
                        objectArray[n] = new Double(n8 >> n7);
                        break;
                    }
                    case 22: {
                        int n7 = ScriptRuntime.toInt32(objectArray[n--]) & 0x1F;
                        long l = ScriptRuntime.toUint32(objectArray[n]);
                        objectArray[n] = new Double(l >>> n7);
                        break;
                    }
                    case 23: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.add(object3, object2);
                        break;
                    }
                    case 24: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = new Double(ScriptRuntime.toNumber(object3) - ScriptRuntime.toNumber(object2));
                        break;
                    }
                    case 29: {
                        Object object2 = objectArray[n];
                        objectArray[n] = new Double(-ScriptRuntime.toNumber(object2));
                        break;
                    }
                    case 58: {
                        Object object2 = objectArray[n];
                        objectArray[n] = new Double(ScriptRuntime.toNumber(object2));
                        break;
                    }
                    case 25: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = new Double(ScriptRuntime.toNumber(object3) * ScriptRuntime.toNumber(object2));
                        break;
                    }
                    case 26: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = new Double(ScriptRuntime.toNumber(object3) / ScriptRuntime.toNumber(object2));
                        break;
                    }
                    case 27: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = new Double(ScriptRuntime.toNumber(object3) % ScriptRuntime.toNumber(object2));
                        break;
                    }
                    case 61: {
                        objectArray[++n] = ScriptRuntime.bind(scriptable, Interpreter.getString(interpreterData.itsStringTable, byArray, n2 + 1));
                        n2 += 2;
                        break;
                    }
                    case 71: {
                        objectArray[++n] = ScriptRuntime.getBase(scriptable, Interpreter.getString(interpreterData.itsStringTable, byArray, n2 + 1));
                        n2 += 2;
                        break;
                    }
                    case 10: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.setName((Scriptable)object3, object2, scriptable, Interpreter.getString(interpreterData.itsStringTable, byArray, n2 + 1));
                        n2 += 2;
                        break;
                    }
                    case 31: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.delete(object3, object2);
                        break;
                    }
                    case 39: {
                        String string = (String)objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.getProp(object3, string, scriptable);
                        break;
                    }
                    case 40: {
                        Object object2 = objectArray[n--];
                        String string = (String)objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.setProp(object3, string, object2, scriptable);
                        break;
                    }
                    case 41: {
                        Object object4 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.getElem(object3, object4, scriptable);
                        break;
                    }
                    case 42: {
                        Object object2 = objectArray[n--];
                        Object object4 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.setElem(object3, object4, object2, scriptable);
                        break;
                    }
                    case 34: {
                        String string = (String)objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.postIncrement(object3, string, scriptable);
                        break;
                    }
                    case 37: {
                        String string = (String)objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.postDecrement(object3, string, scriptable);
                        break;
                    }
                    case 35: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.postIncrementElem(object3, object2, scriptable);
                        break;
                    }
                    case 38: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.postDecrementElem(object3, object2, scriptable);
                        break;
                    }
                    case 68: {
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.getThis((Scriptable)object3);
                        break;
                    }
                    case 69: {
                        Object object3 = objectArray[n];
                        int n6 = byArray[++n2] & 0xFF;
                        objectArray2[n6] = object3;
                        break;
                    }
                    case 70: {
                        int n6 = byArray[++n2] & 0xFF;
                        objectArray[++n] = objectArray2[n6];
                        break;
                    }
                    case 67: {
                        n4 = byArray[n2 + 1] << 8 | byArray[n2 + 2] & 0xFF;
                        String string = Interpreter.getString(interpreterData.itsStringTable, byArray, n2 + 3);
                        int n9 = byArray[n2 + 5] << 8 | byArray[n2 + 6] & 0xFF;
                        Object[] objectArray4 = new Object[n9];
                        n4 = n9 - 1;
                        while (n4 >= 0) {
                            objectArray4[n4] = objectArray[n--];
                            --n4;
                        }
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.callSpecial(context, object3, object2, objectArray4, interpreterData.itsThisObj, scriptable, string, n4);
                        n2 += 6;
                        break;
                    }
                    case 43: {
                        int n9 = byArray[n2 + 1] << 8 | byArray[n2 + 2] & 0xFF;
                        Object[] objectArray4 = new Object[n9];
                        n4 = n9 - 1;
                        while (n4 >= 0) {
                            objectArray4[n4] = objectArray[n--];
                            --n4;
                        }
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.call(context, object3, object2, objectArray4);
                        n2 += 2;
                        context.interpreterSecurityDomain = interpreterData.securityDomain;
                        break;
                    }
                    case 30: {
                        int n9 = byArray[n2 + 1] << 8 | byArray[n2 + 2] & 0xFF;
                        Object[] objectArray4 = new Object[n9];
                        n4 = n9 - 1;
                        while (n4 >= 0) {
                            objectArray4[n4] = objectArray[n--];
                            --n4;
                        }
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.newObject(context, object3, objectArray4);
                        n2 += 2;
                        break;
                    }
                    case 32: {
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.typeof(object3);
                        break;
                    }
                    case 78: {
                        String string = Interpreter.getString(interpreterData.itsStringTable, byArray, n2 + 1);
                        objectArray[++n] = ScriptRuntime.typeofName(scriptable, string);
                        n2 += 2;
                        break;
                    }
                    case 46: {
                        objectArray[++n] = Interpreter.getString(interpreterData.itsStringTable, byArray, n2 + 1);
                        n2 += 2;
                        break;
                    }
                    case 45: {
                        objectArray[++n] = Interpreter.getNumber(interpreterData.itsNumberTable, byArray, n2 + 1);
                        n2 += 2;
                        break;
                    }
                    case 44: {
                        objectArray[++n] = ScriptRuntime.name(scriptable, Interpreter.getString(interpreterData.itsStringTable, byArray, n2 + 1));
                        n2 += 2;
                        break;
                    }
                    case 33: {
                        objectArray[++n] = ScriptRuntime.postIncrement(scriptable, Interpreter.getString(interpreterData.itsStringTable, byArray, n2 + 1));
                        n2 += 2;
                        break;
                    }
                    case 36: {
                        objectArray[++n] = ScriptRuntime.postDecrement(scriptable, Interpreter.getString(interpreterData.itsStringTable, byArray, n2 + 1));
                        n2 += 2;
                        break;
                    }
                    case 73: {
                        Object object3 = objectArray[n];
                        int n6 = byArray[++n2] & 0xFF;
                        objectArray3[n6] = object3;
                        break;
                    }
                    case 72: {
                        int n6 = byArray[++n2] & 0xFF;
                        objectArray[++n] = objectArray3[n6];
                        break;
                    }
                    case 59: {
                        int n6 = byArray[++n2] & 0xFF;
                        objectArray[++n] = objectArray3[n6];
                        objectArray3[n6] = ScriptRuntime.postIncrement(objectArray3[n6]);
                        break;
                    }
                    case 60: {
                        int n6 = byArray[++n2] & 0xFF;
                        objectArray[++n] = objectArray3[n6];
                        objectArray3[n6] = ScriptRuntime.postDecrement(objectArray3[n6]);
                        break;
                    }
                    case 47: {
                        objectArray[++n] = zero;
                        break;
                    }
                    case 48: {
                        objectArray[++n] = one;
                        break;
                    }
                    case 49: {
                        objectArray[++n] = null;
                        break;
                    }
                    case 50: {
                        objectArray[++n] = interpreterData.itsThisObj;
                        break;
                    }
                    case 51: {
                        objectArray[++n] = Boolean.FALSE;
                        break;
                    }
                    case 52: {
                        objectArray[++n] = Boolean.TRUE;
                        break;
                    }
                    case 74: {
                        objectArray[++n] = Undefined.instance;
                        break;
                    }
                    case 62: {
                        context.interpreterSecurityDomain = null;
                        throw new JavaScriptException(objectArray[n--]);
                    }
                    case 87: {
                        context.interpreterSecurityDomain = null;
                        Object object3 = objectArray[n--];
                        if (object3 instanceof JavaScriptException) {
                            throw (JavaScriptException)object3;
                        }
                        throw (RuntimeException)object3;
                    }
                    case 3: {
                        Object object3 = objectArray[n--];
                        scriptable = ScriptRuntime.enterWith(object3, scriptable);
                        break;
                    }
                    case 4: {
                        scriptable = ScriptRuntime.leaveWith(scriptable);
                        break;
                    }
                    case 77: {
                        objectArray[++n] = ScriptRuntime.newScope();
                        break;
                    }
                    case 79: {
                        int n6 = byArray[++n2] & 0xFF;
                        Object object3 = objectArray[n--];
                        objectArray2[n6] = ScriptRuntime.initEnum(object3, scriptable);
                        break;
                    }
                    case 80: {
                        int n6 = byArray[++n2] & 0xFF;
                        objectArray[++n] = ScriptRuntime.nextEnum((Enumeration)objectArray2[n6]);
                        break;
                    }
                    case 81: {
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.getProto(object3, scriptable);
                        break;
                    }
                    case 82: {
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.getParent(object3);
                        break;
                    }
                    case 86: {
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.getParent(object3, scriptable);
                        break;
                    }
                    case 83: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.setProto(object3, object2, scriptable);
                        break;
                    }
                    case 84: {
                        Object object2 = objectArray[n--];
                        Object object3 = objectArray[n];
                        objectArray[n] = ScriptRuntime.setParent(object3, object2, scriptable);
                        break;
                    }
                    case 85: {
                        objectArray[++n] = scriptable;
                        break;
                    }
                    case 55: {
                        n4 = byArray[n2 + 1] << 8 | byArray[n2 + 2] & 0xFF;
                        objectArray[++n] = new NativeClosure(context, scriptable, interpreterData.itsNestedFunctions[n4]);
                        n2 += 2;
                        break;
                    }
                    case 56: {
                        n4 = byArray[n2 + 1] << 8 | byArray[n2 + 2] & 0xFF;
                        objectArray[++n] = interpreterData.itsRegExpLiterals[n4];
                        n2 += 2;
                        break;
                    }
                    default: {
                        Interpreter.dumpICode(interpreterData);
                        throw new RuntimeException("Unknown icode : " + (byArray[n2] & 0xFF) + " @ pc : " + n2);
                    }
                }
                ++n2;
            }
            catch (JavaScriptException javaScriptException) {
                n = 0;
                context.interpreterSecurityDomain = interpreterData.securityDomain;
                if (n5 > 0) {
                    n2 = nArray[--n5];
                    scriptable = scriptableArray[n5];
                    if (n2 == 0) {
                        n2 = nArray2[n5];
                        if (n2 == 0) {
                            throw javaScriptException;
                        }
                        objectArray[0] = javaScriptException;
                        continue;
                    }
                    objectArray[0] = ScriptRuntime.unwrapJavaScriptException(javaScriptException);
                    continue;
                }
                throw javaScriptException;
            }
            catch (RuntimeException runtimeException) {
                if (n5 > 0) {
                    n = 0;
                    objectArray[0] = runtimeException;
                    n2 = nArray2[--n5];
                    scriptable = scriptableArray[n5];
                    context.interpreterSecurityDomain = interpreterData.securityDomain;
                    if (n2 != 0) continue;
                    throw runtimeException;
                }
                throw runtimeException;
            }
        }
        context.interpreterSecurityDomain = null;
        return object;
    }

    private static void createFunctionObject(InterpretedFunction interpretedFunction, Scriptable scriptable) {
        interpretedFunction.setPrototype(ScriptableObject.getClassPrototype(scriptable, "Function"));
        interpretedFunction.setParentScope(scriptable);
        if (interpretedFunction.itsData.itsName.length() > 0) {
            ScriptRuntime.setName(scriptable, interpretedFunction, scriptable, interpretedFunction.itsData.itsName);
        }
    }

    private int addGoto(Node node, int n, int n2) {
        int n3;
        if (node.getType() == 5) {
            if (this.itsEpilogLabel == -1) {
                this.itsEpilogLabel = this.acquireLabel();
            }
            n3 = this.itsEpilogLabel;
        } else {
            Node node2 = (Node)node.getProp(1);
            Object object = node2.getProp(20);
            if (object == null) {
                n3 = this.acquireLabel();
                node2.putProp(20, new Integer(n3));
            } else {
                n3 = (Integer)object;
            }
        }
        n2 = this.addGoto(n3, (int)((byte)n), n2);
        return n2;
    }

    private int addGoto(int n, int n2, int n3) {
        int n4 = n3;
        n3 = this.addByte((byte)n2, n3);
        int n5 = n & Integer.MAX_VALUE;
        short s = this.itsLabelTable[n5].getPC();
        if (s != -1) {
            short s2 = (short)(s - n4);
            n3 = this.addByte((byte)(s2 >> 8), n3);
            n3 = this.addByte((byte)s2, n3);
        } else {
            this.itsLabelTable[n5].addFixup(n4 + 1);
            n3 = this.addByte((byte)0, n3);
            n3 = this.addByte((byte)0, n3);
        }
        return n3;
    }

    private NativeRegExp[] generateRegExpLiterals(Vector vector, Scriptable scriptable) {
        NativeRegExp[] nativeRegExpArray = new NativeRegExp[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Node node = (Node)vector.elementAt(n);
            Node node2 = node.getFirstChild();
            Node node3 = node.getLastChild();
            nativeRegExpArray[n] = new NativeRegExp(scriptable, node2.getString(), node2 == node3 ? null : node3.getString());
            node.putProp(12, new Integer(n));
            ++n;
        }
        return nativeRegExpArray;
    }

    static {
        zero = new Double(0.0);
        one = new Double(1.0);
    }

    private void updateLineNumber(Node node) {
        Object object = node.getDatum();
        if (object == null || !(object instanceof Number)) {
            return;
        }
        this.itsLineNumber = ((Number)object).shortValue();
    }

    public Node transform(Node node, TokenStream tokenStream) {
        return new NodeTransformer().transform(node, null, tokenStream);
    }

    private final int addNumber(Number number, int n) {
        n = this.addByte((byte)(this.itsData.itsNumberTableIndex >> 8), n);
        n = this.addByte((byte)(this.itsData.itsNumberTableIndex & 0xFF), n);
        if (this.itsData.itsNumberTable.length == this.itsData.itsNumberTableIndex) {
            Number[] numberArray = new Number[this.itsData.itsNumberTableIndex * 2];
            System.arraycopy(this.itsData.itsNumberTable, 0, numberArray, 0, this.itsData.itsNumberTableIndex);
            this.itsData.itsNumberTable = numberArray;
        }
        this.itsData.itsNumberTable[this.itsData.itsNumberTableIndex++] = number;
        return n;
    }

    public IRFactory createIRFactory(TokenStream tokenStream, ClassNameHelper classNameHelper) {
        return new IRFactory(tokenStream);
    }

    private final int addString(String string, int n) {
        n = this.addByte((byte)(this.itsData.itsStringTableIndex >> 8), n);
        n = this.addByte((byte)(this.itsData.itsStringTableIndex & 0xFF), n);
        if (this.itsData.itsStringTable.length == this.itsData.itsStringTableIndex) {
            String[] stringArray = new String[this.itsData.itsStringTableIndex * 2];
            System.arraycopy(this.itsData.itsStringTable, 0, stringArray, 0, this.itsData.itsStringTableIndex);
            this.itsData.itsStringTable = stringArray;
        }
        this.itsData.itsStringTable[this.itsData.itsStringTableIndex++] = string;
        return n;
    }

    private int generateICode(Node node, int n) {
        Node node2;
        int n2 = node.getType();
        Node node3 = node2 = node.getFirstChild();
        block0 : switch (n2) {
            case 109: {
                n = this.addByte((byte)55, n);
                Node node4 = (Node)node.getProp(5);
                Short s = (Short)node4.getProp(5);
                n = this.addByte((byte)(s >> 8), n);
                n = this.addByte((byte)(s & 0xFF), n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 145: {
                this.updateLineNumber(node);
                while (node2 != null) {
                    if (node2.getType() != 109) {
                        n = this.generateICode(node2, n);
                    }
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 115: {
                this.updateLineNumber(node);
                node2 = node2.getNextSibling();
                while (node2 != null) {
                    n = this.generateICode(node2, n);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 116: 
            case 123: 
            case 127: 
            case 131: 
            case 132: 
            case 135: 
            case 137: {
                this.updateLineNumber(node);
                while (node2 != null) {
                    n = this.generateICode(node2, n);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 95: {
                n = this.generateICode(node2, n);
                n = this.addByte((byte)57, n);
                this.itsStackDepth += -1;
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                break;
            }
            case 114: {
                Node node5;
                Node node6;
                this.updateLineNumber(node);
                n = this.generateICode(node2, n);
                int n3 = this.itsData.itsMaxLocals++;
                n = this.addByte((byte)69, n);
                n = this.addByte((byte)n3, n);
                n = this.addByte((byte)57, n);
                this.itsStackDepth += -1;
                Vector vector = (Vector)node.getProp(13);
                int n4 = 0;
                while (n4 < vector.size()) {
                    node6 = (Node)vector.elementAt(n4);
                    node5 = node6.getFirstChild();
                    n = this.generateICode(node5, n);
                    n = this.addByte((byte)70, n);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    n = this.addByte((byte)n3, n);
                    n = this.addByte((byte)53, n);
                    Node node7 = new Node(136);
                    node6.addChildAfter(node7, node5);
                    Node node8 = new Node(7);
                    node8.putProp(1, node7);
                    n = this.addGoto(node8, 7, n);
                    this.itsStackDepth += -1;
                    ++n4;
                }
                Node node9 = (Node)node.getProp(14);
                if (node9 != null) {
                    node6 = new Node(136);
                    node9.getFirstChild().addChildToFront(node6);
                    node5 = new Node(6);
                    node5.putProp(1, node6);
                    n = this.addGoto(node5, 6, n);
                }
                node6 = (Node)node.getProp(2);
                node5 = new Node(6);
                node5.putProp(1, node6);
                n = this.addGoto(node5, 6, n);
                break;
            }
            case 136: {
                Object object = node.getProp(20);
                if (object == null) {
                    int n5 = this.markLabel(this.acquireLabel(), n);
                    node.putProp(20, new Integer(n5));
                } else {
                    int n6 = (Integer)object;
                    this.markLabel(n6, n);
                }
                if (node.getProp(21) == null) break;
                this.itsStackDepth = 1;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 101: 
            case 102: {
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                int n7 = node.getInt();
                if (this.version == 120) {
                    if (n7 == 14) {
                        n7 = 53;
                    } else if (n7 == 15) {
                        n7 = 54;
                    }
                }
                n = this.addByte((byte)n7, n);
                this.itsStackDepth += -1;
                break;
            }
            case 30: 
            case 43: {
                int n8 = 0;
                while (node2 != null) {
                    n = this.generateICode(node2, n);
                    node2 = node2.getNextSibling();
                    ++n8;
                }
                if (node.getProp(30) != null) {
                    n = this.addByte((byte)67, n);
                    n = this.addByte((byte)(this.itsLineNumber >> 8), n);
                    n = this.addByte((byte)(this.itsLineNumber & 0xFF), n);
                    n = this.addString(this.itsSourceFile, n);
                } else {
                    n = this.addByte((byte)n2, n);
                }
                this.itsStackDepth -= n8 - 1;
                n8 = n2 == 30 ? --n8 : (n8 -= 2);
                n = this.addByte((byte)(n8 >> 8), n);
                n = this.addByte((byte)(n8 & 0xFF), n);
                if (n8 <= this.itsData.itsMaxArgs) break;
                this.itsData.itsMaxArgs = n8;
                break;
            }
            case 69: 
            case 143: {
                n = this.generateICode(node2, n);
                n = this.addByte((byte)69, n);
                n = this.addLocalRef(node, n);
                break;
            }
            case 144: {
                if (node.getProp(1) != null) {
                    n = this.addByte((byte)66, n);
                } else {
                    n = this.addByte((byte)70, n);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                }
                Node node10 = (Node)node.getProp(7);
                n = this.addLocalRef(node10, n);
                break;
            }
            case 70: {
                n = this.addByte((byte)70, n);
                Node node11 = (Node)node.getProp(6);
                n = this.addLocalRef(node11, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 7: 
            case 8: {
                n = this.generateICode(node2, n);
                this.itsStackDepth += -1;
            }
            case 6: {
                n = this.addGoto(node, (int)((byte)n2), n);
                break;
            }
            case 142: {
                Node node12 = (Node)node.getProp(1);
                node12.putProp(21, node);
                n = this.addGoto(node, 65, n);
                break;
            }
            case 100: {
                n = this.generateICode(node2, n);
                n = this.addByte((byte)9, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int n9 = this.acquireLabel();
                n = this.addGoto(n9, 8, n);
                n = this.addByte((byte)57, n);
                this.itsStackDepth += -1;
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                this.markLabel(n9, n);
                break;
            }
            case 99: {
                n = this.generateICode(node2, n);
                n = this.addByte((byte)9, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int n10 = this.acquireLabel();
                n = this.addGoto(n10, 7, n);
                n = this.addByte((byte)57, n);
                this.itsStackDepth += -1;
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                this.markLabel(n10, n);
                break;
            }
            case 39: {
                n = this.generateICode(node2, n);
                String string = (String)node.getProp(19);
                if (string != null) {
                    if (string.equals("__proto__")) {
                        n = this.addByte((byte)81, n);
                        break;
                    }
                    if (string.equals("__parent__")) {
                        n = this.addByte((byte)86, n);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                n = this.addByte((byte)39, n);
                this.itsStackDepth += -1;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 41: {
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                n = this.addByte((byte)n2, n);
                this.itsStackDepth += -1;
                break;
            }
            case 141: {
                n = this.generateICode(node2, n);
                Object object = node.getProp(18);
                if (object == ScriptRuntime.NumberClass) {
                    n = this.addByte((byte)58, n);
                    break;
                }
                this.badTree(node);
                break;
            }
            case 104: {
                n = this.generateICode(node2, n);
                switch (node.getInt()) {
                    case 131: {
                        n = this.addByte((byte)57, n);
                        n = this.addByte((byte)74, n);
                        break block0;
                    }
                    case 128: {
                        int n11 = this.acquireLabel();
                        int n12 = this.acquireLabel();
                        n = this.addGoto(n11, 7, n);
                        n = this.addByte((byte)52, n);
                        n = this.addGoto(n12, 6, n);
                        this.markLabel(n11, n);
                        n = this.addByte((byte)51, n);
                        this.markLabel(n12, n);
                        break block0;
                    }
                    case 28: {
                        n = this.addByte((byte)28, n);
                        break block0;
                    }
                    case 32: {
                        n = this.addByte((byte)32, n);
                        break block0;
                    }
                    case 24: {
                        n = this.addByte((byte)29, n);
                        break block0;
                    }
                    case 23: {
                        n = this.addByte((byte)58, n);
                        break block0;
                    }
                }
                this.badTree(node);
                break;
            }
            case 40: {
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                String string = (String)node.getProp(19);
                if (string != null) {
                    if (string.equals("__proto__")) {
                        n = this.addByte((byte)83, n);
                        break;
                    }
                    if (string.equals("__parent__")) {
                        n = this.addByte((byte)84, n);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                n = this.addByte((byte)40, n);
                this.itsStackDepth -= 2;
                break;
            }
            case 42: {
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                n = this.addByte((byte)n2, n);
                this.itsStackDepth -= 2;
                break;
            }
            case 10: {
                n = this.generateICode(node2, n);
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                n = this.addByte((byte)10, n);
                n = this.addString(node3.getString(), n);
                this.itsStackDepth += -1;
                break;
            }
            case 32: {
                String string = node.getString();
                int n13 = -1;
                if (this.itsInFunctionFlag) {
                    n13 = this.itsData.itsVariableTable.getOrdinal(string);
                }
                if (n13 == -1) {
                    n = this.addByte((byte)78, n);
                    n = this.addString(string, n);
                } else {
                    n = this.addByte((byte)72, n);
                    n = this.addByte((byte)n13, n);
                    n = this.addByte((byte)32, n);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 140: {
                n = this.generateICode(node2, n);
                n = this.addByte((byte)82, n);
                break;
            }
            case 44: 
            case 46: 
            case 61: 
            case 71: {
                n = this.addByte((byte)n2, n);
                n = this.addString(node.getString(), n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 105: 
            case 106: {
                int n14 = node2.getType();
                switch (n14) {
                    case 72: {
                        String string = node2.getString();
                        if (this.itsData.itsNeedsActivation) {
                            n = this.addByte((byte)85, n);
                            n = this.addByte((byte)46, n);
                            n = this.addString(string, n);
                            this.itsStackDepth += 2;
                            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                                this.itsData.itsMaxStack = this.itsStackDepth;
                            }
                            n = this.addByte((byte)(n2 == 105 ? 34 : 37), n);
                            this.itsStackDepth += -1;
                            break block0;
                        }
                        n = this.addByte((byte)(n2 == 105 ? 59 : 60), n);
                        int n15 = this.itsData.itsVariableTable.getOrdinal(string);
                        n = this.addByte((byte)n15, n);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break block0;
                    }
                    case 39: 
                    case 41: {
                        Node node13 = node2.getFirstChild();
                        n = this.generateICode(node13, n);
                        node13 = node13.getNextSibling();
                        n = this.generateICode(node13, n);
                        n = n14 == 39 ? this.addByte((byte)(n2 == 105 ? 34 : 37), n) : this.addByte((byte)(n2 == 105 ? 35 : 38), n);
                        this.itsStackDepth += -1;
                        break block0;
                    }
                }
                n = this.addByte((byte)(n2 == 105 ? 33 : 36), n);
                n = this.addString(node2.getString(), n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 45: {
                Number number = (Number)node.getDatum();
                if (number.doubleValue() == 0.0) {
                    n = this.addByte((byte)47, n);
                } else if (number.doubleValue() == 1.0) {
                    n = this.addByte((byte)48, n);
                } else {
                    n = this.addByte((byte)45, n);
                    n = this.addNumber(number, n);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 2: 
            case 57: {
                this.updateLineNumber(node);
            }
            case 3: {
                n = this.generateICode(node2, n);
                n = this.addByte((byte)n2, n);
                this.itsStackDepth += -1;
                break;
            }
            case 68: {
                n = this.generateICode(node2, n);
                n = this.addByte((byte)n2, n);
                break;
            }
            case 77: {
                n = this.addByte((byte)n2, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 4: {
                n = this.addByte((byte)n2, n);
                break;
            }
            case 75: {
                ++this.itsTryDepth;
                if (this.itsTryDepth > this.itsData.itsMaxTryDepth) {
                    this.itsData.itsMaxTryDepth = this.itsTryDepth;
                }
                Node node14 = (Node)node.getProp(1);
                Node node15 = (Node)node.getProp(21);
                if (node14 == null) {
                    n = this.addByte((byte)75, n);
                    n = this.addByte((byte)0, n);
                    n = this.addByte((byte)0, n);
                } else {
                    n = this.addGoto(node, 75, n);
                }
                int n16 = 0;
                if (node15 != null) {
                    n16 = this.acquireLabel();
                    int n17 = n16 & Integer.MAX_VALUE;
                    this.itsLabelTable[n17].addFixup(n);
                }
                n = this.addByte((byte)0, n);
                n = this.addByte((byte)0, n);
                Node node16 = null;
                while (node2 != null) {
                    if (node16 == node14) {
                        this.itsStackDepth = 1;
                        if (this.itsStackDepth > this.itsData.itsMaxStack) {
                            this.itsData.itsMaxStack = this.itsStackDepth;
                        }
                    }
                    n = this.generateICode(node2, n);
                    node16 = node2;
                    node2 = node2.getNextSibling();
                }
                this.itsStackDepth = 0;
                n = this.addByte((byte)76, n);
                if (node15 != null) {
                    int n18 = this.acquireLabel();
                    n = this.addGoto(n18, 6, n);
                    this.markLabel(n16, n);
                    this.itsStackDepth = 1;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    int n19 = this.itsData.itsMaxLocals++;
                    n = this.addByte((byte)69, n);
                    n = this.addByte((byte)n19, n);
                    n = this.addByte((byte)57, n);
                    Integer n20 = (Integer)node15.getProp(20);
                    n = this.addGoto(n20, 65, n);
                    n = this.addByte((byte)70, n);
                    n = this.addByte((byte)n19, n);
                    n = this.addByte((byte)87, n);
                    this.itsStackDepth = 0;
                    this.markLabel(n18, n);
                }
                this.itsTryDepth += -1;
                break;
            }
            case 62: {
                this.updateLineNumber(node);
                n = this.generateICode(node2, n);
                n = this.addByte((byte)62, n);
                this.itsStackDepth += -1;
                break;
            }
            case 5: {
                this.updateLineNumber(node);
                if (node2 != null) {
                    n = this.generateICode(node2, n);
                } else {
                    n = this.addByte((byte)74, n);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                }
                n = this.addGoto(node, 5, n);
                this.itsStackDepth += -1;
                break;
            }
            case 72: {
                String string = node.getString();
                if (this.itsData.itsNeedsActivation) {
                    n = this.addByte((byte)85, n);
                    n = this.addByte((byte)46, n);
                    n = this.addString(string, n);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    n = this.addByte((byte)39, n);
                    this.itsStackDepth += -1;
                    break;
                }
                int n21 = this.itsData.itsVariableTable.getOrdinal(string);
                n = this.addByte((byte)72, n);
                n = this.addByte((byte)n21, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 73: {
                if (this.itsData.itsNeedsActivation) {
                    node2.setType(61);
                    node.setType(10);
                    n = this.generateICode(node, n);
                    break;
                }
                String string = node2.getString();
                node2 = node2.getNextSibling();
                n = this.generateICode(node2, n);
                int n22 = this.itsData.itsVariableTable.getOrdinal(string);
                n = this.addByte((byte)73, n);
                n = this.addByte((byte)n22, n);
                break;
            }
            case 108: {
                n = this.addByte((byte)node.getInt(), n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 79: {
                n = this.generateICode(node2, n);
                n = this.addByte((byte)79, n);
                n = this.addLocalRef(node, n);
                this.itsStackDepth += -1;
                break;
            }
            case 80: {
                n = this.addByte((byte)80, n);
                Node node17 = (Node)node.getProp(4);
                n = this.addLocalRef(node17, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 56: {
                Node node18 = (Node)node.getProp(12);
                int n23 = (Integer)node18.getProp(12);
                n = this.addByte((byte)56, n);
                n = this.addByte((byte)(n23 >> 8), n);
                n = this.addByte((byte)(n23 & 0xFF), n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            default: {
                this.badTree(node);
            }
            case 138: 
        }
        return n;
    }
}

