/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import org.apache.jmeter.visualizers.Visualizer;

public class WindowedVisualizer
extends JPanel
implements Visualizer {
    private Graph graph = new Graph();
    private JTextField windowField;
    private JTextField samplesField;
    private JTextField dataField;
    private JTextField averageField;
    private JTextField deviationField;

    public WindowedVisualizer() {
        JScrollPane jScrollPane = new JScrollPane(this.graph);
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JLabel jLabel = new JLabel("Window");
        this.windowField = new JTextField();
        this.windowField.setEditable(true);
        this.windowField.setColumns(5);
        this.windowField.setText(Integer.toString(this.graph.getWindow()));
        JLabel jLabel2 = new JLabel("Samples");
        this.samplesField = new JTextField();
        this.samplesField.setEditable(true);
        this.samplesField.setColumns(5);
        this.samplesField.setText(Integer.toString(this.graph.getSamples()));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(jLabel);
        jPanel.add(this.windowField);
        jPanel.add(jLabel2);
        jPanel.add(this.samplesField);
        this.dataField = new JTextField("0000ms");
        this.dataField.setEditable(false);
        this.dataField.setForeground(Color.black);
        this.dataField.setBackground(this.getBackground());
        this.averageField = new JTextField("0000ms");
        this.averageField.setEditable(false);
        this.averageField.setForeground(Color.blue);
        this.averageField.setBackground(this.getBackground());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel2.add(this.dataField);
        jPanel2.add(this.averageField);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "West");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "East");
    }

    public synchronized void add(long l) {
        int n = this.graph.add(l);
        this.dataField.setText(String.valueOf(l) + "ms");
        this.averageField.setText(String.valueOf(n) + "ms");
        this.repaint();
    }

    public synchronized void clear() {
        try {
            this.windowField.setText(Integer.toString(this.graph.setWindow(Integer.parseInt(this.windowField.getText()))));
        }
        catch (Exception exception) {}
        try {
            this.samplesField.setText(Integer.toString(this.graph.setSamples(Integer.parseInt(this.samplesField.getText()))));
        }
        catch (Exception exception) {}
        this.graph.clear();
        this.dataField.setText("0000ms");
        this.averageField.setText("0000ms");
        this.repaint();
    }

    public String toString() {
        return "Show the samples analysys as windowed dot plots";
    }

    public class Graph
    extends JComponent
    implements Scrollable {
        private int counter = 0;
        private int cursor = 0;
        private int sum = 0;
        private int window = 100;
        private int samples = 2000;
        private int max = 1;
        private boolean active = true;
        private int[] sample = new int[this.window];
        private int[] average = new int[this.window];

        public Graph() {
            this.setPreferredSize(this.getPreferredScrollableViewportSize());
        }

        public int add(long l) {
            if (++this.counter < this.samples) {
                int n = (int)l;
                this.cursor = this.cursor < this.window - 1 ? ++this.cursor : 0;
                this.sum -= this.sample[this.cursor];
                this.sample[this.cursor] = n;
                this.sum += n;
                if (n > this.max) {
                    this.max = n;
                }
                this.average[this.cursor] = this.sum / this.window;
            } else {
                this.active = false;
            }
            return this.average[this.cursor];
        }

        public void clear() {
            this.sample = new int[this.window];
            this.average = new int[this.window];
            this.sum = 0;
            this.cursor = 0;
            this.counter = 0;
            this.max = 1;
            this.active = true;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(400, 200);
        }

        public int getSamples() {
            return this.samples;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return 50;
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return 1;
        }

        public int getWindow() {
            return this.window;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Dimension dimension = this.getSize();
            int n = 0;
            int n2 = 0;
            while (n < this.window) {
                int n3 = this.sample[n] * dimension.height / this.max;
                graphics.setColor(Color.black);
                graphics.fillRect(n2, dimension.height - n3 - 1, 1, 2);
                int n4 = this.average[n] * dimension.height / this.max;
                graphics.setColor(Color.blue);
                graphics.fillRect(n2, dimension.height - n4 - 1, 1, 2);
                ++n;
                ++n2;
            }
        }

        public int setSamples(int n) {
            if (n > 0) {
                this.samples = n;
            }
            return this.samples;
        }

        public int setWindow(int n) {
            if (n > 0) {
                this.window = n;
            }
            return this.window;
        }
    }
}

