/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

public class Spline3 {
    private final boolean DEBUG = false;
    protected float[][] _coefficients;
    protected float[][] _A;
    protected float[] _B;
    protected float[] _r;
    protected float[] _rS;
    protected int _m;
    protected int _n;
    protected static final float DEFAULT_PRECISION = 0.1f;
    protected static final int DEFAULT_MAX_ITERATIONS = 100;
    protected float _minPrecision = 0.1f;
    protected int _maxIterations = 100;

    public Spline3(float[] fArray) {
        int n;
        this._m = n = fArray.length;
        this._r = new float[n];
        int n2 = 0;
        while (n2 < n) {
            this._r[n2] = fArray[n2];
            ++n2;
        }
        this._n = n - 2;
        try {
            long l = System.currentTimeMillis();
            this.interpolation();
        }
        catch (Exception exception) {
            System.err.print("Error when interpolating : ");
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    protected boolean converge() {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        n = 0;
        while (n < this._n) {
            if (bl) {
                f = 0.0f;
                n2 = 0;
                while (n2 < this._n) {
                    f += Math.abs(this._A[n][n2]);
                    ++n2;
                }
                if ((f -= Math.abs(this._A[n][n])) > Math.abs(this._A[n][n])) {
                    bl = false;
                }
            }
            ++n;
        }
        return bl;
    }

    public void debugCheck() {
        int n = 0;
        n = 0;
        while (n < this._m) {
            System.out.print("Point " + n + " : ");
            System.out.println(String.valueOf(this._r[n]) + " =? " + this.value(n));
            ++n;
        }
    }

    public int getDefaultMaxIterations() {
        return 100;
    }

    public float getDefaultPrecision() {
        return 0.1f;
    }

    public int getMaxIterations() {
        return this._maxIterations;
    }

    public int[] getPlots(int n, int n2) {
        int[] nArray = new int[n];
        float[] fArray = new float[n];
        float f = -2.1474836E9f;
        float f2 = 2.1474836E9f;
        int n3 = 0;
        while (n3 < n) {
            fArray[n3] = this.value((float)n3 * (float)(this._m - 1) / (float)n);
            if (fArray[n3] < f2) {
                f2 = fArray[n3];
            }
            if (fArray[n3] > f) {
                f = fArray[n3];
            }
            ++n3;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        int n4 = 0;
        while (n4 < n) {
            nArray[n4] = Math.round((fArray[n4] - f2) * (float)(n2 - 1) / (f - f2));
            ++n4;
        }
        return nArray;
    }

    public float getPrecision() {
        return this._minPrecision;
    }

    protected void interpolation() {
        this._rS = new float[this._m];
        this._B = new float[this._n];
        this._A = new float[this._n][this._n];
        this._coefficients = new float[this._n + 1][4];
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n < this._n) {
            this._B[n] = 0.0f;
            n2 = 0;
            while (n2 < this._n) {
                this._A[n][n2] = 0.0f;
                ++n2;
            }
            n2 = 0;
            while (n2 < 4) {
                this._coefficients[n][n2] = 0.0f;
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this._n) {
            this._rS[n] = 0.0f;
            ++n;
        }
        n = 0;
        while (n < this._n) {
            this._A[n][n] = 4.0f;
            ++n;
        }
        n = 1;
        while (n < this._n) {
            this._A[n][n - 1] = 1.0f;
            this._A[n - 1][n] = 1.0f;
            ++n;
        }
        n = 0;
        while (n < this._n) {
            this._B[n] = 6.0f * (this._r[n + 2] - 2.0f * this._r[n + 1] + this._r[n]);
            ++n;
        }
        this.jacobi();
        n = 0;
        while (n < this._n + 1) {
            this._coefficients[n][0] = this._r[n];
            this._coefficients[n][1] = this._r[n + 1] - this._r[n] - (this._rS[n + 1] + 2.0f * this._rS[n]) / 6.0f;
            this._coefficients[n][2] = this._rS[n] / 2.0f;
            this._coefficients[n][3] = (this._rS[n + 1] - this._rS[n]) / 6.0f;
            ++n;
        }
    }

    protected void jacobi() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float[] fArray = new float[this._n];
        float[] fArray2 = new float[this._n];
        this.converge();
        n = 0;
        while (n < this._n) {
            fArray[n] = 0.0f;
            fArray2[n] = 0.0f;
            ++n;
        }
        while (this.precision(fArray2, fArray) > this._minPrecision && n3 < this._maxIterations) {
            n = 0;
            while (n < this._n) {
                fArray2[n] = fArray[n];
                ++n;
            }
            n = 0;
            while (n < this._n) {
                fArray[n] = this._B[n];
                n2 = 0;
                while (n2 < n) {
                    fArray[n] = fArray[n] - this._A[n][n2] * fArray2[n2];
                    ++n2;
                }
                n2 = n + 1;
                while (n2 < this._n) {
                    fArray[n] = fArray[n] - this._A[n][n2] * fArray2[n2];
                    ++n2;
                }
                fArray[n] = fArray[n] / this._A[n][n];
                ++n;
            }
            ++n3;
        }
        this.precision(fArray2, fArray);
        n = 0;
        while (n < this._n) {
            this._rS[n + 1] = fArray[n];
            ++n;
        }
    }

    public static void main(String[] stringArray) {
    }

    protected float precision(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n = 0;
        n = 0;
        while (n < this._n) {
            f += Math.abs(fArray2[n] - fArray[n]);
            f2 += Math.abs(fArray2[n]);
            ++n;
        }
        f3 = f2 != 0.0f ? f / f2 : Float.MAX_VALUE;
        return f3;
    }

    public void setMaxIterations(int n) {
        this._maxIterations = n;
    }

    public void setPrecision(float f) {
        this._minPrecision = f;
    }

    public void setToDefaultMaxIterations() {
        this._maxIterations = 100;
    }

    public void setToDefaultPrecision() {
        this._minPrecision = 0.1f;
    }

    public float value(float f) {
        int n = 0;
        int n2 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (f < 0.0f || f > (float)(this._m - 1)) {
            f = f < 0.0f ? 0.0f : (float)(this._m - 1);
        }
        n2 = (int)Math.floor(f);
        if (f == (float)(this._m - 1)) {
            --n2;
        }
        f2 = f - (float)n2;
        n = 0;
        while (n < 4) {
            f3 *= f2;
            f3 += this._coefficients[n2][3 - n];
            ++n;
        }
        return f3;
    }
}

