/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.jmeter.visualizers.Visualizer;

public class FileVisualizer
extends JPanel
implements Visualizer,
ActionListener {
    private boolean verbose = true;
    private boolean append = true;
    private boolean open = false;
    private String file;
    private PrintWriter stream;
    JButton browseButton;
    JButton openButton;
    JButton flushButton;
    JButton closeButton;
    JFileChooser fileChooser;
    JCheckBox appendCheck;
    JCheckBox verboseCheck;
    JComboBox fileList;

    public FileVisualizer() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output File"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.fileList = new JComboBox();
        this.fileList.setEditable(true);
        this.fileList.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.fileList, gridBagConstraints);
        jPanel.add(this.fileList);
        this.browseButton = new JButton("Browse");
        this.browseButton.addActionListener(this);
        this.browseButton.setEnabled(true);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(this.browseButton, gridBagConstraints);
        jPanel.add(this.browseButton);
        this.appendCheck = new JCheckBox("Append", this.append);
        this.appendCheck.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.appendCheck, gridBagConstraints);
        jPanel.add(this.appendCheck);
        this.verboseCheck = new JCheckBox("Verbose Output", this.verbose);
        this.verboseCheck.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.verboseCheck, gridBagConstraints);
        jPanel.add(this.verboseCheck);
        this.openButton = new JButton("Open");
        this.openButton.addActionListener(this);
        this.openButton.setEnabled(true);
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(this.openButton, gridBagConstraints);
        jPanel.add(this.openButton);
        this.flushButton = new JButton("Flush");
        this.flushButton.addActionListener(this);
        this.flushButton.setEnabled(false);
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(this.flushButton, gridBagConstraints);
        jPanel.add(this.flushButton);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.closeButton.setEnabled(false);
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
        jPanel.add(this.closeButton);
        this.fileChooser = new JFileChooser();
        this.add(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            if (jComponent == this.fileList) {
                this.file = (String)this.fileList.getSelectedItem();
                this.fileList.removeItem(this.file);
                this.fileList.addItem(this.file);
            } else if (jComponent == this.appendCheck) {
                this.append = this.appendCheck.isSelected();
            } else if (jComponent == this.browseButton) {
                int n = this.fileChooser.showOpenDialog(this);
                if (n == 0) {
                    this.file = this.fileChooser.getSelectedFile().toString();
                    this.fileList.removeItem(this.file);
                    this.fileList.addItem(this.file);
                    this.fileList.getEditor().setItem(this.file);
                }
            } else if (jComponent == this.openButton) {
                this.stream = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.file, this.append)), false);
                if (this.verbose) {
                    this.stream.println("\n# Sample data created by Apache JMeter 1.4");
                    this.stream.println("\n#       URL                    Milliseconds\n");
                }
                this.browseButton.setEnabled(false);
                this.openButton.setEnabled(false);
                this.flushButton.setEnabled(true);
                this.closeButton.setEnabled(true);
                this.open = true;
            } else if (jComponent == this.flushButton) {
                this.stream.flush();
            } else if (jComponent == this.closeButton) {
                this.open = false;
                this.stream.flush();
                this.stream.close();
                this.browseButton.setEnabled(true);
                this.openButton.setEnabled(true);
                this.flushButton.setEnabled(false);
                this.closeButton.setEnabled(false);
            } else if (jComponent == this.verboseCheck) {
                this.verbose = this.verboseCheck.isSelected();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception, "Error", 0);
        }
    }

    public synchronized void add(long l) {
        if (this.open) {
            if (this.verbose) {
                this.stream.println(String.valueOf(Thread.currentThread().getName()) + "  " + l);
            } else {
                this.stream.println(l);
            }
        }
    }

    public synchronized void clear() {
    }

    public String toString() {
        return "Write the samples to a file";
    }
}

