/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.visualizers.Visualizer;

public class BarVisualizer
extends JPanel
implements Visualizer,
ChangeListener {
    private static final int MAX_SCALE = 2000;
    private Graph graph = new Graph();
    private JSlider slider = new JSlider(1, 0, 2000, 1000);

    public BarVisualizer() {
        this.slider.addChangeListener(this);
        this.slider.setPaintLabels(false);
        this.slider.setPaintTicks(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.slider, "West");
        this.add((Component)this.graph, "Center");
        this.setPreferredSize(new Dimension(500, 100));
    }

    public synchronized void add(long l) {
        this.graph.add((int)l);
        this.repaint();
    }

    public synchronized void clear() {
        this.graph.clear();
        this.repaint();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.slider.getValue();
        this.graph.setLimit(n);
        this.repaint();
    }

    public String toString() {
        return "Show the samples as scrolling bars";
    }

    class Graph
    extends JComponent {
        private final int GRIDS = 10;
        private int limit = 1000;
        private int scale;
        private int counter = 0;
        private Vector samples = new Vector();
        private Color barColor = Color.lightGray;

        public Graph() {
            this.scale = this.limit / 10;
        }

        public void add(int n) {
            this.samples.addElement(new Integer(n));
            ++this.counter;
        }

        public void clear() {
            this.samples.removeAllElements();
            this.counter = 0;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Dimension dimension = this.getSize();
            int n = 1;
            while (n < 10) {
                int n2 = dimension.height - n * dimension.height / 10;
                graphics.setColor(Color.black);
                graphics.drawLine(5, n2, dimension.width - 35, n2);
                graphics.setColor(Color.blue);
                graphics.drawString(Integer.toString(n * this.scale), dimension.width - 30, n2 + this.getFont().getSize() / 2);
                ++n;
            }
            int n3 = (dimension.width - 40) / 8;
            if (this.counter < n3) {
                n3 = this.counter;
            }
            int n4 = n3;
            while (n4 > 0) {
                int n5 = (Integer)this.samples.elementAt(this.counter - n4) * dimension.height / this.limit;
                graphics.setColor(this.barColor);
                graphics.fill3DRect(dimension.width - 36 - 8 * n4, dimension.height - n5, 5, n5, true);
                --n4;
            }
        }

        public synchronized void setLimit(int n) {
            this.limit = n;
            this.scale = n / 10;
        }
    }
}

