/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.jmeter.samplers.AuthManager;
import org.apache.jmeter.samplers.CookieManager;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.visualizers.Visualizer;

public class URLSampler
extends JLabel
implements Runnable {
    private int index;
    private Vector urls;
    private String query;
    private boolean alive;
    private Timer timer;
    private Visualizer visualizer;
    private CookieManager cookieManager = null;
    private AuthManager authManager = null;
    private boolean doPost;

    public URLSampler(ImageIcon imageIcon) {
        super(imageIcon);
    }

    public void die() {
        this.alive = false;
    }

    private URL getURL() {
        this.index = ++this.index < this.urls.size() ? this.index : 0;
        return (URL)this.urls.elementAt(this.index);
    }

    public void init(Timer timer, Vector vector, String string, String string2) throws IOException {
        this.init(timer, vector, string, string2, null, false);
    }

    public void init(Timer timer, Vector vector, String string, String string2, String string3) throws IOException {
        this.init(timer, vector, string, string2, string3, false);
    }

    public void init(Timer timer, Vector vector, String string, String string2, String string3, boolean bl) throws IOException {
        if (string2 != null) {
            this.cookieManager = new CookieManager(string2);
        }
        if (string3 != null) {
            this.authManager = new AuthManager(string3);
        }
        this.timer = timer;
        this.timer.set();
        this.urls = vector;
        this.query = string;
        this.alive = true;
        this.index = 0;
        this.doPost = bl;
    }

    public void run() {
        while (this.alive) {
            Serializable serializable = this;
            synchronized (serializable) {
                try {
                    this.setEnabled(false);
                    this.repaint();
                    this.wait(this.timer.delay());
                    this.setEnabled(true);
                    this.repaint();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                serializable = this.getURL();
                Thread.currentThread().setName(((URL)serializable).toString());
                long l = this.sample((URL)serializable);
                if (!this.alive) continue;
                this.visualizer.add(l);
            }
            catch (Exception exception) {
                this.alive = false;
            }
        }
        this.setEnabled(false);
        this.repaint();
    }

    private long sample(URL uRL) throws IOException {
        String string;
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        if (this.doPost) {
            ((HttpURLConnection)uRLConnection).setRequestMethod("POST");
        }
        if (this.cookieManager != null && (string = this.cookieManager.getCookieHeaderForURL(uRL)) != null) {
            uRLConnection.setRequestProperty("Cookie", string);
        }
        if (this.authManager != null && (string = this.authManager.getAuthHeaderForURL(uRL)) != null) {
            uRLConnection.setRequestProperty("Authorization", string);
        }
        long l = System.currentTimeMillis();
        if (this.cookieManager != null) {
            int n = 1;
            while (true) {
                block8: {
                    try {
                        if (!uRLConnection.getHeaderFieldKey(n).equals("Set-Cookie")) break block8;
                        this.cookieManager.addCookieFromHeader(uRLConnection.getHeaderField(n), uRL);
                    }
                    catch (NullPointerException nullPointerException) {
                        break;
                    }
                }
                ++n;
            }
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        int n = 0;
        while (n != -1) {
            n = bufferedInputStream.read();
        }
        bufferedInputStream.close();
        return System.currentTimeMillis() - l;
    }

    public void setVisualizer(Visualizer visualizer) {
        this.visualizer = visualizer;
    }

    public static Vector tryURLs(Vector vector, String string, boolean bl, JComponent jComponent) throws IOException {
        Vector<URL> vector2 = new Vector<URL>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string != null) {
                string2 = String.valueOf(string2) + "?" + (string.charAt(0) == '?' ? string.substring(1) : string);
            }
            URL uRL = new URL(string2);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            if (bl) {
                ((HttpURLConnection)uRLConnection).setRequestMethod("POST");
            }
            try {
                int n = ((HttpURLConnection)uRLConnection).getResponseCode();
                if (n != 200 && n != 401 && n != 302) continue;
                vector2.addElement(uRL);
            }
            catch (IOException iOException) {}
        }
        return vector2;
    }
}

