/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.jmeter.samplers.Authorization;
import org.apache.jmeter.samplers.Base64Encoder;

public class AuthManager
implements Cloneable {
    private Vector auths = new Vector();

    public AuthManager(String string) throws IOException {
        String string2;
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + string);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string2 = bufferedReader.readLine()) != null) {
            try {
                if (string2.startsWith("#") || string2.trim().length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                Authorization authorization = new Authorization(string3, string4, string5);
                this.auths.addElement(authorization);
            }
            catch (Exception exception) {
                throw new IOException("Error parsing auth line\n\t'" + string2 + "'\n\t" + exception);
            }
        }
        bufferedReader.close();
    }

    public String getAuthHeaderForURL(URL uRL) {
        if (!uRL.getProtocol().toUpperCase().equals("HTTP")) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.auths.elements();
        while (enumeration.hasMoreElements()) {
            Authorization authorization = (Authorization)enumeration.nextElement();
            if (!uRL.toString().startsWith(authorization.getURL())) continue;
            stringBuffer.append("Basic " + Base64Encoder.encode(String.valueOf(authorization.getUser()) + ":" + authorization.getPass()));
            break;
        }
        if (stringBuffer.length() != 0) {
            return stringBuffer.toString();
        }
        return null;
    }
}

