/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.apache.jmeter.JMeter;

class JMeterUtils {
    static /* synthetic */ Class class$org$apache$jmeter$JMeterUtils;

    JMeterUtils() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static JButton createButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(JMeterUtils.getImage(String.valueOf(string) + ".on.gif"));
        jButton.setDisabledIcon(JMeterUtils.getImage(String.valueOf(string) + ".off.gif"));
        jButton.setRolloverIcon(JMeterUtils.getImage(String.valueOf(string) + ".over.gif"));
        jButton.setPressedIcon(JMeterUtils.getImage(String.valueOf(string) + ".down.gif"));
        jButton.setActionCommand(string);
        jButton.addActionListener(actionListener);
        jButton.setRolloverEnabled(true);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setOpaque(false);
        jButton.setPreferredSize(new Dimension(40, 40));
        return jButton;
    }

    protected static Hashtable getAlias(Properties properties) {
        return JMeterUtils.getHashtable(properties, "alias.");
    }

    protected static Hashtable getHashtable(Properties properties, String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            hashtable.put(string2.substring(string.length()), properties.getProperty(string2));
        }
        return hashtable;
    }

    protected static ImageIcon getImage(String string) {
        (class$org$apache$jmeter$JMeterUtils != null ? class$org$apache$jmeter$JMeterUtils : (class$org$apache$jmeter$JMeterUtils = JMeterUtils.class$("org.apache.jmeter.JMeterUtils"))).getClassLoader();
        return new ImageIcon(ClassLoader.getSystemResource("org/apache/jmeter/images/" + string));
    }

    protected static Properties getProperties(String string) {
        Properties properties = new Properties();
        try {
            File file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + string);
            properties.load(new FileInputStream(file));
        }
        catch (Exception exception) {
            ((Hashtable)properties).clear();
            try {
                (class$org$apache$jmeter$JMeterUtils != null ? class$org$apache$jmeter$JMeterUtils : (class$org$apache$jmeter$JMeterUtils = JMeterUtils.class$("org.apache.jmeter.JMeterUtils"))).getClassLoader();
                properties.load(ClassLoader.getSystemResourceAsStream("org/apache/jmeter/jmeter.properties"));
            }
            catch (IOException iOException) {
                JMeter.fail("Could not read internal resource. Archive is broken.");
            }
        }
        return properties;
    }

    protected static Vector getTimers(Properties properties) {
        return JMeterUtils.instantiate(JMeterUtils.getVector(properties, "timer."), "org.apache.jmeter.timers.Timer");
    }

    protected static Vector getVector(Properties properties, String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            vector.addElement(properties.getProperty(string2));
        }
        return vector;
    }

    protected static Vector getVisualizers(Properties properties) {
        return JMeterUtils.instantiate(JMeterUtils.getVector(properties, "visualizer."), "org.apache.jmeter.visualizers.Visualizer");
    }

    protected static Vector instantiate(Vector vector, String string) {
        Vector vector2 = new Vector();
        try {
            Class<?> clazz = Class.forName(string);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                try {
                    Object obj = Class.forName(string2).newInstance();
                    if (!clazz.isInstance(obj)) continue;
                    vector2.addElement(obj);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JMeter.fail("Error loading class " + string2 + ": class is not found");
                }
                catch (IllegalAccessException illegalAccessException) {
                    JMeter.fail("Error loading class " + string2 + ": does not have access");
                }
                catch (InstantiationException instantiationException) {
                    JMeter.fail("Error loading class " + string2 + ": could not instantiate");
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            JMeter.fail("Error loading class " + string + ": class is not found");
        }
        return vector2;
    }

    protected static Vector tokenize(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }
}

