/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.AST.ASTProgram;
import FESI.AST.ASTStatement;
import FESI.AST.ASTStatementList;
import FESI.Data.ESLoader;
import FESI.Data.ESObject;
import FESI.Data.ESPackages;
import FESI.Data.ESReference;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Data.GlobalObject;
import FESI.Data.JSGlobalWrapper;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.EcmaScriptLexicalException;
import FESI.Exceptions.EcmaScriptParseException;
import FESI.Extensions.Extension;
import FESI.Interpreter.EcmaScriptEvaluateVisitor;
import FESI.Interpreter.EcmaScriptFunctionVisitor;
import FESI.Interpreter.EcmaScriptVariableVisitor;
import FESI.Interpreter.EvaluationSource;
import FESI.Interpreter.FileEvaluationSource;
import FESI.Interpreter.JarEvaluationSource;
import FESI.Interpreter.ParsedProgram;
import FESI.Interpreter.ScopeChain;
import FESI.Interpreter.StringEvaluationSource;
import FESI.Interpreter.UserEvaluationSource;
import FESI.Parser.EcmaScript;
import FESI.Parser.ParseException;
import FESI.Parser.TokenMgrError;
import FESI.jslib.JSException;
import FESI.jslib.JSExtension;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Evaluator {
    private static String eol = System.getProperty("line.separator", "\n");
    private boolean debugParse = false;
    private GlobalObject globalObject;
    private ESObject objectPrototype;
    private ESObject functionPrototype;
    private ESObject functionObject;
    private ESObject stringPrototype;
    private ESObject numberPrototype;
    private ESObject booleanPrototype;
    private ESObject arrayPrototype;
    private ESObject datePrototype;
    private ESObject packageObject;
    private ScopeChain theScopeChain;
    private ESObject currentVariableObject;
    private ESObject currentThisObject;
    private EcmaScriptFunctionVisitor functionDeclarationVisitor;
    private EcmaScriptVariableVisitor varDeclarationVisitor;
    private Hashtable extensions;

    public static String getVersion() {
        return "1.1.2 (8-May-1999)";
    }

    public static String getWelcomeText() {
        return "FESI (pronounced like 'fuzzy'): an EcmaScript Interpreter" + eol + "Copyright (c) Jean-Marc Lugrin, 1998 - Version: " + Evaluator.getVersion();
    }

    protected void reset() {
        this.functionDeclarationVisitor = new EcmaScriptFunctionVisitor(this);
        this.varDeclarationVisitor = new EcmaScriptVariableVisitor(this);
        this.globalObject = GlobalObject.makeGlobalObject(this);
        this.packageObject = new ESPackages(this);
        this.extensions = new Hashtable();
    }

    public Evaluator() {
        this.reset();
    }

    public EcmaScriptVariableVisitor getVarDeclarationVisitor() {
        return this.varDeclarationVisitor;
    }

    public ESObject getThisObject() {
        return this.currentThisObject;
    }

    public GlobalObject getGlobalObject() {
        return this.globalObject;
    }

    public void setDebugParse(boolean bl) {
        this.debugParse = bl;
    }

    public boolean isDebugParse() {
        return this.debugParse;
    }

    public void setObjectPrototype(ESObject eSObject) {
        this.objectPrototype = eSObject;
    }

    public ESObject getObjectPrototype() {
        return this.objectPrototype;
    }

    public void setFunctionPrototype(ESObject eSObject) {
        this.functionPrototype = eSObject;
    }

    public ESObject getFunctionPrototype() {
        return this.functionPrototype;
    }

    public void setFunctionObject(ESObject eSObject) {
        this.functionObject = eSObject;
    }

    public ESObject getFunctionObject() {
        return this.functionObject;
    }

    public void setStringPrototype(ESObject eSObject) {
        this.stringPrototype = eSObject;
    }

    public ESObject getStringPrototype() {
        return this.stringPrototype;
    }

    public void setNumberPrototype(ESObject eSObject) {
        this.numberPrototype = eSObject;
    }

    public ESObject getNumberPrototype() {
        return this.numberPrototype;
    }

    public void setBooleanPrototype(ESObject eSObject) {
        this.booleanPrototype = eSObject;
    }

    public ESObject getBooleanPrototype() {
        return this.booleanPrototype;
    }

    public void setArrayPrototype(ESObject eSObject) {
        this.arrayPrototype = eSObject;
    }

    public ESObject getArrayPrototype() {
        return this.arrayPrototype;
    }

    public void setDatePrototype(ESObject eSObject) {
        this.datePrototype = eSObject;
    }

    public ESObject getDatePrototype() {
        return this.datePrototype;
    }

    public ESObject getPackageObject() {
        return this.packageObject;
    }

    public Extension getExtension(String string) {
        return (Extension)this.extensions.get(string);
    }

    public Enumeration getExtensions() {
        return this.extensions.keys();
    }

    public Object addExtension(String string) throws EcmaScriptException {
        Extension extension;
        block11: {
            extension = this.getExtension(string);
            if (extension != null) break block11;
            try {
                extension = Class.forName(string).newInstance();
                if (extension instanceof Extension) {
                    extension.initializeExtension(this);
                } else if (extension instanceof JSExtension) {
                    GlobalObject globalObject = this.getGlobalObject();
                    JSGlobalWrapper jSGlobalWrapper = new JSGlobalWrapper(globalObject, this);
                    try {
                        ((JSExtension)((Object)extension)).initializeExtension(jSGlobalWrapper);
                    }
                    catch (JSException jSException) {
                        return null;
                    }
                } else {
                    return null;
                }
                this.extensions.put(string, extension);
            }
            catch (ClassNotFoundException classNotFoundException) {
                extension = null;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                extension = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                extension = null;
            }
            catch (InstantiationException instantiationException) {
                extension = null;
            }
        }
        return extension;
    }

    public Object addMandatoryExtension(String string) throws EcmaScriptException {
        Extension extension = this.getExtension(string);
        if (extension == null) {
            try {
                extension = Class.forName(string).newInstance();
                if (extension instanceof Extension) {
                    extension.initializeExtension(this);
                } else if (extension instanceof JSExtension) {
                    GlobalObject globalObject = this.getGlobalObject();
                    JSGlobalWrapper jSGlobalWrapper = new JSGlobalWrapper(globalObject, this);
                    try {
                        ((JSExtension)((Object)extension)).initializeExtension(jSGlobalWrapper);
                    }
                    catch (JSException jSException) {
                        throw new EcmaScriptException("Error initializing extension " + string, jSException);
                    }
                } else {
                    throw new EcmaScriptException("Extenstion object " + string + " of wrong type " + extension.getClass());
                }
                this.extensions.put(string, extension);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new EcmaScriptException("Error loading extension " + string, classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new EcmaScriptException("Error loading extension " + string, noClassDefFoundError);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EcmaScriptException("Error loading extension " + string, illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new EcmaScriptException("Error loading extension " + string, instantiationException);
            }
        }
        return extension;
    }

    public ESReference getReference(String string) throws EcmaScriptException {
        return this.theScopeChain.getReference(string);
    }

    public ESReference getReference(String string, int n) throws EcmaScriptException {
        return this.theScopeChain.getReference(string, n);
    }

    public ESValue getValue(String string) throws EcmaScriptException {
        return this.theScopeChain.getValue(string);
    }

    public ESValue getValue(String string, int n) throws EcmaScriptException {
        return this.theScopeChain.getValue(string, n);
    }

    public ESValue doIndirectCall(ESObject eSObject, String string, int n, ESValue[] eSValueArray) throws EcmaScriptException {
        return this.theScopeChain.doIndirectCall(this, eSObject, string, n, eSValueArray);
    }

    public void createVariable(String string, int n) throws EcmaScriptException {
        if (!this.currentVariableObject.hasProperty(string, n)) {
            ESReference eSReference = new ESReference(this.currentVariableObject, string, n);
            eSReference.putValue(this.currentVariableObject, ESUndefined.theUndefined);
        }
    }

    public void putValue(ESReference eSReference, ESValue eSValue) throws EcmaScriptException {
        eSReference.putValue(this.globalObject, eSValue);
    }

    public ESValue evaluateEvalString(String string) throws EcmaScriptException {
        ESValue eSValue = ESUndefined.theUndefined;
        StringReader stringReader = new StringReader(string);
        EcmaScript ecmaScript = new EcmaScript(stringReader);
        ASTProgram aSTProgram = null;
        StringEvaluationSource stringEvaluationSource = new StringEvaluationSource(string, null);
        try {
            aSTProgram = (ASTProgram)ecmaScript.Program();
            if (this.debugParse) {
                System.out.println();
                System.out.println("Dump parse tree of eval (debugParse true)");
                aSTProgram.dump("");
            }
        }
        catch (ParseException parseException) {
            if (this.debugParse) {
                System.out.println("[[PARSING ERROR DETECTED: (debugParse true)]]");
                System.out.println(parseException.getMessage());
                System.out.println("[[BY ROUTINE:]]");
                parseException.printStackTrace();
                System.out.println();
            }
            throw new EcmaScriptParseException(parseException, stringEvaluationSource);
        }
        catch (TokenMgrError tokenMgrError) {
            if (this.debugParse) {
                System.out.println("[[LEXICAL ERROR DETECTED: (debugParse true)]]");
                System.out.println(tokenMgrError.getMessage());
                System.out.println("[[BY ROUTINE:]]");
                tokenMgrError.printStackTrace();
                System.out.println();
            }
            throw new EcmaScriptLexicalException(tokenMgrError, stringEvaluationSource);
        }
        ESObject eSObject = this.currentVariableObject;
        this.currentVariableObject = this.globalObject;
        try {
            this.functionDeclarationVisitor.processFunctionDeclarations(aSTProgram, stringEvaluationSource);
            this.varDeclarationVisitor.processVariableDeclarations(aSTProgram, (EvaluationSource)stringEvaluationSource);
            EcmaScriptEvaluateVisitor ecmaScriptEvaluateVisitor = new EcmaScriptEvaluateVisitor(this);
            eSValue = ecmaScriptEvaluateVisitor.evaluateProgram(aSTProgram, stringEvaluationSource);
            if (eSValue == null) {
                eSValue = ESUndefined.theUndefined;
            }
            if (ecmaScriptEvaluateVisitor.getCompletionCode() != 0) {
                throw new EcmaScriptException("Unexpected " + ecmaScriptEvaluateVisitor.getCompletionCodeString() + " in eval parameter top level");
            }
            Object var9_11 = null;
            this.currentVariableObject = eSObject;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.currentVariableObject = eSObject;
            throw throwable;
        }
        return eSValue;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ESValue evaluateLoadFile(File file) throws EcmaScriptException {
        void var2_5;
        ESUndefined eSUndefined = ESUndefined.theUndefined;
        if (!file.isFile()) {
            throw new EcmaScriptException("File '" + file.getPath() + "' does not exist or is not a text file");
        }
        FileEvaluationSource fileEvaluationSource = new FileEvaluationSource(file.getPath(), null);
        FileReader fileReader = null;
        try {
            try {
                fileReader = new FileReader(file);
                ESValue eSValue = this.evaluate(fileReader, null, fileEvaluationSource, false);
                if (eSValue == null) {
                    ESUndefined eSUndefined2 = ESUndefined.theUndefined;
                }
            }
            catch (IOException iOException) {
                throw new EcmaScriptException("IO Error loading file " + file + ": " + iOException);
            }
            Object var6_9 = null;
            if (fileReader == null) return var2_5;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (fileReader == null) throw throwable;
            try {
                fileReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileReader.close();
            return var2_5;
        }
        catch (IOException iOException) {}
        return var2_5;
    }

    public ESValue evaluateLoadModule(String string) throws EcmaScriptException {
        Object object;
        if (string == null) {
            throw new EcmaScriptException("Missing file or module name for load");
        }
        String string2 = System.getProperty("FESI.path", null);
        if (string2 == null) {
            string2 = System.getProperty("java.class.path", null);
        }
        ESValue eSValue = ESUndefined.theUndefined;
        if (string2 == null) {
            object = new File(string);
            try {
                eSValue = this.evaluateLoadFile((File)object);
            }
            catch (EcmaScriptParseException ecmaScriptParseException) {
                ecmaScriptParseException.setNeverIncomplete();
                throw ecmaScriptParseException;
            }
        }
        boolean bl = ((String)(object = string.toLowerCase())).endsWith(".es") || ((String)object).endsWith(".esw") || ((String)object).endsWith(".js");
        String string3 = System.getProperty("path.seperator", ";");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            eSValue = this.tryLoad(string4, string, bl);
            if (eSValue != null) break;
        }
        if (eSValue == null) {
            throw new EcmaScriptException("Module " + string + " not found in " + string2);
        }
        return eSValue;
    }

    private ESValue tryLoad(String string, String string2, boolean bl) throws EcmaScriptException {
        File file = new File(string);
        if (file.isDirectory()) {
            File file2;
            if (bl) {
                file2 = new File(file, string2);
            } else {
                file2 = new File(file, String.valueOf(string2) + ".es");
                if (!file2.exists()) {
                    file2 = new File(file, String.valueOf(string2) + ".esw");
                }
                if (!file2.exists()) {
                    file2 = new File(file, String.valueOf(string2) + ".js");
                }
            }
            if (!file2.exists()) {
                return null;
            }
            try {
                String string3 = file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new EcmaScriptException("IO error accessing module " + string2 + " in directory  " + file, iOException);
            }
            return this.evaluateLoadFile(file2);
        }
        if (file.isFile()) {
            Object object;
            ZipFile zipFile;
            Object object2;
            try {
                object2 = file.getCanonicalPath();
                zipFile = new ZipFile((String)object2);
            }
            catch (IOException iOException) {
                return null;
            }
            if (bl) {
                object2 = zipFile.getEntry(string2);
            } else {
                object2 = zipFile.getEntry(String.valueOf(string2) + ".es");
                if (object2 == null) {
                    object2 = zipFile.getEntry(String.valueOf(string2) + ".esw");
                }
                if (object2 == null) {
                    object2 = zipFile.getEntry(String.valueOf(string2) + ".js");
                }
            }
            if (object2 == null) {
                return null;
            }
            byte[] byArray = null;
            try {
                int n;
                object = zipFile.getInputStream((ZipEntry)object2);
                int n2 = (int)((ZipEntry)object2).getSize();
                byArray = new byte[n2];
                for (int i = 0; i < n2; i += n) {
                    n = ((InputStream)object).read(byArray, i, n2 - i);
                    if (n != 0) continue;
                    throw new IOException("Only " + i + " bytes out of " + n2 + " read from entry '" + string2 + "' in jar '" + zipFile.getName() + "'");
                }
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** Error reading jar: " + iOException);
                }
                return null;
            }
            object = new JarEvaluationSource(file.getPath(), string2, null);
            StringReader stringReader = new StringReader(new String(byArray));
            ESValue eSValue = this.evaluate(stringReader, null, (EvaluationSource)object, false);
            if (eSValue == null) {
                eSValue = ESUndefined.theUndefined;
            }
            return eSValue;
        }
        return null;
    }

    public ESValue evaluateFunction(ASTStatementList aSTStatementList, EvaluationSource evaluationSource, ESObject eSObject, Vector vector, ESObject eSObject2) throws EcmaScriptException {
        ESValue eSValue = ESUndefined.theUndefined;
        ESObject eSObject3 = this.currentVariableObject;
        ESObject eSObject4 = this.currentThisObject;
        ScopeChain scopeChain = this.theScopeChain;
        this.currentVariableObject = eSObject;
        this.currentThisObject = eSObject2;
        this.theScopeChain = new ScopeChain(this.globalObject, null);
        this.theScopeChain = new ScopeChain(eSObject, this.theScopeChain);
        try {
            Object object;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                this.createVariable((String)object, ((String)object).hashCode());
            }
            object = new EcmaScriptEvaluateVisitor(this);
            eSValue = ((EcmaScriptEvaluateVisitor)object).evaluateFunction(aSTStatementList, evaluationSource);
            int n = ((EcmaScriptEvaluateVisitor)object).getCompletionCode();
            if (n != 0 && n != 1) {
                throw new EcmaScriptException("Unexpected " + ((EcmaScriptEvaluateVisitor)object).getCompletionCodeString() + " in function");
            }
            Object var11_13 = null;
            this.currentVariableObject = eSObject3;
            this.theScopeChain = scopeChain;
            this.currentThisObject = eSObject4;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.currentVariableObject = eSObject3;
            this.theScopeChain = scopeChain;
            this.currentThisObject = eSObject4;
            throw throwable;
        }
        return eSValue;
    }

    public ESValue evaluateWith(ASTStatement aSTStatement, ESObject eSObject, EvaluationSource evaluationSource) throws EcmaScriptException {
        ESValue eSValue = ESUndefined.theUndefined;
        this.theScopeChain = new ScopeChain(eSObject, this.theScopeChain);
        try {
            EcmaScriptEvaluateVisitor ecmaScriptEvaluateVisitor = new EcmaScriptEvaluateVisitor(this);
            eSValue = ecmaScriptEvaluateVisitor.evaluateWith(aSTStatement, evaluationSource);
        }
        finally {
            Object var6_6 = null;
            this.theScopeChain = this.theScopeChain.previousScope();
        }
        return eSValue;
    }

    public ESValue evaluate(ParsedProgram parsedProgram, ESObject eSObject, boolean bl) throws EcmaScriptException {
        ASTProgram aSTProgram = parsedProgram.getProgramNode();
        ESValue eSValue = ESUndefined.theUndefined;
        ESObject eSObject2 = this.currentVariableObject;
        ESObject eSObject3 = this.currentThisObject;
        ScopeChain scopeChain = this.theScopeChain;
        this.theScopeChain = new ScopeChain(this.globalObject, null);
        this.currentVariableObject = this.globalObject;
        this.currentThisObject = eSObject != null ? eSObject : this.globalObject;
        EcmaScriptEvaluateVisitor ecmaScriptEvaluateVisitor = new EcmaScriptEvaluateVisitor(this);
        try {
            this.functionDeclarationVisitor.processFunctionDeclarations(aSTProgram, parsedProgram.getEvaluationSource());
            Vector vector = parsedProgram.getVariableNames();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.createVariable(string, string.hashCode());
            }
            eSValue = ecmaScriptEvaluateVisitor.evaluateProgram(aSTProgram, parsedProgram.getEvaluationSource());
        }
        finally {
            Object var11_13 = null;
            this.currentVariableObject = eSObject2;
            this.theScopeChain = scopeChain;
            this.currentThisObject = eSObject3;
        }
        int n = ecmaScriptEvaluateVisitor.getCompletionCode();
        if (n != 0) {
            if (n != 1) {
                throw new EcmaScriptException("Unexpected " + ecmaScriptEvaluateVisitor.getCompletionCodeString() + " in main program");
            }
            if (!bl) {
                throw new EcmaScriptException("Return is not accepted in main program with the 'eval' interface");
            }
        }
        return eSValue;
    }

    public synchronized void evaluateEvent(ESWrapper eSWrapper, ESObject eSObject, Object[] objectArray) throws EcmaScriptException {
        ESValue[] eSValueArray = new ESValue[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            eSValueArray[n] = ESLoader.normalizeValue(objectArray[n], this);
            ++n;
        }
        eSObject.callFunction(eSWrapper, eSValueArray);
    }

    public synchronized ESValue evaluate(Reader reader, ESObject eSObject, EvaluationSource evaluationSource, boolean bl) throws EcmaScriptException {
        ESValue eSValue = ESUndefined.theUndefined;
        EcmaScript ecmaScript = new EcmaScript(reader);
        ASTProgram aSTProgram = null;
        try {
            aSTProgram = (ASTProgram)ecmaScript.Program();
            if (this.debugParse) {
                System.out.println();
                System.out.println("@@ Dumping parse tree (debugParse true)");
                aSTProgram.dump("");
            }
        }
        catch (ParseException parseException) {
            if (this.debugParse) {
                System.out.println("[[PARSING ERROR DETECTED: (debugParse true)]]");
                System.out.println(parseException.getMessage());
                System.out.println("[[BY ROUTINE:]]");
                parseException.printStackTrace();
                System.out.println();
            }
            throw new EcmaScriptParseException(parseException, evaluationSource);
        }
        catch (TokenMgrError tokenMgrError) {
            if (this.debugParse) {
                System.out.println("[[LEXICAL ERROR DETECTED: (debugParse true)]]");
                System.out.println(tokenMgrError.getMessage());
                System.out.println("[[BY ROUTINE:]]");
                tokenMgrError.printStackTrace();
                System.out.println();
            }
            throw new EcmaScriptLexicalException(tokenMgrError, evaluationSource);
        }
        Vector vector = this.varDeclarationVisitor.processVariableDeclarations(aSTProgram, evaluationSource);
        ParsedProgram parsedProgram = new ParsedProgram(aSTProgram, vector, evaluationSource);
        eSValue = this.evaluate(parsedProgram, eSObject, bl);
        return eSValue;
    }

    public synchronized ESValue evaluate(Reader reader, ESObject eSObject) throws EcmaScriptException {
        UserEvaluationSource userEvaluationSource = new UserEvaluationSource("<Anonymous stream>", null);
        return this.evaluate(reader, eSObject, userEvaluationSource, false);
    }

    public synchronized ESValue evaluate(Reader reader) throws EcmaScriptException {
        return this.evaluate(reader, null);
    }

    public synchronized ESValue evaluate(String string, String string2) throws EcmaScriptException {
        StringReader stringReader = null;
        ESValue eSValue = null;
        UserEvaluationSource userEvaluationSource = new UserEvaluationSource(string2, null);
        try {
            stringReader = new StringReader(string);
            eSValue = this.evaluate(stringReader, this.globalObject, userEvaluationSource, false);
        }
        finally {
            Object var7_6 = null;
            if (stringReader != null) {
                stringReader.close();
            }
        }
        return eSValue;
    }

    public synchronized ESValue evaluate(File file) throws EcmaScriptException, IOException {
        return this.evaluate(file, null);
    }

    public synchronized ESValue evaluate(File file, ESObject eSObject) throws EcmaScriptException, IOException {
        FileEvaluationSource fileEvaluationSource = new FileEvaluationSource(file.getPath(), null);
        FileReader fileReader = null;
        ESValue eSValue = null;
        try {
            fileReader = new FileReader(file);
            eSValue = this.evaluate(fileReader, eSObject, fileEvaluationSource, false);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        Object var7_6 = null;
        if (fileReader != null) {
            try {
                fileReader.close();
            }
            catch (IOException iOException) {}
        }
        return eSValue;
    }

    public synchronized ESValue evaluate(String string) throws EcmaScriptException {
        return this.evaluate(string, null, false);
    }

    public synchronized ESValue evaluate(String string, ESObject eSObject, boolean bl) throws EcmaScriptException {
        StringReader stringReader = null;
        ESValue eSValue = null;
        StringEvaluationSource stringEvaluationSource = new StringEvaluationSource(string, null);
        try {
            stringReader = new StringReader(string);
            eSValue = this.evaluate(stringReader, eSObject, stringEvaluationSource, bl);
        }
        finally {
            Object var8_7 = null;
            if (stringReader != null) {
                stringReader.close();
            }
        }
        return eSValue;
    }
}

