/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;

public class ESReference {
    private ESObject base;
    private String propertyName;
    private int hash;

    public ESReference(ESValue eSValue, String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.base = (ESObject)eSValue;
        this.propertyName = string;
        this.hash = n;
    }

    public ESValue getBase() throws EcmaScriptException {
        return this.base;
    }

    public String getPropertyName() throws EcmaScriptException {
        return this.propertyName;
    }

    public ESValue getValue() throws EcmaScriptException {
        if (this.base == null) {
            throw new EcmaScriptException("global variable '" + this.propertyName + "' does not have a value");
        }
        return this.base.getProperty(this.propertyName, this.hash);
    }

    public void putValue(ESObject eSObject, ESValue eSValue) throws EcmaScriptException {
        if (this.base == null) {
            eSObject.putProperty(this.propertyName, eSValue, this.hash);
            return;
        }
        this.base.putProperty(this.propertyName, eSValue, this.hash);
    }

    public String toDetailString() {
        return "ES:*<" + (this.base == null ? "null" : this.base.toString()) + ":" + this.propertyName + ">";
    }

    public String toString() {
        return String.valueOf(this.base == null ? "" : "{" + this.base.toString() + "}.") + this.propertyName;
    }
}

