/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;

public final class XMLSerializer
extends BaseMarkupSerializer {
    public XMLSerializer() {
        this.setOutputFormat(null);
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
        try {
            this.setOutputByteStream(outputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
    }

    public void endElement(String string) {
        this.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this.printText("/>");
        } else {
            if (this._format.getIndenting() && !elementState.preserveSpace && elementState.afterElement) {
                this.breakLine();
            }
            this.printText("</" + string + ">");
        }
        elementState = this.leaveElementState();
        if (elementState != null) {
            elementState.afterElement = true;
            elementState.empty = false;
        } else {
            this.flush();
        }
    }

    protected String getEntityRef(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    protected void serializeElement(Element element) {
        boolean bl;
        String string = element.getTagName();
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string);
            }
            bl = this._format.getPreserveSpace();
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            bl = elementState.preserveSpace;
            if (this._format.getIndenting() && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this.breakLine();
            }
        }
        this.printText(String.valueOf('<') + string);
        this.indent();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string2 = attr.getName();
                String string3 = attr.getValue();
                if (string3 == null) {
                    string3 = "";
                }
                if (attr.getSpecified()) {
                    this.printSpace();
                    this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                }
                if (string2.equals("xml:space")) {
                    bl = string3.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++n;
            }
        }
        if (element.hasChildNodes()) {
            elementState = this.enterElementState(string, bl);
            elementState.cdata = this._format.isCDataElement(string);
            elementState.unescaped = this._format.isNonEscapingElement(string);
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            this.endElement(string);
        } else {
            this.unindent();
            this.printText("/>");
            if (elementState != null) {
                elementState.afterElement = true;
                elementState.empty = false;
            }
        }
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            super.setOutputFormat(new OutputFormat("xml", null, false));
        } else {
            super.setOutputFormat(outputFormat);
        }
    }

    public void startDocument() {
    }

    protected void startDocument(String string) {
        String string2 = this.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                if (this._format.getEncoding() != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(this._format.getEncoding());
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._format.getDoctypeSystem() == null && this._format.getDoctypePublic() == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this.printText(stringBuffer.toString());
                this.breakLine();
            }
            if (this._format.getDoctypeSystem() != null) {
                this.printText("<!DOCTYPE ");
                this.printText(string);
                if (this._format.getDoctypePublic() != null) {
                    this.printText(" PUBLIC ");
                    this.printDoctypeURL(this._format.getDoctypePublic());
                    if (this._format.getIndenting()) {
                        this.breakLine();
                        int n = 0;
                        while (n < 18 + string.length()) {
                            this.printText(" ");
                            ++n;
                        }
                    }
                    this.printDoctypeURL(this._format.getDoctypeSystem());
                } else {
                    this.printText(" SYSTEM ");
                    this.printDoctypeURL(this._format.getDoctypeSystem());
                }
                if (string2 != null && string2.length() > 0) {
                    this.printText(" [");
                    this.indent();
                    if (this._format.getIndenting()) {
                        this.breakLine();
                    }
                    this.printText(string2, true);
                    this.unindent();
                    this.printText("]");
                }
                this.printText(">");
                this.breakLine();
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    public void startElement(String string, AttributeList attributeList) {
        boolean bl;
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string);
            }
            bl = this._format.getPreserveSpace();
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            bl = elementState.preserveSpace;
            if (this._format.getIndenting() && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this.breakLine();
            }
        }
        this.printText(String.valueOf('<') + string);
        this.indent();
        if (attributeList != null) {
            int n = 0;
            while (n < attributeList.getLength()) {
                this.printSpace();
                String string2 = attributeList.getName(n);
                String string3 = attributeList.getValue(n);
                if (string3 == null) {
                    string3 = "";
                }
                this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                if (string2.equals("xml:space")) {
                    bl = string3.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++n;
            }
        }
        elementState = this.enterElementState(string, bl);
        elementState.cdata = this._format.isCDataElement(string);
        elementState.unescaped = this._format.isNonEscapingElement(string);
    }
}

