/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.xml.sax.AttributeList;

public final class TextSerializer
extends BaseMarkupSerializer {
    public TextSerializer() {
        this.setOutputFormat(null);
    }

    public TextSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
        try {
            this.setOutputByteStream(outputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public TextSerializer(Writer writer, OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
        this.setOutputCharStream(writer);
    }

    public TextSerializer(OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
    }

    protected void characters(String string, boolean bl, boolean bl2) {
        super.characters(string, false, true);
    }

    public void comment(String string) {
    }

    public void comment(char[] cArray, int n, int n2) {
    }

    protected ElementState content() {
        ElementState elementState = this.getElementState();
        if (elementState != null) {
            if (elementState.empty) {
                elementState.empty = false;
            }
            elementState.afterElement = false;
        }
        return elementState;
    }

    public void endElement(String string) {
        this.unindent();
        ElementState elementState = this.getElementState();
        elementState = this.leaveElementState();
        if (elementState != null) {
            elementState.afterElement = true;
            elementState.empty = false;
        } else {
            this.flush();
        }
    }

    protected String getEntityRef(char c) {
        return null;
    }

    public void processingInstruction(String string, String string2) {
    }

    protected void serializeElement(Element element) {
        boolean bl;
        String string = element.getTagName();
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string);
            }
            bl = this._format.getPreserveSpace();
        } else {
            bl = elementState.preserveSpace;
        }
        this.indent();
        if (element.hasChildNodes()) {
            elementState = this.enterElementState(string, bl);
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            this.endElement(string);
        } else {
            this.unindent();
            if (elementState != null) {
                elementState.afterElement = true;
                elementState.empty = false;
            }
        }
    }

    protected void serializeNode(Node node) {
        switch (node.getNodeType()) {
            case 3: {
                this.characters(node.getNodeValue(), false, true);
                break;
            }
            case 4: {
                this.characters(node.getNodeValue(), false, true);
                break;
            }
            case 1: {
                this.serializeElement((Element)node);
                break;
            }
            case 9: {
                DocumentType documentType = ((Document)node).getDoctype();
                if (documentType != null) {
                    int n;
                    this.startDTD(documentType.getName(), null, null);
                    NamedNodeMap namedNodeMap = documentType.getEntities();
                    if (namedNodeMap != null) {
                        n = 0;
                        while (n < namedNodeMap.getLength()) {
                            Entity entity = (Entity)namedNodeMap.item(n);
                            this.unparsedEntityDecl(entity.getNodeName(), entity.getPublicId(), entity.getSystemId(), entity.getNotationName());
                            ++n;
                        }
                    }
                    if ((namedNodeMap = documentType.getNotations()) != null) {
                        n = 0;
                        while (n < namedNodeMap.getLength()) {
                            Notation notation = (Notation)namedNodeMap.item(n);
                            this.notationDecl(notation.getNodeName(), notation.getPublicId(), notation.getSystemId());
                            ++n;
                        }
                    }
                    this.endDTD();
                }
            }
            case 11: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.serializeNode(node2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
        }
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            super.setOutputFormat(new OutputFormat("text", null, false));
        } else {
            super.setOutputFormat(outputFormat);
        }
    }

    public void startDocument() {
    }

    protected void startDocument(String string) {
        this.leaveDTD();
        this._started = true;
        this.serializePreRoot();
    }

    public void startElement(String string, AttributeList attributeList) {
        boolean bl;
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string);
            }
            bl = this._format.getPreserveSpace();
        } else {
            bl = elementState.preserveSpace;
        }
        this.indent();
        elementState = this.enterElementState(string, bl);
    }
}

