/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.SymbolCache;
import org.apache.xerces.utils.UTF8DataChunk;
import org.apache.xerces.utils.XMLCharacterProperties;

final class UTF8Reader
extends XMLEntityReader {
    private static final boolean USE_OUT_OF_LINE_LOAD_NEXT_BYTE = false;
    private static final boolean USE_TRY_CATCH_FOR_LOAD_NEXT_BYTE = true;
    public static final byte[] fgAsciiAttValueChar;
    public static final byte[] fgAsciiEntityValueChar;
    private char[] fCharacters = new char[16384];
    private int fCharDataLength = 0;
    private static final char[] cdata_string;
    private StringPool.CharArrayRange fCharArrayRange = null;
    private InputStream fInputStream = null;
    private StringPool fStringPool = null;
    private UTF8DataChunk fCurrentChunk = null;
    private int fCurrentIndex = 0;
    private byte[] fMostRecentData = null;
    private int fMostRecentByte = 0;
    private int fLength = 0;
    private boolean fCallClearPreviousChunk = true;

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 4;
        byArray[1] = 4;
        byArray[2] = 4;
        byArray[3] = 4;
        byArray[4] = 4;
        byArray[5] = 4;
        byArray[6] = 4;
        byArray[7] = 4;
        byArray[8] = 4;
        byArray[9] = 2;
        byArray[10] = 2;
        byArray[11] = 4;
        byArray[12] = 4;
        byArray[13] = 2;
        byArray[14] = 4;
        byArray[15] = 4;
        byArray[16] = 4;
        byArray[17] = 4;
        byArray[18] = 4;
        byArray[19] = 4;
        byArray[20] = 4;
        byArray[21] = 4;
        byArray[22] = 4;
        byArray[23] = 4;
        byArray[24] = 4;
        byArray[25] = 4;
        byArray[26] = 4;
        byArray[27] = 4;
        byArray[28] = 4;
        byArray[29] = 4;
        byArray[30] = 4;
        byArray[31] = 4;
        byArray[34] = 1;
        byArray[38] = 2;
        byArray[39] = 1;
        byArray[60] = 3;
        fgAsciiAttValueChar = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[0] = 7;
        byArray2[1] = 4;
        byArray2[2] = 4;
        byArray2[3] = 4;
        byArray2[4] = 4;
        byArray2[5] = 4;
        byArray2[6] = 4;
        byArray2[7] = 4;
        byArray2[8] = 4;
        byArray2[10] = 5;
        byArray2[11] = 4;
        byArray2[12] = 4;
        byArray2[13] = 6;
        byArray2[14] = 4;
        byArray2[15] = 4;
        byArray2[16] = 4;
        byArray2[17] = 4;
        byArray2[18] = 4;
        byArray2[19] = 4;
        byArray2[20] = 4;
        byArray2[21] = 4;
        byArray2[22] = 4;
        byArray2[23] = 4;
        byArray2[24] = 4;
        byArray2[25] = 4;
        byArray2[26] = 4;
        byArray2[27] = 4;
        byArray2[28] = 4;
        byArray2[29] = 4;
        byArray2[30] = 4;
        byArray2[31] = 4;
        byArray2[34] = 1;
        byArray2[37] = 3;
        byArray2[38] = 2;
        byArray2[39] = 1;
        fgAsciiEntityValueChar = byArray2;
        cdata_string = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    }

    public UTF8Reader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, InputStream inputStream, StringPool stringPool) throws Exception {
        super(xMLEntityHandler, xMLErrorReporter, bl);
        this.fInputStream = inputStream;
        this.fStringPool = stringPool;
        this.fCharArrayRange = this.fStringPool.createCharArrayRange();
        this.fCurrentChunk = UTF8DataChunk.createChunk(this.fStringPool, null);
        this.fillCurrentChunk();
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(n, n2);
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, 0);
    }

    private int addSymbol(int n, int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, n3);
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
        this.fCurrentChunk.append(charBuffer, n, n2);
    }

    private void appendCharData(int n) throws Exception {
        try {
            this.fCharacters[this.fCharDataLength] = (char)n;
            ++this.fCharDataLength;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.slowAppendCharData(n);
        }
    }

    private boolean atEOF(int n) {
        return n > this.fLength;
    }

    public XMLEntityHandler.EntityReader changeReaders() throws Exception {
        XMLEntityHandler.EntityReader entityReader = super.changeReaders();
        this.fCurrentChunk.releaseChunk();
        this.fCurrentChunk = null;
        this.fMostRecentData = null;
        this.fMostRecentByte = 0;
        return entityReader;
    }

    private void characters(int n, int n2) throws Exception {
        if (!this.fSendCharDataAsCharArray) {
            int n3 = this.addString(n, n2 - n);
            this.fEntityHandler.processCharacters(n3);
            return;
        }
        this.fEntityHandler.processCharacters(this.fCharacters, 0, this.fCharDataLength);
    }

    private int copyAsciiCharData() throws Exception {
        int n = this.fCurrentIndex;
        int n2 = this.fCurrentOffset - n;
        byte[] byArray = this.fMostRecentData;
        int n3 = this.fCharDataLength;
        boolean bl = false;
        while (true) {
            int n4;
            try {
                n4 = byArray[n] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n2 += n;
                this.slowLoadNextByte();
                n = 0;
                byArray = this.fMostRecentData;
                n4 = byArray[n] & 0xFF;
            }
            if (n4 >= 128) {
                this.fCurrentOffset = n2 + n;
                this.fCurrentIndex = n;
                this.fMostRecentByte = n4;
                return n4;
            }
            if (XMLCharacterProperties.fgAsciiCharData[n4] == 0) {
                ++this.fCharacterCounter;
                bl = false;
            } else if (n4 == 10) {
                ++this.fLinefeedCounter;
                if (bl) {
                    bl = false;
                    ++n;
                    continue;
                }
                this.fCharacterCounter = 1;
            } else if (n4 == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                bl = true;
                n4 = 10;
            } else {
                this.fCurrentOffset = n2 + n;
                this.fCurrentIndex = n;
                this.fMostRecentByte = n4;
                return n4;
            }
            ++n;
            try {
                this.fCharacters[this.fCharDataLength] = (char)n4;
                ++this.fCharDataLength;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.slowAppendCharData(n4);
                continue;
            }
            break;
        }
    }

    private boolean copyMultiByteCharData(int n) throws Exception {
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n2 = this.fCurrentOffset;
        int n3 = this.fCurrentIndex;
        int n4 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            int n5 = ((0x1F & n) << 6) + (0x3F & n4);
            this.appendCharData(n5);
            this.loadNextByte();
            return true;
        }
        int n6 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            if (n == 237 && n4 >= 160 || n == 239 && n4 == 191 && n6 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n3;
                this.fCurrentOffset = n2;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            int n7 = ((0xF & n) << 12) + ((0x3F & n4) << 6) + (0x3F & n6);
            this.appendCharData(n7);
            this.loadNextByte();
            return true;
        }
        int n8 = this.loadNextByte();
        if (n > 244 || n == 244 && n4 >= 144) {
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n3;
            this.fCurrentOffset = n2;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return false;
        }
        int n9 = ((0xF & n) << 18) + ((0x3F & n4) << 12) + ((0x3F & n6) << 6) + (0x3F & n8);
        if (n9 < 65536) {
            this.appendCharData(n9);
        } else {
            this.appendCharData((n9 - 65536 >> 10) + 55296);
            this.appendCharData((n9 - 65536 & 0x3FF) + 56320);
        }
        this.loadNextByte();
        return true;
    }

    private int fillCurrentChunk() throws Exception {
        byte[] byArray = this.fCurrentChunk.toByteArray();
        if (this.fInputStream == null) {
            if (byArray == null) {
                byArray = new byte[]{0};
            }
            this.fMostRecentData = byArray;
            this.fCurrentIndex = 0;
            this.fCurrentChunk.setByteArray(this.fMostRecentData);
            this.fMostRecentByte = this.fMostRecentData[0] & 0xFF;
            return this.fMostRecentByte;
        }
        if (byArray == null) {
            byArray = new byte[16384];
        }
        int n = 0;
        int n2 = 16384;
        int n3 = 0;
        do {
            try {
                n3 = this.fInputStream.read(byArray, n, n2);
            }
            catch (IOException iOException) {
                n3 = -1;
            }
            if (n3 == -1) {
                this.fInputStream.close();
                this.fInputStream = null;
                try {
                    byArray[n] = 0;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                break;
            }
            if (n3 <= 0) continue;
            n += n3;
            n2 -= n3;
        } while (n2 > 0);
        this.fMostRecentData = byArray;
        this.fLength += n;
        this.fCurrentIndex = 0;
        this.fCurrentChunk.setByteArray(this.fMostRecentData);
        this.fMostRecentByte = this.fMostRecentData[0] & 0xFF;
        return this.fMostRecentByte;
    }

    private int getMultiByteSymbolChar(int n) throws Exception {
        int n2;
        int n3;
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n4 = this.fCurrentIndex++;
        int n5 = this.fCurrentOffset++;
        try {
            n3 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n3 = this.slowLoadNextByte();
        }
        if ((0xE0 & n) == 192) {
            int n6 = ((0x1F & n) << 6) + (0x3F & n3);
            if ((XMLCharacterProperties.fgCharFlags[n6] & 4) == 0) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n5;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return -1;
            }
            this.loadNextByte();
            return n6;
        }
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            n2 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n2 = this.slowLoadNextByte();
        }
        if ((0xF0 & n) == 224) {
            if (n == 237 && n3 >= 160 || n == 239 && n3 == 191 && n2 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n5;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return -1;
            }
            int n7 = ((0xF & n) << 12) + ((0x3F & n3) << 6) + (0x3F & n2);
            if ((XMLCharacterProperties.fgCharFlags[n7] & 4) == 0) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n5;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return -1;
            }
            this.loadNextByte();
            return n7;
        }
        this.fCurrentChunk = uTF8DataChunk;
        this.fCurrentIndex = n4;
        this.fCurrentOffset = n5;
        this.fMostRecentData = uTF8DataChunk.toByteArray();
        this.fMostRecentByte = n;
        return -1;
    }

    private int loadNextByte() throws Exception {
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            return this.fMostRecentByte;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.slowLoadNextByte();
        }
    }

    public boolean lookingAtChar(char c, boolean bl) throws Exception {
        block12: {
            int n = this.fMostRecentByte;
            if (n != c) {
                if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    return this.changeReaders().lookingAtChar(c, bl);
                }
                if (c == '\n' && n == 13) {
                    if (bl) {
                        ++this.fCarriageReturnCounter;
                        this.fCharacterCounter = 1;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n = this.slowLoadNextByte();
                        }
                        if (n == 10) {
                            ++this.fLinefeedCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                this.slowLoadNextByte();
                            }
                        }
                    }
                    return true;
                }
                return false;
            }
            if (c == '\r') {
                return false;
            }
            if (!bl) break block12;
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.slowLoadNextByte();
            }
        }
        return true;
    }

    public boolean lookingAtSpace(boolean bl) throws Exception {
        int n = this.fMostRecentByte;
        if (n > 32) {
            return false;
        }
        if (n == 32 || n == 9) {
            if (!bl) {
                return true;
            }
            ++this.fCharacterCounter;
        } else if (n == 10) {
            if (!bl) {
                return true;
            }
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (n == 13) {
            if (!bl) {
                return true;
            }
            ++this.fCarriageReturnCounter;
            this.fCharacterCounter = 1;
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n = this.slowLoadNextByte();
            }
            if (n != 10) {
                return true;
            }
            ++this.fLinefeedCounter;
        } else {
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtSpace(bl);
            }
            return false;
        }
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.slowLoadNextByte();
        }
        return true;
    }

    public boolean lookingAtValidChar(boolean bl) throws Exception {
        int n = this.fMostRecentByte;
        if (n < 128) {
            if (n >= 32 || n == 9) {
                if (bl) {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.slowLoadNextByte();
                    }
                }
                return true;
            }
            if (n == 10) {
                if (bl) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.slowLoadNextByte();
                    }
                }
                return true;
            }
            if (n == 13) {
                if (bl) {
                    ++this.fCarriageReturnCounter;
                    this.fCharacterCounter = 1;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n = this.slowLoadNextByte();
                    }
                    if (n == 10) {
                        ++this.fLinefeedCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            this.slowLoadNextByte();
                        }
                    }
                }
                return true;
            }
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtValidChar(bl);
            }
            return false;
        }
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n2 = this.fCurrentIndex;
        int n3 = this.fCurrentOffset;
        int n4 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            if (bl) {
                ++this.fCharacterCounter;
                this.loadNextByte();
            } else {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n2;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
            }
            return true;
        }
        int n5 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            boolean bl2 = false;
            if (!(n == 237 && n4 >= 160 || n == 239 && n4 == 191 && n5 >= 190)) {
                if (bl) {
                    ++this.fCharacterCounter;
                    this.loadNextByte();
                    return true;
                }
                bl2 = true;
            }
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n2;
            this.fCurrentOffset = n3;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return bl2;
        }
        int n6 = this.loadNextByte();
        boolean bl3 = false;
        if (n <= 244 && (n != 244 || n4 < 144)) {
            if (bl) {
                ++this.fCharacterCounter;
                this.loadNextByte();
                return true;
            }
            bl3 = true;
        }
        this.fCurrentChunk = uTF8DataChunk;
        this.fCurrentIndex = n2;
        this.fCurrentOffset = n3;
        this.fMostRecentData = uTF8DataChunk.toByteArray();
        this.fMostRecentByte = n;
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int recognizeMarkup(int n, int n2) throws Exception {
        switch (n) {
            case 0: {
                return 11;
            }
            case 63: {
                ++this.fCharacterCounter;
                this.loadNextByte();
                return 0;
            }
            case 33: {
                ++this.fCharacterCounter;
                n = this.loadNextByte();
                if (n == 0) {
                    --this.fCharacterCounter;
                    --this.fCurrentOffset;
                    return 11;
                }
                if (n == 45) {
                    ++this.fCharacterCounter;
                    n = this.loadNextByte();
                    if (n == 0) {
                        this.fCharacterCounter -= 2;
                        this.fCurrentOffset -= 2;
                        return 11;
                    }
                    if (n != 45) return 10;
                    ++this.fCharacterCounter;
                    n = this.loadNextByte();
                    return 1;
                }
                if (n != 91) return 10;
                int n3 = 0;
                while (true) {
                    if (n3 >= 6) {
                        ++this.fCharacterCounter;
                        this.loadNextByte();
                        return 2;
                    }
                    ++this.fCharacterCounter;
                    n = this.loadNextByte();
                    if (n == 0) {
                        this.fCharacterCounter -= 2 + n3;
                        this.fCurrentOffset -= 2 + n3;
                        return 11;
                    }
                    if (n != cdata_string[n3]) {
                        return 10;
                    }
                    ++n3;
                }
            }
            case 47: {
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n = this.slowLoadNextByte();
                }
                int n4 = n2;
                this.fStringPool.getCharArrayRange(n4, this.fCharArrayRange);
                char[] cArray = this.fCharArrayRange.chars;
                int n5 = this.fCharArrayRange.offset;
                int n6 = this.fCharArrayRange.length;
                if (n != cArray[n5++]) return 4;
                UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
                int n7 = this.fCurrentIndex;
                int n8 = this.fCurrentOffset;
                int n9 = 1;
                while (true) {
                    if (n9 >= n6) {
                        this.fCharacterCounter += n6;
                        ++this.fCharacterCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n = this.slowLoadNextByte();
                        }
                        break;
                    }
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n = this.slowLoadNextByte();
                    }
                    if (n != cArray[n5++]) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n7;
                        this.fCurrentOffset = n8;
                        this.fMostRecentData = this.fCurrentChunk.toByteArray();
                        this.fMostRecentByte = this.fMostRecentData[n7] & 0xFF;
                        return 4;
                    }
                    ++n9;
                }
                if (n == 62) {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        return 5;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.slowLoadNextByte();
                    }
                    return 5;
                }
                do {
                    if (n != 32 && n != 9 && n != 10 && n != 13) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n7;
                        this.fCurrentOffset = n8;
                        this.fMostRecentData = this.fCurrentChunk.toByteArray();
                        this.fMostRecentByte = this.fMostRecentData[n7] & 0xFF;
                        return 4;
                    }
                    if (n == 10) {
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                        n = this.loadNextByte();
                        continue;
                    }
                    if (n == 13) {
                        ++this.fCarriageReturnCounter;
                        this.fCharacterCounter = 1;
                        n = this.loadNextByte();
                        if (n != 10) continue;
                        ++this.fLinefeedCounter;
                        n = this.loadNextByte();
                        continue;
                    }
                    ++this.fCharacterCounter;
                    n = this.loadNextByte();
                } while (n != 62);
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    return 5;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.slowLoadNextByte();
                }
                return 5;
            }
        }
        return 6;
    }

    private int recognizeReference(int n) throws Exception {
        if (n == 0) {
            return 12;
        }
        if (n == 35) {
            ++this.fCharacterCounter;
            this.loadNextByte();
            return 7;
        }
        return 8;
    }

    public int scanAttValue(char c, boolean bl) throws Exception {
        int n = this.fCurrentOffset;
        int n2 = this.fMostRecentByte;
        block11: while (true) {
            if (n2 < 128) {
                switch (fgAsciiAttValueChar[n2]) {
                    default: {
                        continue block11;
                    }
                    case 1: {
                        if (n2 == c) {
                            int n3 = this.fCurrentOffset - n;
                            int n4 = n3 == 0 ? 0 : (bl ? this.fCurrentChunk.addSymbol(n, n3, 0) : this.fCurrentChunk.addString(n, n3));
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                this.slowLoadNextByte();
                            }
                            return n4;
                        }
                    }
                    case 0: {
                        ++this.fCharacterCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n2 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n2 = this.slowLoadNextByte();
                        }
                        continue block11;
                    }
                    case 2: {
                        return -1;
                    }
                    case 3: {
                        return -2;
                    }
                    case 4: 
                }
                return -3;
            }
            if (!this.skipMultiByteCharData(n2)) {
                return -3;
            }
            n2 = this.fMostRecentByte;
        }
    }

    public int scanCharRef(boolean bl) throws Exception {
        int n = this.fMostRecentByte;
        if (n == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanCharRef(bl);
            }
            return -2;
        }
        int n2 = 0;
        if (bl) {
            if (n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0) {
                return -2;
            }
            n2 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
        } else {
            if (n < 48 || n > 57) {
                return -2;
            }
            n2 = n - 48;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        boolean bl2 = false;
        while ((n = this.fMostRecentByte) != 0 && !(bl ? n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0 : n < 48 || n > 57)) {
            int n3;
            ++this.fCharacterCounter;
            this.loadNextByte();
            if (bl) {
                n3 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
                n2 = (n2 << 4) + n3;
            } else {
                n3 = n - 48;
                n2 = n2 * 10 + n3;
            }
            if (n2 <= 0x10FFFF) continue;
            bl2 = true;
            n2 = 0;
        }
        if (n != 59) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        if (bl2) {
            return -3;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    public int scanContent(int var1_1) throws Exception {
        block97: {
            if (this.fCallClearPreviousChunk && this.fCurrentChunk.clearPreviousChunk()) {
                this.fCallClearPreviousChunk = false;
            }
            this.fCharDataLength = 0;
            var2_2 = this.fCurrentOffset++;
            var3_3 = this.fMostRecentByte;
            if (var3_3 >= 128) break block97;
            switch (XMLCharacterProperties.fgAsciiWSCharData[var3_3]) {
                case 0: {
                    if (this.fSendCharDataAsCharArray) {
                        try {
                            this.fCharacters[this.fCharDataLength] = (char)var3_3;
                            ++this.fCharDataLength;
                        }
                        catch (ArrayIndexOutOfBoundsException v0) {
                            this.slowAppendCharData(var3_3);
                        }
                    }
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        var3_3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                    }
                    catch (ArrayIndexOutOfBoundsException v1) {
                        var3_3 = this.slowLoadNextByte();
                    }
                    ** GOTO lbl217
                }
                case 1: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentIndex;
                    try {
                        var3_3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                    }
                    catch (ArrayIndexOutOfBoundsException v2) {
                        var3_3 = this.slowLoadNextByte();
                    }
                    if (!this.fInCDSect) {
                        return this.recognizeMarkup(var3_3, var1_1);
                    }
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(60);
                    }
                    ** GOTO lbl217
                }
                case 2: {
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextByte();
                    if (!this.fInCDSect) {
                        return this.recognizeReference(var3_3);
                    }
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(38);
                    }
                    ** GOTO lbl217
                }
                case 3: {
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextByte();
                    if (var3_3 == 93) ** GOTO lbl53
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(93);
                    }
                    ** GOTO lbl217
lbl53:
                    // 1 sources

                    if (this.fCurrentIndex + 1 != 16384) ** GOTO lbl66
                    var4_4 = this.fCurrentChunk;
                    var5_9 = this.fCurrentIndex;
                    var6_12 = this.fCurrentOffset;
                    if (this.loadNextByte() == 62) ** GOTO lbl72
                    this.fCurrentChunk = var4_4;
                    this.fCurrentIndex = var5_9;
                    this.fCurrentOffset = var6_12;
                    this.fMostRecentData = this.fCurrentChunk.toByteArray();
                    this.fMostRecentByte = 93;
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(93);
                    }
                    ** GOTO lbl217
lbl66:
                    // 1 sources

                    if (this.fMostRecentData[this.fCurrentIndex + 1] == 62) ** GOTO lbl70
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(93);
                    }
                    ** GOTO lbl217
lbl70:
                    // 1 sources

                    ++this.fCurrentIndex;
                    ++this.fCurrentOffset;
lbl72:
                    // 2 sources

                    this.loadNextByte();
                    this.fCharacterCounter += 2;
                    return 3;
                }
                case 4: {
                    if (var3_3 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                        this.changeReaders();
                        return 9;
                    }
                    return 9;
                }
                case 5: {
                    do {
                        if (var3_3 == 10) {
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                        } else if (var3_3 == 13) {
                            ++this.fCarriageReturnCounter;
                            this.fCharacterCounter = 1;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                var3_3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            catch (ArrayIndexOutOfBoundsException v3) {
                                var3_3 = this.slowLoadNextByte();
                            }
                            if (var3_3 != 10) {
                                if (this.fSendCharDataAsCharArray) {
                                    this.appendCharData(10);
                                }
                                if (var3_3 != 32 && var3_3 != 9 && var3_3 != 13) break;
                                continue;
                            }
                            ++this.fLinefeedCounter;
                        } else {
                            ++this.fCharacterCounter;
                        }
                        if (this.fSendCharDataAsCharArray) {
                            try {
                                this.fCharacters[this.fCharDataLength] = (char)var3_3;
                                ++this.fCharDataLength;
                            }
                            catch (ArrayIndexOutOfBoundsException v4) {
                                this.slowAppendCharData(var3_3);
                            }
                        }
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            var3_3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                        }
                        catch (ArrayIndexOutOfBoundsException v5) {
                            var3_3 = this.slowLoadNextByte();
                        }
                    } while (var3_3 == 32 || var3_3 == 9 || var3_3 == 10 || var3_3 == 13);
                    if (var3_3 >= 128) ** GOTO lbl203
                    switch (XMLCharacterProperties.fgAsciiCharData[var3_3]) {
                        case 0: {
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(var3_3);
                            }
                            ++this.fCharacterCounter;
                            var3_3 = this.loadNextByte();
                            ** GOTO lbl217
                        }
                        case 1: {
                            if (!this.fInCDSect) {
                                if (this.fSendCharDataAsCharArray) {
                                    this.fEntityHandler.processWhitespace(this.fCharacters, 0, this.fCharDataLength);
                                } else {
                                    var4_5 = this.addString(var2_2, this.fCurrentOffset - var2_2);
                                    this.fEntityHandler.processWhitespace(var4_5);
                                }
                                ++this.fCharacterCounter;
                                ++this.fCurrentOffset;
                                ++this.fCurrentIndex;
                                try {
                                    var3_3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                                }
                                catch (ArrayIndexOutOfBoundsException v6) {
                                    var3_3 = this.slowLoadNextByte();
                                }
                                return this.recognizeMarkup(var3_3, var1_1);
                            }
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(60);
                            }
                            ++this.fCharacterCounter;
                            var3_3 = this.loadNextByte();
                            ** GOTO lbl217
                        }
                        case 2: {
                            if (!this.fInCDSect) {
                                this.whitespace(var2_2, this.fCurrentOffset);
                                ++this.fCharacterCounter;
                                var3_3 = this.loadNextByte();
                                return this.recognizeReference(var3_3);
                            }
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(38);
                            }
                            ++this.fCharacterCounter;
                            var3_3 = this.loadNextByte();
                            ** GOTO lbl217
                        }
                        case 3: {
                            var4_6 = this.fCurrentOffset++;
                            var3_3 = this.loadNextByte();
                            if (var3_3 == 93) ** GOTO lbl169
                            ++this.fCharacterCounter;
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(93);
                            }
                            ** GOTO lbl217
lbl169:
                            // 1 sources

                            if (this.fCurrentIndex + 1 != 16384) ** GOTO lbl183
                            var5_10 = this.fCurrentChunk;
                            var6_12 = this.fCurrentIndex;
                            var7_13 = this.fCurrentOffset;
                            if (this.loadNextByte() == 62) ** GOTO lbl189
                            this.fCurrentChunk = var5_10;
                            this.fCurrentIndex = var6_12;
                            this.fCurrentOffset = var7_13;
                            this.fMostRecentData = this.fCurrentChunk.toByteArray();
                            this.fMostRecentByte = 93;
                            ++this.fCharacterCounter;
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(93);
                            }
                            ** GOTO lbl217
lbl183:
                            // 1 sources

                            if (this.fMostRecentData[this.fCurrentIndex + 1] == 62) ** GOTO lbl188
                            ++this.fCharacterCounter;
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(93);
                            }
                            ** GOTO lbl217
lbl188:
                            // 1 sources

                            ++this.fCurrentIndex;
lbl189:
                            // 2 sources

                            this.loadNextByte();
                            this.whitespace(var2_2, var4_6);
                            this.fCharacterCounter += 3;
                            return 3;
                        }
                        case 4: {
                            this.whitespace(var2_2, this.fCurrentOffset);
                            if (var3_3 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                                this.changeReaders();
                                return 9;
                            }
                            return 9;
                        }
                        default: {
                            ** if (!this.fSendCharDataAsCharArray) goto lbl-1000
                        }
                    }
lbl203:
                    // 1 sources

                    if (this.fSendCharDataAsCharArray) {
                        if (!this.copyMultiByteCharData(var3_3)) {
                            this.whitespace(var2_2, this.fCurrentOffset);
                            return 9;
                        }
                    } else if (!this.skipMultiByteCharData(var3_3)) {
                        this.whitespace(var2_2, this.fCurrentOffset);
                        return 9;
                    }
                    ** GOTO lbl217
                }
                default: {
                    ** if (!this.fSendCharDataAsCharArray) goto lbl-1000
                }
            }
        }
        if (this.fSendCharDataAsCharArray != false ? this.copyMultiByteCharData(var3_3) == false : this.skipMultiByteCharData(var3_3) == false) {
            return 9;
        }
lbl217:
        // 17 sources

        if (this.fSendCharDataAsCharArray) lbl-1000:
        // 3 sources

        {
            var3_3 = this.copyAsciiCharData();
        } else lbl-1000:
        // 3 sources

        {
            var3_3 = this.skipAsciiCharData();
        }
        block39: while (true) {
            if (var3_3 < 128) {
                switch (XMLCharacterProperties.fgAsciiCharData[var3_3]) {
                    default: {
                        continue block39;
                    }
                    case 0: {
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(var3_3);
                        }
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextByte();
                        continue block39;
                    }
                    case 1: {
                        if (!this.fInCDSect) {
                            if (this.fSendCharDataAsCharArray) {
                                this.fEntityHandler.processCharacters(this.fCharacters, 0, this.fCharDataLength);
                            } else {
                                var4_7 = this.addString(var2_2, this.fCurrentOffset - var2_2);
                                this.fEntityHandler.processCharacters(var4_7);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                var3_3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            catch (ArrayIndexOutOfBoundsException v7) {
                                var3_3 = this.slowLoadNextByte();
                            }
                            return this.recognizeMarkup(var3_3, var1_1);
                        }
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(60);
                        }
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextByte();
                        continue block39;
                    }
                    case 2: {
                        if (!this.fInCDSect) {
                            this.characters(var2_2, this.fCurrentOffset);
                            ++this.fCharacterCounter;
                            var3_3 = this.loadNextByte();
                            return this.recognizeReference(var3_3);
                        }
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(38);
                        }
                        ++this.fCharacterCounter;
                        var3_3 = this.loadNextByte();
                        continue block39;
                    }
                    case 3: {
                        var4_8 = this.fCurrentOffset++;
                        var3_3 = this.loadNextByte();
                        if (var3_3 != 93) {
                            ++this.fCharacterCounter;
                            if (!this.fSendCharDataAsCharArray) continue block39;
                            this.appendCharData(93);
                            continue block39;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            var5_11 = this.fCurrentChunk;
                            var6_12 = this.fCurrentIndex;
                            var7_13 = this.fCurrentOffset;
                            if (this.loadNextByte() != 62) {
                                this.fCurrentChunk = var5_11;
                                this.fCurrentIndex = var6_12;
                                this.fCurrentOffset = var7_13;
                                this.fMostRecentData = this.fCurrentChunk.toByteArray();
                                this.fMostRecentByte = 93;
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) continue block39;
                                this.appendCharData(93);
                                continue block39;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != 62) {
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) continue block39;
                                this.appendCharData(93);
                                continue block39;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextByte();
                        this.characters(var2_2, var4_8);
                        this.fCharacterCounter += 3;
                        return 3;
                    }
                    case 4: 
                }
                if (var3_3 == 10) {
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(var3_3);
                    }
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    var3_3 = this.loadNextByte();
                    continue;
                }
                if (var3_3 == 13) {
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(10);
                    }
                    ++this.fCarriageReturnCounter;
                    this.fCharacterCounter = 1;
                    var3_3 = this.loadNextByte();
                    if (var3_3 != 10) continue;
                    ++this.fLinefeedCounter;
                    var3_3 = this.loadNextByte();
                    continue;
                }
                this.characters(var2_2, this.fCurrentOffset);
                if (var3_3 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders();
                    return 9;
                }
                return 9;
            }
            if (this.fSendCharDataAsCharArray) {
                if (!this.copyMultiByteCharData(var3_3)) {
                    this.characters(var2_2, this.fCurrentOffset);
                    return 9;
                }
            } else if (!this.skipMultiByteCharData(var3_3)) {
                this.characters(var2_2, this.fCurrentOffset);
                return 9;
            }
            var3_3 = this.fMostRecentByte;
        }
    }

    public int scanEntityValue(int n, boolean bl) throws Exception {
        int n2 = this.fCurrentOffset;
        int n3 = this.fMostRecentByte;
        block20: while (true) {
            if (n3 < 128) {
                switch (fgAsciiEntityValueChar[n3]) {
                    default: {
                        continue block20;
                    }
                    case 1: {
                        if (n3 == n) {
                            if (!bl) {
                                return -1;
                            }
                            int n4 = this.fCurrentOffset - n2;
                            int n5 = n4 == 0 ? 0 : this.fCurrentChunk.addString(n2, n4);
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                this.slowLoadNextByte();
                            }
                            return n5;
                        }
                    }
                    case 0: {
                        ++this.fCharacterCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n3 = this.slowLoadNextByte();
                        }
                        continue block20;
                    }
                    case 5: {
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n3 = this.slowLoadNextByte();
                        }
                        continue block20;
                    }
                    case 6: {
                        ++this.fCarriageReturnCounter;
                        this.fCharacterCounter = 1;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n3 = this.slowLoadNextByte();
                        }
                        if (n3 != 10) continue block20;
                        ++this.fLinefeedCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n3 = this.slowLoadNextByte();
                        }
                        continue block20;
                    }
                    case 2: {
                        return -2;
                    }
                    case 3: {
                        return -3;
                    }
                    case 7: {
                        if (!this.atEOF(this.fCurrentOffset + 1)) break;
                        this.changeReaders();
                        return -5;
                    }
                    case 4: 
                }
                return -4;
            }
            if (!this.skipMultiByteCharData(n3)) {
                return -4;
            }
            n3 = this.fMostRecentByte;
        }
    }

    public boolean scanExpectedName(char c, StringPool.CharArrayRange charArrayRange) throws Exception {
        char[] cArray = charArrayRange.chars;
        int n = charArrayRange.offset;
        int n2 = charArrayRange.length;
        int n3 = this.fMostRecentByte;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (n3 < 128) {
                n4 = n3;
                if (n5 == n2) break;
                if (n4 != cArray[n]) {
                    this.skipPastNmtoken(c);
                    return false;
                }
            } else {
                int n6;
                UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
                int n7 = this.fCurrentIndex++;
                int n8 = this.fCurrentOffset++;
                try {
                    n6 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n6 = this.slowLoadNextByte();
                }
                if ((0xE0 & n3) == 192) {
                    n4 = ((0x1F & n3) << 6) + (0x3F & n6);
                    if (n5 == n2) break;
                    if (n4 != cArray[n]) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n7;
                        this.fCurrentOffset = n8;
                        this.fMostRecentData = uTF8DataChunk.toByteArray();
                        this.fMostRecentByte = n3;
                        this.skipPastNmtoken(c);
                        return false;
                    }
                } else {
                    int n9;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        n9 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n9 = this.slowLoadNextByte();
                    }
                    if ((0xF0 & n3) == 224) {
                        if (n3 == 237 && n6 >= 160 || n3 == 239 && n6 == 191 && n9 >= 190) {
                            this.fCurrentChunk = uTF8DataChunk;
                            this.fCurrentIndex = n7;
                            this.fCurrentOffset = n8;
                            this.fMostRecentData = uTF8DataChunk.toByteArray();
                            this.fMostRecentByte = n3;
                            return false;
                        }
                        n4 = ((0xF & n3) << 12) + ((0x3F & n6) << 6) + (0x3F & n9);
                        if (n5 == n2) break;
                        if (n4 != cArray[n]) {
                            this.fCurrentChunk = uTF8DataChunk;
                            this.fCurrentIndex = n7;
                            this.fCurrentOffset = n8;
                            this.fMostRecentData = uTF8DataChunk.toByteArray();
                            this.fMostRecentByte = n3;
                            this.skipPastNmtoken(c);
                            return false;
                        }
                    } else {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n7;
                        this.fCurrentOffset = n8;
                        this.fMostRecentData = uTF8DataChunk.toByteArray();
                        this.fMostRecentByte = n3;
                        return false;
                    }
                }
            }
            ++n5;
            ++n;
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                n3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n3 = this.slowLoadNextByte();
            }
        }
        if (n4 == c) {
            return true;
        }
        if (n4 < 128 ? XMLCharacterProperties.fgAsciiNameChar[n4] == 0 : (XMLCharacterProperties.fgCharFlags[n4] & 4) == 0) {
            return true;
        }
        this.skipPastNmtoken(c);
        return false;
    }

    public int scanInvalidChar() throws Exception {
        int n = this.fMostRecentByte;
        int n2 = n;
        if (n2 == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (n2 == 13) {
            ++this.fCarriageReturnCounter;
            this.fCharacterCounter = 1;
            n2 = this.loadNextByte();
            if (n2 != 10) {
                return 10;
            }
            ++this.fLinefeedCounter;
        } else if (n2 == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanInvalidChar();
            }
            ++this.fCharacterCounter;
        } else if (n >= 128) {
            ++this.fCharacterCounter;
            int n3 = this.loadNextByte();
            if ((0xE0 & n) == 192) {
                n2 = ((0x1F & n) << 6) + (0x3F & n3);
            } else {
                int n4 = this.loadNextByte();
                if ((0xF0 & n) == 224) {
                    n2 = ((0xF & n) << 12) + ((0x3F & n3) << 6) + (0x3F & n4);
                } else {
                    int n5 = this.loadNextByte();
                    n2 = ((0xF & n) << 18) + ((0x3F & n3) << 12) + ((0x3F & n4) << 6) + (0x3F & n5);
                }
            }
        }
        this.loadNextByte();
        return n2;
    }

    private int scanMatchingName(int n, int n2, int n3) throws Exception {
        int n4;
        SymbolCache symbolCache = this.fStringPool.getSymbolCache();
        int[][] nArray = symbolCache.fCacheLines;
        char[] cArray = symbolCache.fSymbolChars;
        boolean bl = n3 == this.fMostRecentByte;
        int n5 = symbolCache.fSymbolCharsOffset;
        int n6 = 0;
        int[] nArray2 = nArray[n6];
        int n7 = 1 + (nArray2[0] - 1) * 3;
        int n8 = 0;
        if (bl) {
            int n9;
            while (n7 > 0) {
                if (nArray2[n7] == n) {
                    if (nArray2[n7 + 1] == -1) break;
                    int n10 = nArray2[n7 + 1];
                    if (n8 > 3) {
                        this.fStringPool.updateCacheLine(n10, n8, 1);
                    }
                    return n10;
                }
                n7 -= 3;
                ++n8;
            }
            try {
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                cArray = new char[symbolCache.fSymbolCharsOffset * 2];
                System.arraycopy(symbolCache.fSymbolChars, 0, cArray, 0, symbolCache.fSymbolCharsOffset);
                symbolCache.fSymbolChars = cArray;
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            ++symbolCache.fSymbolCharsOffset;
            if (n7 < 0) {
                n7 = 1 + nArray2[0] * 3;
                nArray2[0] = nArray2[0] + 1;
                try {
                    nArray2[n7] = n;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n9 = 1 + (n7 - 1) * 2;
                    nArray2 = new int[n9];
                    System.arraycopy(nArray[n6], 0, nArray2, 0, n7);
                    nArray[n6] = nArray2;
                    nArray2[n7] = n;
                }
                nArray2[n7 + 2] = -1;
            }
            n9 = this.fStringPool.createNonMatchingSymbol(n5, n6, nArray2, n7);
            return n9;
        }
        try {
            cArray[symbolCache.fSymbolCharsOffset] = (char)n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            cArray = new char[symbolCache.fSymbolCharsOffset * 2];
            System.arraycopy(symbolCache.fSymbolChars, 0, cArray, 0, symbolCache.fSymbolCharsOffset);
            symbolCache.fSymbolChars = cArray;
            cArray[symbolCache.fSymbolCharsOffset] = (char)n;
        }
        ++symbolCache.fSymbolCharsOffset;
        int n11 = 1;
        while (n7 >= 0) {
            if (nArray2[n7] != n) {
                n7 -= 3;
                ++n8;
                continue;
            }
            if (n2 >= 128) {
                n = this.getMultiByteSymbolChar(n2);
                n2 = this.fMostRecentByte;
            } else if (n2 == n3 || XMLCharacterProperties.fgAsciiNameChar[n2] == 0) {
                n = -1;
            } else {
                n = n2;
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    n2 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n2 = this.slowLoadNextByte();
                }
            }
            if (n == -1) {
                if (nArray2[n7 + 1] == -1) {
                    return this.fStringPool.createNonMatchingSymbol(n5, n6, nArray2, n7);
                }
                symbolCache.fSymbolCharsOffset = n5;
                int n12 = nArray2[n7 + 1];
                if (n8 > n11 * 3) {
                    this.fStringPool.updateCacheLine(n12, n8, n11);
                }
                return n12;
            }
            try {
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                cArray = new char[symbolCache.fSymbolCharsOffset * 2];
                System.arraycopy(symbolCache.fSymbolChars, 0, cArray, 0, symbolCache.fSymbolCharsOffset);
                symbolCache.fSymbolChars = cArray;
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            ++symbolCache.fSymbolCharsOffset;
            n6 = nArray2[n7 + 2];
            try {
                nArray2 = nArray[n6];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (n6 == -1) {
                    nArray2[n7 + 2] = n6 = symbolCache.fCacheLineCount++;
                    nArray2 = new int[13];
                    try {
                        nArray[n6] = nArray2;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                        nArray = new int[n6 * 2][];
                        System.arraycopy(symbolCache.fCacheLines, 0, nArray, 0, n6);
                        symbolCache.fCacheLines = nArray;
                        nArray[n6] = nArray2;
                    }
                }
                nArray2 = nArray[n6];
                throw new RuntimeException("untested 1");
            }
            n7 = 1 + (nArray2[0] - 1) * 3;
            ++n11;
        }
        if (n7 < 0) {
            n7 = 1 + nArray2[0] * 3;
        }
        while (true) {
            nArray2[0] = nArray2[0] + 1;
            try {
                nArray2[n7] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n4 = 1 + (n7 - 1) * 2;
                nArray2 = new int[n4];
                System.arraycopy(nArray[n6], 0, nArray2, 0, n7);
                nArray[n6] = nArray2;
                nArray2[n7] = n;
            }
            if (n2 >= 128) {
                n = this.getMultiByteSymbolChar(n2);
                n2 = this.fMostRecentByte;
            } else if (n2 == n3 || XMLCharacterProperties.fgAsciiNameChar[n2] == 0) {
                n = -1;
            } else {
                n = n2;
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    n2 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n2 = this.slowLoadNextByte();
                }
            }
            if (n == -1) break;
            ++symbolCache.fCacheLineCount;
            nArray2[n7 + 1] = -1;
            nArray2[n7 + 2] = n6;
            nArray2 = new int[13];
            try {
                nArray[n6] = nArray2;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                nArray = new int[n6 * 2][];
                System.arraycopy(symbolCache.fCacheLines, 0, nArray, 0, n6);
                symbolCache.fCacheLines = nArray;
                nArray[n6] = nArray2;
            }
            n7 = 1;
            try {
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                cArray = new char[symbolCache.fSymbolCharsOffset * 2];
                System.arraycopy(symbolCache.fSymbolChars, 0, cArray, 0, symbolCache.fSymbolCharsOffset);
                symbolCache.fSymbolChars = cArray;
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            ++symbolCache.fSymbolCharsOffset;
        }
        nArray2[n7 + 2] = -1;
        n4 = this.fStringPool.createNonMatchingSymbol(n5, n6, nArray2, n7);
        return n4;
    }

    public int scanName(char c) throws Exception {
        int n;
        int n2 = this.fMostRecentByte;
        if (n2 < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[n2] == 0) {
                if (n2 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    return this.changeReaders().scanName(c);
                }
                return -1;
            }
            n = n2;
        } else {
            int n3;
            UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
            int n4 = this.fCurrentIndex++;
            int n5 = this.fCurrentOffset++;
            try {
                n3 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n3 = this.slowLoadNextByte();
            }
            if ((0xE0 & n2) == 192) {
                n = ((0x1F & n2) << 6) + (0x3F & n3);
                if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
                    this.fCurrentChunk = uTF8DataChunk;
                    this.fCurrentIndex = n4;
                    this.fCurrentOffset = n5;
                    this.fMostRecentData = uTF8DataChunk.toByteArray();
                    this.fMostRecentByte = n2;
                    return -1;
                }
            } else {
                int n6;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    n6 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n6 = this.slowLoadNextByte();
                }
                if ((0xF0 & n2) == 224) {
                    if (n2 == 237 && n3 >= 160 || n2 == 239 && n3 == 191 && n6 >= 190) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n4;
                        this.fCurrentOffset = n5;
                        this.fMostRecentData = uTF8DataChunk.toByteArray();
                        this.fMostRecentByte = n2;
                        return -1;
                    }
                    n = ((0xF & n2) << 12) + ((0x3F & n3) << 6) + (0x3F & n6);
                    if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n4;
                        this.fCurrentOffset = n5;
                        this.fMostRecentData = uTF8DataChunk.toByteArray();
                        this.fMostRecentByte = n2;
                        return -1;
                    }
                } else {
                    this.fCurrentChunk = uTF8DataChunk;
                    this.fCurrentIndex = n4;
                    this.fCurrentOffset = n5;
                    this.fMostRecentData = uTF8DataChunk.toByteArray();
                    this.fMostRecentByte = n2;
                    return -1;
                }
            }
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            n2 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n2 = this.slowLoadNextByte();
        }
        return this.scanMatchingName(n, n2, c);
    }

    public int scanQName(char c) throws Exception {
        int n;
        int n2;
        int n3 = this.fMostRecentByte;
        if (n3 < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[n3] == 0) {
                return -1;
            }
            if (n3 == 58) {
                return -1;
            }
        } else if ((XMLCharacterProperties.fgCharFlags[n3] & 2) == 0) {
            return -1;
        }
        int n4 = this.fCurrentOffset;
        int n5 = this.fCurrentIndex;
        byte[] byArray = this.fMostRecentData;
        int n6 = -1;
        while (true) {
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            ++n5;
            try {
                n3 = byArray[n5] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n3 = this.slowLoadNextByte();
                n5 = 0;
                byArray = this.fMostRecentData;
            }
            if (c == n3) break;
            if (n3 < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[n3] == 0) break;
                if (n3 != 58) continue;
                if (n6 != -1) break;
                n6 = this.fCurrentOffset;
                try {
                    n3 = byArray[n5 + 1] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
                    n2 = this.fCurrentOffset;
                    n3 = this.slowLoadNextByte();
                    this.fCurrentChunk = uTF8DataChunk;
                    this.fCurrentOffset = n2;
                    this.fMostRecentData = this.fCurrentChunk.toByteArray();
                }
                n = 1;
                if (n3 < 128) {
                    if (XMLCharacterProperties.fgAsciiInitialNameChar[n3] == 0 || n3 == 58) {
                        n = 0;
                    }
                } else if ((XMLCharacterProperties.fgCharFlags[n3] & 2) == 0) {
                    n = 0;
                }
                n3 = 58;
                if (n != 0) continue;
                n6 = -1;
                break;
            }
            if ((XMLCharacterProperties.fgCharFlags[n3] & 4) == 0) break;
        }
        this.fCurrentIndex = n5;
        this.fMostRecentByte = n3;
        n = this.fCurrentOffset - n4;
        n2 = this.addSymbol(n4, n);
        int n7 = n6 == -1 ? -1 : this.addSymbol(n4, n6 - n4);
        int n8 = n6 == -1 ? n2 : this.addSymbol(n6 + 1, this.fCurrentOffset - (n6 + 1));
        n2 = this.fStringPool.addQName(n2, n7, n8);
        return n2;
    }

    public int scanStringLiteral() throws Exception {
        boolean bl = this.lookingAtChar('\'', true);
        if (!bl && !this.lookingAtChar('\"', true)) {
            return -1;
        }
        int n = this.fCurrentOffset;
        char c = bl ? (char)'\'' : '\"';
        while (!this.lookingAtChar(c, false)) {
            if (this.lookingAtValidChar(true)) continue;
            return -2;
        }
        int n2 = this.fCurrentChunk.addString(n, this.fCurrentOffset - n);
        this.lookingAtChar(c, true);
        return n2;
    }

    private int skipAsciiCharData() throws Exception {
        int n = this.fCurrentIndex;
        int n2 = this.fCurrentOffset - n;
        byte[] byArray = this.fMostRecentData;
        while (true) {
            int n3;
            try {
                n3 = byArray[n] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n2 += n;
                this.slowLoadNextByte();
                n = 0;
                byArray = this.fMostRecentData;
                n3 = byArray[n] & 0xFF;
            }
            if (n3 >= 128) {
                this.fCurrentOffset = n2 + n;
                this.fCurrentIndex = n;
                this.fMostRecentByte = n3;
                return n3;
            }
            if (XMLCharacterProperties.fgAsciiCharData[n3] == 0) {
                ++this.fCharacterCounter;
            } else if (n3 == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n3 == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
            } else {
                this.fCurrentOffset = n2 + n;
                this.fCurrentIndex = n;
                this.fMostRecentByte = n3;
                return n3;
            }
            ++n;
        }
    }

    private boolean skipMultiByteCharData(int n) throws Exception {
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n2 = this.fCurrentOffset;
        int n3 = this.fCurrentIndex;
        int n4 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            this.loadNextByte();
            return true;
        }
        int n5 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            if (n == 237 && n4 >= 160 || n == 239 && n4 == 191 && n5 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n3;
                this.fCurrentOffset = n2;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            this.loadNextByte();
            return true;
        }
        int n6 = this.loadNextByte();
        if (n > 244 || n == 244 && n4 >= 144) {
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n3;
            this.fCurrentOffset = n2;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return false;
        }
        this.loadNextByte();
        return true;
    }

    public void skipPastName(char c) throws Exception {
        int n = this.fMostRecentByte;
        if (n < 128 ? XMLCharacterProperties.fgAsciiInitialNameChar[n] == 0 : !this.skippedMultiByteCharWithFlag(n, 2)) {
            return;
        }
        do {
            ++this.fCharacterCounter;
            n = this.loadNextByte();
            if (c != n) continue;
            return;
        } while (!(n < 128 ? XMLCharacterProperties.fgAsciiNameChar[n] == 0 : !this.skippedMultiByteCharWithFlag(n, 4)));
    }

    public void skipPastNmtoken(char c) throws Exception {
        int n = this.fMostRecentByte;
        while (c != n) {
            if (n < 128 ? XMLCharacterProperties.fgAsciiNameChar[n] == 0 : !this.skippedMultiByteCharWithFlag(n, 4)) {
                return;
            }
            ++this.fCharacterCounter;
            n = this.loadNextByte();
        }
        return;
    }

    public void skipPastSpaces() throws Exception {
        int n = this.fMostRecentByte;
        while (true) {
            if (n == 32 || n == 9) {
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n = this.slowLoadNextByte();
                }
                if (n != 10) continue;
                ++this.fLinefeedCounter;
            } else {
                if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipPastSpaces();
                }
                return;
            }
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n = this.slowLoadNextByte();
                continue;
            }
            break;
        }
    }

    public void skipToChar(char c) throws Exception {
        int n = this.fMostRecentByte;
        while (n != c) {
            if (n == 0) {
                if (this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipToChar(c);
                    return;
                }
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                n = this.loadNextByte();
                if (n != 10) continue;
                ++this.fLinefeedCounter;
            } else if (n < 128) {
                ++this.fCharacterCounter;
            } else {
                ++this.fCharacterCounter;
                if ((0xE0 & n) == 192) {
                    this.loadNextByte();
                } else if ((0xF0 & n) == 224) {
                    this.loadNextByte();
                    this.loadNextByte();
                } else {
                    this.loadNextByte();
                    this.loadNextByte();
                    this.loadNextByte();
                }
            }
            n = this.loadNextByte();
        }
        return;
    }

    protected boolean skippedMultiByteCharWithFlag(int n, int n2) throws Exception {
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n3 = this.fCurrentOffset;
        int n4 = this.fCurrentIndex;
        int n5 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            if ((XMLCharacterProperties.fgCharFlags[((0x1F & n) << 6) + (0x3F & n5)] & n2) == 0) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            return true;
        }
        int n6 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            if (n == 237 && n5 >= 160 || n == 239 && n5 == 191 && n6 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            if ((XMLCharacterProperties.fgCharFlags[((0xF & n) << 12) + ((0x3F & n5) << 6) + (0x3F & n6)] & n2) == 0) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            return true;
        }
        this.fCurrentChunk = uTF8DataChunk;
        this.fCurrentIndex = n4;
        this.fCurrentOffset = n3;
        this.fMostRecentData = uTF8DataChunk.toByteArray();
        this.fMostRecentByte = n;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean skippedString(char[] var1_1) throws Exception {
        block7: {
            var2_2 = var1_1.length;
            var3_3 = this.fMostRecentData;
            var4_4 = this.fCurrentIndex + var2_2;
            var5_5 = var2_2;
            try {
                while (var5_5-- > 0) {
                    if (var3_3[--var4_4] == var1_1[var5_5]) continue;
                    return false;
                }
                break block7;
            }
            catch (ArrayIndexOutOfBoundsException v0) {
                var6_6 = 0;
                ** while (var4_4 < 16384)
            }
lbl-1000:
            // 1 sources

            {
                if (var3_3[var4_4++] == var1_1[var6_6++]) continue;
                return false;
            }
lbl15:
            // 1 sources

            var7_7 = this.fCurrentChunk;
            var8_8 = this.fCurrentOffset;
            var9_9 = this.fCurrentIndex;
            this.slowLoadNextByte();
            var3_3 = this.fMostRecentData;
            var4_4 = 0;
            while (var6_6 < var2_2) {
                if (var3_3[var4_4++] == var1_1[var6_6++]) continue;
                this.fCurrentChunk = var7_7;
                this.fCurrentIndex = var9_9;
                this.fCurrentOffset = var8_8;
                this.fMostRecentData = this.fCurrentChunk.toByteArray();
                this.fMostRecentByte = this.fMostRecentData[var9_9] & 255;
                return false;
            }
        }
        this.fCharacterCounter += var2_2;
        this.fCurrentOffset += var2_2;
        this.fCurrentIndex += var2_2;
        try {
            this.fMostRecentByte = var3_3[this.fCurrentIndex] & 255;
        }
        catch (ArrayIndexOutOfBoundsException v1) {
            this.slowLoadNextByte();
        }
        return true;
    }

    private void slowAppendCharData(int n) throws Exception {
        this.characters(0, this.fCharDataLength);
        this.fCharDataLength = 0;
        this.fCharacters[this.fCharDataLength++] = (char)n;
    }

    private int slowLoadNextByte() throws Exception {
        this.fCallClearPreviousChunk = true;
        if (this.fCurrentChunk.nextChunk() != null) {
            this.fCurrentChunk = this.fCurrentChunk.nextChunk();
            this.fCurrentIndex = 0;
            this.fMostRecentData = this.fCurrentChunk.toByteArray();
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            return this.fMostRecentByte;
        }
        this.fCurrentChunk = UTF8DataChunk.createChunk(this.fStringPool, this.fCurrentChunk);
        return this.fillCurrentChunk();
    }

    private void whitespace(int n, int n2) throws Exception {
        if (!this.fSendCharDataAsCharArray) {
            int n3 = this.addString(n, n2 - n);
            this.fEntityHandler.processWhitespace(n3);
            return;
        }
        this.fEntityHandler.processWhitespace(this.fCharacters, 0, this.fCharDataLength);
    }
}

