/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.framework.XMLValidator;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.utils.StringPool;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RevalidatingDOMParser
extends DOMParser {
    private static final boolean DEBUG_VALIDATE = false;

    private final int countChildren(Node node) {
        int n = 0;
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n2 = (n += nodeList.getLength()) - 1;
            while (n2 >= 0) {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 5) {
                    n += this.countChildren(node2) - 1;
                }
                --n2;
            }
        }
        return n;
    }

    private final int expandChildren(Node node, int[] nArray, Node[] nodeArray, int n, StringPool stringPool) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            int n3 = 0;
            while (n3 < n2) {
                Node node2 = nodeList.item(n3);
                short s = node2.getNodeType();
                if (s == 1) {
                    nArray[n] = stringPool.addSymbol(node2.getNodeName());
                    nodeArray[n] = node2;
                    ++n;
                } else if (s == 3) {
                    if (!(node2 instanceof TextImpl) || !((TextImpl)node2).isIgnorableWhitespace()) {
                        nArray[n] = -1;
                        nodeArray[n] = node2;
                        ++n;
                    }
                } else if (s == 5) {
                    n = this.expandChildren(node2, nArray, nodeArray, n, stringPool);
                }
                ++n3;
            }
        }
        return n;
    }

    private static String normalize(String string) {
        return null;
    }

    private static void print(Node node, String string) {
    }

    private final Node recursiveValidate(Node node, XMLValidator xMLValidator, StringPool stringPool) {
        int[] nArray = new int[this.countChildren(node)];
        Node[] nodeArray = new Node[nArray.length];
        int n = this.expandChildren(node, nArray, nodeArray, 0, stringPool);
        int n2 = -1;
        int n3 = stringPool.addSymbol(node.getNodeName());
        int n4 = -1;
        try {
            n4 = this.fStringPool.getDeclaration(n3);
            n2 = xMLValidator.checkContent(n4, n, nArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Node node2 = null;
        if (n2 != -1) {
            node2 = nodeArray[n2];
            String string = xMLValidator.getContentSpecAsString(n4);
            int n5 = n2 != n ? 87 : 88;
            try {
                Object[] objectArray = new Object[]{node.getNodeName(), string};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n5, 0, objectArray, 1);
            }
            catch (Exception exception) {}
        } else {
            int n6 = 0;
            while (n6 < n) {
                Node node3;
                if (nArray[n6] != -1 && (node3 = nodeArray[n6]) != null && (node3 = this.recursiveValidate(node3, xMLValidator, stringPool)) != null) {
                    node2 = node3;
                    break;
                }
                ++n6;
            }
        }
        nArray = null;
        nodeArray = null;
        return node2;
    }

    private static String type(int n) {
        return null;
    }

    public final Node validate(Node node) {
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("Can't revalidate a non element");
        }
        return this.recursiveValidate(node, this.fValidator, this.fStringPool);
    }
}

