/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Stack;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLDocumentScanner;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.framework.XMLValidator;
import org.apache.xerces.readers.DefaultReaderFactory;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyCharArray;
import org.apache.xerces.utils.ImplementationMessages;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.utils.XMLMessageProvider;
import org.apache.xerces.utils.XMLMessages;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.dtd.DTDValidator;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.apache.xerces.validators.schema.XSchemaValidator;
import org.xml.sax.Configurable;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public abstract class XMLParser
implements XMLErrorReporter,
XMLEntityHandler,
XMLDocumentScanner.EventHandler,
DTDValidator.EventHandler,
Configurable,
Locator {
    protected static final String SAX2_FEATURES_PREFIX = "http://xml.org/sax/features/";
    protected static final String SAX2_PROPERTIES_PREFIX = "http://xml.org/sax/properties/";
    protected static final String SAX2_HANDLERS_PREFIX = "http://xml.org/sax/handlers/";
    protected static final String XERCES_FEATURES_PREFIX = "http://apache.org/xml/features/";
    protected static final String XERCES_PROPERTIES_PREFIX = "http://apache.org/xml/properties/";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://xml.org/sax/features/namespaces", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/default-attribute-values", "http://apache.org/xml/features/validation/validate-content-models", "http://apache.org/xml/features/validation/validate-datatypes", "http://apache.org/xml/features/validation/warn-on-duplicate-attdef", "http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/continue-after-fatal-error"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://xml.org/sax/properties/namespace-sep", "http://xml.org/sax/properties/xml-string"};
    private static final boolean PRINT_EXCEPTION_STACK_TRACE = false;
    private XMLAttrList fAttrList = null;
    protected boolean fParseInProgress = false;
    private boolean fNeedReset = false;
    private boolean fContinueAfterFatalError;
    private ErrorHandler fErrorHandler;
    private char[] fCharRefData = null;
    private int[] fElementTypeStack = new int[8];
    private int[] fElementEntityStack = new int[8];
    private boolean fCalledStartDocument = false;
    private int fXMLLang = -1;
    protected String fNamespaceSep = "";
    protected XMLValidator fValidator = null;
    protected DTDValidator fDTDValidator = null;
    protected XSchemaValidator fSchemaValidator = null;
    private boolean fCheckedForSchema = false;
    private Locator fLocator = null;
    private Locale fLocale = null;
    private LocatorImpl fAttrNameLocator = null;
    private boolean fSeenRootElement = false;
    private boolean fStandaloneDocument = false;
    private int fCDATASymbol = -1;
    protected boolean fNamespacesEnabled = false;
    private boolean fSendCharDataAsCharArray = false;
    private boolean fValidating = false;
    private boolean fScanningDTD = false;
    private StringPool.CharArrayRange fCurrentElementCharArrayRange = null;
    private static XMLMessageProvider fgXMLMessages = new XMLMessages();
    private static XMLMessageProvider fgImplementationMessages = new ImplementationMessages();
    private static XMLMessageProvider fgSchemaMessages = new SchemaMessageProvider();
    private static XMLMessageProvider fgDatatypeMessages = new DatatypeMessageProvider();
    protected XMLDocumentScanner fScanner = null;
    protected StringPool fStringPool = null;
    protected XMLErrorReporter fErrorReporter = null;
    protected XMLEntityHandler fEntityHandler = null;
    protected XMLEntityReaderFactory fReaderFactory = null;
    protected int fElementDepth = 0;
    protected int fCurrentElementType = -1;
    protected int fCurrentElementEntity = -1;
    protected boolean fInElementContent = false;
    private ReaderState fReaderStateFreeList = null;
    private EntityResolver fResolver = null;
    private byte[] fEntityTypeStack = null;
    private int[] fEntityNameStack = null;
    private int fEntityStackDepth = 0;
    private Stack fReaderStack = new Stack();
    private XMLEntityHandler.EntityReader fReader = null;
    private InputSource fSource = null;
    private int fEntityName = -1;
    private int fEntityType = -1;
    private int fEntityContext = -1;
    private String fPublicId = null;
    private String fSystemId = null;
    private int fReaderId = -1;
    private int fReaderDepth = -1;
    private int fNextReaderId = 0;
    private NullReader fNullReader = null;

    protected XMLParser() {
        this.fStringPool = new StringPool();
        this.fErrorReporter = this;
        this.fEntityHandler = this;
        this.fScanner = new XMLDocumentScanner(this, this.fStringPool, this.fErrorReporter, this.fEntityHandler, new ChunkyCharArray(this.fStringPool));
        XMLCharacterProperties.initCharFlags();
        this.fAttrList = new XMLAttrList(this.fStringPool);
        this.fLocator = this;
        this.fReaderFactory = new DefaultReaderFactory();
        this.fCDATASymbol = this.fStringPool.addSymbol("CDATA");
        this.fDTDValidator = new DTDValidator(this, this.fStringPool, this.fErrorReporter, this.fEntityHandler);
        try {
            this.setContinueAfterFatalError(false);
        }
        catch (SAXException sAXException) {}
    }

    public void addRecognizer(XMLDeclRecognizer xMLDeclRecognizer) {
        this.fReaderFactory.addRecognizer(xMLDeclRecognizer);
    }

    public abstract void attlistDecl(int var1, int var2, int var3, String var4, int var5, int var6) throws Exception;

    public void callCharacters(int n) throws Exception {
        int n2;
        if (this.fCharRefData == null) {
            this.fCharRefData = new char[2];
        }
        int n3 = n2 = n < 65536 ? 1 : 2;
        if (n2 == 1) {
            this.fCharRefData[0] = (char)n;
        } else {
            this.fCharRefData[0] = (char)((n - 65536 >> 10) + 55296);
            this.fCharRefData[1] = (char)((n - 65536 & 0x3FF) + 56320);
        }
        if (this.fSendCharDataAsCharArray) {
            if (!this.fInElementContent) {
                this.fValidator.characters(this.fCharRefData, 0, n2);
            }
            this.characters(this.fCharRefData, 0, n2);
        } else {
            int n4 = this.fStringPool.addString(new String(this.fCharRefData, 0, n2));
            if (!this.fInElementContent) {
                this.fValidator.characters(n4);
            }
            this.characters(n4);
        }
    }

    public void callComment(int n) throws Exception {
        this.comment(n);
    }

    public void callEndDocument() throws Exception {
        if (this.fCalledStartDocument) {
            this.endDocument();
        }
    }

    public boolean callEndElement(int n) throws Exception {
        int n2 = this.fCurrentElementType;
        if (this.fCurrentElementEntity != n) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 68, 68, new Object[]{this.fStringPool.toString(n2)}, 2);
        }
        this.endElement(n2);
        this.fInElementContent = this.fValidator.endElement(n2);
        if (this.fElementDepth-- == 0) {
            throw new RuntimeException("Element stack underflow");
        }
        if (this.fElementDepth == 0) {
            this.fCurrentElementType = -1;
            this.fCurrentElementEntity = -1;
            return true;
        }
        this.fCurrentElementType = this.fElementTypeStack[this.fElementDepth - 1];
        this.fCurrentElementEntity = this.fElementEntityStack[this.fElementDepth - 1];
        return false;
    }

    public void callProcessingInstruction(int n, int n2) throws Exception {
        this.processingInstruction(n, n2);
    }

    public void callStartDocument(int n, int n2, int n3) throws Exception {
        if (!this.fCalledStartDocument) {
            this.startDocument(n, n2, n3);
            this.fCalledStartDocument = true;
        }
    }

    public void callStartElement(int n) throws Exception {
        int n2;
        if (!this.fSeenRootElement) {
            this.fSeenRootElement = true;
            if (this.fValidator == null) {
                this.fValidator = this.fDTDValidator;
            }
            this.fValidator.rootElementSpecified(n);
            this.fStringPool.resetShuffleCount();
        }
        this.fInElementContent = this.fValidator.startElement(n, this.fAttrList);
        int n3 = this.fAttrList.attrListHandle();
        if (n3 != -1) {
            this.fAttrList.endAttrList();
            if (this.fXMLLang == -1) {
                this.fXMLLang = this.fStringPool.addSymbol("xml:lang");
            }
            n2 = this.fAttrList.getFirstAttr(n3);
            while (n2 != -1) {
                if (this.fStringPool.equalNames(this.fAttrList.getAttrName(n2), this.fXMLLang)) {
                    this.fScanner.checkXMLLangAttributeValue(this.fAttrList.getAttValue(n2));
                    break;
                }
                n2 = this.fAttrList.getNextAttr(n2);
            }
        }
        this.startElement(n, this.fAttrList, n3);
        n2 = this.fEntityHandler.getReaderId();
        if (this.fElementDepth == this.fElementTypeStack.length) {
            int[] nArray = new int[this.fElementDepth * 2];
            System.arraycopy(this.fElementTypeStack, 0, nArray, 0, this.fElementDepth);
            this.fElementTypeStack = nArray;
            nArray = new int[this.fElementDepth * 2];
            System.arraycopy(this.fElementEntityStack, 0, nArray, 0, this.fElementDepth);
            this.fElementEntityStack = nArray;
        }
        this.fCurrentElementType = n;
        this.fCurrentElementEntity = n2;
        this.fElementTypeStack[this.fElementDepth] = n;
        this.fElementEntityStack[this.fElementDepth] = n2;
        ++this.fElementDepth;
    }

    public XMLEntityHandler.EntityReader changeReaders() throws Exception {
        this.sendEndOfInputNotifications();
        this.sendEndEntityNotifications();
        this.popReader();
        this.sendReaderChangeNotifications();
        this.popEntity();
        return this.fReader;
    }

    public abstract void characters(int var1) throws Exception;

    public abstract void characters(char[] var1, int var2, int var3) throws Exception;

    public abstract void comment(int var1) throws Exception;

    public void commentInDTD(int n) throws Exception {
        this.fStringPool.releaseString(n);
    }

    public abstract void elementDecl(int var1, XMLValidator.ContentSpec var2) throws Exception;

    public abstract void endCDATA() throws Exception;

    public abstract void endDTD() throws Exception;

    public abstract void endDocument() throws Exception;

    public abstract void endElement(int var1) throws Exception;

    public void endEntityDecl() throws Exception {
        this.popEntity();
    }

    public abstract void endEntityReference(int var1, int var2, int var3) throws Exception;

    public abstract void endNamespaceDeclScope(int var1) throws Exception;

    private String entityReferencePath(boolean bl, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(top-level)");
        int n2 = 0;
        while (n2 < this.fEntityStackDepth) {
            if (this.fEntityNameStack[n2] >= 0) {
                stringBuffer.append('-');
                stringBuffer.append(this.fEntityTypeStack[n2] == 1 ? (char)'%' : '&');
                stringBuffer.append(this.fStringPool.toString(this.fEntityNameStack[n2]));
                stringBuffer.append(';');
            }
            ++n2;
        }
        stringBuffer.append('-');
        stringBuffer.append(bl ? (char)'%' : '&');
        stringBuffer.append(this.fStringPool.toString(n));
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public String expandSystemId(String string) {
        return this.expandSystemId(string, this.fSystemId);
    }

    private String expandSystemId(String string, String string2) {
        URL uRL;
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            return string;
        }
        try {
            uRL = new URL(string3);
            if (uRL != null) {
                return string;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        string3 = XMLParser.fixURI(string3);
        uRL = null;
        URL uRL2 = null;
        try {
            if (string2 == null) {
                String string4;
                try {
                    string4 = XMLParser.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException securityException) {
                    string4 = "";
                }
                if (!string4.endsWith("/")) {
                    string4 = String.valueOf(string4) + "/";
                }
                uRL = new URL("file", "", string4);
            } else {
                uRL = new URL(string2);
            }
            uRL2 = new URL(uRL, string3);
        }
        catch (Exception exception) {}
        if (uRL2 == null) {
            return string;
        }
        return uRL2.toString();
    }

    public abstract void externalEntityDecl(int var1, int var2, int var3) throws Exception;

    public abstract void externalPEDecl(int var1, int var2, int var3) throws Exception;

    private static String fixURI(String string) {
        char c;
        char c2;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2 && (c2 = string.charAt(1)) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            string = "/" + string;
        }
        return string;
    }

    protected boolean getAllowJavaEncodings() throws SAXException {
        return this.fReaderFactory.getAllowJavaEncodingName();
    }

    public int getColumnNumber() {
        return this.fReader.getColumnNumber();
    }

    protected boolean getContinueAfterFatalError() throws SAXException {
        return this.fContinueAfterFatalError;
    }

    public XMLEntityHandler.EntityReader getEntityReader() {
        return this.fReader;
    }

    protected boolean getExternalGeneralEntities() throws SAXException {
        return true;
    }

    protected boolean getExternalParameterEntities() throws SAXException {
        return true;
    }

    public boolean getFeature(String string) throws SAXException {
        if (string.startsWith(SAX2_FEATURES_PREFIX)) {
            String string2 = string.substring(SAX2_FEATURES_PREFIX.length());
            if (string2.equals("validation")) {
                return this.getValidation();
            }
            if (string2.equals("external-general-entities")) {
                return this.getExternalGeneralEntities();
            }
            if (string2.equals("external-parameter-entities")) {
                return this.getExternalParameterEntities();
            }
            if (string2.equals("namespaces")) {
                return this.getNamespaces();
            }
        } else if (string.startsWith(XERCES_FEATURES_PREFIX)) {
            String string3 = string.substring(XERCES_FEATURES_PREFIX.length());
            if (string3.equals("validation/dynamic")) {
                return this.getValidationDynamic();
            }
            if (string3.equals("validation/default-attribute-values")) {
                throw new SAXNotRecognizedException(string);
            }
            if (string3.equals("validation/validate-content-models")) {
                throw new SAXNotRecognizedException(string);
            }
            if (string3.equals("validation/validate-datatypes")) {
                throw new SAXNotRecognizedException(string);
            }
            if (string3.equals("validation/warn-on-duplicate-attdef")) {
                return this.getValidationWarnOnDuplicateAttdef();
            }
            if (string3.equals("validation/warn-on-undeclared-elemdef")) {
                return this.getValidationWarnOnUndeclaredElemdef();
            }
            if (string3.equals("allow-java-encodings")) {
                return this.getAllowJavaEncodings();
            }
            if (string3.equals("continue-after-fatal-error")) {
                return this.getContinueAfterFatalError();
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public String[] getFeaturesRecognized() {
        return RECOGNIZED_FEATURES;
    }

    public int getLineNumber() {
        return this.fReader.getLineNumber();
    }

    public final Locator getLocator() {
        return this.fLocator;
    }

    private LocatorImpl getLocatorImpl(LocatorImpl locatorImpl) {
        if (locatorImpl == null) {
            return new LocatorImpl(this);
        }
        locatorImpl.setPublicId(this.getPublicId());
        locatorImpl.setSystemId(this.getSystemId());
        locatorImpl.setLineNumber(this.getLineNumber());
        locatorImpl.setColumnNumber(this.getColumnNumber());
        return locatorImpl;
    }

    protected String getNamespaceSep() throws SAXException {
        return this.fNamespaceSep;
    }

    protected boolean getNamespaces() throws SAXException {
        return this.fNamespacesEnabled;
    }

    public String[] getPropertiesRecognized() {
        return RECOGNIZED_PROPERTIES;
    }

    public Object getProperty(String string) throws SAXException {
        if (string.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string2 = string.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string2.equals("namespace-sep")) {
                return this.getNamespaceSep();
            }
            if (string2.equals("xml-string")) {
                return this.getXMLString();
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public String getPublicId() {
        return this.fPublicId;
    }

    public int getReaderDepth() {
        return this.fReaderDepth;
    }

    public int getReaderId() {
        return this.fReaderId;
    }

    protected XSchemaValidator getSchemaValidator() {
        if (this.fSchemaValidator == null) {
            this.fSchemaValidator = new XSchemaValidator(this.fStringPool, this.fErrorReporter, this.fEntityHandler);
        }
        return this.fSchemaValidator;
    }

    public String getSystemId() {
        return this.fSystemId;
    }

    protected boolean getValidation() throws SAXException {
        return this.fDTDValidator.getValidationEnabled();
    }

    protected boolean getValidationDynamic() throws SAXException {
        return this.fDTDValidator.getDynamicValidationEnabled();
    }

    protected boolean getValidationWarnOnDuplicateAttdef() throws SAXException {
        return this.fDTDValidator.getWarningOnDuplicateAttDef();
    }

    protected boolean getValidationWarnOnUndeclaredElemdef() throws SAXException {
        return this.fDTDValidator.getWarningOnUndeclaredElements();
    }

    protected String getXMLString() throws SAXException {
        throw new SAXNotSupportedException("http://xml.org/sax/properties/xml-string");
    }

    public abstract void ignorableWhitespace(int var1) throws Exception;

    public abstract void ignorableWhitespace(char[] var1, int var2, int var3) throws Exception;

    public abstract void internalEntityDecl(int var1, int var2) throws Exception;

    public abstract void internalPEDecl(int var1, int var2) throws Exception;

    public boolean isFeatureRecognized(String string) {
        String[] stringArray = this.getFeaturesRecognized();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isPropertyRecognized(String string) {
        String[] stringArray = this.getPropertiesRecognized();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public abstract void notationDecl(int var1, int var2, int var3) throws Exception;

    public void parse(String string) throws SAXException, IOException {
        InputSource inputSource = new InputSource(string);
        this.parse(inputSource);
        try {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                reader.close();
            } else {
                InputStream inputStream = inputSource.getByteStream();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {}
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        if (this.fParseInProgress) {
            throw new SAXException("parse may not be called while parsing");
        }
        try {
            if (this.parseSomeSetup(inputSource)) {
                this.fScanner.parseSome(true);
            }
            this.fParseInProgress = false;
        }
        catch (SAXException sAXException) {
            this.fParseInProgress = false;
            throw sAXException;
        }
        catch (IOException iOException) {
            this.fParseInProgress = false;
            throw iOException;
        }
        catch (Exception exception) {
            this.fParseInProgress = false;
            throw new SAXException(exception);
        }
    }

    public boolean parseSome() throws Exception {
        if (!this.fScanner.parseSome(false)) {
            this.fParseInProgress = false;
            return false;
        }
        return true;
    }

    public boolean parseSomeSetup(InputSource inputSource) throws Exception {
        if (this.fNeedReset) {
            this.resetOrCopy();
        }
        this.fParseInProgress = true;
        this.fNeedReset = true;
        return this.fEntityHandler.startReadingFromDocument(inputSource);
    }

    private void popEntity() throws Exception {
        --this.fEntityStackDepth;
    }

    private void popReader() {
        if (this.fReaderStack.empty()) {
            throw new RuntimeException("cannot happen 19");
        }
        ReaderState readerState = (ReaderState)this.fReaderStack.pop();
        this.fReader = readerState.reader;
        this.fSource = readerState.source;
        this.fEntityName = readerState.entityName;
        this.fEntityType = readerState.entityType;
        this.fEntityContext = readerState.entityContext;
        this.fPublicId = readerState.publicId;
        this.fSystemId = readerState.systemId;
        this.fReaderId = readerState.readerId;
        this.fReaderDepth = readerState.depth;
        readerState.nextReaderState = this.fReaderStateFreeList;
        this.fReaderStateFreeList = readerState;
    }

    public void processCharacters(int n) throws Exception {
        if (this.fValidating && !this.fInElementContent) {
            this.fValidator.characters(n);
        }
        this.characters(n);
    }

    public void processCharacters(char[] cArray, int n, int n2) throws Exception {
        if (this.fValidating && !this.fInElementContent) {
            this.fValidator.characters(cArray, n, n2);
        }
        this.characters(cArray, n, n2);
    }

    public void processWhitespace(int n) throws Exception {
        if (this.fInElementContent) {
            if (this.fStandaloneDocument && this.fValidating) {
                this.fValidator.ignorableWhitespace(n);
            }
            this.ignorableWhitespace(n);
        } else {
            if (this.fValidating && !this.fInElementContent) {
                this.fValidator.characters(n);
            }
            this.characters(n);
        }
    }

    public void processWhitespace(char[] cArray, int n, int n2) throws Exception {
        if (this.fInElementContent) {
            if (this.fStandaloneDocument && this.fValidating) {
                this.fValidator.ignorableWhitespace(cArray, n, n2);
            }
            this.ignorableWhitespace(cArray, n, n2);
        } else {
            if (this.fValidating && !this.fInElementContent) {
                this.fValidator.characters(cArray, n, n2);
            }
            this.characters(cArray, n, n2);
        }
    }

    public abstract void processingInstruction(int var1, int var2) throws Exception;

    public void processingInstructionInDTD(int n, int n2) throws Exception {
        this.fStringPool.releaseString(n);
        this.fStringPool.releaseString(n2);
    }

    private boolean pushEntity(boolean bl, int n) throws Exception {
        if (n >= 0) {
            int n2 = 0;
            while (n2 < this.fEntityStackDepth) {
                if (this.fEntityNameStack[n2] == n && this.fEntityTypeStack[n2] == (bl ? (byte)1 : 0)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.fEntityTypeStack == null) {
            this.fEntityTypeStack = new byte[8];
            this.fEntityNameStack = new int[8];
        } else if (this.fEntityStackDepth == this.fEntityTypeStack.length) {
            byte[] byArray = new byte[this.fEntityStackDepth * 2];
            System.arraycopy(this.fEntityTypeStack, 0, byArray, 0, this.fEntityStackDepth);
            this.fEntityTypeStack = byArray;
            int[] nArray = new int[this.fEntityStackDepth * 2];
            System.arraycopy(this.fEntityNameStack, 0, nArray, 0, this.fEntityStackDepth);
            this.fEntityNameStack = nArray;
        }
        this.fEntityTypeStack[this.fEntityStackDepth] = (byte)(bl ? 1 : 0);
        this.fEntityNameStack[this.fEntityStackDepth] = n;
        ++this.fEntityStackDepth;
        return true;
    }

    private void pushNullReader() {
        ReaderState readerState = this.fReaderStateFreeList;
        if (readerState == null) {
            readerState = new ReaderState();
        } else {
            this.fReaderStateFreeList = readerState.nextReaderState;
        }
        if (this.fNullReader == null) {
            this.fNullReader = new NullReader();
        }
        readerState.reader = this.fNullReader;
        readerState.source = null;
        readerState.entityName = -1;
        readerState.entityType = -1;
        readerState.entityContext = -1;
        readerState.publicId = "Null Entity";
        readerState.systemId = this.fSystemId;
        readerState.readerId = this.fNextReaderId++;
        readerState.depth = -1;
        readerState.nextReaderState = null;
        this.fReaderStack.push(readerState);
    }

    private void pushReader() {
        ReaderState readerState = this.fReaderStateFreeList;
        if (readerState == null) {
            readerState = new ReaderState();
        } else {
            this.fReaderStateFreeList = readerState.nextReaderState;
        }
        readerState.reader = this.fReader;
        readerState.source = this.fSource;
        readerState.entityName = this.fEntityName;
        readerState.entityType = this.fEntityType;
        readerState.entityContext = this.fEntityContext;
        readerState.publicId = this.fPublicId;
        readerState.systemId = this.fSystemId;
        readerState.readerId = this.fReaderId;
        readerState.depth = this.fReaderDepth;
        readerState.nextReaderState = null;
        this.fReaderStack.push(readerState);
    }

    public void reportError(Locator locator, String string, int n, int n2, Object[] objectArray, int n3) throws Exception {
        SAXParseException sAXParseException;
        if (string.equals("http://www.w3.org/TR/1998/REC-xml-19980210")) {
            sAXParseException = new SAXParseException(fgXMLMessages.createMessage(this.fLocale, n, n2, objectArray), locator);
        } else if (string.equals("http://www.w3.org/TR/1999/REC-xml-names-19990114")) {
            sAXParseException = new SAXParseException(fgXMLMessages.createMessage(this.fLocale, n, n2, objectArray), locator);
        } else if (string.equals("http://www.apache.org/xml/xerces.html")) {
            sAXParseException = new SAXParseException(fgImplementationMessages.createMessage(this.fLocale, n, n2, objectArray), locator);
        } else if (string.equals("http://www.w3.org/TR/xml-schema-1")) {
            sAXParseException = new SAXParseException(fgSchemaMessages.createMessage(this.fLocale, n, n2, objectArray), locator);
        } else if (string.equals("http://www.w3.org/TR/xml-schema-2")) {
            sAXParseException = new SAXParseException(fgDatatypeMessages.createMessage(this.fLocale, n, n2, objectArray), locator);
        } else {
            throw new RuntimeException("Unknown error domain \"" + string + "\".");
        }
        if (this.fErrorHandler == null) {
            if (n3 == 2 && !this.fContinueAfterFatalError) {
                throw sAXParseException;
            }
            return;
        }
        if (n3 == 0) {
            this.fErrorHandler.warning(sAXParseException);
        } else if (n3 == 2) {
            this.fErrorHandler.fatalError(sAXParseException);
            if (!this.fContinueAfterFatalError) {
                Object[] objectArray2 = new Object[]{sAXParseException.getMessage()};
                throw new SAXException(fgImplementationMessages.createMessage(this.fLocale, 16, 0, objectArray2));
            }
        } else {
            this.fErrorHandler.error(sAXParseException);
        }
    }

    public void reset() throws Exception {
        this.fStringPool.reset();
        this.fAttrList.reset(this.fStringPool);
        this.resetCommon();
    }

    private void resetCommon() throws Exception {
        this.fScanner.reset(this.fStringPool, new ChunkyCharArray(this.fStringPool));
        this.fValidating = false;
        this.fScanningDTD = false;
        this.resetEntityHandler();
        this.fValidator = null;
        this.fDTDValidator.reset(this.fStringPool);
        if (this.fSchemaValidator != null) {
            this.fSchemaValidator.reset(this.fStringPool, this.fErrorReporter, this.fEntityHandler);
        }
        this.fCheckedForSchema = false;
        this.fNeedReset = false;
        this.fCalledStartDocument = false;
        this.fSeenRootElement = false;
        this.fStandaloneDocument = false;
        this.fCDATASymbol = this.fStringPool.addSymbol("CDATA");
        this.fXMLLang = -1;
        this.fElementDepth = 0;
        this.fCurrentElementType = -1;
        this.fCurrentElementEntity = -1;
        this.fInElementContent = false;
    }

    private void resetEntityHandler() {
        this.fReaderStack.removeAllElements();
        this.fEntityStackDepth = 0;
        this.fReader = null;
        this.fSource = null;
        this.fEntityName = -1;
        this.fEntityType = -1;
        this.fEntityContext = -1;
        this.fPublicId = null;
        this.fSystemId = null;
        this.fReaderId = -1;
        this.fReaderDepth = -1;
        this.fNextReaderId = 0;
    }

    protected void resetOrCopy() throws Exception {
        this.fStringPool = new StringPool();
        this.fAttrList = new XMLAttrList(this.fStringPool);
        this.resetCommon();
    }

    public int scanAttValue(int n, int n2) throws Exception {
        this.fAttrNameLocator = this.getLocatorImpl(this.fAttrNameLocator);
        int n3 = this.fScanner.scanAttValue(n, n2, this.fValidating);
        if (n3 == -1) {
            return -1;
        }
        if (!this.fCheckedForSchema) {
            this.fCheckedForSchema = true;
            if (n2 == this.fStringPool.addSymbol("xmlns")) {
                this.fValidator = this.getSchemaValidator();
                this.fSchemaValidator.loadSchema(this.fStringPool.toString(n3));
            }
        }
        if (!this.fValidator.attributeSpecified(n, this.fAttrList, n2, this.fAttrNameLocator, n3)) {
            return -2;
        }
        return 0;
    }

    public int scanAttributeName(XMLEntityHandler.EntityReader entityReader, int n) throws Exception {
        if (!this.fSeenRootElement) {
            this.fSeenRootElement = true;
            if (this.fValidator == null) {
                this.fValidator = this.fDTDValidator;
            }
            this.fValidator.rootElementSpecified(n);
            this.fStringPool.resetShuffleCount();
        }
        if (!this.fNamespacesEnabled) {
            return entityReader.scanName('=');
        }
        int n2 = entityReader.scanQName('=');
        if (entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
        return n2;
    }

    public void scanDoctypeDecl(boolean bl) throws Exception {
        this.fScanningDTD = true;
        this.fCheckedForSchema = true;
        this.fStandaloneDocument = bl;
        this.fValidator = this.fDTDValidator;
        this.fDTDValidator.scanDoctypeDecl(bl);
        this.fScanningDTD = false;
    }

    public int scanElementType(XMLEntityHandler.EntityReader entityReader, char c) throws Exception {
        if (!this.fNamespacesEnabled) {
            return entityReader.scanName(c);
        }
        int n = entityReader.scanQName(c);
        if (this.fNamespacesEnabled && entityReader.lookingAtChar(':', false)) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
            entityReader.skipPastNmtoken(' ');
        }
        return n;
    }

    public boolean scanExpectedElementType(XMLEntityHandler.EntityReader entityReader, char c) throws Exception {
        if (this.fCurrentElementCharArrayRange == null) {
            this.fCurrentElementCharArrayRange = this.fStringPool.createCharArrayRange();
        }
        this.fStringPool.getCharArrayRange(this.fCurrentElementType, this.fCurrentElementCharArrayRange);
        return entityReader.scanExpectedName(c, this.fCurrentElementCharArrayRange);
    }

    private void sendEndEntityNotifications() throws Exception {
        this.endEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
    }

    private void sendEndOfInputNotifications() throws Exception {
        boolean bl = this.fReaderStack.size() > 1;
        this.fScanner.endOfInput(this.fEntityName, bl);
        if (this.fScanningDTD) {
            this.fDTDValidator.endOfInput(this.fEntityName, bl);
        }
    }

    private void sendReaderChangeNotifications() throws Exception {
        this.fScanner.readerChange(this.fReader, this.fReaderId);
        if (this.fScanningDTD) {
            this.fDTDValidator.readerChange(this.fReader, this.fReaderId);
        }
    }

    private void sendStartEntityNotifications() throws Exception {
        this.startEntityReference(this.fEntityName, this.fEntityType, this.fEntityContext);
    }

    protected void setAllowJavaEncodings(boolean bl) throws SAXException {
        this.fReaderFactory.setAllowJavaEncodingName(bl);
    }

    protected void setContinueAfterFatalError(boolean bl) throws SAXException {
        this.fContinueAfterFatalError = bl;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.fResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    protected void setExternalGeneralEntities(boolean bl) throws SAXException {
        if (!bl) {
            throw new SAXNotSupportedException("http://xml.org/sax/features/external-general-entities");
        }
    }

    protected void setExternalParameterEntities(boolean bl) throws SAXException {
        if (!bl) {
            throw new SAXNotSupportedException("http://xml.org/sax/features/external-parameter-entities");
        }
    }

    public void setFeature(String string, boolean bl) throws SAXException {
        if (string.startsWith(SAX2_FEATURES_PREFIX)) {
            String string2 = string.substring(SAX2_FEATURES_PREFIX.length());
            if (string2.equals("validation")) {
                this.setValidation(bl);
                return;
            }
            if (string2.equals("external-general-entities")) {
                this.setExternalGeneralEntities(bl);
                return;
            }
            if (string2.equals("external-parameter-entities")) {
                this.setExternalParameterEntities(bl);
                return;
            }
            if (string2.equals("namespaces")) {
                this.setNamespaces(bl);
                return;
            }
        } else if (string.startsWith(XERCES_FEATURES_PREFIX)) {
            String string3 = string.substring(XERCES_FEATURES_PREFIX.length());
            if (string3.equals("validation/dynamic")) {
                this.setValidationDynamic(bl);
                return;
            }
            if (string3.equals("validation/default-attribute-values")) {
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("validation/validate-content-models")) {
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("validation/validate-datatypes")) {
                throw new SAXNotSupportedException(string);
            }
            if (string3.equals("validation/warn-on-duplicate-attdef")) {
                this.setValidationWarnOnDuplicateAttdef(bl);
                return;
            }
            if (string3.equals("validation/warn-on-undeclared-elemdef")) {
                this.setValidationWarnOnUndeclaredElemdef(bl);
                return;
            }
            if (string3.equals("allow-java-encodings")) {
                this.setAllowJavaEncodings(bl);
                return;
            }
            if (string3.equals("continue-after-fatal-error")) {
                this.setContinueAfterFatalError(bl);
                return;
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setLocale(Locale locale) throws SAXException {
        if (this.fParseInProgress) {
            throw new SAXException("setLocale may not be called while parsing");
        }
        this.fLocale = locale;
        fgXMLMessages.setLocale(locale);
        fgImplementationMessages.setLocale(locale);
    }

    public void setLocator(Locator locator) {
        this.fLocator = locator;
    }

    protected void setNamespaceSep(String string) throws SAXException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://xml.org/sax/properties/namespace-sep: parse is in progress");
        }
        this.fNamespaceSep = string;
    }

    protected void setNamespaces(boolean bl) throws SAXException {
        this.fNamespacesEnabled = bl;
        this.fDTDValidator.setNamespacesEnabled(bl);
        this.getSchemaValidator().setNamespacesEnabled(bl);
    }

    public void setProperty(String string, Object object) throws SAXException {
        if (string.startsWith(SAX2_PROPERTIES_PREFIX)) {
            String string2 = string.substring(SAX2_PROPERTIES_PREFIX.length());
            if (string2.equals("namespace-sep")) {
                try {
                    this.setNamespaceSep((String)object);
                }
                catch (ClassCastException classCastException) {
                    throw new SAXNotSupportedException(string);
                }
                return;
            }
            if (string2.equals("xml-string")) {
                throw new SAXNotSupportedException(string);
            }
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setReaderDepth(int n) {
        this.fReaderDepth = n;
    }

    public void setReaderFactory(XMLEntityReaderFactory xMLEntityReaderFactory) {
        this.fReaderFactory = xMLEntityReaderFactory;
        this.fReaderFactory.setSendCharDataAsCharArray(this.fSendCharDataAsCharArray);
    }

    protected void setSendCharDataAsCharArray(boolean bl) {
        this.fSendCharDataAsCharArray = bl;
        this.fReaderFactory.setSendCharDataAsCharArray(this.fSendCharDataAsCharArray);
    }

    public void setValidating(boolean bl) throws Exception {
        this.fValidating = bl;
    }

    protected void setValidation(boolean bl) throws SAXException {
        try {
            this.fDTDValidator.setValidationEnabled(bl);
            this.getSchemaValidator().setValidationEnabled(bl);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    protected void setValidationDynamic(boolean bl) throws SAXException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException("http://apache.org/xml/features/validation/dynamic: parse is in progress");
        }
        try {
            this.fDTDValidator.setDynamicValidationEnabled(bl);
            this.getSchemaValidator().setDynamicValidationEnabled(bl);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    protected void setValidationWarnOnDuplicateAttdef(boolean bl) throws SAXException {
        this.fDTDValidator.setWarningOnDuplicateAttDef(bl);
        this.getSchemaValidator().setWarningOnDuplicateAttDef(bl);
    }

    protected void setValidationWarnOnUndeclaredElemdef(boolean bl) throws SAXException {
        this.fDTDValidator.setWarningOnUndeclaredElements(bl);
        this.getSchemaValidator().setWarningOnUndeclaredElements(bl);
    }

    public abstract void startCDATA() throws Exception;

    public abstract void startDTD(int var1, int var2, int var3) throws Exception;

    public abstract void startDocument(int var1, int var2, int var3) throws Exception;

    public abstract void startElement(int var1, XMLAttrList var2, int var3) throws Exception;

    public boolean startEntityDecl(boolean bl, int n) throws Exception {
        if (!this.pushEntity(bl, n)) {
            int n2 = bl ? 72 : 71;
            Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.entityReferencePath(bl, n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", n2, 73, objectArray, 2);
            return false;
        }
        return true;
    }

    public abstract void startEntityReference(int var1, int var2, int var3) throws Exception;

    public abstract void startNamespaceDeclScope(int var1, int var2) throws Exception;

    public boolean startReadingFromDocument(InputSource inputSource) throws Exception {
        this.pushEntity(false, -2);
        this.fSystemId = null;
        this.pushNullReader();
        this.fEntityName = -2;
        this.fEntityType = 5;
        this.fEntityContext = 6;
        this.fReaderDepth = 0;
        this.fReaderId = this.fNextReaderId++;
        this.fPublicId = inputSource.getPublicId();
        this.fSystemId = inputSource.getSystemId();
        this.sendStartEntityNotifications();
        this.fSystemId = this.expandSystemId(this.fSystemId, null);
        this.fSource = inputSource;
        boolean bl = true;
        try {
            this.fReader = this.fReaderFactory.createReader(this.fEntityHandler, this.fErrorReporter, inputSource, this.fSystemId, bl, this.fStringPool);
        }
        catch (MalformedURLException malformedURLException) {
            this.fReader = null;
            String string = this.fSystemId;
            this.sendEndEntityNotifications();
            this.popReader();
            this.popEntity();
            Object[] objectArray = new Object[]{string};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, objectArray, 2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fReader = null;
            String string = this.fSystemId;
            this.sendEndEntityNotifications();
            this.popReader();
            this.popEntity();
            Object[] objectArray = new Object[]{string};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, objectArray, 2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fReader = null;
            this.sendEndEntityNotifications();
            this.popReader();
            this.popEntity();
            String string = unsupportedEncodingException.getMessage();
            if (string == null) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 70, 72, null, 2);
            }
            if (!XMLCharacterProperties.validEncName(string)) {
                Object[] objectArray = new Object[]{string};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 40, 42, objectArray, 2);
            }
            Object[] objectArray = new Object[]{string};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 61, 60, objectArray, 2);
        }
        this.sendReaderChangeNotifications();
        return this.fReader != null;
    }

    public boolean startReadingFromEntity(int n, int n2, int n3) throws Exception {
        if (n3 > 2) {
            return this.startReadingFromParameterEntity(n, n2, n3);
        }
        int n4 = this.fValidator.lookupEntity(n);
        if (n4 < 0) {
            int n5 = 62;
            int n6 = 1;
            if (this.fEntityContext == 6 || this.fEntityContext == 0) {
                n5 = 61;
                n6 = 2;
            }
            Object[] objectArray = new Object[]{this.fStringPool.toString(n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 62, n5, objectArray, n6);
            return false;
        }
        if (n3 == 2) {
            if (this.fValidator.isUnparsedEntity(n4)) {
                Object[] objectArray = new Object[]{this.fStringPool.toString(n)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 63, 63, objectArray, 2);
                return false;
            }
        } else if (this.fValidator.isExternalEntity(n4)) {
            Object[] objectArray = new Object[]{this.fStringPool.toString(n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 64, 64, objectArray, 2);
            return false;
        }
        if (!this.pushEntity(false, n)) {
            Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.entityReferencePath(false, n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 71, 73, objectArray, 2);
            return false;
        }
        this.pushReader();
        this.fEntityName = n;
        this.fEntityContext = n3;
        this.fReaderDepth = n2;
        this.fReaderId = this.fNextReaderId++;
        if (n3 != 2 || !this.fValidator.externalReferenceInContent(n4)) {
            this.fEntityType = 2;
            this.fPublicId = null;
            this.fSystemId = this.fSystemId;
            int n7 = -1;
            n7 = n3 == 2 || n3 == 1 ? this.fValidator.getEntityValue(n4) : this.fValidator.valueOfReferenceInAttValue(n4);
            this.startReadingFromInternalEntity(n7, false);
            return false;
        }
        this.fEntityType = 3;
        this.fPublicId = this.fValidator.getPublicIdOfEntity(n4);
        this.fSystemId = this.fValidator.getSystemIdOfEntity(n4);
        return this.startReadingFromExternalEntity(true);
    }

    private boolean startReadingFromExternalEntity(boolean bl) throws Exception {
        Object[] objectArray;
        String string;
        this.sendStartEntityNotifications();
        ReaderState readerState = (ReaderState)this.fReaderStack.peek();
        this.fSystemId = this.expandSystemId(this.fSystemId, readerState.systemId);
        InputSource inputSource = this.fSource = this.fResolver == null ? null : this.fResolver.resolveEntity(this.fPublicId, this.fSystemId);
        if (this.fSource == null) {
            this.fSource = new InputSource(this.fSystemId);
            if (this.fPublicId != null) {
                this.fSource.setPublicId(this.fPublicId);
            }
        }
        boolean bl2 = false;
        try {
            this.fReader = this.fReaderFactory.createReader(this.fEntityHandler, this.fErrorReporter, this.fSource, this.fSystemId, bl2, this.fStringPool);
        }
        catch (MalformedURLException malformedURLException) {
            this.fReader = null;
            string = this.fSystemId;
            this.sendEndEntityNotifications();
            this.popReader();
            this.popEntity();
            objectArray = new Object[]{string};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, objectArray, 2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fReader = null;
            string = this.fSystemId;
            this.sendEndEntityNotifications();
            this.popReader();
            this.popEntity();
            objectArray = new Object[]{string};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 5, 0, objectArray, 2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fReader = null;
            this.sendEndEntityNotifications();
            this.popReader();
            this.popEntity();
            objectArray = unsupportedEncodingException.getMessage();
            if (objectArray == null) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 70, 72, null, 2);
            }
            if (!XMLCharacterProperties.validEncName((String)objectArray)) {
                Object[] objectArray2 = new Object[]{objectArray};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 40, 42, objectArray2, 2);
            }
            Object[] objectArray3 = new Object[]{objectArray};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 61, 60, objectArray3, 2);
        }
        if (this.fReader == null || !bl) {
            this.sendReaderChangeNotifications();
            return false;
        }
        int n = this.fReaderId;
        this.sendReaderChangeNotifications();
        boolean bl3 = this.fReader.lookingAtChar('<', false);
        if (n != this.fReaderId) {
            bl3 = false;
        }
        return bl3;
    }

    public void startReadingFromExternalSubset(String string, String string2, int n) throws Exception {
        this.pushEntity(true, -1);
        this.pushReader();
        this.pushNullReader();
        this.fEntityName = -1;
        this.fEntityType = 6;
        this.fEntityContext = 7;
        this.fReaderDepth = n;
        this.fReaderId = this.fNextReaderId++;
        this.fPublicId = string;
        this.fSystemId = string2;
        this.startReadingFromExternalEntity(false);
    }

    private void startReadingFromInternalEntity(int n, boolean bl) throws Exception {
        this.fSource = null;
        this.sendStartEntityNotifications();
        this.fReader = this.fReaderFactory.createStringReader(this, this.fErrorReporter, this.fSendCharDataAsCharArray, this.getLineNumber(), this.getColumnNumber(), n, this.fStringPool, bl);
        this.sendReaderChangeNotifications();
    }

    private boolean startReadingFromParameterEntity(int n, int n2, int n3) throws Exception {
        int n4 = this.fValidator.lookupParameterEntity(n);
        if (n4 == -1) {
            return false;
        }
        if (!this.pushEntity(true, n)) {
            Object[] objectArray = new Object[]{this.fStringPool.toString(n), this.entityReferencePath(true, n)};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 72, 73, objectArray, 2);
            return false;
        }
        this.pushReader();
        this.fEntityName = n;
        this.fEntityContext = n3;
        this.fReaderDepth = n2;
        this.fReaderId = this.fNextReaderId++;
        if (!this.fValidator.isExternalParameterEntity(n4)) {
            this.fEntityType = 0;
            this.fPublicId = null;
            this.fSystemId = this.fSystemId;
            int n5 = this.fValidator.getParameterEntityValue(n4);
            this.startReadingFromInternalEntity(n5, this.fEntityContext != 4);
            return false;
        }
        this.fEntityType = 1;
        this.fPublicId = this.fValidator.getPublicIdOfParameterEntity(n4);
        this.fSystemId = this.fValidator.getSystemIdOfParameterEntity(n4);
        return this.startReadingFromExternalEntity(true);
    }

    public void stopReadingFromExternalSubset() throws Exception {
        if (!(this.fReader instanceof NullReader)) {
            throw new RuntimeException("cannot happen 18");
        }
        this.popReader();
        this.sendReaderChangeNotifications();
    }

    public abstract void unparsedEntityDecl(int var1, int var2, int var3, int var4) throws Exception;

    public boolean validEncName(String string) {
        return XMLCharacterProperties.validEncName(string);
    }

    public boolean validVersionNum(String string) {
        return XMLCharacterProperties.validVersionNum(string);
    }

    private class ReaderState {
        XMLEntityHandler.EntityReader reader;
        InputSource source;
        int entityName;
        int entityType;
        int entityContext;
        String publicId;
        String systemId;
        int readerId;
        int depth;
        ReaderState nextReaderState;

        ReaderState() {
        }
    }

    private final class NullReader
    implements XMLEntityHandler.EntityReader {
        public int addString(int n, int n2) {
            return -1;
        }

        public int addSymbol(int n, int n2) {
            return -1;
        }

        public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
        }

        public int currentOffset() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public boolean getInCDSect() {
            return false;
        }

        public int getLineNumber() {
            return -1;
        }

        public boolean lookingAtChar(char c, boolean bl) {
            return false;
        }

        public boolean lookingAtSpace(boolean bl) {
            return false;
        }

        public boolean lookingAtValidChar(boolean bl) {
            return false;
        }

        public int scanAttValue(char c, boolean bl) {
            return -3;
        }

        public int scanCharRef(boolean bl) {
            return -2;
        }

        public int scanContent(int n) throws Exception {
            return 9;
        }

        public int scanEntityValue(int n, boolean bl) {
            return -4;
        }

        public boolean scanExpectedName(char c, StringPool.CharArrayRange charArrayRange) {
            return false;
        }

        public int scanInvalidChar() {
            return -1;
        }

        public int scanName(char c) {
            return -1;
        }

        public int scanQName(char c) {
            return -1;
        }

        public int scanStringLiteral() {
            return -1;
        }

        public void setInCDSect(boolean bl) {
        }

        public void skipPastName(char c) {
        }

        public void skipPastNmtoken(char c) {
        }

        public void skipPastSpaces() {
        }

        public void skipToChar(char c) {
        }

        public boolean skippedString(char[] cArray) {
            return false;
        }
    }
}

