/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.utils.StringPool;

public class DeferredEntityImpl
extends EntityImpl
implements DeferredNode {
    static final long serialVersionUID = 4760180431078941638L;
    protected transient int fNodeIndex;

    DeferredEntityImpl(DeferredDocumentImpl deferredDocumentImpl, int n) {
        super(deferredDocumentImpl, null);
        this.fNodeIndex = n;
        this.syncData = true;
        this.syncChildren = true;
    }

    public int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected void synchronizeChildren() {
        this.syncChildren = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        int n = deferredDocumentImpl.getFirstChild(this.fNodeIndex);
        while (n != -1) {
            DeferredNode deferredNode = deferredDocumentImpl.getNodeObject(n);
            this.appendChild(deferredNode);
            n = deferredDocumentImpl.getNextSibling(n);
        }
    }

    protected void synchronizeData() {
        this.syncData = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        this.name = deferredDocumentImpl.getNodeNameString(this.fNodeIndex);
        StringPool stringPool = deferredDocumentImpl.getStringPool();
        int n = deferredDocumentImpl.getNodeValue(this.fNodeIndex);
        deferredDocumentImpl.getNodeType(n);
        this.publicId = stringPool.toString(deferredDocumentImpl.getNodeName(n));
        this.systemId = stringPool.toString(deferredDocumentImpl.getNodeValue(n));
        this.notationName = stringPool.toString(deferredDocumentImpl.getFirstChild(n));
    }
}

