//  Source File Name: mSQLApplt.java  %I%
//
//  Licensed Materials -- Property of IBM
//
//  (c) Copyright International Business Machines Corporation, 1996, 1997.
//      All Rights Reserved.
//
//  US Government Users Restricted Rights -
//  Use, duplication or disclosure restricted by
//  GSA ADP Schedule Contract with IBM Corp.

// This sample program shows how to write a Java applet using the
// JDBC applet driver to access a DB2 database.
//

// Run this sample by the following steps:
// (1) run db2sampl to create and populate the "sample" database
// (2) modify the DB2Applt.html according to the instructions there
// (4) start our JDBC applet server on some TCP/IP port: db2jstrt portno
// (5) run this sample: install the applet and the HTML file according
//     to the documentation, run it from a Java-enabled brower.

import java.sql.*;
import java.awt.*;
import java.applet.Applet;

public class mSQLApplt extends Applet {

   static {
      try {
         // register the driver with DriverManager
         // The newInstance() call is needed for the sample to work with
         // JDK 1.1.1 on OS/2, where the Class.forName() method does not
         // run the static initializer. For other JDKs, the newInstance
         // call can be omitted.

         Class.forName("com.imaginary.sql.msql.MsqlDriver").newInstance();
      } catch (Exception e) {
         e.printStackTrace();
      }
   }

   Connection con;

   public void init() {
      resize(350,325);


      try {
         // get parameter values from the html page
         String server = getParameter("server");
         String port = getParameter("port");

         // construct the URL ( sample is the database name )
         String url = "jdbc:msql://" + server + ":" + port + "/UserBase";

         String userid = getParameter("userid");
         String password = getParameter("password");

         // connect to database with userid and password
         con = DriverManager.getConnection(url, userid, password );

      } catch( Exception e ) {
         e.printStackTrace();
      }
   }

   public void paint(Graphics g) {
      try {
         // retrieve data from database
         g.drawString("First, let's retrieve some data from the database...", 10, 10);
         Statement stmt = con.createStatement();
         ResultSet rs = stmt.executeQuery("SELECT * from userpassword order by Userid");
         g.drawString("Received results:", 10, 25);

         // display the result set
         // rs.next() returns false when there are no more rows
         int y = 50;
         int i = 0;
         while (rs.next() && (i<4)) {
            i++;
            String a= rs.getString(1);
            String str = rs.getString(2);
            String oneLine = "Userid= " + a + " Password= " + str;
            g.drawString(oneLine, 20, y );
            y = y + 20;

         }
         stmt.close();

         // update the database
         g.drawString("Update...", 10, 200);
         stmt = con.createStatement();
         int rowsUpdated = stmt.executeUpdate("UPDATE userpassword set Password = 'user01' where Userid = 'user01'");

         // display the number of rows updated
         String msg = "Updated " + rowsUpdated;

         if (1 == rowsUpdated)
            msg = msg +" row.";
         else
            msg = msg +" rows.";
         y = y + 40;
         g.drawString(msg, 20, y);

         stmt.close();
      } catch( Exception e ) {
	System.err.println("Exception!");
         e.printStackTrace();
      }
   }
}
