/* mr2ice address name utility - jt Jan 1997 level proglevel */
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs
proglevel = 1.0
say 'adrnames.cmd level' proglevel

arg inarg test .

if \ ( (inarg=0) | (inarg=1)|(inarg=2)|(inarg=3))  then do
   say "Usage is adrnames 0|1|2|3 [test]  This utility manipulates an MR2ICE"
   say "address book to extract a NAME from the email address"
   say "in one of the forms suggested by the RFC or in common use:"
   say '1     "Joe Blow" <jb123@windy.com'
   say '2     Joe Blow <jb123@windy.com'
   say '3     jb123@windy.com (Joe Blow)'
   say ' '  
   say 'and reformat all names to one of these forms (0 deletes names);'
   say 'you must select one of these options'
   say ''
   say 'This reads mr2i.adr as input and rewrites it (the old one is saved'
   say 'as mr2iadr.bk unless the 2nd argument is test, in which case it'
   say 'will read mr2i.adr and create a file named mr2inew.adr'
   say 'To use:  exit mr2ice, cd to your mr2ice directory.'
   say 'invoke adrnames with an argument of 0, 1,2, or 3 '
   say 'Then start mr2ice and review the entries in the address book'
   say ''
   say 'There is some error checking, but this may barff on some ill-formed'
   say 'email addresses.  Bug reports to jt@epix.net; flames to /dev/null'
   exit
   end

/* based on these assumptions: */
/* address file entries are of the form name \ email \ flag \ tag */
/* but anything after flag will be preserved if Nick adds additional fields */
/* the comment field is optional, */
/* begins with a ^A, and consists of 3 lines total */

adrfile = 'mr2i.adr'

signal on notready
which = adrfile
if lines(adrfile) = 0 then signal notready
call lineout(adrfile)   /* close file */
which = ''

if test <> "TEST" then do
   infile = 'mr2iadr.bk'
   outfile = adrfile
   if stream(infile,C,QUERY EXISTS) > '' then '@del' infile '> NUL'
   '@rename' outfile infile   '>NUL' 
   end
else do
    infile = adrfile
    outfile = 'mr2inew.adr'
    if stream(outfile,C,QUERY EXISTS) > '' then '@del' outfile '> NUL'
    end
   

do while lines(infile)
   line = linein(infile)
   if substr(line,1,1) = '' then do
      call lineout outfile,line
      line = linein(infile)  /* also the next 2 lines */
      call lineout outfile,line
      line = linein(infile)  
      call lineout outfile,line
      end
   else do
      parse var line name '\' email '\' rest
      if (check4name(email) = 0)| (name='') then outline = line
         else call buildline 
      call lineout outfile,outline
      end
    end /* processing of line */
call lineout(outfile)   /* close output file */
say "all done"
exit

check4name: PROCEDURE
    ARG  x
    /* check for " < or (  */
    if (pos('"',x) + pos('<',x) + pos('(',x))>0 then rv=1
    else rv = 0
    return rv

buildline: PROCEDURE expose inarg name nam email rest outline adr

   /* 1     "Joe Blow" <jb123@windy.com  */
   /* 2     Joe Blow <jb123@windy.com    */
   /* 3     jb123@windy.com (Joe Blow)   */
   /* 0     jb123@windy.com              */
   call splitter    /* splitter splits email into nam and adr */
   select
       when (inarg = 0) then do 
           newemail = adr
	   end
       when (inarg = 1) then do 
	   if pos('"',nam)>0 then do
	      newemail = adr
	      say name email 'not processed due to " in name'
	      end
           else newemail = '"'||nam||'" <'||adr||'>'
	   end
       when (inarg = 2) then do
            if (pos('.',nam)+pos('!',nam)+pos('@',nam))>0 then do
	      newemail = adr
	      say name email 'not processed due to ! @ or . in name'
	      end
            else newemail = nam||' <'||adr||'>'
            end
       when (inarg = 3) then do 
	   if (pos('(',nam)+pos(')',nam))>0 then do
	      newemail = adr
	      say name email 'not processed due to ( or ) in name'
	      end
           else newemail = adr '('||nam||')'
	   end
       otherwise ;
       end

    outline = name||'\'||newemail||'\'||rest
    return 

splitter: PROCEDURE expose inarg name nam email rest outline adr
/*  has an email field of the form    Joe Blow <jb123@windy.com> */
/*  or                                jb123@windy.com (Joe Blow) */
/* name may or may not be quoted; quotes are stripped            */
/* nam holds extracted name; adr extracted address               */
parse var email w1 residue
if pos('@',w1)>0 then do
   /* we have form 3 or no name */
   adr = w1
   if (pos('(',residue) <>1)|(pos(')',residue)<length(residue)) then do
      /* either no name or bad format */
      nam = ''
      if length(residue)>0 then say name email 'not processed; email fmt error'
      end
   else nam=substr(residue,2,length(residue)-2)
   end
else do 
   /* something of the form name <jb123@windy.com> */
   parse var email w1 '<' adr '>' residue
   if pos('"',w1)=1 then parse var w1 '"' nam '"'  
     else nam = w1
   end
return
notready:
say which " file error"
exit
