/* mr2ice address utility - jt Jan 1997 proglevel */
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs
proglevel = 1.00
say 'ADRFIX.cmd level' proglevel

arg inarg test .

if \ ((inarg=1)|(inarg=2)|(inarg=3))  then do
   say "Usage is adrfix 1|2|3 [test]  This utility manipulates an MR2ICE"
   say "address book to put the NAME field as part of the email address"
   say "in one of the forms suggested by the RFC or in common use:"
   say '1     "Joe Blow" <jb123@windy.com'
   say '2     Joe Blow <jb123@windy.com'
   say '3     jb123@windy.com (Joe Blow)'
   say 'you must select one of these options'
   say ''
   say 'If an entry appears to already have a name in the email address'
   say 'it is not changed.'
   say ''
   say 'This reads mr2i.adr as input and rewrites it (the old one is saved'
   say 'as mr2iadr.bk unless the 2nd argument is test, in which case it'
   say 'will read mr2i.adr and create a file named mr2inew.adr'
   say 'To use:  exit mr2ice, cd to your mr2ice directory.'
   say 'invoke adrfix with an argument of 1,2, or 3 '
   say 'Then start mr2ice and review the entries in the address book'
   exit
   end

/* based on these assumptions: */
/* address file entries are of the form name \ email \ flag \ tag */
/* but anything after flag will be preserved if Nick adds additional fields */
/* the comment field is optional, */
/* begins with a ^A, and consists of 3 lines total */

adrfile = 'mr2i.adr'

signal on notready
which = adrfile
if lines(adrfile) = 0 then signal notready
call lineout(adrfile)   /* close file */
which = ''

if test <> "TEST" then do
   infile = 'mr2iadr.bk'
   outfile = adrfile
   if stream(infile,C,QUERY EXISTS) > '' then '@del' infile '> NUL'
   '@rename' outfile infile   '>NUL' 
   end
else do
    infile = adrfile
    outfile = 'mr2inew.adr'
    if stream(outfile,C,QUERY EXISTS) > '' then '@del' outfile '> NUL'
    end
   

do while lines(infile)
   line = linein(infile)
   if substr(line,1,1) = '' then do
      call lineout outfile,line
      line = linein(infile)  /* also the next 2 lines */
      call lineout outfile,line
      line = linein(infile)  
      call lineout outfile,line
      end
   else do
      parse var line name '\' email '\' rest
      if (check4name(email) = 1)| (name='') then outline = line
         else call buildline 
      call lineout outfile,outline
      end
    end /* processing of line */
call lineout(outfile)   /* close output file */
say "all done"
exit

check4name: PROCEDURE
    ARG  x
    /* check for " < or (  */
    if (pos('"',x) + pos('<',x) + pos('(',x))>0 then rv=1
    else rv = 0
    return rv

buildline: PROCEDURE expose inarg name email rest outline

   /* 1     "Joe Blow" <jb123@windy.com  */
   /* 2     Joe Blow <jb123@windy.com    */
   /* 3     jb123@windy.com (Joe Blow)   */
   select
       when (inarg = 1) then do 
	   if pos('"',name)>0 then do
	      newemail = email
	      say name email 'not processed due to " in name'
	      end
           else newemail = '"'||name||'" <'||email||'>'
	   end
       when (inarg = 2) then do
            if (pos('.',name)+pos('!',name)+pos('@',name))>0 then do
	      newemail = email
	      say name email 'not processed due to ! @ or . in name'
	      end
            else newemail = name||' <'||email||'>'
            end
       when (inarg = 3) then do 
	   if (pos('(',name)+pos(')',name))>0 then do
	      newemail = email
	      say name email 'not processed due to ( or ) in name'
	      end
           else newemail = email '('||name||')'
	   end
       otherwise ;
       end

    outline = name||'\'||newemail||'\'||rest
    return 

notready:
say which " file error"
exit
