/*                  Installationsprogramm von VideoOS2                       */
/*                           von Heiko Casper                                */

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

call SysCls

say ''
say '**************************************************************************'
say '*                                                                        *'
say '*                     Installation von VideoOS/2                         *'
say '*                                                                        *'
say '**************************************************************************'
say ''

/* Es wird berprft, ob alle bentigten Dateien im aktuellen Verzeichnis */
/* vorhanden sind.                                                        */
aktuellesVerzeichnis = DIRECTORY()
if right(aktuellesVerzeichnis,1)<>'\' then
  aktuellesVerzeichnis = aktuellesVerzeichnis'\' 
call SysFileTree aktuellesVerzeichnis'VideoOS2.EXE', 'Ergebnis', 'F'
if Ergebnis.0=0 then
  call FehlerDatei
call SysFileTree aktuellesVerzeichnis'VideoOS2.HLP', 'Ergebnis', 'F'
if Ergebnis.0=0 then
  call FehlerDatei
call SysFileTree aktuellesVerzeichnis'VideoOS2.INI', 'Ergebnis', 'F'
if Ergebnis.0=0 then
  call FehlerDatei
call SysFileTree aktuellesVerzeichnis'LiesMich.TXT', 'Ergebnis', 'F'
if Ergebnis.0=0 then
  call FehlerDatei
call SysFileTree aktuellesVerzeichnis'Register.TXT', 'Ergebnis', 'F'
if Ergebnis.0=0 then
  call FehlerDatei
call SysFileTree aktuellesVerzeichnis'Lizenz.TXT', 'Ergebnis', 'F'
if Ergebnis.0=0 then
  call FehlerDatei
call SysFileTree aktuellesVerzeichnis'Video1.ICO', 'Ergebnis', 'F'
if Ergebnis.0=0 then
  call FehlerDatei
call SysFileTree aktuellesVerzeichnis'Video2.ICO', 'Ergebnis', 'F'
if Ergebnis.0=0 then
  call FehlerDatei
call SysFileTree aktuellesVerzeichnis'3DVideo1.ICO', 'Ergebnis', 'F'
if Ergebnis.0=0 then
  call FehlerDatei
call SysFileTree aktuellesVerzeichnis'3DVideo2.ICO', 'Ergebnis', 'F'
if Ergebnis.0=0 then
  call FehlerDatei

/* Das Laufwerk, auf das installiert werden soll, wird abgefragt und berprft. */
say 'Geben sie das Laufwerk an, auf das das Programm installiert werden soll,'
say 'z.B. D. Wenn sie kein Laufwerk angeben, wird auf C installiert.'

pull Laufwerk
if Laufwerk='' then
  Laufwerk = 'C'
else if length(Laufwerk)<>1 then
  call Fehler
Laufwerk = Laufwerk':'

LaufwerkInfo = SysDriveInfo(Laufwerk)
if LaufwerkInfo='' then
  call FehlerLaufwerk

/* Das Verzeichnis, in das installiert werden soll, wird abgefragt und erstellt. */
say 'Geben die das Verzeichnis an, in das das Programm installiert werden soll.'
say 'Wenn sie kein Verzeichnis angeben, wird in "\VIDEOOS2" installiert.'

pull Verzeichnis
if Verzeichnis='' then
  Verzeichnis = '\VideoOS2'
if left(Verzeichnis,1)<>'\' then
  Verzeichnis = '\'Verzeichnis
if right(Verzeichnis,1)='\' then
  Verzeichnis = left(Verzeichnis,length(Verzeichnis)-1)  

NeuesVerzeichnis = Laufwerk''Verzeichnis
call SysFileTree NeuesVerzeichnis, 'Ergebnis', 'D'
if ergebnis.0=0 then
do
  rc = SysMkDir(NeuesVerzeichnis)
  if rc<>0 then
    call FehlerVerzeichnis
end

/* Die Dateien werden in das ausgewhlte Verzeichnis kopiert.              */
copy 'VideoOS2.EXE' NeuesVerzeichnis
copy 'VideoOS2.HLP' NeuesVerzeichnis
copy 'LiesMich.TXT' NeuesVerzeichnis
copy 'Lizenz.TXT' NeuesVerzeichnis
copy 'Register.TXT' NeuesVerzeichnis
copy 'Install.CMD' NeuesVerzeichnis
copy 'Video1.ICO' NeuesVerzeichnis
copy 'Video2.ICO' NeuesVerzeichnis
copy '3DVideo1.ICO' NeuesVerzeichnis
copy '3DVideo2.ICO' NeuesVerzeichnis
call SysFileTree NeuesVerzeichnis'\VideoOS2.INI', 'Ergebnis', 'F'
if Ergebnis.0<>1 then
  copy 'VideoOS2.INI' NeuesVerzeichnis

/* Das Programmsymbol wird auf der Arbeitsoberflche erstellt. */
Pfad      = 'STARTUPDIR='NeuesVerzeichnis
Programm  = 'EXENAME='NeuesVerzeichnis
IF RIGHT(Programm,1)='\' then
  Programm = Programm'VideoOS2.EXE'
else
  Programm = Programm'\VideoOS2.EXE'
Parameter = Programm';'Pfad';ASSOCFILTER=*.VDB'
IF SysCreateObject('WPProgram', 'VideoOS/2', '<WP_DESKTOP>',,
  Parameter, 'REPLACE') then
  SAY "VideoOS/2 wurde erfolgreich installiert !"
else
  call Fehler

exit

Fehler: procedure
  say 'Es ist ein Fehler aufgetreten! Die Installation wurde abgebrochen.'
  exit
return

FehlerLaufwerk: procedure
  say 'Die Laufwerksangabe ist ungltig! Die Installation wurde abgebrochen.'
  exit
return

FehlerVerzeichnis: procedure
  say 'Das angegebene Verzeichnis konnte nicht erstellt werden!'
  say 'Die Installation wurde abgebrochen.'
  exit
return

FehlerDatei: procedure
  say 'Es fehlt eine zur Installation notwendige Datei!'
  say 'Die Installation wurde abgebrochen.'
  exit
return

