/*****************************/
/* REXX command-line install */
/*****************************/
/*         Small Clock       */
/*****************************/

'@echo off'
'cls'

SIGNAL ON FAILURE
SIGNAL ON ERROR

CALL RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
CALL SysLoadFuncs

CurDir=DIRECTORY()

say ''
say '*********************************************'
say '*    Welcome to the Small Clock Install     *'
say '*********************************************'
say ''
say 'The install will create objects on your desktop using the'
say 'current directory.  If this is not what you want, move the'
say 'program file(s) to their destination directory and re-run'
say 'the install program.'
say ''
call charout,'Press any key to start Install or Q to quit...'
parse upper value SysGetKey('NOECHO') with key
if key='Q' then
  EXIT

say ''

classname='WPProgram'
title='Small Clock'
location='<WP_DESKTOP>'
setup='EXENAME='||CurDir||'\SML_CLK.EXE;OBJECTID=<SMLCLK_PROG>;'
option='R'
call BldObj

say ''
call charout,'Would you like to place Small Clock in your start-up folder also (Y/N)? '
parse upper value SysGetKey('NOECHO') with key
if key ='Y' then
  do
    classname='WPProgram'
    title='Small Clock'
    location='<WP_START>'
    setup='EXENAME='||CurDir||'\SML_CLK.EXE;OBJECTID=<SMLCLK_START>;'
    option='R'
    say ''
    call BldObj
  end

if STREAM('VROBJ.DLL','C','QUERY EXISTS') \= '' then
do
  StartupDrive=SysSearchPath('PATH','CONFIG.SYS')
  StartupDrive=FILESPEC("drive",StartupDrive)
  say ''
  say 'VROBJ.DLL must be present in a directory contained in the LIBPATH'
  say 'variable in config.sys.  I recommend '||StartupDrive||'\OS2\DLL'
  call charout,'Would you like to copy VROBJ.DLL to '||StartupDrive||'\OS2\DLL (Y/N)?'
  parse upper value SysGetKey('NOECHO') with key
  say ''
  if key ='Y' then
       'COPY VROBJ.DLL '||StartupDrive||'\OS2\DLL > nul'
  else
       say 'Okay, then remember to place VROBJ.DLL in a directory contained in your LIBPATH!'
end

say ''
call charout,'Press any key to exit...'
key=SysGetKey('NOECHO')
EXIT

/* Build Object Procedure */
BldObj:
call charout ,'Building: 'title substr(classname,3,)

result = SysCreateObject(classname, title, location, setup, option)

If result=1 Then call charout ,' ...Created!'
else
  call charout ,' ...Not created! Return code='result
say ' '
Return

/*****************************************************************************/
 * Standard REXX program error handler
 *****************************************************************************/
ERROR:
    say ''
    SAY 'An install error has occurred...'
    EXIT

FAILURE:
    say ''
    SAY 'An install error has occurred...'
    EXIT

/* End */
