/* install.cmd -- Builds a Shoebox folder and icons  */

address CMD

'@echo off'

call RXFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

call setlocal

/* Check if Target exists */

 target_dir  = ''
folder_title = ''

parse arg target_dir folder_title

if( folder_title = '' )then
    folder_title = 'Shoebox'

if( target_dir = '' )then
    target_dir = directory()

target_dir = directory( target_dir )

if( right( target_dir, 2 ) = ':\' )then do
    target_dir = left( target_dir, length( target_dir ) - 1 );
end 


/*
 * Create the main folder object
 */

say 'Building Shoebox Objects...'

classname = 'WPFolder'
title     = folder_title
location  = '<WP_DESKTOP>'
/* iconparm  = 'ICONFILE=' || target_dir || '\watcom2.ico;' */
setup     = 'OBJECTID=<Shoebox_FOLDER>;'/* || iconparm */

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Create the Shoebox program object
 */

classname = 'WPProgram'
title     = 'Shoebox'
location  = '<Shoebox_FOLDER>'
setup     = 'EXENAME=' || target_dir || '\SHOEBOX.EXE;' ||,
            'PROGTYPE=PM;' ||,
            'ASSOCFILTER=*.SDB;' ||,
            'ASSOCTYPE=Shoebox File;'

call SysCreateObject classname, title, location, setup, 'r'

/*
 * Add Templates
 */

 classname = 'WPDataFile'
    title     = 'Shoe.SDB'
    location  = '<Shoebox_FOLDER>'
    setup     = ''
    setup     = 'OBJECTID=<Shoebox_TEMPLATE>;' ||,
                'TEMPLATE=yes;'

    call SysCreateObject classname, title, location, setup, 'r' 

/*
 * Create Shadows
 */

classname = 'WPShadow'
title     = 'Demo.SDB'
location  = '<Shoebox_FOLDER>'
setup     = 'SHADOWID=' || target_dir || '\demo.sdb'  
call SysCreateObject classname, title, location, setup, 'r'

classname = 'WPShadow'
title     = 'read.me'
location  = '<Shoebox_FOLDER>'
setup     = 'SHADOWID=' || target_dir || '\read.me'  
call SysCreateObject classname, title, location, setup, 'r'


say "Shoebox Object Creation Complete"

