/*
     Randomizer.cmd
     Randomizer v3.1 by Don Eitner, 2000

     Selects random items from a user-defined set of fields.

     This code is neither supported nor under warranty.  Feel free to
     examine and modify this script for your own purposes.  See the
     included readme.txt for additional information.
*/

parse arg CmdLine
parse var CmdLine CL1 CmdLine
CL1 = translate(CL1)

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call SysCls

DataFile = ''

call ParseInput

call SysCls

Fields = linein(DataFile,,1)
Count = words(Fields)

do Num = 1 to Count
    Item.Num = linein(DataFile,,1)
    Field.Num = word(Fields, Num)

    if Pos('',Field.Num) = 1 then
	   Count2 = trunc(random(1, words(Item.Num)) / 2)
    else
	   Count2 = 1

    if Pos('',Field.Num) = 1 then
	   Field.Num = substr(Field.Num,2)
    X1 = lastpos('', Field.Num)
    do while X1 <> '0'
	   Data2 = substr(Field.Num, X1+1)
	   Data1 = substr(Field.Num, 1, X1-1)
	   Field.Num = Data1||' '||Data2
	   X1 = lastpos('', Field.Num)
    end

    do Rands = 1 to Count2
    	   Rand = random(1, words(Item.Num))
	   Data.Num = word(Item.Num, Rand)

	   X1 = lastpos('', Data.Num)
	   do while X1 <> '0'
		  Data2 = substr(Data.Num, X1+1)
		  Data1 = substr(Data.Num, 1, X1-1)
		  Data.Num = Data1||' '||Data2
		  X1 = lastpos('', Data.Num)
	   end

        Item.Num = delword(Item.Num, Rand, 1)

	   say Field.Num' : 'Data.Num
    end

end

call lineout(DataFile)

exit


ParseInput:

Again:

    if (CL1 = '/Y') then
    do
	   if DataInput = 'N' then
            signal GiveHelp
	   DataInput = 'Y'
	   parse var CmdLine CL1 CmdLine
	   CL1 = translate(CL1)
	   signal Again
    end

    if (CL1 = '/N') then
    do
	   if DataInput = 'Y' then
            signal GiveHelp
        DataInput = 'N'
	   parse var CmdLine CL1 CmdLine
	   CL1 = translate(CL1)
	   signal Again
    end

    if (CL1 = '/D') then
    do
        parse var CmdLine CL1 CmdLine
	   DataFile = CL1
	   parse var CmdLine CL1 CmdLine
	   CL1 = translate(CL1)
	   signal Again
    end

    if DataFile = '' then
        DataFile = 'RandomData.dat'

    select
        when DataInput = 'N' then
		  return
	   when DataInput = 'Y' then
		  call DataInput(DataFile)
	   otherwise
	   do
		  do until (datatype(Junk) = 'CHAR') & (Junk = 'Y' | Junk = 'N')
			 say 'Would you like to edit the list of fields & items (Y/N)?'
			 Junk = translate(SysGetKey('NOECHO'))
		  end
		  if (Junk = 'Y') then
			 call DataInput(DataFile)
	   end
    end

return


GiveHelp:

    say 'Randomizer v3.0, 2000 by Don Eitner'
    say 'Universal random item selector.'
    say ''
    say ' Usage:  Randomizer [[/Y | /N] [/D DataFile]] [/?]'
    say ''
    say '  Only one or the other parameter may be given, or neither.'
    say '  If neither is given, program will prompt for input mode.'
    say ''
    say '  /Y = sets input mode on so you can add fields and items'
    say '       to selected data file'
    say '  /N = sets input mode off so you just get random selection'
    say '       from selected data file'
    say '  /D = allows you to choose the name of the data file to use'
    say '  /? = shows this help screen'

exit

