/*
     DataInput.cmd
     Randomizer v3.1 by Don Eitner, 2000

     Sets up user-defined fields and items for Randomizer.cmd.

     This code is neither supported nor under warranty.  Feel free to
     examine and modify this script for your own purposes.  See the
     included readme.txt for additional information.
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse arg DataFile

call AnsiSetup

if DataFile = '' then
do
    say 'Enter the name of the data file you wish to use.'
    parse pull DataFile
    if DataFile = '' then
	   DataFile = 'RandomData.dat'
end

Fields = linein(DataFile,,1)
Count = words(Fields)

do Num = 1 to Count
    Item.Num = linein(DataFile,,1)
end

call lineout(DataFile)

do forever
    call FieldMenu
    if Save = 1 then
	   signal SaveIt
end

exit


SaveIt:

    RC = SysFileDelete(DataFile)
    call lineout DataFile, Fields
    do Num = 1 to Count
	   call lineout DataFile, Item.Num
    end
    call lineout(DataFile)

return


FieldMenu:

    Count = words(Fields)
    call SysCls
    say center('Main Fields Menu', 80)
    do Num = 1 to Count
	   Data.Num = word(Fields, Num)
        Display.Num = Data.Num

	   X1 = lastpos('', Display.Num)
	   do while X1 <> '0'
		  Data2 = substr(Display.Num, X1+1)
		  Data1 = substr(Display.Num, 1, X1-1)
		  Display.Num = Data1||' '||Data2
		  X1 = lastpos('', Display.Num)
	   end

	   call ArrangeDisplay
	   call SysCurPos Row, Col
	   say '('||Num||')' Display.Num
    end
    call SysCurPos 17, 0
    say copies('-', 80)
    call SysCurPos 17, 28
    say LWhi||'Please Select From Below'||Non
    call SysCurPos 18, 8
    say '('||LBro||'A'||Non||')dd a Field  ('||LBro||'D'||Non||')elete a Field  ('||LBro||'E'||Non||')dit a Field  ('||LBro||'M'||Non||')ark a field'
    call SysCurPos 19, 21
    say '('||LBro||'H'||Non||')elp  ('||LBro||'S'||Non||')ave & Exit  ('||LBro||'Q'||Non||')uit w/o Save'
    call SysCurPos 20, 0
    say copies('-', 80)
    parse upper pull Selection

    select
        when (datatype(Selection) = 'NUM') & (Selection <= Count) then
		  signal ItemMenu

	   when Selection = 'A' then
	   do
		  Fields = ''
		  say 'Enter new field name.'
		  Count = Count + 1
		  parse pull Data.Count
		  X1 = lastpos(' ', Data.Count)
		  do while X1 <> '0'
			 Data2 = substr(Data.Count, X1+1)
			 Data1 = substr(Data.Count, 1, X1-1)
			 Data.Count = Data1||''||Data2 /* That's ASCII code ALT-29 */
			 X1 = lastpos(' ', Data.Count)
		  end
		  Item.Count = 'editme!'
		  do Num = 1 to Count
			 Fields = Fields Data.Num
		  end
		  signal FieldMenu
	   end

	   when Selection = 'D' then
	   do
		  say 'Which field do you wish to delete?'
		  parse pull Selection2
		  if (Selection2 <= Count) & (Selection2 > 0) then
		  do
			 say 'Are you sure you want to delete this field and its items?'
			 parse pull Junk
			 if translate(Junk) = 'Y' then
			 do
				Fields = ''
				Data.Selection2 = ''
				Item.Selection2 = ''
				do Num = 1 to Count
				    Fields = Fields Data.Num
				end
				do Num = 2 to Count
				    PrevNum = Num - 1
				    if Item.PrevNum = '' then
				    do
					   Item.PrevNum = Item.Num
					   Item.Num = ''
				    end
				end
				signal FieldMenu
			 end
			 else
				signal FieldMenu
		  end
		  else
			 signal FieldMenu
	   end

	   when Selection = 'E' then
	   do
		  say 'Which field do you wish to edit?'
		  parse pull Selection2
		  if (Selection2 <= Count) & (Selection2 > 0) then
		  do
			 say 'Current value of field' Selection2 'is' Display.Selection2||'.  Enter new value.'
			 parse pull Data.Selection2
			 if Data.Selection2 = '' then
				signal FieldMenu
			 else
			 do
				Fields = ''
				X1 = lastpos(' ', Data.Selection2)
				do while X1 <> '0'
				    Data2 = substr(Data.Selection2, X1+1)
				    Data1 = substr(Data.Selection2, 1, X1-1)
				    Data.Selection2 = Data1||''||Data2
				    X1 = lastpos(' ', Data.Selection2)
				end
				do Num = 1 to Count
				    Fields = Fields Data.Num
				end
				signal FieldMenu
			 end
		  end
		  else
			 signal FieldMenu
	   end

	   when Selection = 'M' then
	   do
		  say 'Which field do you wish to mark/unmark for multiple selections?'
		  parse pull Selection3
		  if (Selection3 <= Count) & (Selection3 > 0) then
		  do
			 if pos('',Data.Selection3) = 1 then
				Data.Selection3 = substr(Data.Selection3,2)
			 else
				Data.Selection3 = ''||Data.Selection3
			 Fields = ''
			 do Num = 1 to Count
				Fields = Fields Data.Num
			 end
			 signal FieldMenu
		  end
		  else
			 signal FieldMenu
	   end

	   when Selection = 'H' then
	   do
		  call GiveHelp
	   end

	   when Selection = 'S' then
	   do
		  Save = '1'
		  return save
	   end

	   when Selection = 'Q' then
		  exit

	   otherwise
		  signal FieldMenu

	   Selection = ''

    end

return


ItemMenu:

    Count = words(Item.Selection)
    call SysCls
    say center(word(Fields, Selection) 'Sub-Menu', 80)
    do Num = 1 to Count
	   Data.Num = word(Item.Selection, Num)
        Display.Num = Data.Num

	   X1 = lastpos('', Display.Num)
	   do while X1 <> '0'
		  Data2 = substr(Display.Num, X1+1)
		  Data1 = substr(Display.Num, 1, X1-1)
		  Display.Num = Data1||' '||Data2
		  X1 = lastpos('', Display.Num)
	   end

	   call ArrangeDisplay
	   call SysCurPos Row, Col
	   say '('||Num||')' Display.Num
    end
    call SysCurPos 17, 0
    say copies('-', 80)
    call SysCurPos 17, 28
    say LWhi||'Please Select From Below'||Non
    call SysCurPos 18, 8
    say '('||LBro||'A'||Non||')dd an Item  ('||LBro||'D'||Non||')elete an item  ('||LBro||'E'||Non||')dit an Item  ('||LBro||'P'||Non||')revious Menu'
    call SysCurPos 19, 0
    say copies('-', 80)
    parse upper pull Selected

    select

	   when Selected = 'A' then
	   do
		  Item.Selection = ''
		  say 'Enter new item.'
		  Count = Count + 1
		  parse pull Data.Count
		  X1 = lastpos(' ', Data.Count)
		  do while X1 <> '0'
			 Data2 = substr(Data.Count, X1+1)
			 Data1 = substr(Data.Count, 1, X1-1)
			 Data.Count = Data1||''||Data2 /* That's ASCII code ALT-29 */
			 X1 = lastpos(' ', Data.Count)
		  end
		  do Num = 1 to Count
			 Item.Selection = Item.Selection Data.Num
		  end
		  signal ItemMenu
	   end

	   when Selected = 'D' then
	   do
		  say 'Which item do you wish to delete?'
		  parse pull Selected2
		  if (Selected2 <= Count) & (Selected2 > 0) then
		  do
			 say 'Are you sure you want to delete this item?'
			 parse pull Junk
			 if translate(Junk) = 'Y' then
			 do
			 Item.Selection = ''
				Data.Selected2 = ''
				do Num = 1 to Count
				    Item.Selection = Item.Selection Data.Num
				end
				signal ItemMenu
		  end
			 else
			 signal ItemMenu
		  end
		  else
			 signal ItemMenu
	   end

	   when Selected = 'E' then
	   do
		  say 'Which item do you wish to edit?'
		  parse pull Selected2
		  if (Selected2 <= Count) & (Selected2 > 0) then
		  do
			 say 'Current value of item' Selected2 'is' Display.Selected2||'.  Enter new value.'
			 parse pull Data.Selected2
			 if Data.Selected2 = '' then
				signal ItemMenu
			 else
			 do
				Item.Selection = ''
				X1 = lastpos(' ', Data.Selected2)
				do while X1 <> '0'
				    Data2 = substr(Data.Selected2, X1+1)
				    Data1 = substr(Data.Selected2, 1, X1-1)
				    Data.Selected2 = Data1||''||Data2
				    X1 = lastpos(' ', Data.Selected2)
				end
				do Num = 1 to Count
				    Item.Selection = Item.Selection Data.Num
				end
				signal ItemMenu
			 end
		  end
		  else
			 signal ItemMenu
	   end

	   when Selected = 'P' then
		  signal FieldMenu

	   otherwise
	   signal ItemMenu
    end

    Selected = ''

return


ArrangeDisplay:

    Num2 = Num
    if (Count / 45) > 1 then
	   do
		  HighCount = trunc(Count / 45)
		  do Count2 = 1 to HighCount
			 if (Num2 > (45 * Count2)) & (Num2 < (45 * (Count2 + 1)) + 1) then
			 do
				if Num2 = ((45 * Count2) + 1) then
				do
				    say 'Press ENTER for next screen of Numbers.'
				    pull Junk
				    call SysCls
				end
				Num2 = Num2 - (45 * Count2)
			 end
		  end
	   end

	   select
		  when (Num2 > 0) & (Num2 < 16) then
		  do
			 Row = Num2 + 1
			 Col = 2
		  end
		  when (Num2 > 15) & (Num2 < 31) then
		  do
			 Row = Num2 - 14
			 Col = 29
		  end
		  when (Num2 > 30) & (Num2 < 46) then
		  do
			 Row = Num2 - 29
			 Col = 56
		  end
	   end

return


GiveHelp:

    call SysCls
    say 'Add a Field allows you to create arrays from which other programs can'
    say 'select one or more items.'
    say
    say 'Delete a Field will delete an entire array of items permanently.'
    say LBro||'USE WITH GREAT CAUTION!'||Non
    say
    say 'Edit a Field allows you to edit the name of a chosen array.'
    say
    say 'Mark a Field allows you to set a chosen array to be selected from multiple'
    say 'times by a calling program which supports this (ie. randomizer2.cmd).'
    say
    say 'Save will save the currently open data file with the currently active'
    say 'array names and items within each array.'
    say
    say 'Quit will exit DataInput without saving changes you have made.'
    key = SysGetKey('NOECHO')

return


AnsiSetup:

    Esc=d2c(27)d2c(91)

/* Attributes */
    Hig=Esc'1m'
    Non=Esc'0m'

/* Foreground Colors */
    Bla=Esc'30m'
    Red=Esc'31m'
    Gre=Esc'32m'
    Bro=Esc'33m'
    Blu=Esc'34m'
    Pur=Esc'35m'
    Tur=Esc'36m'
    Whi=Esc'37m'
    LBla=Hig||Bla
    LRed=Hig||Red
    LGre=Hig||Gre
    LBro=Hig||Bro
    LBlu=Hig||Blu
    LPur=Hig||Pur
    LTur=Hig||Tur
    LWhi=Hig||Whi

/* Background Colors */
    BBla=Esc'40m'
    BRed=Esc'41m'
    BGre=Esc'42m'
    BBro=Esc'43m'
    BBlu=Esc'44m'
    BCya=Esc'45m'
    BTur=Esc'46m'
    BWhi=Esc'47m'

return

