/*
@echo off
cls
echo.
echo.
echo ERROR:
echo REXX support not installed
echo You must have REXX support installed to run this
echo program.
echo.
echo To run this program, run Selective Install from
echo your System Setup folder, and install REXX.
exit
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
/*-- get the command line --*/
parse arg sourcedir destdir

  /* Go search for the OS2.INI file, this will be our bootdrive */
  testos2path = SysSearchPath('PATH', 'OS2.INI');
  bootdrive = FILESPEC("drive", testos2path);
  os2path = FILESPEC("path",testos2path);

/*-- get dest dir --*/
if destdir = '' then do
  say ''
  say 'Please enter a directory name for PMMeal'
  say '(Default: 'bootdrive'\PMMeal):'
  /*-- if error --*/
  parse pull destdir
  if destdir = ' ' then do
    destdir = bootdrive'\PMMeal'
  end
end


  DestDrive = FILESPEC("drive", destdir)
if sourcedir = '' then do
  thisdir = directory()
  say ''
  say 'Please enter the directory where the program is being installed'
  say 'from(Default: 'thisdir'):'
  parse pull sourcedir
  /*-- if another error --*/
  if sourcedir = ' ' then do
    sourcedir = thisdir
    say 'using the current directory as the source directory.'
end

/*-- make sure path is good --*/
If substr( sourcedir, length(sourcedir), 1 ) \= '\' then
    sourcedir = sourcedir||'\'

/*-- Select language --*/

call sysfiletree sourcedir'*.lng','languages',"FO"
say 'Select the language you prefer'
say ''
say '  A = DEUTSCH'
do n=1 to languages.0
  languages.n=substr(languages.n,lastpos("\",languages.n)+1)
  languages.n=translate(left(languages.n,pos(".",languages.n)-1))
  say "  "d2c(65+n)" = "languages.n
end

l = c2d(translate(SysGetKey('NOECHO')))-65
if l>languages.0 | l<0 then do
  say
  say 'Installation cancelled.'
  exit
end

if l=0 then do
  language="DEUTSCH"
end; else do
  language=languages.l
end

/*-- do main screen --*/
call SysCls
say
say '                        PMMeal Installation'
say
say 'The Programm PMMeal will be Installed with the following settings:'
say
say '     Source directory: "'sourcedir'"'
say 'Destination directory: "'destdir'"'
say '             Language: "'language'"'
say
say 'Okay to continue(Y/n)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then do
  say
  say 'Installation cancelled.'
  exit
end

    call copyfiles sourcedir,destdir

     DestDrive
     "@CD "||destdir
 End
/*-- create a program object --*/
call SysCls

say
say 'Creating the program folder,'
x = SysCreateObject("WPFolder",,
                    "PMMeal",,
                    "<WP_DESKTOP>",,
                    "OBJECTID=<PMMealFLDR>;ICONFILE="||destdir||"\PMealFld.ICO", "replace")
if x = 0 then do
  say 'Unable to create folder; cancelling.'
  exit
end


x = SysCreateObject("WPProgram",,
                    "Lies Mich"||"0d0a"x||"Read Me"||"0d0a"x||"Liez Moi",,
                    "<PMMealFLDR>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\PMMeal.INF")

x = SysCreateObject("WPProgram",,
                    "PMMeal"||"0d0a"x||"Rezeptverwaltung",,
                    "<PMMealFLDR>",,
                    "EXENAME="||destdir||"\PMMeal.EXE;STARTUPDIR="||destdir)

x = SysCreateObject("WPProgram",,
                    "PMMeal"||"0d0a"x||"Registrierung",,
                    "<PMMealFLDR>",,
                    "EXENAME="||destdir||"\REGPMEAL.EXE;STARTUPDIR="||destdir)



GoodBye:
/*-- exit with a goodbye --*/
call SysCls
say
say
say
say
say 'PMMeal was installed successfully.'
say
say 'Be sure to read the file LIES MICH for up-to-date information.'
say
say 'Press any key to exit installation...'
k = SysGetKey('NOECHO')
call SysCls
"@start view.exe "||destdir||"\PMMeal.inf"
exit


INST_EXIT:
  EXIT



CopyFiles: Arg SrcDrive , DestDir

  DestDrive = FILESPEC("drive",DestDir)
  /*-- create the dest. dir --*/
  DestDrive
  rc = SysMkDir(DestDir)
  if rc = 0 then do
    say 'The directory ' DestDir ' was created successfully.'
  end
  else do
    if SysFileTree(DestDir,file,D)>0 then
    do
       say 'The directory ' DestDir ' could not be created successfully; cancelling.'
       exit
    end
  end
  say 'Please wait ....'
  "@copy "||SrcDrive||"PMMEAL.EXE "||DestDir
  "@copy "||SrcDrive||"PMMEAL.INF "||DestDir
  "@copy "||SrcDrive||"PMMEAL.INF "||DestDir"\PMMEAL.HLP"
  "@copy "||SrcDrive||"RegPMEAL.EXE "||DestDir
  "@if exist "SrcDrive||language||".EH copy "||SrcDrive||language||".EH "||DestDir"\PMMEAL.EH"
  "@if exist "SrcDrive||language||".LNG copy "||SrcDrive||language||".LNG "||DestDir"\PMMEAL.LNG"
  "@copy "||SrcDrive||"CONVERT.CMD "||DestDir
  "@copy "||SrcDrive||"CNVKOCHB.CMD "||DestDir
  "@copy "||SrcDrive||"INSTALL.CMD "||DestDir
  "@copy "||SrcDrive||"PMEALFLD.ICO "||DestDir
  call charout DestDir"\PMMEAL.HLP","10"x,4
return
