/* REXX PROGRAM */
/* This file is for importing GoldMine data into OmniFile */
/* This REXX program expects OMNIFILE or CCV2 to be the host environment */
/* If you are attempting to change this file, you will normally only need to change the commands in the CHANGE_REC subroutine and the user variables. */

/********* USER VARIABLES ***********************/
/* If useCreateOwner is set to 1 the created by and owner fields will be stored as a note */
/* By default, we set this variable to 0 to indicate that these fields will not be converted */
/* If useLastInfo is set to 1, the fields regarding the last time the record was changed will be added as a note*/
/* By default, we set this variable to 0 to indicate that these fields will not be converted */
/* If separateBusinesses is set to 1, then Goldmine records with a business name but no contact name will be */
/* added to the Business database, as opposed to the Individual database.  Set it to 0 if you want all */
/* records added to the Individuals database  */
/* If useAccountNum is set to 1, the account number assigned by GoldMine will be used as an ID for the record */
/* By default, we set this variable to 0 to indicate that this field will not be converted; only pertains to GoldMine 95*/
/* If useStatus is set to 1, the status field is added as a note */
/* By default, we set this variable to 0 to indicate that this field will not be converted */
useCreateOwner = 0
useLastInfo=0
separateBusinesses=1
useAccountNum = 0
useStatus = 0
Delimiter = '|'
/****************************************************/

/*  Define field numbers */
fileType=GetTypeGivenName("File")
fileTypeType=GetTypeGivenName("File Type")
actionType=GetTypeGivenName("Action")
actionTypeType=GetTypeGivenName("Action Type")
codeTypeType=GetTypeGivenName("Code Type")

/* these are field numbers for individuals */
prefixFieldNum = 2
firstFieldNum= 3
middleFieldNum= 4
lastFieldNum=5
suffixFieldNum = 6
jobTitleFieldNum = 10
IidFieldNum = 1
IaddressFieldNum = 12
IphoneFieldNum = 13
IcodeFieldNum = 14
InotesFieldNum = 15

/* these are field numbers for businesses */
BidFieldNum = 1
BaddressFieldNum = 4
BphoneFieldNum = 5
BcodeFieldNum = 6
BnotesFieldNum = 7

addressTypeFieldNum = 1
addressAddressFieldNum = 3
addressCityFieldNum = 4
addressStateFieldNum = 5
addressZipFieldNum = 6
addressCountryFieldNum = 7
addressNoteFieldNum = 8
phoneTypeFieldNum = 1
phonePhoneFieldNum = 2
phoneNoteFieldNum = 3
fileTypeFieldNum = 1
fileNameFieldNum = 2
codeTypeField = 1
actionTypeField = 1
actionCompletedField = 2
actionDateField = 3
actionTimeField = 4
actionFreqField = 5
actionSummaryField = 7

/* MAIN SUBROUTINE */
szEnvironment = address()
IF ((szEnvironment <> "Omnifile") & (szEnvironment <> "Contacts")) THEN DO
	SAY "This rexx file can only be run by Omnifile or Contact Connection, not directly."
	RETURN 1
	END

/* FileIn1 is the file with all the GoldMine exported data; provided by user */
FileIn1 = ARG(1)

/* Make sure the required arguments were given. */
IF FileIn1 = "" THEN DO
	SAY "FILEIN1 is required."
	RETURN 1
	END

/* Set the delimiters and separators; GoldMine uses different terminology */
SetDefaultQuoteChar(Delimiter)
Separator = ','
SetDefaultDelimiter(Separator)

/* Set the Header Line and pass it to OmniFile in order to initialize the import. */
/* Literals in REXX have a limit of 250 chars; but can concatenate to make a bigger one */
headerLine1 = 'Business Name, FullName, Last Name, Job Title, Address1, Address2, City, State, Zip, Country, Phone1, Phone1Ext, Phone2, Phone2Ext, Phone3, Phone3Ext, Fax, Phone4Ext, Informal Name,'

headerLine2='Department, Email, Asst, Source, Status, Comments, CreateBy, Key1, Key2, Key3, Key4, Key5, AccountNum, Owner, u1,u2,u3,u4,u5,u6,u7,u8,u9,u10, PrevResult, LastDate, LastTime, LastUser,'

headerLine3='LastContAt, LastContOn, LastAttAt, LastAttOn, NextMeetOn, NextMeetAt, NextAction, SaleDate, CallBackAt, CallBackOn, CallBackFreq, NextActionOn, NoteString'

headerLine=headerLine1||headerLine2||headerLine3

/* For each line in the input file, load the line, load the Rexx variables, modify the Rexx variables, and add the record. */
DO while LINES(FileIn1)
	line = LINEIN(FileIn1)
	multiline = 0
	/* if there's a multiline note field, then need to append a delimiter at end of line */
	lineLength=LENGTH(line)
	PARSE VAR line a =(lineLength) lastChar
	IF lastChar \= Delimiter THEN DO
		line = line || Delimiter
		multiline = 1
		END
	RecType = GetTypeGivenName("Individual")
	SetDefaultType(RecType)
	SetHeaderLine(headerLine)
	SetRexxVariables(line)
	IF separateBusinesses=1 & FullName= "" & BusinessName \= "" THEN DO
		RecType = GetTypeGivenName("Business")
		SetDefaultType(RecType)
		SetHeaderLine(headerLine)
		SetRexxVariables(line)
		inBusiness = 1
		idFieldNum = BidFieldNum
		addressFieldNum = BaddressFieldNum
		phoneFieldNum = BphoneFieldNum
		codeFieldNum = BcodeFieldNum
		notesFieldNum = BnotesFieldNum
		END
	ELSE DO
		inBusiness = 0
		idFieldNum = IidFieldNum
		addressFieldNum = IaddressFieldNum
		phoneFieldNum = IphoneFieldNum
		codeFieldNum = IcodeFieldNum
		notesFieldNum = InotesFieldNum
		END
	Rec = GetRec(0, RecType)
	SetRecFromRexxVariables()
	/* get rest of note if a multiline note */
	IF multiline=1 THEN
		DO while LINES(FileIn1)
			line = LINEIN(FileIn1)
			IF line=="" THEN line = " "
			lineLength=LENGTH(line)
			PARSE VAR line a =(lineLength) lastChar
			IF lastChar == Delimiter THEN DO
				IF lineLength > 1 THEN DO
					PARSE VAR line line =(lineLength) .
					NoteString = NoteString || 'A'x || line
					END
				LEAVE
				END
			NoteString = NoteString || 'A'x || line
			END
	CALL CHANGE_REC
	AddRec()
	END
/* Close the file. */
result=stream(FileIn1, 'c', 'close')
RETURN 0


/* SUBROUTINE */
CHANGE_REC:
/* Need to break FullName into first, middle, last etc.  */
/* Goldmine only has explicit field for LastName, so we need to get the rest */
IF inBusiness = 0 & FullName \= "" THEN DO
	prefix=""
	first=""
	middle=""
	suffix=""
	firstPos=0
	lastPos= 0
	/* Parse the full name into words */
	namestr=FullName
	DO j=1 TO 50
		IF namestr='' THEN LEAVE
		PARSE VAR namestr name.j namestr
		name.j=STRIP(name.j, 'B', ',')
		IF name.j = LastName THEN lastPos=j
		END
	numnames=j-1
	IF lastPos=0 THEN DO
		lastPos=numnames
		IF LastName="" THEN DO
			LastName = name.lastPos
			LastName=STRIP(LastName,'B')
			Result=SetField(lastFieldNum, LastName, "String", "cur");
			END
		END
	IF name.1='Mr.' | name.1='Mrs.' | name.1='Ms.' | name.1='Miss' | name.1='Dr.' | name.1='Prof.' THEN DO
		prefix=name.1
		firstPos=2
		IF lastPos > 2 THEN first=name.2
		END
	ELSE DO
		firstPos=1
		IF lastPos > 1 THEN first=name.1
		END
	DO j=(firstPos+1) TO (lastPos-1)
		middle = middle||name.j||' '
		END
	DO j=(lastPos+1) TO numnames
		suffix = suffix||name.j||' '
		END
	prefix=STRIP(prefix, 'B')
	first=STRIP(first,'B')
	middle=STRIP(middle,'B')
	suffix=STRIP(suffix,'B')
	Result=SetField(prefixFieldNum, prefix, "String", "cur");
	Result=SetField(firstFieldNum, first, "String", "cur");
	Result=SetField(middleFieldNum, middle, "String", "cur");
	Result=SetField(suffixFieldNum, suffix, "String", "cur");
	END

/* Add in address if not blank */
/* need to make one string out of the 2 Address strings */
IF Address2 \= "" THEN Address1 = Address1||'A'x||Address2
IF Address1 \= "" | City \= "" | State \= "" | Zip \= "" | Country \= "" THEN DO
	subRec=GetSubRec(addressFieldNum, 0, "cur")
	Result=SetField(addressTypeFieldNum, 2, "Int", "SubRec")
	Result=SetField(addressAddressFieldNum, Address1, "String", "SubRec")
	Result=SetField(addressCityFieldNum, City, "String", "SubRec")
	Result=SetField(addressStateFieldNum, State, "String", "SubRec")
	Result=SetField(addressZipFieldNum, Zip, "String", "SubRec")
	Result=SetField(addressCountryFieldNum, Country, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END
/* GoldMine for Windows doesn't have an email field */
IF Email \= "" & Email \= "WINDOWS" THEN DO
	subRec=GetSubRec(addressFieldNum, 0, "cur")
	Result=SetField(addressTypeFieldNum, 4, "Int", "SubRec")
	Result=SetField(addressAddressFieldNum, Email, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END

/* Add in phones; by default set type to WORK  */
CALL ADD_PHONE Phone1, Phone1Ext, 2
CALL ADD_PHONE Phone2, Phone2Ext, 2
/* GoldMine appears to have a bug; phone4ext is switched with phone3ext when exporting */
CALL ADD_PHONE Phone3, Phone4Ext, 2
/* GoldMine has the 4th phone as a FAX */
CALL ADD_PHONE Fax, Phone3Ext, 6

/* add in 5 codes */
CALL ADD_CODE Key1
CALL ADD_CODE Key2
CALL ADD_CODE Key3
CALL ADD_CODE Key4
CALL ADD_CODE Key5

/*  Need to convert dates to OmniFile format */
LastContOn=CONVERT_DATE(LastContOn)
LastAttOn=CONVERT_DATE(LastAttOn)
NextMeetOn=CONVERT_DATE(NextMeetOn)
CallBackOn=CONVERT_DATE(CallBackOn)
SaleDate=CONVERT_DATE(SaleDate)
LastDate=CONVERT_DATE(LastDate)

/* Add in activities */
CALL ADD_ACTIVITY LastContOn, LastContAt, "Contact", 1, ""
CALL ADD_ACTIVITY LastAttOn, LastAttAt, "Call", 1, "Unsuccessful call attempt"
CALL ADD_ACTIVITY NextMeetOn, NextMeetAt, "Meet", 0, NextAction
CALL ADD_ACTIVITY CallBackOn, CallBackAt, "Call", 0, ""
CALL ADD_ACTIVITY SaleDate, "", "Forecast Sale", 0, ""

/* GoldMine for Windows doesn't have an account number field */
IF useAccountNum = 1 & AccountNum \= "" & AccountNum \= "WINDOWS" THEN
	Result=SetField(idFieldNum, AccountNum, "String", "cur");

/* the Goldmine fields that have no correlation to fields in OmniFile are read into the Notes section so the data is not lost */
notes = ""
IF Asst \= "" THEN notes = notes || "Assistant: " || Asst || 'A'x
IF Source \= "" THEN notes = notes || "Source: " || Source || 'A'x
IF PrevResult \= "" THEN notes = notes || "Previous result: " || PrevResult || 'A'x
IF useStatus = 1 & Status \= "" THEN notes = notes || "Status: " || Status || 'A'x
IF useCreateOwner = 1 THEN DO
	IF CreateBy \= "" THEN notes = notes || "Created by: " || CreateBy || 'A'x
	IF Owner \= "" THEN notes = notes || "Owner: " || Owner || 'A'x
	END
IF useLastInfo = 1 THEN DO
	notes = notes || "Last touched on " || LastDate || " "|| LastTime || "m by "|| LastUser || 'A'x
	END
IF Comments \= "" THEN notes = notes || Comments || 'A'x
IF u1 \= "" THEN notes = notes || "User field1: " || u1 || 'A'x
IF u2 \= "" THEN notes = notes || "User field2: " || u2 || 'A'x
IF u3 \= "" THEN notes = notes || "User field3: " || u3 || 'A'x
IF u4 \= "" THEN notes = notes || "User field4: " || u4 || 'A'x
IF u5 \= "" THEN notes = notes || "User field5: " || u5 || 'A'x
IF u6 \= "" THEN notes = notes || "User field6: " || u6 || 'A'x
IF u7 \= "" THEN notes = notes || "User field7: " || u7 || 'A'x
IF u8 \= "" THEN notes = notes || "User field8: " || u8 || 'A'x
IF u9 \= "" THEN notes = notes || "User field9: " || u9 || 'A'x
IF u10 \= "" THEN notes = notes || "User field10: " || u10 || 'A'x
IF NoteString \= "" THEN notes = notes || NoteString
notes=STRIP(notes, 'T', 'A'x)
IF notes \= "" THEN Result=SetField(notesFieldNum, notes, "String", "cur");
RETURN


/* SUBROUTINE */
CONVERT_DATE:
dateString = ARG(1)
IF dateString = "" THEN RETURN dateString
/* if date already has slashes then leave it */
PARSE VAR dateString a "/" .
IF dateString = a THEN DO
	PARSE VAR dateString unused 3 year +2 month +2 day
	dateString=month || '/' || day || '/' || year
	END
RETURN dateString


/* SUBROUTINE */
ADD_PHONE:
/* Add in phones if they're not blank; the EXT field of Goldmine can also be used for type */
PhoneNumber=ARG(1)
PhoneExt=ARG(2)
PhoneType=ARG(3)
IF PhoneExt \= "" THEN DO
	IF PhoneExt="Car" | PhoneExt="CAR" THEN PhoneType = 4
	ELSE IF PhoneExt="Fax" | PhoneExt="FAX" THEN PhoneType = 6
	ELSE IF PhoneExt="Home" | PhoneExt="HOME" THEN PhoneType = 1
	ELSE IF PhoneExt="Office" | PhoneExt="OFFICE" THEN PhoneType = 2
	ELSE IF PhoneExt="Work" | PhoneExt="WORK" THEN PhoneType = 2
	ELSE IF PhoneExt="Beeper" | PhoneExt="BEEPER" THEN PhoneType = 5
	ELSE PhoneNumber = PhoneNumber||" Ext: "||PhoneExt
	END
IF PhoneNumber \= "" & PhoneNumber \= "(   )   -" THEN DO
	subRec=GetSubRec(phoneFieldNum, 0, "cur")
	Result=SetField(phoneTypeFieldNum, PhoneType, "Int", "SubRec")
	Result=SetField(phonePhoneFieldNum, PhoneNumber, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END
RETURN


/* SUBROUTINE */
ADD_CODE:
Key=ARG(1)
IF Key \= "" & Key \= "N/A" THEN DO
	subRec=GetSubRec(codeFieldNum, 0, "cur")
	CodeRecNum=ConvertStringToDefineableComboBox(Key, codeTypeType, 1)
	Result=SetField(codeTypeField, CodeRecNum, "Int", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END
RETURN


/* SUBROUTINE */
ADD_ACTIVITY:
actDate=ARG(1)
actTime=ARG(2)
actType=ARG(3)
actCompleted=ARG(4)
actSummary=ARG(5)
IF actDate = "" & actTime = "" THEN RETURN
ActionRec=GetRec(0, actionType, "Temp")
ActionTypeRecNum=ConvertStringToDefineableComboBox(actType, actionTypeType, 1)
Result=SetField(actionTypeField, ActionTypeRecNum, "Int", "Temp")
Result=SetField(actionCompletedField, actCompleted, "Int", "Temp")
Result=SetField(actionDateField, actDate, "Date", "Temp")
Result=SetField(actionTimeField, actTime, "Time", "Temp")
Result=SetField(actionSummaryField, actSummary, "String", "Temp")
Result=SetField(actionFreqField, 1, "Int", "Temp")
NewRecNum=AddRec(ActionRec, 0, "Temp")
Result=AddLink(NewRecNum)
RETURN

