/* REXX PROGRAM */
/* OMNIFILE DEMO INSTALLATION PROGRAM */
SAY "INSTALLATION PROGRAM FOR OMNIFILE DEMO"
SAY ""
/* You may optionally specify the destination path for the program as an argument. */
/* If you do not specify the destination path you will be prompted to enter a path. */
PARSE SOURCE os processor cmd
srcdrive = FILESPEC("drive",cmd)
srcpath = FILESPEC("path",cmd)
src = srcdrive||srcpath
minHardDiskSize = 2800000

arg destpath
"@echo off"

call RxFuncAdd 'SysMkDir', 'RexxUtil', 'SysMkDir'
call RxFuncAdd 'SysDriveInfo', 'RexxUtil', 'SysDriveInfo'
driveInfo = SysDriveInfo(srcdrive)
driveSize = SUBWORD(driveInfo, 3, 1)
DO FOREVER
   IF destpath = "" THEN DO
       IF driveSize > minHardDiskSize THEN DO
           tempsrc = STRIP(src, 'T', '\')
           SAY "If you would like to run the demonstration"
           SAY "from "tempsrc" without copying"
           SAY "the files to a new directory simply"
           SAY "press Enter without typing anything."
           SAY ""
           SAY "Otherwise enter the full directory path (including drive)"
           SAY "where you would like the demonstration program"
           SAY "to be installed."
           SAY '(We suggest "C:\OMNIDEMO").'
           END
       ELSE DO
           SAY "Enter the full directory path (including drive) where"
           SAY "you would like the demonstration program installed."
           SAY "If you press Enter without typing anything"
           SAY 'it will be installed in the "C:\OMNIDEMO" directory.'
           END
       SAY "If you would like to abort this installation"
       SAY "type QUIT and press Enter."
       PULL destpath
       IF destpath = "QUIT" THEN EXIT
       IF driveSize > minHardDiskSize THEN DO
           IF destpath = "" THEN LEAVE
           END
       ELSE DO
           IF destpath = "" THEN destpath = "C:\OMNIDEMO"
           END
       END
   rc = SysMkDir(destpath)
   IF rc == 0 THEN LEAVE
   SAY ""
   SAY "ERROR: Unable to make the directory "destpath"."
   IF rc == 3 THEN say "The path was not found."
   IF rc == 5 THEN say "Either it already exists or you do not have access to the directory."
   SAY "Enter a new path."
   SAY ""
   destpath = ""
   END

DO FOREVER
   SAY "Which version of OmniFile would you like to install?"
   SAY "     Enter HOME, PRO, or OFFICE and press Enter."
   SAY "     Home  - is for personal use,"
   SAY "     Pro    - is for professional use,"
   SAY "     Office - is a multi user version."
   SAY "If you would like to abort this installation"
   SAY "type QUIT and press Enter."
   PULL version
   IF version = "QUIT" THEN EXIT
   IF version = "HOME" THEN LEAVE
   IF version = "PRO" THEN LEAVE
   IF version = "OFFICE" THEN LEAVE
   SAY "Enter a valid version name."
   SAY ""
   END
IF destpath = "" THEN DO
   destpath = src
   SIGNAL INSTALL_VERSION
   END

/* Copy the files */
SAY ""
SAY "Now copying files..."
/* If the source drive is not big enough to hold the entire program (i.e. a floppy) ask for disk 2. */
IF driveSize <= minHardDiskSize THEN DO
   src"decomp "src"Omnifile.exe "destpath"\Omnifile.exe"
   src"decomp "src"Omnifile.hlp "destpath"\Omnifile.hlp"
   "copy "src"*.cmd "destpath"/v"
   "copy "src"*.txt "destpath"/v"
   src"decomp "src"cicodu0.dll "destpath"\cicodu0.dll"
   src"decomp "src"cicodw01.dll "destpath"\cicodw01.dll"
   src"decomp "src"cicoda01.dll "destpath"\cicoda01.dll"
   src"decomp "src"cicodr01.dll "destpath"\cicodr01.dll"
   "md "destpath"\ICONS.OS2 2>nul"
   "copy "src"ICONS.OS2\*.* "destpath"\ICONS.OS2/v"
   "md "destpath"\SYSTEM.HME 2>nul"
   "copy "src"SYSTEM.HME\*.* "destpath"\SYSTEM.HME/v"
   "del "destpath"\SYSTEM.HME\bundled.dbv"
   src"decomp "src"SYSTEM.HME\bundled.dbv "destpath"\SYSTEM.HME\bundled.dbv"
   "md "destpath"\SYSTEM.PRO 2>nul"
   "copy "src"SYSTEM.PRO\*.* "destpath"\SYSTEM.PRO/v"
   "del "destpath"\SYSTEM.PRO\bundled.dbv"
   src"decomp "src"SYSTEM.PRO\bundled.dbv "destpath"\SYSTEM.PRO\bundled.dbv"
   src"decomp "src"impex2wn.ntx "destpath"\impex2wn.ntx"
   src"decomp "src"impex295.ntx "destpath"\impex295.ntx"
   SAY ""
   SAY "Insert the disk Labeled Disk 2 and press Enter."
   PULL response
   SAY ""
   SAY "Now copying files..."
   src"decomp "src"cicodv01.dll "destpath"\cicodv01.dll"
   src"decomp "src"cicodb0.dll "destpath"\cicodb0.dll"
   src"decomp "src"cicodd01.dll "destpath"\cicodd01.dll"
   src"decomp "src"cicodt01.dll "destpath"\cicodt01.dll"
   src"decomp "src"cicodm0.dll "destpath"\cicodm0.dll"
   src"decomp "src"cicodp01.dll "destpath"\cicodp01.dll"
   src"decomp "src"cicodx01.dll "destpath"\cicodx01.dll"
   src"decomp "src"cicodi01.dll "destpath"\cicodi01.dll"
   src"decomp "src"impexpwn.gbf "destpath"\impexpwn.gbf"
   src"decomp "src"impexpwn.gbt "destpath"\impexpwn.gbt"
   src"decomp "src"impexpwn.ntx "destpath"\impexpwn.ntx"
   src"decomp "src"impexp95.gbf "destpath"\impexp95.gbf"
   src"decomp "src"impexp95.gbt "destpath"\impexp95.gbt"
   src"decomp "src"impexp95.ntx "destpath"\impexp95.ntx"
   "copy "src"*.rep "destpath"/v"
   "erase "destpath"\install.cmd 2>nul"
   END
ELSE DO
   "copy "src"Omnifile.exe "destpath"\Omnifile.exe"
   "copy "src"Omnifile.hlp "destpath"\Omnifile.hlp"
   "copy "src"*.cmd "destpath"/v"
   "copy "src"*.txt "destpath"/v"
   "copy "src"cicodu0.dll "destpath"\cicodu0.dll"
   "copy "src"cicodw01.dll "destpath"\cicodw01.dll"
   "copy "src"cicoda01.dll "destpath"\cicoda01.dll"
   "copy "src"cicodr01.dll "destpath"\cicodr01.dll"
   "md "destpath"\ICONS.OS2 2>nul"
   "copy "src"ICONS.OS2\*.* "destpath"\ICONS.OS2/v"
   "md "destpath"\SYSTEM.HME 2>nul"
   "copy "src"SYSTEM.HME\*.* "destpath"\SYSTEM.HME/v"
   "md "destpath"\SYSTEM.PRO 2>nul"
   "copy "src"SYSTEM.PRO\*.* "destpath"\SYSTEM.PRO/v"
   "copy "src"impex2wn.ntx "destpath"\impex2wn.ntx"
   "copy "src"impex295.ntx "destpath"\impex295.ntx"
   "copy "src"cicodv01.dll "destpath"\cicodv01.dll"
   "copy "src"cicodb0.dll "destpath"\cicodb0.dll"
   "copy "src"cicodd01.dll "destpath"\cicodd01.dll"
   "copy "src"cicodt01.dll "destpath"\cicodt01.dll"
   "copy "src"cicodm0.dll "destpath"\cicodm0.dll"
   "copy "src"cicodp01.dll "destpath"\cicodp01.dll"
   "copy "src"cicodx01.dll "destpath"\cicodx01.dll"
   "copy "src"cicodi01.dll "destpath"\cicodi01.dll"
   "copy "src"impexpwn.gbf "destpath"\impexpwn.gbf"
   "copy "src"impexpwn.gbt "destpath"\impexpwn.gbt"
   "copy "src"impexpwn.ntx "destpath"\impexpwn.ntx"
   "copy "src"impexp95.gbf "destpath"\impexp95.gbf"
   "copy "src"impexp95.gbt "destpath"\impexp95.gbt"
   "copy "src"impexp95.ntx "destpath"\impexp95.ntx"
   "copy "src"*.rep "destpath"/v"
   "erase "destpath"\install.cmd 2>nul"
   END

INSTALL_VERSION:
"md "destpath"\SYSTEM 2>nul"
IF version = HOME
   THEN DO
       "del "destpath"\*.db* 2>nul"
       "copy "destpath"\SYSTEM.HME\*.* "destpath"\SYSTEM/v"
       END
   ELSE DO
       "del "destpath"\*.db* 2>nul"
       "copy "destpath"\SYSTEM.PRO\*.* "destpath"\SYSTEM/v"
       END

/* Create the Omnifile Demo Icon. */
call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
if SysCreateObject('WPProgram', 'OmniFile Demo', '<WP_DESKTOP>', 'EXENAME='destpath'\Omnifile.exe;STARTUPDIR='destpath, 'replace') == 0 then SAY 'Unable to create the OmniFile Demo icon.  You should add it manually after the installation program finishes.'

/* Make sub directories */
"md "destpath"\FILES 2>nul"

SAY ""
SAY "DONE INSTALLING THE OMNIFILE DEMO."
SAY "To use the program double click on the OmniFile Demo icon on your desktop."
SAY ""
EXIT
