/* REXX */
/* Procedure to call Boulder NIST and set System Time  */
/* With acknowledgement to Jerry am Ende, Compuserve 73237,131			*/
/* Defaults are peculiar to my system. Change them to suit yours.		*/		
/* Thomas M Maddox (maddtom@ibm.net) Boulder CO Somewhere between the Mtns and reality. */
/* 26Aug1995									*/
parse arg year offset PhoneNumber ComPort

"CLS"                 			 			 /* Clear Screen */

/*if year = "" then do  							*/
/*   say "Usage is: TIMESET <year> <offset> <PhoneNumber> <ComPort>"		*/
/*   say "          <year>        = 2 digit year (e.g. 1992 = 92)"		*/
/*   say "          <offset>      = Hours from Greenwich Mean time. "		*/
/*   say "                           Mountain = 6 "       			*/
/*   say "          <PhoneNumber> = Phone Number of NIST"			*/
/*   say "                           default is  NIST 494-4774 or 494-4775"	*/
/*   say "          <ComPort>     = ComPort where modem is connected"		*/
/*   say "                           COM2 is default				*/
/*   return									*/
/*   end  									*/
if year == "" then
	year = 95
if offset == "" then               				 /* Set Defaults */
   offset = 6

if PhoneNumber == "" then
   PhoneNumber = "4944774"

if ComPort == "" then
   ComPort = "COM2"

CrLf = X2C("0D0A")

State = STREAM(ComPort,"C","OPEN")
"@MODE" ComPort":115200,N,8,1 > NUL"

CALL LINEOUT ComPort, "ATX3DT"PhoneNumber||CrLf   		      /* Dial In */
StartTime = time('E')
ReturnStuff = ""
DO WHILE pos('UTC',ReturnStuff) == 0          		 /* UTC is end of String */
  ReturnStuff = ReturnStuff||CHARIN(ComPort)
  if (pos('BUSY',ReturnStuff) <> 0) then do   		       /* Check for Busy */
     CALL LINEOUT ComPort,"ATH"CrLf                                   /* Hang Up */
     State = STREAM(ComPort,"C","CLOSE")
     Say "Line Busy, Please Try Again..."
     return
     end
  if ((time('E') - StartTime) > 45) then do                           /* Check for Timeout */
     CALL LINEOUT ComPort,"ATH"CrLf                                             /* Hang Up */
     State = STREAM(ComPort,"C","CLOSE")
     Say "Sorry, Timeout..."
     return
     end
END

NISTString = Right(ReturnStuff,36)   			   /* Retrieve the time/date string */

parse var NISTString  doy time . . . .
								/* Convert time to HH:MM:SS */
hour = right(left(time,2) - offset,2,'0')
if (hour < 0) then do
   hour = hour + 24
   doy = doy - 1
   end
minute = right(substr(time,4,2),2,'0')
second = right(substr(time,7,2),2,'0')
TimeString = hour || ':' || minute || ':' || second

							  /* Convert doy to MM-DD-YY format */
month = right(substr(doy,4,2),2,'0')
day = right(substr(doy,7,2),2,'0')
DateString = month || '-' || day || '-' || Year

OldTime = Time()
OldDate = Date()

								/* Send Date & Time to OS2 */
"@DATE" DateString        
"@TIME" TimeString
        
Say "Date & Time was            .... " OldDate OLdTime
Say "Date & Time has been Set to:" Date() Time()

return
