/* REXX - OS/2 Install command for mSQL 1.0.16 */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Clear screen */
Call SysCls

targetDir = "C:\mSQL"

say
say "This program will install the OS/2 port of mSQL 1.0.16."
say
say "NOTE: Make sure you include the drive letter in your"
say "      destination directory below. It must also be a"
say "      HPFS drive or one that supports long filenames."
say "      Such as a Netware volume with OS/2 name space."
say
Call CharOut, "Destination directory ["targetDir"]: "
Parse Upper Pull answer
if length(answer) > 0 then
    targetDir = answer

say
say "Creating Directories..."
call SysMkDir targetDir
if ((result = 0) | (result = 5)) then do
    call SysMkDir targetDir||"\bin"
    call SysMkDir targetDir||"\include"
    call SysMkDir targetDir||"\lib"
    call SysMkDir targetDir||"\msqldb"
    call SysMkDir targetDir||"\msqldb\.tmp"
    call SysMkDir targetDir||"\doc"

    say
    say "Copying Files..."

    /* Update BIN directory */
    '@copy targets\OS_2-2-i386\msql\msql.exe' targetDir'\bin >nul'
    '@copy targets\OS_2-2-i386\msql\msqldump.exe' targetDir'\bin >nul'
    '@copy targets\OS_2-2-i386\msql\relshow.exe' targetDir'\bin >nul'
    '@copy targets\OS_2-2-i386\msql\select_test.exe' targetDir'\bin >nul'
    '@copy targets\OS_2-2-i386\msql\msqladmin.exe' targetDir'\bin >nul'
    '@copy targets\OS_2-2-i386\msql\msqld.exe' targetDir'\bin >nul'

    /* Update INCLUDE directory */
    '@copy targets\OS_2-2-i386\msql\msql.h' targetDir'\include >nul'

    /* Update LIB directory */
    '@copy targets\OS_2-2-i386\msql\libmsql.a' targetDir'\lib >nul'

    /* Update DOC directory */
    '@copy doc\License.' targetDir'\doc\License.mSQL >nul'
    '@copy doc\mSQL-1.0.11.ps' targetDir'\doc >nul'
    '@copy doc\mSQL-Invoice.ps' targetDir'\doc >nul'
    '@copy readme.os2' targetDir'\doc >nul'

    /* Copy sample ACL file */
    '@copy src\msql\sample.acl' targetDir'\msql.acl.sample >nul'

    say
    say "Creating Folder and icons."
    CreateCollision = 'Update'
    Call CreateObjects

    say
    say "Done."
    say
    say "You will need to add"
    say
    say "SET MSQL_HOME="targetDir
    say
    say "to your CONFIG.SYS file and make sure \TMP"
    say "directory exists on the same drive as" targetDir"."
    say

end
else do
    say "Error creating destination directory" targetDir"."
    say "Result =" result
end

return

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

CreateObjects:

current_dir = directory()
previous_dir = left(current_dir, ( length(current_dir) - 4 ))

rc = CreateObject( 'WPFolder',,
    'mSQL 1.0.16 for OS/2',,
    '<WP_DESKTOP>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID=<WP_mSQL1_0_16_OS2>',,
    CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Create DB',,
      '<WP_mSQL1_0_16_OS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||targetDir||'\BIN\MSQLADMIN.EXE;'||,
          'PARAMETERS=create [database to create?];'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Drop DB',,
      '<WP_mSQL1_0_16_OS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||targetDir||'\BIN\MSQLADMIN.EXE;'||,
          'PARAMETERS=drop [database to create?];'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Dump',,
      '<WP_mSQL1_0_16_OS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||targetDir||'\BIN\MSQLDUMP.EXE;'||,
          'PARAMETERS=[database?];'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Relations',,
      '<WP_mSQL1_0_16_OS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||targetDir||'\BIN\RELSHOW.EXE;'||,
          'PARAMETERS=[database?] [table?];'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'mSQL-Server',,
      '<WP_mSQL1_0_16_OS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||targetDir||'\BIN\MSQLD.EXE;'||,
          'PROGTYPE=FULLSCREEN;'||,
          'MINIMIZED=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'local Monitor',,
      '<WP_mSQL1_0_16_OS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||targetDir||'\BIN\MSQL.EXE;'||,
          'PARAMETERS=[database to use?];'||,
          'PROGTYPE=WINDOWABLEVIO;'||,
          'NOAUTOCLOSE=YES',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'remote Monitor',,
      '<WP_mSQL1_0_16_OS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||targetDir||'\BIN\MSQL.EXE;'||,
          'PARAMETERS=-h [host?] [database to use?];'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Server Shutdown',,
      '<WP_mSQL1_0_16_OS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||targetDir||'\BIN\MSQLADMIN.EXE;'||,
          'PARAMETERS=shutdown;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Server Reload',,
      '<WP_mSQL1_0_16_OS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||targetDir||'\BIN\MSQLADMIN.EXE;'||,
          'PARAMETERS=reload;'||,
          'PROGTYPE=WINDOWABLEVIO',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'README.OS2',,
      '<WP_mSQL1_0_16_OS2>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME=E.EXE;'||,
          'PARAMETERS='||targetDir||'\DOC\README.OS2;',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
    'Access Control List',,
    '<WP_mSQL1_0_16_OS2>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'EXENAME=E.EXE;'||,
        'PARAMETERS='||targetDir||'\msql.acl;',,
     CreateCollision )

  rc = CreateObject( 'WPShadow',,
      'License.mSQL',,
      '<WP_mSQL1_0_16_OS2>',,
      'SHADOWID='||targetDir||'\doc\License.mSQL',,
      CreateCollision )

return

